/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.IConnectionListener;
import com.sonicsw.mf.comm.IConnectorClient;
import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IEnterpriseAware;
import com.sonicsw.mf.common.runtime.IEnterpriseStateAccess;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import com.sonicsw.mf.common.util.LockFile;
import com.sonicsw.mf.common.util.ObjectNameHelper;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IConnectorServer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponent;
import com.sonicsw.mf.framework.IGlobalFrameworkComponent;
import com.sonicsw.mf.framework.IMessageLogger;
import com.sonicsw.mf.framework.INotificationPublisher;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.agent.AbstractMBean;
import com.sonicsw.mf.framework.agent.Agent;
import com.sonicsw.mf.framework.agent.ClassLoaderFactory;
import com.sonicsw.mf.framework.agent.ComponentMBean;
import com.sonicsw.mf.framework.agent.ContainerDS;
import com.sonicsw.mf.framework.agent.ContainerExitCode;
import com.sonicsw.mf.framework.agent.ContainerFT;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ExceptionMapper;
import com.sonicsw.mf.framework.agent.ExpandedSonicArchive;
import com.sonicsw.mf.framework.agent.FrameworkComponentMBean;
import com.sonicsw.mf.framework.agent.HostManager;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.agent.LocalFileManager;
import com.sonicsw.mf.framework.agent.LogicalFile;
import com.sonicsw.mf.framework.agent.MFContext;
import com.sonicsw.mf.framework.agent.NotificationHandlerDelegate;
import com.sonicsw.mf.framework.agent.NotificationListenerDelegate;
import com.sonicsw.mf.framework.agent.NotificationPublisher;
import com.sonicsw.mf.framework.agent.PingThread;
import com.sonicsw.mf.framework.agent.RuntimeConfigurationManager;
import com.sonicsw.mf.framework.agent.SonicURLStreamHandlerFactoryImpl;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.agent.cache.CacheClosedException;
import com.sonicsw.mf.framework.agent.cache.CacheException;
import com.sonicsw.mf.framework.agent.cache.ConfigCacheFactory;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.OutOfPersistentSpaceException;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.agent.ci.LaunchContainer;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.interceptor.actional.soniclog.SonicLogInterceptor;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.ServiceMaintainer;
import com.sonicsw.mx.util.ServiceMaintenance;
import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsManager;
import com.sonicsw.sdf.IShutdown;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Timer;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.naming.Context;
import progress.message.client.api.IUserAlreadyConnected;

public final class ContainerImpl
implements IConnectionListener,
IShutdown {
    private static final boolean DEBUG = false;
    MBeanServer m_mbeanServer;
    private Class m_mbeanServerClass;
    private IConsumer m_connectorHandback;
    private HashMap m_notificationListeners = new HashMap();
    private static ContainerImpl m_container;
    private static IContainer m_containerDelegate;
    private HashSet m_sharedClasses;
    private IDirElement m_containerConfig;
    private IConfigCache m_configCache;
    private IConfigCacheView m_configCacheView;
    private String m_sonicArchiveSearchPath;
    private RuntimeConfigurationManager m_runtimeConfigurationManager;
    private IContainerIdentity m_containerIdentity;
    private JMSConnectorServer m_connector;
    private InternalRequestHandler m_internalRequestHandler = new InternalRequestHandler();
    private HashSet m_storageNames = new HashSet();
    private boolean m_generateCache;
    private boolean m_generateCacheUtil;
    private boolean m_configureFromCache;
    private String m_directConnectionURL = "localhost";
    private String m_directConnectionUser = "";
    private String m_directConnectionPassword = "";
    private Thread m_designatedReconcileThread = null;
    private Object m_reconcileLock = new Object();
    private Object m_reportingChangeLock = new Object();
    private boolean m_dsNotInitiallyAccessible;
    private boolean m_useLocalCacheLogged = false;
    private ServiceMaintainer m_dsMonitor;
    private ServiceMaintainer m_dsTemporaryMonitor;
    private Object m_dsTemporaryMonitorLock = new Object();
    private long m_lastTimeWeSubscribed = 0L;
    private long m_dsPingFrequency = 1800000L;
    private boolean m_recentReconcileSucessful = false;
    private Random m_random;
    private long m_startTimestamp;
    URLClassLoader m_defaultClassLoader;
    Agent m_agent;
    AbstractMBean m_agentMBean;
    LocalFileManager m_fileManager;
    private ContainerDS m_directory;
    private HostManager m_hostManager;
    private boolean m_isBooted = false;
    private boolean m_isLoading = false;
    private boolean m_isUnloading = false;
    private boolean m_isClosing = false;
    private boolean m_isOutOfMemory = false;
    private Hashtable m_mBeans = new Hashtable();
    private ArrayList m_reloadingIDs = new ArrayList();
    private HashMap m_reloadingDetails = new HashMap();
    private TaskScheduler m_taskScheduler = new TaskScheduler(this);
    private NotificationPublisher m_notificationPublisher = new NotificationPublisher(this);
    private NotificationListenerExpirer m_notificationListenerExpirer = new NotificationListenerExpirer();
    private Monitor m_abortMonitor;
    private Timer m_timer = new Timer(true);
    private ArrayList m_listOfLoggers = new ArrayList(0);
    private boolean m_isLoggingStarted = false;
    private String m_tempLogBuffer = "";
    private String m_managementNode;
    private HashSet m_storedLibraries = new HashSet();
    private ExternalRequestHandler m_externalRequestHandler;
    private volatile boolean m_isFailingOver = false;
    private boolean m_allowFailover = true;
    private boolean m_skippedDSReconciliation = false;
    private IDiagnosticsManager m_diagnosticsManager = null;
    private ArrayList m_pendingLogMessageQueue = new ArrayList();
    private LockFile m_containerRunningLockFile = null;
    private static final String ADD_NOTIFICATION_LISTENER_METHOD_NAME = "addNotificationListener";
    private static final String REMOVE_NOTIFICATION_LISTENER_METHOD_NAME = "removeNotificationListener";
    private static final String HANDLE_NOTIFICATION_METHOD_NAME = "handleNotification";
    private static final String EXTERNAL_NOTIFICATION_SUBSCRIPTIONS = "externalNotificationSubscriptions";
    private static final String INTERNAL_NOTIFICATION_SUBSCRIPTIONS = "internalNotificationSubscriptions";
    static final String GET_ATTRIBUTE_METHOD_NAME = "getAttribute";
    static final String GET_ATTRIBUTES_METHOD_NAME = "getAttributes";
    static final String SET_ATTRIBUTE_METHOD_NAME = "setAttribute";
    static final String SET_ATTRIBUTES_METHOD_NAME = "setAttributes";
    public static final String RESTART_MESSAGE = "Restart initiated";
    public static final String SHUTDOWN_MESSAGE = "Shutdown initiated";
    private static final String DEFAULT_CONNECTION_URLS = "tcp://localhost:2506";
    static final String ESBCONTAINER_ARCHIVE = "ESBcontainer.car";
    static final String ACTIONAL_SDK_JMS_LOCATION;
    private static final long MIN_DS_PING_FREQUENCY = 900000L;
    private static final long MAX_DS_PING_FREQUENCY = 9000000L;
    private static final long MAX_TEMP_DS_PING_FREQUENCY = 60000L;
    private ContainerExitCode m_containerExitCode = null;
    private ContainerFT m_containerFT;
    private boolean m_isFTContainer;
    private static final PrintStream s_errDirect;
    private static final boolean m_isLSD;
    private static final long SHUTDOWN_PAUSE = 2000L;

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID) throws Exception {
        this(containerClassLoader, cacheDirectory, containerName, containerConfigID, new Long(0L), new ContainerExitCode());
    }

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID, Long maxCacheSize) throws Exception {
        this(containerClassLoader, cacheDirectory, containerName, containerConfigID, maxCacheSize, new ContainerExitCode());
    }

    public ContainerImpl(ClassLoader containerClassLoader, String cacheDirectory, String containerName, String containerConfigID, Long maxCacheSize, Object containerExitCode) throws Exception {
        if (!m_isLSD) {
            this.m_containerRunningLockFile = new LockFile("container_running.lock");
            if (!this.m_containerRunningLockFile.lock()) {
                throw new Exception("Container is already running in \"" + System.getProperty("user.dir") + "\"");
            }
            this.createStartTimestamp();
        }
        this.m_configureFromCache = Boolean.getBoolean("sonicsw.mf.configureFromCache");
        this.m_diagnosticsManager = DiagnosticsManagerAccess.createManager();
        this.m_diagnosticsManager.setContainerName(containerName);
        this.m_diagnosticsManager.setShutdownInterface((IShutdown)this);
        this.m_containerExitCode = (ContainerExitCode)containerExitCode;
        this.m_directConnectionURL = System.getProperty("sonicsw.mf.cacheGeneration.url");
        this.m_generateCacheUtil = this.m_directConnectionURL != null;
        this.m_generateCache = this.m_generateCacheUtil || Boolean.getBoolean("sonicsw.mf.generateCacheFromConnection");
        this.m_directConnectionUser = System.getProperty("sonicsw.mf.cacheGeneration.user");
        if (this.m_directConnectionUser == null) {
            this.m_directConnectionUser = "";
        }
        this.m_directConnectionPassword = System.getProperty("sonicsw.mf.cacheGeneration.password");
        if (this.m_directConnectionPassword == null) {
            this.m_directConnectionPassword = "";
        }
        NotificationListenerDelegate.setContainerImpl(this);
        try {
            m_container = this;
            m_containerDelegate = new Delegate();
            this.m_defaultClassLoader = (URLClassLoader)containerClassLoader;
            this.m_taskScheduler.start();
            this.m_notificationPublisher.start();
            this.m_notificationListenerExpirer.start();
            String password = ContainerUtil.retrieveCachePassword(new File(cacheDirectory), true);
            this.m_configCache = ConfigCacheFactory.createCache((String)cacheDirectory, (String)password, (long)(maxCacheSize == null ? 0L : maxCacheSize));
            this.m_configCache.clearNativeLibraryDirectory();
            this.m_configCacheView = this.m_configCache.getCacheView();
            this.bootFramework(containerConfigID);
        }
        catch (OutOfMemoryError e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
        catch (ShutdownInProgressException e) {
            if (this.m_isClosing) {
                return;
            }
            throw e;
        }
    }

    public void shutdownCallback(long callerID) {
        if (this.m_startTimestamp != 0L && callerID == this.m_startTimestamp) {
            this.shutdown(0);
        }
    }

    private void createStartTimestamp() {
        this.m_startTimestamp = System.currentTimeMillis();
        File timestampFile = new File("start_timestamp");
        try {
            timestampFile.delete();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(timestampFile, false)), true);
            writer.println(this.m_startTimestamp);
            writer.close();
        }
        catch (IOException e) {
            this.logMessage(null, "Could not create file " + timestampFile.getAbsolutePath(), e, 2);
        }
    }

    public void onReconnect(String localRoutingNode) {
        this.validateConnectorNodeName(localRoutingNode);
        this.exhaustPendingLogMessageQueue();
        if (this.m_isBooted) {
            Runnable reconciler = new Runnable(){

                @Override
                public void run() {
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID("Administrator");
                    ContainerImpl.this.reconcileCache();
                }
            };
            this.m_taskScheduler.scheduleTask(reconciler, false);
        }
        if (this.m_containerFT != null) {
            this.m_containerFT.onReconnect();
        }
    }

    public void onDisconnect() {
        if (this.m_containerFT != null) {
            this.m_containerFT.onDisconnect();
        }
    }

    public void onFailure(Exception e) {
        if (this.m_containerFT != null) {
            this.m_containerFT.onFailure(e);
        }
    }

    public String diagnose(String instructions) {
        if (this.m_diagnosticsManager != null) {
            return this.m_diagnosticsManager.executeDiagnosticsInstructions(instructions);
        }
        return "The Sonic Diagnostics Framework is not available";
    }

    static IContainer getContainer() {
        return m_containerDelegate;
    }

    void addMessageLogger(IMessageLogger logger) {
        this.m_listOfLoggers.add(logger);
    }

    void removeMessageLogger(IMessageLogger logger) {
        this.m_listOfLoggers.remove(logger);
    }

    void setDSPingFrequency(Integer minutesParam) {
        Integer minutes = minutesParam;
        if (minutes == null) {
            minutes = new Integer(30);
        }
        this.m_dsPingFrequency = minutes * 60000;
        if (this.m_dsPingFrequency < 900000L) {
            this.m_dsPingFrequency = 900000L;
        } else if (this.m_dsPingFrequency > 9000000L) {
            this.m_dsPingFrequency = 9000000L;
        }
    }

    String remotePing(String containerName, String pingMessage, long timeout) throws Exception {
        String canonicalName = new CanonicalName(this.m_containerIdentity.getDomainName(), containerName, "AGENT").getCanonicalName();
        return (String)this.m_connector.invoke("mf", canonicalName, canonicalName, "ping", new Object[]{pingMessage}, new String[]{String.class.getName()}, timeout);
    }

    boolean loadConfiguredComponent(String id, IAttributeSet componentAttrs, boolean isExtension, boolean frameworkOnly) {
        String configID = isExtension ? ((Reference)componentAttrs.getAttribute("EXTENSION_CONFIG_REF")).getElementName() : ((Reference)componentAttrs.getAttribute("CONFIG_REF")).getElementName();
        Boolean isAutoStart = null;
        if (this.m_generateCache) {
            isAutoStart = Boolean.FALSE;
        } else {
            isAutoStart = isExtension ? Boolean.TRUE : (Boolean)componentAttrs.getAttribute("AUTO_START");
            if (isAutoStart == null) {
                isAutoStart = new Boolean(true);
            }
        }
        Integer traceMask = null;
        traceMask = isExtension ? new Integer(-1) : (Integer)componentAttrs.getAttribute("TRACE_MASK");
        if (traceMask == null) {
            traceMask = new Integer(0);
        }
        try {
            AttributeSet librariesAttrs = (AttributeSet)componentAttrs.getAttribute("NATIVE_LIBRARIES");
            if (librariesAttrs != null) {
                this.writeLibraries(librariesAttrs);
            }
            return this.loadComponent(id, configID, isAutoStart, traceMask, frameworkOnly) != null;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reloadComponent(final String id) throws Exception {
        ArrayList arrayList = this.m_reloadingIDs;
        synchronized (arrayList) {
            while (!this.m_reloadingIDs.isEmpty()) {
                this.m_reloadingIDs.wait(250L);
                if (!this.m_isClosing) continue;
                return;
            }
            this.m_reloadingIDs.add(id);
        }
        Runnable reloader = new Runnable(){

            @Override
            public void run() {
                ContainerImpl.this.internalReloadComponent(id, true);
            }
        };
        this.m_taskScheduler.scheduleTask(reloader, false);
    }

    void beginLogging() {
        this.m_isLoggingStarted = true;
        this.logMessage(this.m_tempLogBuffer);
        this.m_tempLogBuffer = "";
    }

    void setTraceMask(int traceMask) {
        this.m_connector.setTraceMask(traceMask);
        ClassLoaderFactory.setTraceMask(traceMask, m_containerDelegate);
    }

    void setSonicArchiveSearchPath(String searchPath) {
        if (searchPath == null || searchPath.length() == 0) {
            String message = "Invalid or unspecified archive search path: " + (searchPath == null ? "<null>" : searchPath);
            this.logMessage(null, message, 1);
            this.shutdown(8);
        }
        this.m_sonicArchiveSearchPath = searchPath;
    }

    void reportChangedElements(IDirElement[] elements) {
        try {
            this.updateConfigElements(elements);
        }
        catch (VersionOutofSyncException e) {
            this.reconcileCache();
        }
        catch (CacheClosedException e) {
            return;
        }
        catch (PersistentCacheException e) {
            this.logMessage(null, e, 1);
            this.shutdown(7);
        }
    }

    void reportChangedElement(IBasicElement elementParam) {
        IBasicElement element = elementParam;
        boolean reportToComponent = true;
        boolean replacement = false;
        if (element instanceof IEnvelope) {
            IEnvelope envelope = (IEnvelope)element;
            reportToComponent = envelope.getProperty("DRE") == null;
            replacement = envelope.getProperty("R") != null;
            element = envelope.getEnvelopedElement();
        }
        if (element.getIdentity().getName().equals("/_MFSystem/dsStartup")) {
            this.reconcileCache();
            return;
        }
        if (element.getIdentity().getName().equals("/_MFSystem/dsRenaming")) {
            this.notifyBeansOfRename(element);
            return;
        }
        try {
            this.cacheAndReportElement(element, reportToComponent, replacement);
        }
        catch (VersionOutofSyncException e) {
            this.reconcileCache();
        }
        catch (CacheClosedException e) {
            return;
        }
        catch (PersistentCacheException e) {
            this.logMessage(null, e, 1);
            this.shutdown(7);
        }
    }

    private void storeNotificationListenerSubscriptionsInCache(ObjectName objectName, NotificationListenerDelegate localListener) {
        if (!localListener.isDirty()) {
            return;
        }
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        String destination = localListener.getDestination();
        IAttributeSet subscriptionsAttrs = subscriptionsElement.getAttributes();
        try {
            subscriptionsAttrs.setBytesAttribute(destination, localListener.toByteArray());
        }
        catch (Exception e) {
            this.logMessage(null, "Exception while caching notification subscriptions for " + objectName.getCanonicalName(), e, 2);
            return;
        }
        this.setRuntimeConfigurationInCacheOnly(subscriptionsElement);
    }

    private void deleteNotificationListenerSubscriptionsFromCache(NotificationListenerDelegate localListener) {
        String componentName = new CanonicalName(localListener.getObjectName().getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        String destination = localListener.getDestination();
        IAttributeSet subscriptionsAttrs = subscriptionsElement.getAttributes();
        try {
            if (localListener.getHandbackFilterPairs().size() == 0) {
                Object existing = subscriptionsAttrs.getAttribute(destination);
                if (existing != null) {
                    subscriptionsAttrs.deleteAttribute(destination);
                    if (subscriptionsAttrs.getAttributes().size() == 0) {
                        this.deleteRuntimeElementFromCacheOnly(subscriptionsElement.getIdentity().getName());
                        return;
                    }
                }
            } else {
                subscriptionsAttrs.setBytesAttribute(destination, localListener.toByteArray());
            }
            this.setRuntimeConfigurationInCacheOnly(subscriptionsElement);
        }
        catch (Exception e) {
            this.logMessage(null, "Exception while updating cached notification subscriptions for " + localListener.getObjectName().getCanonicalName(), e, 2);
        }
    }

    void storeNotificationHandlerSubscriptionsInCache(ObjectName objectName, NotificationHandlerDelegate localHandler) {
        if (!localHandler.isDirty()) {
            return;
        }
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        IAttributeSet subscriptionsAttrs = subscriptionsElement.getAttributes();
        try {
            subscriptionsAttrs.setBytesAttribute(localHandler.getDestination(), localHandler.toByteArray());
        }
        catch (Exception e) {
            this.logMessage(null, "Exception while caching notification subscriptions for " + objectName.getCanonicalName(), e, 2);
            return;
        }
        this.setRuntimeConfigurationInCacheOnly(subscriptionsElement);
    }

    void deleteNotificationHandlerSubscriptionsFromCache(ObjectName objectName, NotificationHandlerDelegate localHandler) {
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        String destination = localHandler.getDestination();
        IAttributeSet subscriptionsAttrs = subscriptionsElement.getAttributes();
        try {
            Object existing = subscriptionsAttrs.getAttribute(destination);
            if (existing != null) {
                subscriptionsAttrs.deleteAttribute(destination);
                if (subscriptionsAttrs.getAttributes().size() == 0) {
                    this.deleteRuntimeElementFromCacheOnly(subscriptionsElement.getIdentity().getName());
                    return;
                }
            }
            this.setRuntimeConfigurationInCacheOnly(subscriptionsElement);
        }
        catch (Exception e) {
            this.logMessage(null, "Exception while updating cached notification subscriptions for " + localHandler.getDestination(), e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreNotificationSubscriptionsFromCache(ComponentMBean mBean) {
        ObjectName objectName = mBean.getObjectName();
        String componentName = new CanonicalName(objectName.getCanonicalName()).getComponentName();
        IDirElement subscriptionsElement = null;
        IAttributeSet subscriptionsAttrs = null;
        Iterator delegates = null;
        subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        subscriptionsAttrs = subscriptionsElement.getAttributes();
        delegates = subscriptionsAttrs.getAttributes().values().iterator();
        while (delegates.hasNext()) {
            try {
                NotificationListenerDelegate localListener = NotificationListenerDelegate.fromByteArray((byte[])delegates.next());
                String remoteListenerKey = localListener.getRemoteListenerKey();
                HashMap hashMap = this.m_notificationListeners;
                synchronized (hashMap) {
                    this.m_notificationListeners.put(remoteListenerKey, localListener);
                }
                this.m_mbeanServer.addNotificationListener(objectName, localListener, null, null);
            }
            catch (Exception e) {
                this.logMessage(null, "Exception while reading cached notification subscriptions for " + objectName.getCanonicalName(), e, 2);
                break;
            }
        }
        subscriptionsElement = this.getRuntimeConfigurationFromContainerCache(componentName, INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        subscriptionsAttrs = subscriptionsElement.getAttributes();
        delegates = subscriptionsAttrs.getAttributes().values().iterator();
        while (delegates.hasNext()) {
            try {
                NotificationHandlerDelegate localHandler = NotificationHandlerDelegate.fromByteArray((byte[])delegates.next());
                mBean.restoreNotificationHandler(localHandler);
            }
            catch (Exception e) {
                this.logMessage(null, "Exception while reading cached notification subscriptions for " + objectName.getCanonicalName(), e, 2);
                break;
            }
        }
    }

    private void notifyBeansOfRename(IBasicElement renamingNotificationsElement) {
        if (this.m_isClosing) {
            return;
        }
        try {
            byte[] streamBytes = (byte[])((IElement)renamingNotificationsElement).getAttributes().getAttribute("notifications");
            ByteArrayInputStream bais = new ByteArrayInputStream(streamBytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ArrayList notificationsList = (ArrayList)ois.readObject();
            for (int i = 0; i < notificationsList.size(); ++i) {
                IRenameNotification notification = (IRenameNotification)notificationsList.get(i);
                String[] storageNames = this.m_configCache.rename(notification.getName(), notification.getNewName());
                for (int j = 0; j < storageNames.length; ++j) {
                    Object[] entries = this.m_mBeans.entrySet().toArray();
                    for (int k = 0; k < entries.length; ++k) {
                        Map.Entry entry = (Map.Entry)entries[k];
                        AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
                        if (mBean == null) continue;
                        try {
                            if (!mBean.acceptChanges(this.getParentName(storageNames[j]), storageNames[j]).booleanValue() || !mBean.isLogicalRequest(storageNames[j])) continue;
                            if (this.m_isClosing) {
                                return;
                            }
                            mBean.handleFSNamingNotification((INamingNotification)notification);
                            continue;
                        }
                        catch (Throwable t) {
                            this.logMessage(null, "Failed to pass configuration change to component " + (String)entry.getKey() + ", trace follows... ", t, 2);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            MFRuntimeException re = new MFRuntimeException("Cache element rename failure");
            re.initCause((Throwable)e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHostingComponent(String id) {
        ArrayList arrayList = this.m_reloadingIDs;
        synchronized (arrayList) {
            if (this.m_reloadingIDs.contains(id)) {
                return true;
            }
        }
        return this.m_mBeans.containsKey(id);
    }

    void deleteRuntimeConfiguration(String id) {
        String rootDir = "/_MFRuntime/" + this.m_containerIdentity.getCanonicalName() + '/' + id;
        this.deleteRuntimeElement(rootDir + "/metrics");
        this.deleteRuntimeElement(rootDir + "/alerts");
        this.deleteRuntimeElementFromCacheOnly(rootDir + '/' + EXTERNAL_NOTIFICATION_SUBSCRIPTIONS);
        this.deleteRuntimeElementFromCacheOnly(rootDir + '/' + INTERNAL_NOTIFICATION_SUBSCRIPTIONS);
    }

    boolean isBooted() {
        return this.m_isBooted;
    }

    boolean isClosing() {
        return this.m_isClosing;
    }

    IContainerIdentity getContainerIdentity() {
        return this.m_containerIdentity;
    }

    ITaskScheduler getTaskScheduler() {
        return this.m_taskScheduler;
    }

    INotificationPublisher getNotificationPublisher() {
        return this.m_notificationPublisher;
    }

    void traceMessage(String message) {
        if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
            this.logMessage(null, message, 7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logMessage(String id, String message, int severityLevel) {
        if (this.m_isBooted && this.m_agent.getActionalLogInterceptor().booleanValue() && !this.m_isClosing && SonicLogInterceptor.beforeLogMessage((String)id, (String)message, (int)severityLevel)) {
            return;
        }
        String timestampedMessage = ContainerUtil.createLogMessage(m_isLSD ? this.m_containerIdentity.getContainerName() : null, id, message, severityLevel);
        if (this.m_isBooted && this.m_agent.getLogToConsole().booleanValue() && this.m_agent.getCommandLine().booleanValue() && !this.m_isClosing) {
            this.m_agent.crAfterPrompt();
        }
        if (this.m_isLoggingStarted) {
            this.logMessage(timestampedMessage);
        } else {
            this.m_tempLogBuffer = this.m_tempLogBuffer + (this.m_tempLogBuffer.length() == 0 ? "" : IContainer.NEWLINE) + timestampedMessage;
            if (this.m_isClosing) {
                System.out.println(this.m_tempLogBuffer);
            }
        }
        if (this.m_agent != null && this.m_isBooted && this.m_agent.getLogToConsole().booleanValue() && this.m_agent.getCommandLine().booleanValue() && !this.m_isClosing && !message.equals(SHUTDOWN_MESSAGE)) {
            this.m_agent.redoCLIPrompt();
        }
        if (severityLevel < 7) {
            ArrayList arrayList = this.m_pendingLogMessageQueue;
            synchronized (arrayList) {
                this.m_pendingLogMessageQueue.add(timestampedMessage);
                if (this.m_pendingLogMessageQueue.size() > 500) {
                    this.m_pendingLogMessageQueue.remove(0);
                }
            }
            this.exhaustPendingLogMessageQueue();
        }
        if (severityLevel < 7 && this.m_agentMBean != null && this.m_agentMBean.getManagedComponent() != null) {
            ((Agent)this.m_agentMBean.getManagedComponent()).sendLogMessageNotification(id, message, severityLevel);
        }
    }

    private void logMessage(String message) {
        for (int i = 0; i < this.m_listOfLoggers.size(); ++i) {
            IMessageLogger logger = (IMessageLogger)this.m_listOfLoggers.get(i);
            logger.logMessage(message);
        }
    }

    void logMessage(String id, String message, Throwable exception, int severityLevel) {
        if (this.isOutOfMemoryError(exception)) {
            if (this.m_isOutOfMemory) {
                return;
            }
            this.m_isOutOfMemory = true;
        }
        try {
            String formattedTraceMessage = ContainerUtil.appendThrowableToMessage(message, exception);
            this.logMessage(id, formattedTraceMessage, severityLevel);
        }
        catch (OutOfMemoryError oome) {
            try {
                System.err.print("An OutOfMemoryError occurred while attempting to log the following exception: ");
                System.err.println(exception.toString());
                exception.printStackTrace();
                System.err.println("Logging failed due to: " + oome.toString());
            }
            catch (Throwable t) {
                try {
                    s_errDirect.print("Sonic logging failed for the following exception: ");
                    s_errDirect.println(exception.toString());
                    exception.printStackTrace(s_errDirect);
                    s_errDirect.println("Logging failed due to:");
                    s_errDirect.print("1. ");
                    s_errDirect.println(oome.toString());
                    s_errDirect.print("2. ");
                    s_errDirect.println(t.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_isOutOfMemory = true;
        }
        if (this.m_isOutOfMemory) {
            if (this.m_agent != null) {
                this.m_agent.shutdown(12);
            } else {
                this.shutdown(12);
            }
        }
    }

    private boolean isOutOfMemoryError(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            return true;
        }
        Throwable cause = exception.getCause();
        return cause != null && this.isOutOfMemoryError(cause);
    }

    void logMessage(String id, Throwable exception, int severityLevel) {
        this.logMessage(id, "Trace follows...", exception, severityLevel);
    }

    IContainerState getContainerState() {
        String domainName = this.m_containerIdentity.getDomainName();
        String containerName = this.m_containerIdentity.getContainerName();
        CanonicalName canonicalName = new CanonicalName(domainName, containerName, "");
        ContainerState containerState = new ContainerState(canonicalName, this.m_containerIdentity.getConfigIdentity());
        if (this.m_isClosing) {
            containerState.setState((short)1);
        }
        Object[] entries = this.m_mBeans.entrySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = (Map.Entry)entries[i];
            canonicalName = new CanonicalName(domainName, containerName, (String)entry.getKey());
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
            IComponentState componentState = mBean.getComponentState();
            if (this.m_isClosing) {
                ((ComponentState)componentState).setState((short)1);
            }
            containerState.addComponentState(componentState);
        }
        return containerState;
    }

    IConnectorServer getConnectorServer() {
        return this.m_connector.getConnectorServer();
    }

    void shutdown(int exitCode) {
        this.shutdown(exitCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(int exitCode, boolean cleanRestart) {
        Object sb2;
        if (this.m_connector != null) {
            this.m_connector.closePending();
        }
        if (this.m_isClosing) {
            return;
        }
        if (!this.m_generateCache) {
            sb2 = new StringBuffer();
            if (exitCode == 14) {
                ((StringBuffer)sb2).append(RESTART_MESSAGE);
            } else {
                ((StringBuffer)sb2).append(SHUTDOWN_MESSAGE);
            }
            if (exitCode != 0) {
                ((StringBuffer)sb2).append(" (exit code=").append(exitCode).append(')');
                this.logMessage(null, ((StringBuffer)sb2).toString(), 2);
            } else {
                this.logMessage(null, ((StringBuffer)sb2).toString(), 3);
            }
        }
        this.m_isClosing = true;
        sb2 = this.m_notificationListenerExpirer.getLockObj();
        synchronized (sb2) {
            this.m_notificationListenerExpirer.getLockObj().notifyAll();
        }
        sb2 = m_containerDelegate;
        synchronized (sb2) {
            m_containerDelegate.notifyAll();
        }
        try {
            int i;
            if (this.m_agent != null) {
                this.m_agent.sendShutdownNotification(exitCode);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception sb2) {
                // empty catch block
            }
            if (!this.m_isLoggingStarted && this.m_tempLogBuffer.length() > 0) {
                ((PrintStream)Agent.m_stdout).println(this.m_tempLogBuffer);
                ((PrintStream)Agent.m_stdout).flush();
                this.m_tempLogBuffer = "";
            }
            if (this.m_dsMonitor != null) {
                this.m_dsMonitor.close();
            }
            Object[] entries = null;
            entries = this.m_mBeans.entrySet().toArray();
            for (i = 0; i < entries.length; ++i) {
                Map.Entry entry = (Map.Entry)entries[i];
                AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
                if (ContainerUtil.isFrameworkComponent(mBean.getManagedComponent().getClass())) continue;
                String id = (String)entry.getKey();
                try {
                    this.unloadComponent(id);
                    continue;
                }
                catch (Throwable e) {
                    this.logMessage(null, "Failed to unload ID=" + id + ", trace follows...", e, 2);
                }
            }
            entries = this.m_mBeans.keySet().toArray();
            for (i = 0; i < entries.length; ++i) {
                try {
                    if (entries[i].equals("AGENT")) continue;
                    this.unloadComponent((String)entries[i]);
                    continue;
                }
                catch (Throwable e) {
                    this.logMessage(null, "Failed to unload ID=" + (String)entries[i] + ", trace follows...", e, 2);
                }
            }
            IContainer i22 = m_containerDelegate;
            synchronized (i22) {
                m_containerDelegate.notifyAll();
            }
            if (this.m_connectorHandback != null) {
                this.m_connectorHandback.close();
                this.m_connectorHandback = null;
            }
            if (this.m_connector != null) {
                try {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException i22) {
                        // empty catch block
                    }
                    this.m_connector.close();
                }
                catch (Throwable e) {
                    Throwable t = e instanceof MFRuntimeException ? e.getCause() : e;
                    this.logMessage(null, "Failed to clean up JMS subscriptions/connections, trace follows...", t, 2);
                }
            }
            if (this.m_configCache != null && exitCode != 7) {
                try {
                    this.m_configCache.close();
                }
                catch (PersistentCacheException e) {
                    this.logMessage(null, "Unable to persist local configuration cache, trace follows...", e, 1);
                }
            }
            if (this.m_isLoggingStarted) {
                try {
                    this.unloadComponent("AGENT");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (IContainer.SIGNAL_MODE) {
                System.out.print("\u0007" + exitCode + '\u0007');
                System.out.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (IContainer.SIGNAL_MODE) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException entries) {}
            }
            if (!this.m_generateCache) {
                if (exitCode == 14) {
                    this.logMessage(null, "Restarting...", 3);
                } else {
                    this.logMessage(null, "Exiting...", 3);
                }
            }
            if (System.getProperty("htmlAdaptor", "false").equals("true")) {
                try {
                    int port = Integer.parseInt(System.getProperty("htmlAdaptor.port", "8082"));
                    this.m_mbeanServer.invoke(new ObjectName("Adaptor:name=html,port=" + port), "stop", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
                }
                catch (Throwable e) {
                    this.logMessage(null, e, 1);
                }
            }
            this.m_notificationPublisher.close();
            this.m_taskScheduler.close();
            if (this.m_abortMonitor != null) {
                this.m_abortMonitor.close();
            }
            if (m_isLSD) {
                ThreadGroup root = Thread.currentThread().getThreadGroup();
                while (root.getParent() != null) {
                    root = root.getParent();
                }
                Thread[] activeThreads = new Thread[1000];
                int count = root.enumerate(activeThreads, true);
                for (int i = 0; i < count; ++i) {
                    if (activeThreads[i].isDaemon() || activeThreads[i].getName().equals("DestroyJavaVM")) continue;
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            if (cleanRestart) {
                try {
                    new FileOutputStream("clean_restart_file", true).close();
                }
                catch (Exception e) {
                    this.logMessage("Could not wrire clean restart file", e, 2);
                }
            }
            new File("start_timestamp").delete();
            if (!m_isLSD) {
                this.m_containerRunningLockFile.unlock();
            }
            ContainerExitCode e = this.m_containerExitCode;
            synchronized (e) {
                this.m_containerExitCode.setExitCode(new Integer(exitCode));
                this.m_containerExitCode.exit(true);
                this.m_containerExitCode.notifyAll();
            }
        }
    }

    void addGlobalComponentSupport(String globalID, String instanceID, IGlobalComponentListener globalComponentListener) throws Exception {
        if (this.m_isClosing) {
            return;
        }
        this.m_connector.addGlobalComponentSupport(globalID, instanceID, globalComponentListener);
    }

    void removeGlobalComponentSupport(String globalID, String instanceID) {
        this.m_connector.removeGlobalComponentSupport(globalID, instanceID);
    }

    void setLocalDS(IFrameworkComponent ds) {
        this.m_directory.setLocalDS((DSComponent)ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSharedClassname(String classname) {
        HashSet hashSet = this.m_sharedClasses;
        synchronized (hashSet) {
            this.m_sharedClasses.add(classname);
        }
    }

    Timer getTimer() {
        return this.m_timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object loadComponent(String idParam, String configID, boolean start, int traceMask, boolean frameworkOnly) throws Exception {
        String id = idParam;
        IContainer iContainer = m_containerDelegate;
        synchronized (iContainer) {
            while (this.m_isLoading || this.m_isUnloading) {
                if (this.m_isClosing) {
                    throw new IllegalStateException("Cannot load component [" + id + "] while shutdown is occuring");
                }
                m_containerDelegate.wait();
            }
            this.m_isLoading = true;
            try {
                boolean isFrameworkComponent;
                IComponent component;
                AbstractMBean mBean;
                block23: {
                    block22: {
                        mBean = null;
                        component = null;
                        mBean = this.internalLoadComponent(id, configID, traceMask, frameworkOnly);
                        if (mBean != null) break block22;
                        Object var11_10 = null;
                        return var11_10;
                    }
                    try {
                        boolean sendNotification;
                        component = mBean.getManagedComponent();
                        isFrameworkComponent = component instanceof IFrameworkComponent;
                        if (!this.m_isBooted) break block23;
                        Integer lastErrorLevel = null;
                        String lastError = null;
                        if (component instanceof IGlobalFrameworkComponent) {
                            id = ((IGlobalFrameworkComponent)component).getGlobalID();
                        }
                        lastError = (String)mBean.getAttribute("LastError");
                        lastErrorLevel = (Integer)mBean.getAttribute("LastErrorLevel");
                        boolean bl = sendNotification = !id.equals("AGENT MANAGER");
                        if (!sendNotification) {
                            ArrayList arrayList = this.m_reloadingIDs;
                            synchronized (arrayList) {
                                if (!this.m_reloadingIDs.contains("AGENT MANAGER")) {
                                    sendNotification = true;
                                }
                            }
                        }
                        if (sendNotification) {
                            this.m_agent.sendComponentLoadNotification(id, configID, lastError, lastErrorLevel);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        this.logMessage(null, "Failed to load ID=" + id + " due to insufficient memory...", e, 1);
                        throw e;
                    }
                    catch (Throwable e) {
                        this.logMessage(null, "Failed to load ID=" + id + ", trace follows...", e, 1);
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw (Error)e;
                    }
                }
                if (id.equals("AGENT")) {
                    start = false;
                }
                if (this.m_containerFT != null && !this.m_containerFT.isActive()) {
                    start = false;
                }
                if (start) {
                    this.startComponent(id, component, isFrameworkComponent);
                }
                AbstractMBean abstractMBean = mBean;
                return abstractMBean;
            }
            finally {
                this.m_isLoading = false;
                m_containerDelegate.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startComponent(String id, IComponent component, boolean isFrameworkComponent) throws Exception {
        try {
            MBeanHolder holder;
            if (!id.equals("AGENT") && !id.equals("DIRECTORY SERVICE")) {
                Thread.currentThread().setContextClassLoader(ClassLoaderFactory.getDelegatingLoader(this.m_containerIdentity.getCanonicalName(), id));
            }
            if (id.equals("AGENT MANAGER") && (holder = (MBeanHolder)this.m_mBeans.get(id)) != null) {
                ArrayList arrayList = this.m_reloadingIDs;
                synchronized (arrayList) {
                    if (this.m_reloadingIDs.contains(id)) {
                        this.m_reloadingIDs.clear();
                        this.m_reloadingIDs.notifyAll();
                    }
                }
            }
            component.start();
        }
        catch (OutOfMemoryError e) {
            this.logMessage(null, "Failed to start ID=" + id + " due to insufficient memory...", e, 1);
            throw e;
        }
        catch (Throwable e) {
            this.logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, 1);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        finally {
            if (!isFrameworkComponent) {
                Thread.currentThread().setContextClassLoader(this.m_defaultClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unloadComponent(String id) throws Exception {
        IContainer iContainer = m_containerDelegate;
        synchronized (iContainer) {
            while (this.m_isUnloading || this.m_isLoading && !this.m_isClosing) {
                m_containerDelegate.wait();
            }
            this.m_isUnloading = true;
            try {
                boolean logUnload;
                MBeanHolder holder = (MBeanHolder)this.m_mBeans.get(id);
                if (holder == null) {
                    throw new MFException("Unknown ID: " + id);
                }
                AbstractMBean mBean = holder.mBean;
                if (mBean == null) {
                    throw new MFException("Unknown ID: " + id);
                }
                ClassLoaderFactory.removeLoaderUsages(this.m_containerIdentity.getCanonicalName(), id);
                IComponent component = mBean.getManagedComponent();
                if (component.getState() != 1) {
                    component.stop();
                }
                component.destroy();
                mBean.cleanup();
                this.m_mbeanServer.unregisterMBean(mBean.getObjectName());
                boolean bl = logUnload = !id.equals("AGENT MANAGER");
                if (!logUnload) {
                    ArrayList arrayList = this.m_reloadingIDs;
                    synchronized (arrayList) {
                        if (!this.m_reloadingIDs.contains("AGENT MANAGER")) {
                            logUnload = true;
                        }
                    }
                }
                if (logUnload) {
                    if (!this.m_generateCache) {
                        this.logMessage(null, "Unloaded ID=" + id, 3);
                    }
                    if (this.m_isBooted && !this.m_isClosing) {
                        this.m_agent.sendComponentUnloadNotification(id);
                    }
                }
                String matchString = ":ID=" + id;
                HashMap hashMap = this.m_notificationListeners;
                synchronized (hashMap) {
                    Iterator iterator = this.m_notificationListeners.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        if (!key.endsWith(matchString)) continue;
                        iterator.remove();
                        ((NotificationListenerDelegate)entry.getValue()).close();
                    }
                }
                holder.mBean = null;
            }
            finally {
                this.m_mBeans.remove(id);
                this.m_isUnloading = false;
                m_containerDelegate.notifyAll();
            }
        }
    }

    Object invokeLocal(String target, String operationName, Object[] params, String[] signature) throws Exception {
        try {
            return this.m_internalRequestHandler.invoke(new ObjectName(target), operationName, params, signature, true);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = this.handleException(ite);
            throw (Error)throwable;
        }
    }

    Object invokeLocal(String target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
        try {
            return this.m_internalRequestHandler.invoke(new ObjectName(target), operationName, params, signature, checkExported);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = this.handleException(ite);
            throw (Error)throwable;
        }
    }

    private Throwable handleException(InvocationTargetException ite) throws Exception {
        Throwable throwable = ite.getTargetException();
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        return throwable;
    }

    Object invokeRemote(String target, String operationName, Object[] params, String[] signature, long timeout, boolean synchronous) throws Exception {
        if (synchronous) {
            return this.m_connector.invoke("mf", target, target, operationName, params, signature, timeout);
        }
        long ttl = timeout;
        if (operationName.equals(HANDLE_NOTIFICATION_METHOD_NAME)) {
            ttl = JMSConnectorServer.NOTIFICATION_TTL;
        }
        this.m_connector.invokeOneway("mf", target, target, operationName, params, signature, timeout, ttl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractMBean getMBean(String id) {
        MBeanHolder holder;
        boolean logIfBlocked = false;
        ArrayList arrayList = this.m_reloadingIDs;
        synchronized (arrayList) {
            if (this.m_reloadingIDs.contains(id)) {
                logIfBlocked = true;
            }
        }
        if (logIfBlocked) {
            this.logMessage(id, "Management request blocked during component reload...", 3);
        }
        arrayList = this.m_reloadingIDs;
        synchronized (arrayList) {
            while (this.m_reloadingIDs.contains(id)) {
                try {
                    this.m_reloadingIDs.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (logIfBlocked) {
            this.logMessage(id, "...request resumed after reload", 3);
        }
        return (holder = (MBeanHolder)this.m_mBeans.get(id)) == null ? null : holder.mBean;
    }

    AbstractMBean getMBeanNonBlocking(String id) {
        MBeanHolder holder = (MBeanHolder)this.m_mBeans.get(id);
        return holder == null ? null : holder.mBean;
    }

    Context getInitialContext() {
        return new MFContext(this, "");
    }

    boolean isDirectoryServiceAccessible() {
        return this.m_dsMonitor != null && this.m_dsMonitor.isAccessible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInterestInLogicalName() {
        if (!this.m_storageNames.contains(this.m_containerIdentity.getConfigIdentity().getName())) {
            this.m_storageNames.add(this.m_containerIdentity.getConfigIdentity().getName());
        }
        HashSet hashSet = this.m_storageNames;
        synchronized (hashSet) {
            Iterator storageNames = this.m_storageNames.iterator();
            while (storageNames.hasNext()) {
                if (this.m_isClosing) {
                    return;
                }
                this.storageToLogical((String)storageNames.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String storageToLogical(String storageName) {
        String logicalName = this.m_configCache.storageToLogical(storageName);
        if (logicalName == null) {
            logicalName = this.m_directory.storageToLogical(storageName);
        }
        if (logicalName != null) {
            this.m_directory.registerInterestInChanges(this.m_containerIdentity.getCanonicalName(), logicalName);
            HashSet hashSet = this.m_storageNames;
            synchronized (hashSet) {
                if (!this.m_storageNames.contains(storageName)) {
                    this.m_storageNames.add(storageName);
                }
            }
        }
        return logicalName;
    }

    int checkFSConfiguration(String path) {
        try {
            if (this.m_configCacheView.getElementByLogicalName(path) != null) {
                return 1;
            }
        }
        catch (CacheClosedException ex) {
            MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
            re.initCause((Throwable)ex);
            throw re;
        }
        try {
            if (this.m_directory.getElementByLogicalName(this.m_containerIdentity.getCanonicalName(), path, false) != null) {
                return 1;
            }
            return -1;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    IElement getFSConfiguration(String logicalName, boolean alwaysFromDS) {
        IElement config = null;
        try {
            if (!alwaysFromDS) {
                config = this.m_configCacheView.getElementByLogicalName(logicalName);
            }
            if (config == null) {
                config = this.m_directory.getElementByLogicalName(this.m_containerIdentity.getCanonicalName(), logicalName);
                if (config == null) {
                    return null;
                }
                String archiveName = config.getArchiveName();
                if (archiveName == null) {
                    archiveName = logicalName;
                }
                this.m_configCache.setElementByLogicalName(archiveName, (IBasicElement)config);
                if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
                    this.logMessage(null, "Configuration [" + config.getIdentity().getName() + "] added to cache", 7);
                }
            }
        }
        catch (VersionOutofSyncException e) {
            this.logMessage(null, e, 1);
            this.shutdown(8);
        }
        catch (CacheException e) {
            return this.createException(config, e);
        }
        return config;
    }

    IElement getFSConfiguration(String logicalName) {
        return this.getFSConfiguration(logicalName, false);
    }

    File getLocalFile(String logicalName) throws MFException {
        LogicalFile file = null;
        File blobFile = null;
        try {
            file = this.m_fileManager.localFileFromLocation(null, logicalName, false, null);
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (VersionOutofSyncException e) {
            this.logMessage(null, e, 1);
            this.shutdown(8);
        }
        catch (CacheException e) {
            throw ContainerImpl.createExceptionConfigurationImplementation(e);
        }
        return ContainerImpl.retrieveBlobFile(blobFile, file);
    }

    File getLocalFile(String location, String logicalName) throws MFException {
        LogicalFile file = null;
        File blobFile = null;
        try {
            file = this.m_fileManager.localFileFromLocation(location, logicalName, false, null);
        }
        catch (CacheClosedException cacheClosedException) {
        }
        catch (VersionOutofSyncException e) {
            this.logMessage(null, e, 1);
            this.shutdown(8);
        }
        catch (CacheException e) {
            throw ContainerImpl.createExceptionConfigurationImplementation(e);
        }
        return ContainerImpl.retrieveBlobFile(blobFile, file);
    }

    private static File retrieveBlobFile(File blobFileParam, LogicalFile file) {
        File blobFile = blobFileParam;
        if (file != null) {
            blobFile = new File(file.getFileName());
        }
        return blobFile;
    }

    String getPrivateSubDir(String configID, String baseDirParam) {
        String baseDir = baseDirParam;
        IAttributeSet containerAttrs = this.m_containerConfig.getAttributes();
        String domainName = (String)containerAttrs.getAttribute("DOMAIN_NAME");
        String containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute("COMPONENTS");
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                Map.Entry componentEntry = (Map.Entry)components[i];
                String id = (String)componentEntry.getKey();
                IAttributeSet compSet = (IAttributeSet)componentEntry.getValue();
                String compId = ((Reference)compSet.getAttribute("CONFIG_REF")).getElementName();
                if (!compId.equals(configID)) continue;
                if (!baseDir.endsWith(File.separator)) {
                    baseDir = baseDir + File.separator;
                }
                String dirName = baseDir + domainName + "." + containerName + "." + id;
                File tempDir = new File(dirName);
                boolean madeDirs = true;
                if (!tempDir.exists()) {
                    madeDirs = tempDir.mkdirs();
                }
                if (!madeDirs) continue;
                return tempDir.getAbsolutePath();
            }
        }
        return null;
    }

    IElement getConfiguration(String configID, boolean alwaysFromDS) {
        IElement config = null;
        while (true) {
            try {
                if (!alwaysFromDS) {
                    config = this.m_configCacheView.getElement(configID);
                }
                if (config != null) break;
                config = this.m_directory.getElement(this.m_containerIdentity.getCanonicalName(), configID);
                if (config == null) {
                    return null;
                }
                this.setElement((IBasicElement)config);
                if ((this.m_agent.m_traceMask & 0x200) <= 0 || (this.m_agent.m_traceMask & 1) <= 0) break;
                this.logMessage(null, "Configuration [" + config.getIdentity().getName() + "] added to cache", 7);
            }
            catch (VersionOutofSyncException e) {
                this.logMessage(null, e, 1);
                this.shutdown(8);
            }
            catch (CacheException e) {
                return this.createException(config, e);
            }
            catch (InvokeTimeoutException e) {
                if (this.m_generateCache && !this.m_isClosing) {
                    this.logMessage(null, "Timeout while obtaining configuration [" + configID + "], retry initiated", 2);
                    continue;
                }
                throw e;
            }
            break;
        }
        return config;
    }

    IElement getConfiguration(String configID) {
        return this.getConfiguration(configID, false);
    }

    IElement[] getConfigurations(String[] configIDs) {
        IElement[] configs = new IElement[configIDs.length];
        while (true) {
            try {
                int i;
                boolean allAllreadyInCache = true;
                for (i = 0; i < configIDs.length; ++i) {
                    configs[i] = this.m_configCacheView.getElement(configIDs[i]);
                    if (configs[i] != null) continue;
                    allAllreadyInCache = false;
                }
                if (allAllreadyInCache) break;
                configs = this.m_directory.getElements(this.m_containerIdentity.getCanonicalName(), configIDs);
                for (i = 0; i < configs.length; ++i) {
                    this.setElement((IBasicElement)configs[i]);
                    if ((this.m_agent.m_traceMask & 0x200) <= 0 || (this.m_agent.m_traceMask & 1) <= 0) continue;
                    this.logMessage(null, "Configuration [" + configs[i].getIdentity().getName() + "] added to cache", 7);
                }
            }
            catch (VersionOutofSyncException e) {
                this.logMessage(null, e, 1);
                this.shutdown(8);
            }
            catch (CacheException e) {
                return this.createException(configs, e);
            }
            catch (InvokeTimeoutException e) {
                if (this.m_generateCache && !this.m_isClosing) {
                    this.logMessage(null, "Timeout while obtaining multiple configurations, retry initiated", 2);
                    continue;
                }
                throw e;
            }
            break;
        }
        return configs;
    }

    private <T0> T0 createException(T0 configs, CacheException e) {
        if (e instanceof CacheClosedException) {
            return configs;
        }
        throw ContainerImpl.createExceptionConfigurationImplementation(e);
    }

    public void generateDSBootFile(String dsConfigID) {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return;
        }
        try {
            String dsBootContent = this.m_directory.exportDSBootFileString(dsConfigID);
            ContainerUtil.encryptAndStore(dsBootContent, "ds.xml", IContainer.PASSWORD);
            this.logMessage(null, "(Re)Generated the ds.xml file", 3);
        }
        catch (Exception e) {
            this.logMessage(null, "Failed to generate the \"ds.xml\" file, trace follows...", e, 2);
        }
    }

    IDirIdentity[] listDirectories(String parentDir) {
        return this.m_directory.listDirectories(parentDir);
    }

    IElementIdentity[] listElements(String dirName) {
        return this.m_directory.listElements(dirName);
    }

    IDirElement[] getAllElements(String dirName) {
        return this.m_directory.getAllElements(dirName);
    }

    IIdentity[] listAll(String dirName) {
        return this.m_directory.listAll(dirName);
    }

    IElement[] getConfigurations(String dirName, Boolean acceptChanges) {
        IElement[] configs = null;
        while (true) {
            try {
                if (this.m_configCacheView.getInterestInDir(dirName)) {
                    configs = this.m_configCacheView.getAllElements(dirName);
                    if (configs != null) break;
                    throw new MFRuntimeException(dirName + " is invalid.");
                }
                configs = this.m_directory.getAllElements(this.m_containerIdentity.getCanonicalName(), dirName);
                this.setElements(configs);
                if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
                    this.logMessage(null, "Configurations [" + dirName + "] added to cache", 7);
                }
                this.m_configCache.setInterestInDir(dirName);
            }
            catch (VersionOutofSyncException e) {
                this.logMessage(null, e, 1);
                this.shutdown(8);
            }
            catch (CacheException e) {
                throw ContainerImpl.createExceptionConfigurationImplementation(e);
            }
            catch (InvokeTimeoutException e) {
                if (this.m_generateCache && !this.m_isClosing) {
                    this.logMessage(null, "Timeout while obtaining multiple configurations [" + dirName + ", retry initiated", 2);
                    continue;
                }
                throw e;
            }
            break;
        }
        return configs;
    }

    private static MFRuntimeException createExceptionConfigurationImplementation(CacheException e) {
        MFRuntimeException re = new MFRuntimeException("Configuration implementation failure.");
        re.initCause((Throwable)e);
        return re;
    }

    IDirElement getRuntimeConfiguration(String id, String type) {
        return this.m_runtimeConfigurationManager.getRuntimeConfiguration(id, type, false);
    }

    IDirElement getRuntimeConfigurationFromContainerCache(String id, String type) {
        return this.m_runtimeConfigurationManager.getRuntimeConfiguration(id, type, true);
    }

    void setRuntimeConfiguration(IDirElement config) {
        this.m_runtimeConfigurationManager.setRuntimeConfiguration(config, false);
    }

    void setRuntimeConfigurationInCacheOnly(IDirElement config) {
        this.m_runtimeConfigurationManager.setRuntimeConfiguration(config, true);
    }

    boolean isCacheReadOnly() {
        return this.m_runtimeConfigurationManager.isCacheReadOnly();
    }

    private void deleteRuntimeElement(String configID) {
        this.m_runtimeConfigurationManager.deleteRuntimeConfiguration(configID, false);
    }

    private void deleteRuntimeElementFromCacheOnly(String configID) {
        this.m_runtimeConfigurationManager.deleteRuntimeConfiguration(configID, true);
    }

    void makeGlobalComponentUniquenessCall(String globalComponentID, String callID) throws Exception {
        this.makeGlobalComponentUniquenessCall(globalComponentID, callID, null);
    }

    void makeGlobalComponentUniquenessCall(String globalComponentID, String callID, String instanceID) throws Exception {
        try {
            String containerID = instanceID == null ? globalComponentID : JMSConnectorServer.getPseudoContainerID((String)globalComponentID, (String)instanceID);
            String canonicalName = new CanonicalName(this.m_containerIdentity.getDomainName(), containerID, globalComponentID).getCanonicalName();
            this.m_connector.invokeOneway("mf", canonicalName, canonicalName, "uniquenessCheck", new Object[]{this.m_containerIdentity.getCanonicalName(), callID}, new String[]{String.class.getName(), String.class.getName()}, 0L);
        }
        catch (InvokeTimeoutException invokeTimeoutException) {
            // empty catch block
        }
    }

    private void bootFramework(String containerConfigID) throws Exception {
        SonicURLStreamHandlerFactoryImpl urlStreamHandlerFactory;
        IAttributeSet containerAttrs;
        block28: {
            String ftRole;
            Integer queueSize;
            Integer minThreads;
            this.m_containerConfig = (IDirElement)this.m_configCacheView.getElement(containerConfigID);
            this.m_containerIdentity = new ContainerIdentity((IElement)this.m_containerConfig);
            containerAttrs = this.m_containerConfig.getAttributes();
            Boolean hostsDS = (Boolean)containerAttrs.getAttribute("HOSTS_DIRECTORY_SERVICE");
            IAttributeSet cacheAttrs = (IAttributeSet)containerAttrs.getAttribute("CACHE");
            Integer maxDataMemory = (Integer)cacheAttrs.getAttribute("MAXIMUM_DATA_MEMORY");
            this.m_configCache.adjustSize(maxDataMemory);
            Integer maxThreads = (Integer)containerAttrs.getAttribute("MAX_THREADS");
            if (maxThreads != null) {
                this.m_taskScheduler.setMaxThreads(maxThreads);
            }
            if ((minThreads = (Integer)containerAttrs.getAttribute("MIN_THREADS")) != null) {
                this.m_taskScheduler.setMinThreads(minThreads);
            }
            if ((queueSize = (Integer)containerAttrs.getAttribute("NOTIFICATION_DISPATCH_QUEUE_SIZE")) != null) {
                this.m_notificationPublisher.setQueueSize(queueSize);
            }
            this.setDSPingFrequency((Integer)containerAttrs.getAttribute("DIRECTORY_SERVICE_PING_INTERVAL"));
            this.setSonicArchiveSearchPath((String)containerAttrs.getAttribute("ARCHIVE_SEARCH_PATH"));
            IAttributeSet ftAttrs = (IAttributeSet)containerAttrs.getAttribute("FAULT_TOLERANCE_PARAMETERS");
            boolean bl = this.m_isFTContainer = ftAttrs != null;
            if (this.m_isFTContainer && ((ftRole = (String)ftAttrs.getAttribute("FAULT_TOLERANCE_ROLE")) == null || ftRole.length() == 0)) {
                this.m_isFTContainer = false;
            }
            if (this.m_generateCache) {
                String msg = this.m_generateCacheUtil ? "Generating configuration cache" : "Updating configuration cache";
                this.logMessage(null, msg + " for container \"" + this.m_containerIdentity.getCanonicalName() + "\"...", 3);
            }
            this.logMessage(null, this.getConfigMessage(containerAttrs), 4);
            this.validateConfig(containerAttrs);
            if (!this.m_generateCache) {
                this.logMessage(null, '\"' + this.m_containerIdentity.getCanonicalName() + "\" starting...", 3);
            }
            String devClasspath = null;
            devClasspath = System.getProperty("sonicsw.mf.devGlobalClasspath");
            if (devClasspath != null) {
                m_container.logMessage(null, "Using global classpath prepended with: " + devClasspath, 4);
            }
            if ((devClasspath = System.getProperty("sonicsw.mf.devSharedLibraryClasspath")) != null) {
                m_container.logMessage(null, "Using shared library classpaths prepended with: " + devClasspath, 4);
            }
            if ((devClasspath = System.getProperty("sonicsw.mf.devPrivateClasspath")) != null) {
                m_container.logMessage(null, "Using private classpaths prepended with: " + devClasspath, 4);
            }
            if (System.getProperty("disableShutdownHook", "false").equals("false")) {
                Thread shutdownHook = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (ContainerImpl.this.m_isBooted) {
                            ContainerImpl.this.m_agent.shutdown(0);
                        } else {
                            ContainerImpl.this.shutdown(ContainerImpl.this.m_containerExitCode.getExitCode());
                        }
                        ContainerExitCode containerExitCode = ContainerImpl.this.m_containerExitCode;
                        synchronized (containerExitCode) {
                            while (!ContainerImpl.this.m_containerExitCode.exit()) {
                                try {
                                    ContainerImpl.this.m_containerExitCode.wait(1000L);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }
                };
                shutdownHook.setDaemon(true);
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            if (Integer.getInteger("sonicsw.mf.qa.abort", 0).longValue() > 0L) {
                this.m_abortMonitor = new Monitor();
                this.m_abortMonitor.start();
            }
            this.bootMBeanServer();
            this.loadConnectorServer(containerAttrs);
            this.m_directory = new ContainerDS(this, this.m_connector, this.m_containerIdentity, "mf");
            this.m_hostManager = new HostManager(this.m_containerIdentity.getDomainName(), this.m_containerIdentity.getCanonicalName(), this);
            this.m_fileManager = new LocalFileManager(null, this.m_configCache, new ContainerLogger(), this.m_containerIdentity.getCanonicalName());
            String archiveName = (String)containerAttrs.getAttribute("ARCHIVE_NAME");
            if (archiveName != null) {
                this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, archiveName);
            }
            this.m_fileManager.setBlobSource(this.m_directory);
            this.m_runtimeConfigurationManager = new RuntimeConfigurationManager(this, this.m_configCache, this.m_directory);
            Integer traceMask = (Integer)containerAttrs.getAttribute("TRACE_MASK");
            if (traceMask == null) {
                traceMask = new Integer(0);
            }
            AbstractMBean mBean = (AbstractMBean)this.loadComponent("AGENT", containerConfigID, true, traceMask, true);
            this.m_agent = (Agent)mBean.getManagedComponent();
            this.m_agentMBean = mBean;
            this.startComponent("AGENT", this.m_agent, true);
            this.m_fileManager.setTraceMask(null != this.m_agent ? this.m_agent.m_traceMask : 0);
            if (hostsDS != null && hostsDS.booleanValue()) {
                if (this.isFTContainer()) {
                    String errMessage = "Hosting DS in an FT container is not supported";
                    this.logMessage(null, errMessage, 1);
                    this.shutdown(8);
                } else {
                    this.loadDirectoryService(containerAttrs);
                }
            }
            urlStreamHandlerFactory = new SonicURLStreamHandlerFactoryImpl(this);
            try {
                URL.setURLStreamHandlerFactory(urlStreamHandlerFactory);
            }
            catch (Throwable e) {
                if (m_isLSD) break block28;
                this.logMessage(null, "Failed to set URLStreamHandlerFactory, trace follows...", e, 1);
            }
        }
        this.m_directory.setURLStreamHandlerFactory(urlStreamHandlerFactory);
        this.m_agent.initFineGrainedSecurity();
        if (System.getProperty("htmlAdaptor", "false").equals("true")) {
            try {
                int port = Integer.parseInt(System.getProperty("htmlAdaptor.port", "8082"));
                Class<?> htmlAdaptorClass = this.m_defaultClassLoader.loadClass("com.sun.jdmk.comm.HtmlAdaptorServer");
                Constructor<?> constructor = htmlAdaptorClass.getConstructor(Integer.TYPE);
                DynamicMBean htmlAdaptor = (DynamicMBean)constructor.newInstance(new Integer(port));
                this.m_mbeanServer.registerMBean(htmlAdaptor, new ObjectName("Adaptor:name=html,port=" + port));
                htmlAdaptor.invoke("start", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY);
            }
            catch (Throwable e) {
                this.logMessage(null, e, 1);
            }
        }
        this.m_externalRequestHandler = new ExternalRequestHandler();
        this.m_connectorHandback = this.m_connector.addRequestHandler(this.m_externalRequestHandler);
        if (this.m_isClosing) {
            throw new ShutdownInProgressException();
        }
        this.reconcileCache();
        if (this.m_configCacheView.getDSBackupVersion() == null) {
            this.m_configCache.setDSBackupVersion(this.getBackupTimestampFromDS());
        }
        this.startDSMonitoringThread(this.m_dsPingFrequency, !this.m_dsNotInitiallyAccessible);
        if (this.isFTContainer() && !this.m_generateCache) {
            this.m_containerFT = new ContainerFT(this, this.m_connector);
        }
        this.loadAllConfiguredComponents(containerAttrs);
        if (this.m_generateCache) {
            String cacheDirName = null;
            cacheDirName = this.m_configCache.getCacheRootDirectory().getPath();
            try {
                String restartingMsg = this.m_generateCacheUtil ? "" : " - restarting...";
                this.logMessage(null, "...cache " + (!this.m_generateCacheUtil ? "updated" : "generated") + " in \"" + new File(cacheDirName).getCanonicalPath() + '\"' + restartingMsg, 3);
            }
            catch (IOException restartingMsg) {
                // empty catch block
            }
            if (this.m_generateCache && !this.m_generateCacheUtil) {
                File configureFromCacheFile = new File("configure_from_cache");
                new FileOutputStream(configureFromCacheFile, true).close();
            }
            this.shutdown(this.m_generateCacheUtil ? 0 : 14);
        }
        this.setContainerStartupComplete();
    }

    HostManager getHostManager() {
        return this.m_hostManager;
    }

    private String getConfigMessage(IAttributeSet containerAttrs) {
        StringBuffer message = new StringBuffer(IContainer.NEWLINE);
        message.append(IContainer.NEWLINE);
        message.append('\t').append(Version.getProductName()).append(IContainer.NEWLINE);
        message.append('\t').append(Version.getVersionText()).append(IContainer.NEWLINE);
        message.append('\t').append("Copyright (c) 2026. Aurea Software, Inc.").append(IContainer.NEWLINE);
        message.append('\t').append("All rights reserved.").append(IContainer.NEWLINE);
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Local host: ");
        message.append(System.getProperty("sonicsw.mf.privateHost"));
        if (System.getProperty("os.name") != null) {
            message.append(" (").append(System.getProperty("os.name"));
            if (System.getProperty("os.version") != null) {
                message.append(" - ").append(System.getProperty("os.version"));
            }
        }
        message.append(')').append(IContainer.NEWLINE);
        if (System.getProperty("sonicsw.mf.publicHost") != null) {
            message.append('\t').append("External host: ");
            message.append(System.getProperty("sonicsw.mf.publicHost"));
            message.append(IContainer.NEWLINE);
        }
        message.append('\t').append("Available Processors: ");
        message.append(Runtime.getRuntime().availableProcessors());
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Java Process ID: ");
        message.append(ManagementFactory.getRuntimeMXBean().getName());
        message.append(IContainer.NEWLINE);
        message.append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.runtime.name")).append(" (build ").append(System.getProperty("java.runtime.version")).append(')').append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.vm.vendor")).append(" (home ").append(System.getProperty("java.home")).append(", version ").append(System.getProperty("java.version")).append(')').append(IContainer.NEWLINE);
        message.append('\t').append(System.getProperty("java.vm.name")).append(" (build ").append(System.getProperty("java.vm.version")).append(", ");
        String javaVMInfo = System.getProperty("java.vm.info");
        if (javaVMInfo.indexOf(41) > 0) {
            javaVMInfo = javaVMInfo.substring(0, javaVMInfo.indexOf(41) + 1);
        }
        message.append(javaVMInfo).append(')').append(IContainer.NEWLINE);
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Configured Arguments : ");
        String args = (String)containerAttrs.getAttribute("JVM_ARGUMENTS");
        if (args != null && args.length() > 0) {
            message.append(containerAttrs.getAttribute("JVM_ARGUMENTS"));
        } else {
            message.append("<none>");
        }
        message.append(IContainer.NEWLINE);
        message.append('\t').append("Configured Properties: ");
        IAttributeSet systemProps = (IAttributeSet)containerAttrs.getAttribute("SYSTEM_PROPERTIES");
        if (systemProps != null && systemProps.getAttributes().size() > 0) {
            Iterator iterator = systemProps.getAttributes().entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                if (i > 0) {
                    message.append(" ");
                }
                Map.Entry entry = iterator.next();
                String propertyName = (String)entry.getKey();
                message.append("-D").append(propertyName).append('=');
                String propertyValue = (String)entry.getValue();
                if (propertyValue != null && propertyValue.length() > 0) {
                    if (propertyName.equals("sonicsw.mf.ft.user") || propertyName.equals("sonicsw.mf.ft.password")) {
                        message.append("...");
                    } else {
                        message.append('\"').append(propertyValue).append('\"');
                    }
                }
                ++i;
            }
        } else {
            message.append("<none>");
        }
        message.append(IContainer.NEWLINE);
        return message.toString();
    }

    private void validateConfig(IAttributeSet containerAttrs) {
        boolean runningAsWindowsService = false;
        boolean xrsFlagSet = false;
        boolean utilLibEnabled = false;
        String args = " " + containerAttrs.getAttribute("JVM_ARGUMENTS") + " ";
        xrsFlagSet = args.indexOf(" -Xrs ") >= 0;
        String winsvcUtilDir = System.getProperty("sonicsw.mf.winsvc.utilDir");
        utilLibEnabled = winsvcUtilDir != null && winsvcUtilDir.trim().length() > 0;
        boolean bl = runningAsWindowsService = winsvcUtilDir != null;
        if (runningAsWindowsService && !xrsFlagSet && !utilLibEnabled) {
            this.logMessage(null, "Container appears to have been launched as a Windows Service without the sonicmfUtil DLL, and -Xrs is not specified.  Container may terminate unexpectedly.  Use of sonicmfUtil is recommended (try reinstalling the Windows Service), otherwise use -Xrs.", 2);
        }
        if (xrsFlagSet && utilLibEnabled) {
            this.logMessage(null, "Container appears to have been launched as a Windows Service and the sonicmfUtil DLL is available.  The -Xrs flag is not required and should be removed.", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exhaustPendingLogMessageQueue() {
        if (this.m_agent == null) {
            return;
        }
        while (!this.m_pendingLogMessageQueue.isEmpty()) {
            JMSConnectorServer connector = this.m_connector;
            if (connector == null) {
                return;
            }
            if (!connector.isConnected()) {
                return;
            }
            ArrayList arrayList = this.m_reloadingIDs;
            synchronized (arrayList) {
                if (this.m_reloadingIDs.contains("AGENT MANAGER")) {
                    return;
                }
            }
            arrayList = this.m_pendingLogMessageQueue;
            synchronized (arrayList) {
                if (this.m_pendingLogMessageQueue.isEmpty()) {
                    return;
                }
                String timestampedMessage = (String)this.m_pendingLogMessageQueue.get(0);
                boolean bestEffortLogged = false;
                try {
                    if (this.m_agent.centrallyLogMessage(timestampedMessage)) {
                        bestEffortLogged = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!bestEffortLogged) {
                    return;
                }
                this.m_pendingLogMessageQueue.remove(0);
            }
        }
    }

    ContainerDS getDS() {
        return this.m_directory;
    }

    ContainerFT getContainerFT() {
        return this.m_containerFT;
    }

    boolean isFTContainer() {
        return this.m_isFTContainer;
    }

    Boolean getAllowFailover() {
        return this.isFTContainer() ? new Boolean(this.m_allowFailover) : null;
    }

    void setAllowFailover(Boolean allowFailover) {
        if (!this.isFTContainer()) {
            throw new IllegalStateException("Setting of this attribute is not supported for a non-FT container");
        }
        boolean allow = allowFailover;
        if (allow != this.m_allowFailover) {
            if (!this.m_containerFT.isActive()) {
                this.logMessage(this.m_containerIdentity.getContainerName(), "FT container failover " + (allow ? "reenabled" : "disabled"), allow ? 3 : 2);
            }
            this.m_allowFailover = allow;
        }
    }

    void sendFailoverNotification() {
        this.m_agent.sendFailoverNotification();
    }

    PingThread getPingThread() {
        return this.m_containerFT.getPingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireSubscription(NotificationListenerDelegate delegate) {
        HashMap hashMap = this.m_notificationListeners;
        synchronized (hashMap) {
            try {
                this.m_mbeanServer.removeNotificationListener(delegate.getObjectName(), delegate);
            }
            catch (OperationsException operationsException) {
                // empty catch block
            }
            delegate.removeAllHandbackFilterPairs();
            this.deleteNotificationListenerSubscriptionsFromCache(delegate);
            this.m_notificationListeners.remove(delegate.getRemoteListenerKey());
            delegate.close();
        }
        if ((this.m_agent.m_traceMask & 0x100) > 0) {
            this.logMessage("AGENT", "Expired management notification subcription(s) from JMX client " + this.m_connector.getJMXClientHostAndID(delegate.getDestination()) + " to \"" + new CanonicalName(delegate.getObjectName().getCanonicalName()).getComponentName() + "\"", 7);
        }
    }

    void setFailingOver(boolean isFailingOver) {
        this.m_isFailingOver = isFailingOver;
    }

    boolean isFailingOver() {
        return this.m_isFailingOver;
    }

    private boolean isAutoStartComponent(String componentId) {
        if (this.m_generateCache) {
            return false;
        }
        boolean autostart = true;
        IAttributeSet attrsOfComps = (IAttributeSet)this.m_containerConfig.getAttributes().getAttribute("COMPONENTS");
        if (attrsOfComps == null) {
            return autostart;
        }
        IAttributeSet theCompAttrs = (IAttributeSet)attrsOfComps.getAttribute(componentId);
        if (theCompAttrs == null) {
            return autostart;
        }
        Boolean AutoStart = (Boolean)theCompAttrs.getAttribute("AUTO_START");
        autostart = AutoStart == null ? true : AutoStart;
        return autostart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startComponents() {
        IContainer iContainer = m_containerDelegate;
        synchronized (iContainer) {
            while (!this.m_isClosing && !this.m_isBooted) {
                try {
                    m_containerDelegate.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.m_isClosing) {
                return;
            }
        }
        HashMap<String, IComponent> appComponents = new HashMap<String, IComponent>();
        for (Map.Entry entry : this.m_mBeans.entrySet()) {
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
            IComponent component = mBean.getManagedComponent();
            String id = (String)entry.getKey();
            if (!this.isAutoStartComponent(id)) continue;
            if (ContainerUtil.isFrameworkComponent(component.getClass())) {
                try {
                    IContainer iContainer2 = m_containerDelegate;
                    synchronized (iContainer2) {
                        if (component != null && !id.equals("AGENT")) {
                            this.startComponent(id, component, true);
                        }
                        m_containerDelegate.notifyAll();
                        continue;
                    }
                }
                catch (Throwable e) {
                    this.logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, 2);
                    continue;
                }
            }
            appComponents.put(id, component);
        }
        for (Map.Entry appEntry : appComponents.entrySet()) {
            String id = (String)appEntry.getKey();
            if (!this.isAutoStartComponent(id)) continue;
            IComponent component = (IComponent)appEntry.getValue();
            try {
                if (component == null) continue;
                IContainer e = m_containerDelegate;
                synchronized (e) {
                    this.startComponent(id, component, false);
                    m_containerDelegate.notifyAll();
                }
            }
            catch (Throwable e) {
                this.logMessage(null, "Failed to start ID=" + id + ", trace follows...", e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopComponents() {
        if (this.m_isClosing) {
            return;
        }
        HashMap<String, IComponent> frameworkComponents = new HashMap<String, IComponent>();
        for (Map.Entry entry : this.m_mBeans.entrySet()) {
            AbstractMBean mBean = ((MBeanHolder)entry.getValue()).mBean;
            IComponent component = mBean.getManagedComponent();
            String id = (String)entry.getKey();
            if (ContainerUtil.isFrameworkComponent(component.getClass())) {
                frameworkComponents.put(id, component);
                continue;
            }
            try {
                IContainer iContainer = m_containerDelegate;
                synchronized (iContainer) {
                    component.stop();
                    m_containerDelegate.notifyAll();
                }
            }
            catch (Throwable e) {
                this.logMessage(null, "Failed to stop ID=" + id + ", trace follows...", e, 2);
            }
        }
        for (Map.Entry frameworkEntry : frameworkComponents.entrySet()) {
            String id = (String)frameworkEntry.getKey();
            IComponent component = (IComponent)frameworkEntry.getValue();
            try {
                if (component == null || id.equals("AGENT")) continue;
                IContainer e = m_containerDelegate;
                synchronized (e) {
                    component.stop();
                    m_containerDelegate.notifyAll();
                }
            }
            catch (Throwable e) {
                this.logMessage(null, "Failed to stop ID=" + id + ", trace follows...", e, 2);
            }
        }
    }

    private void bootMBeanServer() throws Exception {
        if (m_isLSD) {
            this.m_mbeanServer = MBeanServerFactory.createMBeanServer(this.getContainerIdentity().getCanonicalName());
        } else {
            try {
                Class<?> managementFactoryClass = this.m_defaultClassLoader.loadClass("java.lang.management.ManagementFactory");
                Method getPlatformMBeanServerMethod = managementFactoryClass.getMethod("getPlatformMBeanServer", IEmptyArray.EMPTY_CLASS_ARRAY);
                this.m_mbeanServer = (MBeanServer)getPlatformMBeanServerMethod.invoke(null, IEmptyArray.EMPTY_OBJECT_ARRAY);
            }
            catch (ClassNotFoundException e) {
                this.m_mbeanServer = MBeanServerFactory.createMBeanServer(this.getContainerIdentity().getCanonicalName());
            }
        }
        this.m_mbeanServerClass = this.m_mbeanServer.getClass();
        this.registerMLetClassLoader();
    }

    private void registerMLetClassLoader() {
        try {
            Class<?> mletClass = Class.forName("javax.management.loading.MLet");
            Constructor<?> constructor = mletClass.getConstructor(URL[].class, ClassLoader.class);
            Object mLet = constructor.newInstance(this.m_defaultClassLoader.getURLs(), this.m_defaultClassLoader.getParent());
            this.m_mbeanServer.registerMBean(mLet, new ObjectName("Loader:name=Default"));
            this.logMessage(null, "Registered MLet class loader MBean", 5);
        }
        catch (ClassNotFoundException e) {
            this.logMessage(null, "MLet class loader not available (JDK 20+), skipping MBean class loader registration. This does not affect normal container operations.", 3);
        }
        catch (Exception e) {
            this.logMessage(null, "Failed to register MLet class loader MBean: " + e.getMessage() + ". Container will continue without dynamic MBean class loading support.", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setContainerStartupComplete() {
        if (IContainer.SIGNAL_MODE) {
            System.out.print('\b');
            System.out.flush();
        }
        this.m_isBooted = true;
        this.logMessage(null, "...startup complete", 3);
        Object object = m_containerDelegate;
        synchronized (object) {
            m_containerDelegate.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        if (!this.m_generateCache) {
            Runnable notifier = new Runnable(){

                @Override
                public void run() {
                    ContainerImpl.this.m_agent.sendStartupNotification();
                }
            };
            this.m_taskScheduler.scheduleTask(notifier, false);
        }
    }

    private void loadConnectorServer(IAttributeSet containerAttrs) throws Exception {
        Integer socketConnectTimeout;
        Integer connectTimeout;
        Integer requestTimeout;
        String managementNode;
        this.m_connector = new JMSConnectorServer(this);
        IAttributeSet connectionAttrs = null;
        if (this.m_generateCache && !this.m_generateCacheUtil) {
            connectionAttrs = (IAttributeSet)containerAttrs.getAttribute("CENTRAL_CONNECTION");
            if (connectionAttrs == null) {
                this.logMessage(null, "The cental connection URL is not configured; cannot generate the cache", 1);
                this.shutdown(9);
            }
        } else {
            connectionAttrs = (IAttributeSet)containerAttrs.getAttribute("CONNECTION");
        }
        if ((managementNode = (String)connectionAttrs.getAttribute("MANAGEMENT_NODE")) != null && managementNode.length() > 0) {
            this.m_connector.setManagementNode(managementNode);
            this.m_managementNode = managementNode;
            if (this.m_containerIdentity.getNodeName() == null || this.m_containerIdentity.getNodeName().length() == 0) {
                this.logMessage("AGENT", "If the Management Node is specified as part of the container connection attributes, then this container name must include the node name in which this container has been deployed. The format of the container name, in that case, must be <container>@<nodeName>", 1);
                this.shutdown(8);
            }
        }
        if ((requestTimeout = (Integer)connectionAttrs.getAttribute("REQUEST_TIMEOUT")) != null) {
            this.m_connector.setRequestTimeout(requestTimeout * 1000);
        }
        if ((connectTimeout = (Integer)connectionAttrs.getAttribute("CONNECT_TIMEOUT")) != null) {
            this.m_connector.setConnectTimeout(connectTimeout * 1000);
        }
        if ((socketConnectTimeout = (Integer)connectionAttrs.getAttribute("SOCKET_CONNECT_TIMEOUT")) != null) {
            int SOCKET_CONN_TIMEOUT_IN_MILLIS = socketConnectTimeout * 1000;
            this.m_connector.setSocketConnectTimeout(SOCKET_CONN_TIMEOUT_IN_MILLIS);
        }
        this.m_connector.addRequestHandler(this.m_internalRequestHandler);
        try {
            String connectionURLs;
            Map factoryAttrs = (Map)connectionAttrs.getAttributes().clone();
            factoryAttrs.remove("MANAGEMENT_NODE");
            factoryAttrs.remove("REQUEST_TIMEOUT");
            factoryAttrs.remove("CONNECT_TIMEOUT");
            factoryAttrs.remove("SOCKET_CONNECT_TIMEOUT");
            factoryAttrs.remove("TRY_DS_AM_BACKUPS_ON_FAILURE");
            if (this.m_generateCache && this.m_generateCacheUtil) {
                factoryAttrs.put("ConnectionURLs", this.m_directConnectionURL);
                factoryAttrs.put("DefaultUser", this.m_directConnectionUser);
                factoryAttrs.put("DefaultPassword", this.m_directConnectionPassword);
            }
            if ((connectionURLs = (String)factoryAttrs.get("ConnectionURLs")) == null) {
                factoryAttrs.put("ConnectionURLs", DEFAULT_CONNECTION_URLS);
            }
            this.m_connector.connect(factoryAttrs, 0L);
            this.validateConnectorNodeName(this.m_connector.getLocalRoutingNodeName());
        }
        catch (Exception e) {
            Exception linkedException;
            if (e instanceof MFRuntimeException && (linkedException = ((MFRuntimeException)((Object)e)).getLinkedException()) instanceof MFProxyRuntimeException && ((MFProxyRuntimeException)linkedException).getActualException() instanceof IUserAlreadyConnected) {
                this.logMessage(null, '\"' + this.m_containerIdentity.getCanonicalName() + "\" appears to be running elsewhere", 1);
                this.shutdown(13);
            }
            this.logMessage("AGENT", "Permanent communications failure, trace follows...", e, 1);
            this.shutdown(9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReloadComponent(String id, boolean isReloadRoot) {
        block33: {
            Object holder;
            try {
                Object dependentID;
                holder = (MBeanHolder)this.m_mBeans.get(id);
                if (holder == null) {
                    throw new MFException("Unknown ID: " + id);
                }
                AbstractMBean mBean = ((MBeanHolder)holder).mBean;
                if (mBean == null) {
                    throw new MFException("Unknown ID: " + id);
                }
                if (!mBean.isOperationExported("reload", IEmptyArray.EMPTY_STRING_ARRAY)) {
                    throw new MFException(id + " reloading is not supported");
                }
                if (isReloadRoot) {
                    this.logMessage(null, "Reload ID=" + id + " initiated...", 3);
                }
                if (id.equals("AGENT MANAGER")) {
                    this.logMessage(null, "Unloaded ID=" + id, 3);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                mBean = ((MBeanHolder)holder).mBean;
                ((MBeanHolder)holder).waitForRequestCompletion();
                IComponent component = mBean.getManagedComponent();
                String configID = (String)mBean.getAttribute("ConfigID");
                short state = component.getState();
                boolean start = state == 2 || state == 3;
                int traceMask = component.getTraceMask();
                String[] dependentIDs = ClassLoaderFactory.getDependentComponents(this.m_containerIdentity.getCanonicalName(), id);
                this.unloadComponent(id);
                this.m_reloadingDetails.put(id, new Object[]{configID, new Boolean(start), new Integer(traceMask)});
                for (int i = 0; i < dependentIDs.length; ++i) {
                    dependentID = dependentIDs[i];
                    if (((String)dependentID).indexOf(58) > 0) {
                        dependentID = ((String)dependentID).substring(((String)dependentID).indexOf(58) + 1);
                    }
                    boolean reloadDependent = false;
                    ArrayList arrayList = this.m_reloadingIDs;
                    synchronized (arrayList) {
                        if (!this.m_reloadingIDs.contains(dependentID)) {
                            this.m_reloadingIDs.add(dependentID);
                            reloadDependent = true;
                        }
                    }
                    if (!reloadDependent) continue;
                    this.internalReloadComponent((String)dependentID, false);
                }
                if (!isReloadRoot) break block33;
                Iterator iterator = null;
                dependentID = this.m_reloadingIDs;
                synchronized (dependentID) {
                    iterator = ((ArrayList)this.m_reloadingIDs.clone()).iterator();
                }
                while (iterator.hasNext()) {
                    String reloadID = (String)iterator.next();
                    Object[] details = (Object[])this.m_reloadingDetails.get(reloadID);
                    configID = (String)details[0];
                    start = (Boolean)details[1];
                    traceMask = (Integer)details[2];
                    this.loadComponent(reloadID, configID, start, traceMask, false);
                }
                this.logMessage(null, "...reload ID=" + id + " complete", 3);
            }
            catch (Throwable t) {
                if (isReloadRoot) {
                    this.logMessage(null, "...reload ID=" + id + " failed, trace follows...", t, 1);
                }
            }
            finally {
                if (isReloadRoot) {
                    holder = this.m_reloadingIDs;
                    synchronized (holder) {
                        this.m_reloadingIDs.clear();
                        this.m_reloadingDetails.clear();
                        this.m_reloadingIDs.notifyAll();
                    }
                }
            }
        }
    }

    private void validateConnectorNodeName(String localRoutingNode) {
        String msg;
        String containerNodeName = null;
        if (this.m_containerIdentity != null) {
            containerNodeName = this.m_containerIdentity.getNodeName();
        }
        if (!this.m_generateCache && containerNodeName != null && containerNodeName.length() > 0 && localRoutingNode != null && !localRoutingNode.equals(containerNodeName)) {
            msg = "The container node name [" + containerNodeName + "] does not match the local management broker node name [" + localRoutingNode + "]. Check the container configuration reflects the URL(s) of the local management broker(s).";
            this.logMessage(null, msg, 1);
            this.shutdown(8);
        }
        if (this.m_generateCache && this.m_generateCacheUtil && containerNodeName != null && containerNodeName.length() > 0 && localRoutingNode != null && !localRoutingNode.equals(this.m_managementNode)) {
            msg = "A management node must be specified in the containers configuration. Modify and regenerate the container's XML boot or file (or edit the container INI file)";
            this.logMessage(null, msg, 1);
            this.shutdown(8);
        }
    }

    private void loadDirectoryService(IAttributeSet containerAttrs) throws Exception {
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute("COMPONENTS");
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();
        for (int i = 0; i < components.length; ++i) {
            if (this.m_isClosing) {
                throw new ShutdownInProgressException();
            }
            Map.Entry componentEntry = (Map.Entry)components[i];
            String id = (String)componentEntry.getKey();
            if (!id.equals("DIRECTORY SERVICE")) continue;
            this.loadConfiguredComponent(id, (IAttributeSet)componentEntry.getValue(), false, true);
            break;
        }
    }

    private boolean containsTimeout(Throwable tParam) {
        Throwable t = tParam;
        while (true) {
            if (t == null) {
                return false;
            }
            if (t instanceof InvokeTimeoutException) {
                return true;
            }
            if (t instanceof MFException) {
                t = ((MFException)t).getLinkedException();
                continue;
            }
            if (!(t instanceof MFRuntimeException)) break;
            t = ((MFRuntimeException)t).getLinkedException();
        }
        return false;
    }

    void cacheFileIfNeeded(String dsAbsolutePathParam, boolean silentFailure, boolean reconcileCache) throws Exception {
        String dsAbsolutePath = dsAbsolutePathParam;
        if (reconcileCache) {
            this.reconcileCache();
        }
        if (!dsAbsolutePath.startsWith("sonicfs:///")) {
            if (!dsAbsolutePath.startsWith("/")) {
                throw new MFException("\"" + dsAbsolutePath + "\" is malformed - must be prefixed with \" " + "sonicfs:///" + "\" or with '/'");
            }
            dsAbsolutePath = "sonicfs:///".substring(0, "sonicfs:///".length() - 1) + dsAbsolutePath;
        }
        if (this.getLocalFile(dsAbsolutePath) == null && !silentFailure) {
            throw new MFException("\"" + dsAbsolutePath + "\" was not found");
        }
    }

    void cacheAllArchivesIfNeeded() throws Exception {
        this.reconcileCache();
        ArrayList archiveList = this.getAllArchiveNames();
        for (int i = 0; i < archiveList.size(); ++i) {
            if (this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, (String)archiveList.get(i)) != null) continue;
            this.logMessage(null, "Could not download archive file \" " + archiveList.get(i) + "\"", 2);
        }
    }

    void downloadArchives(String dsArchivePath, String newVersion) throws Exception {
        int i;
        this.reconcileCache();
        ArrayList archiveList = this.getAllArchiveNames();
        for (i = 0; i < archiveList.size(); ++i) {
            archiveList.set(i, ContainerImpl.replaceVersion((String)archiveList.get(i), newVersion));
        }
        for (i = 0; i < archiveList.size(); ++i) {
            this.cacheFileIfNeeded(dsArchivePath + archiveList.get(i), true, false);
        }
    }

    private static String replaceVersion(String dsArchivePath, String newVesion) {
        ArrayList<String> pathItems = new ArrayList<String>();
        boolean versionFound = false;
        for (File path = new File(dsArchivePath); path != null; path = path.getParentFile()) {
            String name = path.getName();
            if (!versionFound && Character.isDigit(name.charAt(0))) {
                name = newVesion;
                versionFound = true;
            }
            pathItems.add(0, name);
        }
        String newPath = "";
        for (int i = 0; i < pathItems.size(); ++i) {
            newPath = newPath + (String)pathItems.get(i);
            if (i + 1 >= pathItems.size()) continue;
            newPath = newPath + "/";
        }
        return newPath;
    }

    private ArrayList getAllArchiveNames() throws Exception {
        ArrayList<Object> archiveList = new ArrayList<Object>();
        IElement freshContainerConfig = this.getConfiguration(this.m_containerConfig.getIdentity().getName(), true);
        IAttributeSet containerAttrs = freshContainerConfig.getAttributes();
        archiveList.add(containerAttrs.getAttribute("ARCHIVE_NAME"));
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute("COMPONENTS");
        if (componentsAttrs == null) {
            return archiveList;
        }
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();
        for (int i = 0; i < components.length; ++i) {
            Map.Entry componentEntry = (Map.Entry)components[i];
            IAttributeSet compSet = (IAttributeSet)componentEntry.getValue();
            String componentConfigID = ((Reference)compSet.getAttribute("CONFIG_REF")).getElementName();
            IElement componentConfig = this.getConfiguration(componentConfigID, true);
            IAttributeSet componentAttrs = componentConfig.getAttributes();
            String archiveName = (String)componentAttrs.getAttribute("ARCHIVE_NAME");
            if (archiveName == null) continue;
            archiveList.add(archiveName);
        }
        return archiveList;
    }

    private final AbstractMBean internalLoadComponent(String idParam, String configID, int traceMaskParam, boolean frameworkOnly) throws Exception {
        int traceMask = traceMaskParam;
        String id = idParam;
        if (this.m_mBeans.containsKey(id)) {
            throw new MFException("Component ID already exists: " + id);
        }
        IElement componentConfig = this.getConfiguration(configID);
        if (componentConfig == null) {
            throw new MFException("Configuration unavailable: " + configID);
        }
        boolean isFrameworkComponent = true;
        IAttributeSet componentAttrs = componentConfig.getAttributes();
        String classname = (String)componentAttrs.getAttribute("CLASSNAME");
        Class<?> componentClass = null;
        if (id.equals("AGENT") || id.equals("DIRECTORY SERVICE")) {
            URLClassLoader loader = this.m_defaultClassLoader;
            componentClass = loader.loadClass(classname);
        } else {
            if (!this.createDeclaredSharedLibraries(id, componentAttrs)) {
                return null;
            }
            if (!this.createDependentSharedLibraries(id, componentAttrs)) {
                return null;
            }
            String archiveName = (String)componentAttrs.getAttribute("ARCHIVE_NAME");
            File archiveFile = this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, archiveName);
            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveFile);
            String classpath = (String)componentAttrs.getAttribute("CLASSPATH");
            classpath = this.addActionalSdkJms(classpath, archiveName);
            ArrayList classpathURLs = this.translateClasspath(id, classpath);
            URL[] urls = archive.getPrivateClasspath();
            for (int i = 0; i < urls.length; ++i) {
                classpathURLs.add(urls[i]);
            }
            urls = classpathURLs.toArray(ExpandedSonicArchive.EMPTY_URL_ARRAY);
            ClassLoader loader = this.createDelegatingLoader(id, urls, archive, componentConfig, true);
            componentClass = loader.loadClass(classname);
            isFrameworkComponent = ContainerUtil.isFrameworkComponent(componentClass);
            if (!isFrameworkComponent) {
                if (frameworkOnly) {
                    return null;
                }
                loader = this.createDelegatingLoader(id, urls, archive, componentConfig, false);
                componentClass = loader.loadClass(classname);
            }
        }
        IComponent component = (IComponent)componentClass.newInstance();
        if (isFrameworkComponent) {
            if (component instanceof DSComponent) {
                ((DSComponent)component).setContainer(this);
            }
            if (component instanceof IGlobalFrameworkComponent) {
                id = ((IGlobalFrameworkComponent)component).getGlobalID();
            } else if (id.equals("AGENT")) {
                ((Agent)component).setContainer(this);
            }
            if (component instanceof IEnterpriseAware) {
                ((IEnterpriseAware)component).setEnterpriseStateAccess(new IEnterpriseStateAccess(){

                    public boolean isEnterprise() {
                        JMSConnectorServer connector = ContainerImpl.this.m_connector;
                        if (connector == null) {
                            return false;
                        }
                        return connector.isConnectionEnterpriseEnabled();
                    }
                });
            }
        }
        if (traceMask == -1) {
            Integer extensionTraceMask = (Integer)componentAttrs.getAttribute("TRACE_MASK");
            traceMask = extensionTraceMask == null ? 0 : extensionTraceMask;
        }
        component.setTraceMask(new Integer(traceMask));
        ComponentMBean mBean = isFrameworkComponent ? new FrameworkComponentMBean(this, component, id, configID) : new ComponentMBean(this, component, id, configID);
        this.m_mbeanServer.registerMBean(mBean, mBean.getObjectName());
        this.m_mBeans.put(id, new MBeanHolder(mBean));
        this.restoreNotificationSubscriptionsFromCache(mBean);
        if (!this.m_generateCache) {
            this.logMessage(null, "Loaded ID=" + id, 3);
        }
        return mBean;
    }

    String addActionalSdkJms(String classpath, String archiveName) {
        String appendedClasspath = classpath;
        if (archiveName.endsWith(ESBCONTAINER_ARCHIVE)) {
            appendedClasspath = classpath == null || classpath.length() == 0 ? ACTIONAL_SDK_JMS_LOCATION : classpath + ";" + ACTIONAL_SDK_JMS_LOCATION;
        }
        return appendedClasspath;
    }

    private ClassLoader createDelegatingLoader(String id, URL[] urls, ExpandedSonicArchive archive, IElement componentConfig, boolean delegateToMFcore) {
        ArrayList<String> delegateLoaderNames = new ArrayList<String>();
        if (delegateToMFcore) {
            delegateLoaderNames.add("$MFcore");
        }
        String[] sharedLibraryNames = archive.getSharedLibraryNames();
        for (int i = 0; i < sharedLibraryNames.length; ++i) {
            delegateLoaderNames.add(sharedLibraryNames[i]);
        }
        String[] dependsOn = archive.getDependsOn();
        for (int i = 0; i < dependsOn.length; ++i) {
            delegateLoaderNames.add(dependsOn[i]);
        }
        return ClassLoaderFactory.createDelegatingLoader(this.m_containerIdentity.getCanonicalName(), id, urls, this.m_defaultClassLoader.getParent(), delegateLoaderNames.toArray(IEmptyArray.EMPTY_STRING_ARRAY));
    }

    private Long getBackupTimestampFromDS() throws Exception {
        try {
            IElement dsInfoElement = this.m_directory.getElement(this.m_containerIdentity.getCanonicalName(), "/_MFVirtual/ds_version_info");
            if (dsInfoElement == null) {
                throw new Error("The DS is old - use a DS from a recent build.");
            }
            IAttributeSet attributes = dsInfoElement.getAttributes();
            return (Long)attributes.getAttribute("BACKUP_VERSION");
        }
        catch (Exception e) {
            if (!this.containsTimeout(e)) {
                throw e;
            }
            return null;
        }
    }

    private void startDSMonitoringThread(long frequency, boolean initalDSAcessibility) {
        ServiceMaintenance dsMaintenance = new ServiceMaintenance(){
            private int callsUntilReconcile = 3;
            private long lastTimeWeDidMaintenance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public Exception doMaintenance() {
                --this.callsUntilReconcile;
                if (this.lastTimeWeDidMaintenance > 0L && ContainerImpl.this.m_lastTimeWeSubscribed > this.lastTimeWeDidMaintenance && this.callsUntilReconcile == 0) {
                    this.callsUntilReconcile = 2;
                }
                try {
                    Object object = ContainerImpl.this.m_dsTemporaryMonitorLock;
                    // MONITORENTER : object
                    if (ContainerImpl.this.m_dsTemporaryMonitor != null) {
                        this.callsUntilReconcile = 2;
                        Exception exception = null;
                        // MONITOREXIT : object
                        return exception;
                    }
                    // MONITOREXIT : object
                    if (this.callsUntilReconcile == 0) {
                        ContainerImpl.this.reconcileCache();
                        this.callsUntilReconcile = 3;
                        object = null;
                        return object;
                    }
                    if (this.lastTimeWeDidMaintenance == 0L || ContainerImpl.this.m_lastTimeWeSubscribed > this.lastTimeWeDidMaintenance) {
                        object = null;
                        return object;
                    }
                    object = ContainerImpl.this.checkDSAccessibility(ContainerImpl.this.m_dsMonitor);
                    return object;
                }
                finally {
                    this.lastTimeWeDidMaintenance = System.currentTimeMillis();
                }
            }

            public void onAccessibilityChange(boolean isAccessible) {
                if (isAccessible) {
                    ContainerImpl.this.reconcileCache();
                } else {
                    ContainerImpl.this.configuringFromCache();
                }
            }
        };
        this.m_dsMonitor = new ServiceMaintainer("Configuration Change Registrar", dsMaintenance, frequency, initalDSAcessibility);
    }

    private void startDSTemporaryMonitoringThread() {
        ServiceMaintenance dsMaintenance = new ServiceMaintenance(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Exception doMaintenance() {
                ServiceMaintainer dsTemporaryMonitor = null;
                Object object = ContainerImpl.this.m_dsTemporaryMonitorLock;
                synchronized (object) {
                    if (ContainerImpl.this.m_dsTemporaryMonitor != null && ContainerImpl.this.m_recentReconcileSucessful) {
                        ContainerImpl.this.m_dsTemporaryMonitor.close();
                        ContainerImpl.this.m_dsTemporaryMonitor = null;
                        return null;
                    }
                    dsTemporaryMonitor = ContainerImpl.this.m_dsTemporaryMonitor;
                }
                return ContainerImpl.this.checkDSAccessibility(dsTemporaryMonitor);
            }

            public void onAccessibilityChange(boolean isAccessible) {
                if (isAccessible) {
                    ContainerImpl.this.reconcileCache();
                }
            }
        };
        long frequency = this.m_connector.getRequestTimeout() / 2L;
        if (frequency > 60000L) {
            frequency = 60000L;
        }
        this.m_dsTemporaryMonitor = new ServiceMaintainer("Temporary DS Monitor", dsMaintenance, frequency, false);
    }

    private void configuringFromCache() {
        if (this.m_generateCache) {
            this.logMessage(null, "Directory Service unavailable, cannot generate cache", 1);
            this.shutdown(1);
        } else if (!(this.m_dsMonitor != null && this.m_dsMonitor.isAccessible() || this.m_useLocalCacheLogged)) {
            this.m_useLocalCacheLogged = true;
            boolean configFromCacheRequest = Boolean.getBoolean("sonicsw.mf.configureFromCache");
            String msg = configFromCacheRequest ? "Configuring from cache" : "Directory Service unavailable, configuration from local cache only";
            this.logMessage(null, msg, configFromCacheRequest ? 3 : 2);
        }
    }

    private boolean updateConfigElements(IDirElement[] updatedElements) throws VersionOutofSyncException, PersistentCacheException, CacheClosedException {
        Long newBackupVersion = null;
        boolean callAgain = false;
        ArrayList<IDirElement> elementsToReport = new ArrayList<IDirElement>();
        boolean[] reportToComponent = new boolean[updatedElements.length];
        boolean[] replacement = new boolean[updatedElements.length];
        for (int i = 0; i < updatedElements.length; ++i) {
            reportToComponent[i] = true;
            replacement[i] = false;
            IDirElement currentElement = updatedElements[i];
            if (currentElement instanceof IEnvelope) {
                IEnvelope envelope = (IEnvelope)currentElement;
                boolean bl = reportToComponent[i] = envelope.getProperty("DRE") == null;
                if (!callAgain && envelope.getProperty("RNF") != null) {
                    callAgain = true;
                }
                replacement[i] = envelope.getProperty("R") != null;
                currentElement = (IDirElement)envelope.getEnvelopedElement();
            }
            if (i + 1 == updatedElements.length && currentElement.getIdentity().getName().equals("/_MFVirtual/ds_version_info")) {
                IAttributeSet attributes = currentElement.getAttributes();
                newBackupVersion = (Long)attributes.getAttribute("BACKUP_VERSION");
                continue;
            }
            elementsToReport.add(currentElement);
        }
        IElement[] reportList = new IElement[elementsToReport.size()];
        elementsToReport.toArray(reportList);
        this.cacheAndReportElements(reportList, reportToComponent, replacement);
        if (newBackupVersion != null && !callAgain) {
            this.m_configCache.setDSBackupVersion(newBackupVersion);
        }
        return this.m_isClosing ? false : callAgain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reconcileCache() {
        if (this.m_isClosing) {
            return;
        }
        if (this.m_configCache == null) {
            return;
        }
        Object object = this.m_reconcileLock;
        // MONITORENTER : object
        this.m_designatedReconcileThread = Thread.currentThread();
        // MONITOREXIT : object
        if ((this.m_agent.m_traceMask & 0x200) > 0) {
            this.logMessage(null, "Reconcile local configuration cache with Directory Service...", 7);
        }
        boolean success = false;
        this.m_recentReconcileSucessful = false;
        try {
            if (!this.m_skippedDSReconciliation && this.m_configureFromCache) {
                this.m_skippedDSReconciliation = true;
                throw new InvokeTimeoutException("sonicsw.mf.configureFromCache is set ");
            }
            if (this.m_configCacheView.getDSBackupVersion() == null) {
                this.m_configCache.setDSBackupVersion(this.getBackupTimestampFromDS());
            }
            if (this.m_isBooted) {
                Thread.sleep(1500L);
            }
            this.reconcileCacheWithDS();
            Object object2 = this.m_reconcileLock;
            // MONITORENTER : object2
            if (this.m_designatedReconcileThread != Thread.currentThread()) {
                // MONITOREXIT : object2
                return;
            }
            // MONITOREXIT : object2
            this.setupInterestInLogicalName();
            success = true;
            this.m_recentReconcileSucessful = true;
            this.m_lastTimeWeSubscribed = System.currentTimeMillis();
            return;
        }
        catch (VersionOutofSyncException e) {
            this.logMessage(null, e, 1);
            this.shutdown(4);
            return;
        }
        catch (PersistentCacheException e) {
            this.logMessage(null, e, 1);
            this.shutdown(4);
            return;
            {
                catch (Throwable throwable) {
                    if ((this.m_agent.m_traceMask & 0x200) > 0) {
                        if (success) {
                            this.logMessage(null, "...reconcile complete", 7);
                        } else {
                            this.logMessage(null, "...reconcile failed", 7);
                        }
                    }
                    if (success) {
                        if (this.m_useLocalCacheLogged) {
                            this.m_useLocalCacheLogged = false;
                            this.logMessage(null, "Directory Service available, reconciled local cache", 3);
                        }
                    } else {
                        ServiceMaintainer oldTemporaryMonitor = null;
                        Object object3 = this.m_dsTemporaryMonitorLock;
                        // MONITORENTER : object3
                        if (this.m_dsTemporaryMonitor != null) {
                            oldTemporaryMonitor = this.m_dsTemporaryMonitor;
                            this.m_dsTemporaryMonitor = null;
                        }
                        // MONITOREXIT : object3
                        if (oldTemporaryMonitor != null) {
                            oldTemporaryMonitor.close();
                        }
                        object3 = this.m_dsTemporaryMonitorLock;
                        // MONITORENTER : object3
                        if (this.m_dsTemporaryMonitor == null) {
                            this.startDSTemporaryMonitoringThread();
                        }
                        // MONITOREXIT : object3
                    }
                    Object object4 = this.m_reconcileLock;
                    // MONITORENTER : object4
                    if (this.m_designatedReconcileThread == Thread.currentThread()) {
                        this.m_designatedReconcileThread = null;
                    }
                    // MONITOREXIT : object4
                    throw throwable;
                }
            }
            catch (CacheClosedException e2) {
                if (this.m_isClosing) {
                    return;
                }
                this.logMessage(null, e2, 1);
                throw new Error(e2.toString());
                catch (Exception e3) {
                    double random;
                    if (this.m_isClosing) {
                        return;
                    }
                    if (!this.containsTimeout(e3) && !(e3 instanceof MFServiceNotActiveException)) {
                        this.logMessage(null, e3, 1);
                        throw new Error(e3.toString());
                    }
                    this.m_dsNotInitiallyAccessible = true;
                    this.configuringFromCache();
                    long frequency = this.m_connector.getRequestTimeout();
                    if (frequency > 60000L) {
                        frequency = 60000L;
                    }
                    if (this.m_random == null) {
                        this.m_random = new Random(this.m_containerIdentity.getContainerName().hashCode());
                    }
                    if (!((random = this.m_random.nextGaussian() + 1.0) > 0.0)) return;
                    try {
                        Thread.sleep((long)(random * (double)(frequency / 4L)));
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        }
        finally {
            Object oldTemporaryMonitor;
            if ((this.m_agent.m_traceMask & 0x200) > 0) {
                if (success) {
                    this.logMessage(null, "...reconcile complete", 7);
                } else {
                    this.logMessage(null, "...reconcile failed", 7);
                }
            }
            if (!success) {
                oldTemporaryMonitor = null;
                Object oldTemporaryMonitor2 = this.m_dsTemporaryMonitorLock;
            }
            if (this.m_useLocalCacheLogged) {
                this.m_useLocalCacheLogged = false;
                this.logMessage(null, "Directory Service available, reconciled local cache", 3);
            }
            oldTemporaryMonitor = this.m_reconcileLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileCacheWithDS() throws VersionOutofSyncException, PersistentCacheException, CacheClosedException {
        String container = this.m_containerIdentity.getCanonicalName();
        Long dsBackupVersion = this.m_configCacheView.getDSBackupVersion();
        boolean retry = false;
        boolean reconcileExistingElements = true;
        boolean reconcileNewElements = true;
        boolean reconcileLogicalMap = true;
        ArrayList<String> processedIds = new ArrayList<String>();
        while (reconcileExistingElements || reconcileNewElements) {
            if (retry && (this.m_agent.m_traceMask & 0x200) > 0) {
                this.logMessage(null, "Calling reconcileCache() again...", 7);
            }
            IElementIdentity[] allIds = this.m_configCacheView.getAllIdentities(processedIds);
            ArrayList<IElementIdentity> includeIds = new ArrayList<IElementIdentity>();
            ArrayList<IElementIdentity> nonDSFiles = new ArrayList<IElementIdentity>();
            for (int i = 0; i < allIds.length; ++i) {
                IElementIdentity id = allIds[i];
                IElement el = this.m_configCacheView.getElement(id.getName());
                if (this.m_fileManager.isNonDSFile(el)) {
                    nonDSFiles.add(id);
                    continue;
                }
                String[] nameComponents = allIds[i].getNameComponents();
                if (allIds[i].getType().equals("_MF_CI_CONFIG_ID_TYPE") || nameComponents[0].equals("_MFRuntime") && (nameComponents[nameComponents.length - 1].equals(EXTERNAL_NOTIFICATION_SUBSCRIPTIONS) || nameComponents[nameComponents.length - 1].equals(INTERNAL_NOTIFICATION_SUBSCRIPTIONS))) continue;
                includeIds.add(allIds[i]);
            }
            allIds = includeIds.toArray(new IElementIdentity[includeIds.size()]);
            String[] directories = this.m_configCacheView.getAllInterestDirs();
            HashMap allAcceptedChanges = null;
            if (reconcileExistingElements) {
                allAcceptedChanges = new HashMap();
            }
            if (!reconcileNewElements || directories.length == 0) {
                directories = null;
            }
            HashMap logicalMap = null;
            if (reconcileLogicalMap) {
                logicalMap = this.m_configCacheView.getStorageToLogicalMap();
                for (int i = 0; i < nonDSFiles.size(); ++i) {
                    IElementIdentity id = (IElementIdentity)nonDSFiles.get(i);
                    String elName = id.getName();
                    if (logicalMap.get(elName) == null) continue;
                    logicalMap.remove(elName);
                }
            }
            Object i = this.m_reconcileLock;
            synchronized (i) {
                if (this.m_designatedReconcileThread != Thread.currentThread()) {
                    return;
                }
            }
            if (this.m_isClosing) {
                return;
            }
            if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
                this.logMessage(null, "Calling reconcileCache() with " + (allIds == null ? "<null>" : Integer.toString(allIds.length)) + " identities, " + (allAcceptedChanges == null ? "<null>" : Integer.toString(allAcceptedChanges.size())) + " deletedConfigurations, " + (directories == null ? "<null>" : Integer.toString(directories.length)) + " directories, " + (logicalMap == null ? "<null>" : Integer.toString(logicalMap.size())) + " map entries", 7);
            }
            Object[] rtn = this.m_directory.reconcileCache(container, Version.VERSION_INFO, dsBackupVersion, allIds, allAcceptedChanges, directories, logicalMap);
            if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
                this.logMessage(null, "reconcileCache() returned " + (rtn[0] == null ? "<null>" : Integer.toString(((Object[])rtn[0]).length)) + " modified elements, " + (rtn[1] == null ? "<null>" : Integer.toString(((Object[])rtn[1]).length)) + " added elements, " + (rtn[2] == null ? "<null>" : Integer.toString(((HashMap)rtn[2]).size())) + " map updates", 7);
            }
            if (this.m_isClosing) {
                return;
            }
            retry = true;
            Object object = this.m_reconcileLock;
            synchronized (object) {
                if (this.m_designatedReconcileThread != Thread.currentThread()) {
                    return;
                }
                boolean callAgain = false;
                if (reconcileExistingElements) {
                    if (rtn[0] == null) {
                        reconcileExistingElements = false;
                    } else {
                        callAgain = false;
                        HashMap groups = Element.groupByParentDir((IDirElement[])((IDirElement[])rtn[0]));
                        for (ArrayList group : groups.values()) {
                            IDirElement[] elementGroup = new IDirElement[group.size()];
                            for (IDirElement el : group) {
                                processedIds.add(el.getIdentity().getName());
                            }
                            group.toArray(elementGroup);
                            if (!this.updateConfigElements(elementGroup)) continue;
                            callAgain = true;
                        }
                        reconcileExistingElements = callAgain;
                    }
                }
                if (reconcileNewElements) {
                    if (rtn[1] == null) {
                        reconcileNewElements = false;
                    } else {
                        if (((Object[])rtn[1]).length == 0) {
                            continue;
                        }
                        callAgain = false;
                        for (int i2 = 0; i2 < ((Object[])rtn[1]).length; ++i2) {
                            IDirElement currentElement = (IDirElement)((Object[])rtn[1])[i2];
                            if (currentElement instanceof IEnvelope) {
                                IEnvelope envelope = (IEnvelope)currentElement;
                                if (envelope.getProperty("RNF") != null && !processedIds.contains(currentElement.getIdentity().getName())) {
                                    callAgain = true;
                                }
                                currentElement = (IDirElement)envelope.getEnvelopedElement();
                            }
                            this.cacheAndReportElement((IBasicElement)currentElement, true, false);
                            processedIds.add(currentElement.getIdentity().getName());
                        }
                        reconcileNewElements = callAgain;
                    }
                }
                if (reconcileLogicalMap) {
                    this.m_configCacheView.applyCorrections((HashMap)rtn[2]);
                    reconcileLogicalMap = false;
                }
            }
        }
    }

    private void loadAllConfiguredComponents(IAttributeSet containerAttrs) {
        IAttributeSet regularComponentsAttrs;
        HashSet componentsWithArchiveFailures = new HashSet();
        Object[] extensionComponents = null;
        Object[] regularComponents = null;
        IAttributeSet extensionComponentsAttrs = (IAttributeSet)containerAttrs.getAttribute("EXTENSIONS");
        if (extensionComponentsAttrs != null) {
            extensionComponents = extensionComponentsAttrs.getAttributes().entrySet().toArray();
            this.loadComponentArchives(extensionComponents, true, componentsWithArchiveFailures);
        }
        if ((regularComponentsAttrs = (IAttributeSet)containerAttrs.getAttribute("COMPONENTS")) != null) {
            regularComponents = regularComponentsAttrs.getAttributes().entrySet().toArray();
            this.loadComponentArchives(regularComponents, false, componentsWithArchiveFailures);
        }
        if (extensionComponentsAttrs != null) {
            this.loadConfiguredComponents(extensionComponents, true, true, componentsWithArchiveFailures);
            this.loadConfiguredComponents(extensionComponents, true, false, componentsWithArchiveFailures);
        }
        if (regularComponentsAttrs != null) {
            this.loadConfiguredComponents(regularComponents, false, true, componentsWithArchiveFailures);
            this.loadConfiguredComponents(regularComponents, false, false, componentsWithArchiveFailures);
        }
    }

    private void loadComponentArchives(Object[] components, boolean isExtensions, HashSet componentsWithArchiveFailures) {
        for (int i = 0; i < components.length; ++i) {
            this.checkIsClosing();
            Map.Entry componentEntry = (Map.Entry)components[i];
            String id = (String)componentEntry.getKey();
            if (this.m_mBeans.containsKey(id)) continue;
            IAttributeSet attrs = (IAttributeSet)componentEntry.getValue();
            String configID = ((Reference)attrs.getAttribute(isExtensions ? "EXTENSION_CONFIG_REF" : "CONFIG_REF")).getElementName();
            IElement componentConfig = this.getConfiguration(configID);
            IAttributeSet componentAttrs = componentConfig.getAttributes();
            if (!this.createDeclaredSharedLibraries(id, componentAttrs)) {
                componentsWithArchiveFailures.add(id);
                continue;
            }
            if (this.createDependentSharedLibraries(id, componentAttrs)) continue;
            componentsWithArchiveFailures.add(id);
        }
    }

    private boolean createDeclaredSharedLibraries(String id, IAttributeSet componentAttrs) {
        String archiveName = (String)componentAttrs.getAttribute("ARCHIVE_NAME");
        if (archiveName == null) {
            this.logMessage(null, "Failed to load ID=" + id + " - archive attribute is not set", 1);
            return false;
        }
        try {
            File archiveDir = this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, archiveName);
            if (archiveDir == null) {
                this.logMessage(null, "Failed to load ID=" + id + " - archive not found: " + archiveName, 1);
                return false;
            }
            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
            this.createSharedLibraries(id, archive);
        }
        catch (Exception e) {
            if (e instanceof OutOfPersistentSpaceException) {
                this.logMessage(null, e.getMessage(), 1);
                this.shutdown(7);
            }
            this.logMessage(null, "Failed to load ID=" + id + " - error while loading archive " + archiveName + ", trace follows...", e, 1);
            return false;
        }
        return true;
    }

    private boolean createDependentSharedLibraries(String id, IAttributeSet componentAttrs) {
        String archiveName = (String)componentAttrs.getAttribute("ARCHIVE_NAME");
        String[] dependsOnSharedLibraries = null;
        try {
            File archiveDir = this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, archiveName);
            ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
            dependsOnSharedLibraries = archive.getDependsOn();
        }
        catch (Exception e) {
            this.logMessage(null, "Failed to load ID=" + id + " - error while loading archive " + archiveName + ", trace follows...", e, 1);
            return false;
        }
        for (int i = 0; i < dependsOnSharedLibraries.length; ++i) {
            try {
                if (dependsOnSharedLibraries[i].startsWith("$")) continue;
                File archiveDir = this.m_fileManager.getLocalFile(this.m_sonicArchiveSearchPath, dependsOnSharedLibraries[i]);
                ExpandedSonicArchive archive = new ExpandedSonicArchive(archiveDir);
                this.createSharedLibraries(null, archive);
                continue;
            }
            catch (Exception e) {
                this.logMessage(null, "Failed to load ID=" + id + " - error while loading dependent archive " + dependsOnSharedLibraries[i] + ", trace follows...", e, 1);
                return false;
            }
        }
        return true;
    }

    private void createSharedLibraries(String id, ExpandedSonicArchive archive) {
        String[] libraryNames = archive.getSharedLibraryNames();
        for (int i = 0; i < libraryNames.length; ++i) {
            URL[] urls = archive.getSharedLibraryClasspath(libraryNames[i]);
            ClassLoaderFactory.createDelegateLoader(this.m_containerIdentity.getCanonicalName(), id, libraryNames[i], urls, this.m_defaultClassLoader.getParent());
        }
    }

    private void loadConfiguredComponents(Object[] components, boolean isExtensions, boolean frameworkOnly, HashSet componentsWithArchiveFailures) {
        for (int i = 0; i < components.length; ++i) {
            String id;
            this.checkIsClosing();
            Map.Entry componentEntry = (Map.Entry)components[i];
            if (isExtensions) {
                IAttributeSet extensionAttrs = (IAttributeSet)componentEntry.getValue();
                Boolean isActive = (Boolean)extensionAttrs.getAttribute("EXTENSION_ACTIVE");
                if (isActive == null) {
                    isActive = new Boolean(false);
                }
                if (!isActive.booleanValue()) continue;
            }
            if (this.m_mBeans.containsKey(id = (String)componentEntry.getKey()) || componentsWithArchiveFailures.contains(id)) continue;
            this.loadConfiguredComponent(id, (IAttributeSet)componentEntry.getValue(), isExtensions, frameworkOnly);
        }
    }

    private void checkIsClosing() {
        if (this.m_isClosing) {
            throw new ShutdownInProgressException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception checkDSAccessibility(ServiceMaintainer dsMonitor) {
        if (dsMonitor == null) {
            return null;
        }
        if (Thread.currentThread() == dsMonitor) {
            try {
                String retValue = this.m_directory.ping("PONG");
                if (retValue == null || !retValue.equals("PONG")) {
                    return new Exception("The DS is not accessible.");
                }
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
        Object object = dsMonitor.getLock();
        synchronized (object) {
            dsMonitor.getLock().notifyAll();
        }
        return null;
    }

    private ArrayList translateClasspath(String id, String classpath) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        LogicalFile file = null;
        if (classpath == null || classpath.length() == 0) {
            return urls;
        }
        StringTokenizer st = new StringTokenizer(classpath, ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            file = this.m_fileManager.localFileFromLocation(null, path, false, null);
            if (file == null) {
                this.logMessage(null, "Unable to evaluate classpath element for ID=" + id + ": " + path, 2);
                continue;
            }
            urls.add(file.getURL());
        }
        return urls;
    }

    void writeLibrary(String filename, InputStream inputStream) throws IOException {
        File library;
        block7: {
            library = new File(IContainer.LIBX_DIR, filename);
            byte[] bytes = new byte[512];
            try {
                int numBytes;
                FileOutputStream fos = new FileOutputStream(library);
                while ((numBytes = inputStream.read(bytes)) >= 1) {
                    fos.write(bytes, 0, numBytes);
                }
                inputStream.close();
                fos.flush();
                fos.getFD().sync();
                fos.close();
            }
            catch (FileNotFoundException e) {
                if (IContainer.LIBX_DIR.exists()) break block7;
                this.logMessage(null, "Native library directory \"" + IContainer.LIBX_DIR + "\" does not exist", 1);
                this.shutdown(10);
            }
        }
        if (System.getProperty("path.separator").equals(":")) {
            Process chmod = Runtime.getRuntime().exec("chmod u+x " + library.getPath());
            try {
                if (chmod.waitFor() != 0) {
                    this.logMessage(null, "Failed to set execute permissions for native library: " + library.getPath(), 2);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void writeLibraries(AttributeSet libraries) throws Exception {
        for (AttributeSet libraryAttrs : libraries.getAttributes().values()) {
            String nativeLibrary = (String)libraryAttrs.getAttribute("NATIVE_LIBRARY_PATH");
            if (this.m_storedLibraries.contains(nativeLibrary)) continue;
            this.m_storedLibraries.add(nativeLibrary);
            this.m_fileManager.localFileFromLocation(null, nativeLibrary, true, null);
        }
    }

    void sendDirectedNotification(String commsType, String destination, int listenerHash, Notification notification, Object handback) {
        this.m_connector.sendDirectedNotification(commsType, destination, listenerHash, notification, handback);
    }

    private String getParentName(String elementName) {
        try {
            return new EntityName(elementName).getParent();
        }
        catch (ConfigException e) {
            e.printStackTrace();
            this.logMessage(null, e, 1);
            throw new Error();
        }
    }

    private void reportElement(IBasicElement elementToReport, boolean replacement, String logicalName) throws CacheClosedException {
        String elementName = elementToReport.getIdentity().getName();
        Object[] entries = this.m_mBeans.entrySet().toArray();
        for (int i = 0; i < entries.length; ++i) {
            AbstractMBean mBean;
            Map.Entry entry = (Map.Entry)entries[i];
            MBeanHolder holder = (MBeanHolder)entry.getValue();
            if (holder == null || (mBean = holder.mBean) == null) continue;
            try {
                if (!mBean.acceptChanges(elementName, this.getParentName(elementName)).booleanValue()) continue;
                if (mBean.isFileRequest(elementName)) {
                    mBean.handleFileChange(new FSElementChange(logicalName == null ? this.m_configCache.storageToLogical(elementName) : logicalName, elementToReport, replacement));
                    continue;
                }
                if (mBean.isLogicalRequest(elementName)) {
                    mBean.handleElementChange(new FSElementChange(logicalName == null ? this.m_configCache.storageToLogical(elementName) : logicalName, elementToReport, replacement));
                    continue;
                }
                mBean.handleElementChange(new ElementChange(elementToReport, replacement));
                continue;
            }
            catch (Throwable t) {
                this.logMessage(null, "Failed to pass configuration change to component " + (String)entry.getKey() + ", trace follows... ", t, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAndReportElement(IBasicElement element, boolean reportToComponent, boolean replacement) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        if (this.m_isClosing) {
            return;
        }
        if (this.m_configCache == null) {
            return;
        }
        if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
            this.logMessage(null, "Handling configuration change [" + element.getIdentity().getName() + "]", 7);
        }
        Object object = this.m_reportingChangeLock;
        synchronized (object) {
            String logicalName = this.m_configCache.storageToLogical(element.getIdentity().getName());
            IBasicElement elementToReport = this.setElement(element);
            if (elementToReport == null || !reportToComponent) {
                return;
            }
            this.reportElement(elementToReport, replacement, logicalName);
        }
    }

    private IBasicElement[] setElements(IElement[] elements) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        try {
            return this.m_configCache.setElements(elements);
        }
        catch (VersionOutofSyncException e) {
            this.logMessage(null, "Cache reconciliation is required: ", 3);
            throw e;
        }
        catch (CacheClosedException e) {
            this.logMessage(null, "Failed to set in cache element: ", e, 1);
            throw e;
        }
        catch (PersistentCacheException e) {
            this.logMessage(null, "Failed to set in cache element: ", e, 1);
            throw e;
        }
        catch (Throwable t) {
            this.handleThrowable(t, "");
            return null;
        }
    }

    private IBasicElement setElement(IBasicElement element) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        String elementName = element.getIdentity().getName();
        try {
            return this.m_configCache.setElement(element);
        }
        catch (VersionOutofSyncException e) {
            String rootDirectory = element.getIdentity().getNameComponents()[0];
            if (rootDirectory.startsWith("_") && rootDirectory.endsWith("Runtime")) {
                return null;
            }
            this.logMessage(null, "Cache reconciliation is required for element: " + elementName, 3);
            throw e;
        }
        catch (CacheClosedException e) {
            if (!this.m_isClosing) {
                this.logMessage(null, "Failed to set in cache element: " + elementName, e, 1);
            }
            throw e;
        }
        catch (PersistentCacheException e) {
            if (!this.m_isClosing) {
                this.logMessage(null, "Failed to set in cache element: " + elementName, e, 1);
            }
            throw e;
        }
        catch (Throwable t) {
            this.handleThrowable(t, elementName);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAndReportElements(IElement[] elements, boolean[] reportToComponent, boolean[] replacement) throws VersionOutofSyncException, CacheClosedException, PersistentCacheException {
        if (this.m_configCache == null || elements.length == 0) {
            return;
        }
        if ((this.m_agent.m_traceMask & 0x200) > 0 && (this.m_agent.m_traceMask & 1) > 0) {
            this.logMessage(null, "Handling configuration changes in directory [" + this.getParentName(elements[0].getIdentity().getName()) + "]", 7);
        }
        Object object = this.m_reportingChangeLock;
        synchronized (object) {
            IBasicElement[] elementsToReport = this.setElements(elements);
            for (int i = 0; i < elementsToReport.length; ++i) {
                if (elementsToReport[i] == null || !reportToComponent[i]) continue;
                this.reportElement(elementsToReport[i], replacement[i], null);
            }
        }
    }

    private void handleThrowable(Throwable t, String elementName) {
        this.logMessage(null, "Failed to set in cache element: " + elementName, t, 1);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new Error(t.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockReload(ICanonicalName target) {
        ArrayList arrayList = this.m_reloadingIDs;
        synchronized (arrayList) {
            MBeanHolder holder = (MBeanHolder)this.m_mBeans.get(target.getComponentName());
            if (this.m_reloadingIDs.size() > 0 && this.m_reloadingIDs.contains(target.getComponentName())) {
                this.logMessage(target.getComponentName(), "Management request blocked during component reload...", 3);
                while (!this.m_reloadingIDs.isEmpty()) {
                    try {
                        this.m_reloadingIDs.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.m_isClosing) continue;
                    return false;
                }
                holder = (MBeanHolder)this.m_mBeans.get(target.getComponentName());
                if (holder == null) {
                    return false;
                }
                this.logMessage(target.getComponentName(), "...request resumed after reload", 3);
            } else if (holder == null) {
                return false;
            }
            holder.incrementRequestCount();
            return true;
        }
    }

    private void unblockReload(ICanonicalName target) {
        MBeanHolder holder = (MBeanHolder)this.m_mBeans.get(target.getComponentName());
        if (holder == null) {
            return;
        }
        holder.decrementRequestCount();
    }

    ArrayList prepareCacheForActivatedContainer(String adName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, HashMap activationProps) throws Exception {
        return LaunchContainer.prepareCacheForActivatedContainer((IConnectorClient)this.m_connector, (IDirectoryAdminService)this.m_directory.getLocalDS(), (ILogger)new ContainerLogger(adName), (String)this.m_containerIdentity.getDomainName(), (String)containerName, (String)containerID, (String)containerWorkDirDirectoryName, (String)cacheHostDirectoryName, (String)cachePassword, (HashMap)activationProps);
    }

    static {
        ACTIONAL_SDK_JMS_LOCATION = "sonicfs:///Archives/MF/" + Version.getMajorVersion() + "." + Version.getMinorVersion() + "/actional-sdk-jms.jar";
        s_errDirect = new PrintStream(new FileOutputStream(FileDescriptor.err));
        m_isLSD = Boolean.getBoolean("sonicsw.mf.lsd.colocate");
        if (!m_isLSD) {
            Agent.redirectOutput();
        }
    }

    private final class InternalRequestHandler
    extends RequestHandler {
        private InternalRequestHandler() {
        }

        @Override
        public String getHandlerCommsType() {
            return "mf";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object internalInvoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
            CanonicalName canonicalName = new CanonicalName(target.getCanonicalName());
            boolean isReloadRequest = operationName.equals("reload") || operationName.equals("reloadComponent");
            boolean requestCountIncremented = isReloadRequest ? false : ContainerImpl.this.blockReload((ICanonicalName)canonicalName);
            try {
                MBeanHolder mbh = (MBeanHolder)ContainerImpl.this.m_mBeans.get(canonicalName.getComponentName());
                AbstractMBean mBean = null;
                if (mbh != null) {
                    mBean = mbh.mBean;
                }
                if (mBean == null) {
                    throw new MFException("Unknown component: " + target.getCanonicalName());
                }
                if (checkExported) {
                    boolean isExported = false;
                    isExported = mBean.isOperationExported(operationName, signature);
                    if (!isExported) {
                        String signatureString = "(";
                        for (int i = 0; i < signature.length; ++i) {
                            signatureString = signatureString + signature[i];
                            if (i + 1 >= signature.length) continue;
                            signatureString = signatureString + ",";
                        }
                        signatureString = signatureString + ")";
                        throw new MFException('(' + target.getCanonicalName() + ") Unknown operation: " + operationName + signatureString);
                    }
                }
                if (TaskScheduler.isExecutionThread()) {
                    String currentUserID = TaskScheduler.getCurrentUserID();
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID("Administrator");
                    Object returnValue = mBean.internalInvoke(operationName, params, signature);
                    ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(currentUserID);
                    Object object = returnValue;
                    return object;
                }
                Object object = mBean.internalInvoke(operationName, params, signature);
                return object;
            }
            finally {
                if (requestCountIncremented) {
                    ContainerImpl.this.unblockReload((ICanonicalName)canonicalName);
                }
            }
        }

        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean checkExported) throws Exception {
            try {
                return this.internalInvoke(target, operationName, params, signature, checkExported);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                String errorMessage = "Invocation error in " + target + "." + operationName + ": " + t.toString();
                throw new Exception(errorMessage);
            }
        }

        @Override
        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature) throws Exception {
            return this.internalInvoke(target, operationName, params, signature, false);
        }
    }

    private final class NotificationListenerExpirer
    extends Thread {
        private Object lockObj;

        private NotificationListenerExpirer() {
            super("Notification Listener Expirer");
            this.lockObj = new Object();
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block5: while (true) {
                    Object object = this.lockObj;
                    synchronized (object) {
                        this.lockObj.wait(30000L);
                    }
                    if (ContainerImpl.this.m_isClosing) {
                        return;
                    }
                    Object[] subscriptions = ContainerImpl.this.m_notificationListeners.values().toArray();
                    int i = 0;
                    while (true) {
                        if (i >= subscriptions.length) continue block5;
                        NotificationListenerDelegate delegate = (NotificationListenerDelegate)subscriptions[i];
                        if (delegate.hasExpired()) {
                            ContainerImpl.this.expireSubscription(delegate);
                        }
                        if (ContainerImpl.this.m_isClosing) {
                            return;
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public Object getLockObj() {
            return this.lockObj;
        }
    }

    private final class Delegate
    implements IContainer {
        private Delegate() {
        }

        @Override
        public boolean isBooted() {
            return m_container.isBooted();
        }

        @Override
        public boolean isClosing() {
            return m_container.isClosing();
        }

        @Override
        public boolean isHostingComponent(String id) {
            return m_container.isHostingComponent(id);
        }

        @Override
        public IContainerState getContainerState() {
            return m_container.getContainerState();
        }

        @Override
        public IContainerIdentity getContainerIdentity() {
            return m_container.getContainerIdentity();
        }

        @Override
        public ITaskScheduler getTaskScheduler() {
            return m_container.getTaskScheduler();
        }

        @Override
        public INotificationPublisher getNotificationPublisher() {
            return m_container.getNotificationPublisher();
        }

        @Override
        public void addGlobalComponentSupport(String globalID, String instanceID, IGlobalComponentListener globalComponentListener) throws Exception {
            m_container.addGlobalComponentSupport(globalID, instanceID, globalComponentListener);
        }

        @Override
        public void removeGlobalComponentSupport(String globalID, String instanceID) {
            m_container.removeGlobalComponentSupport(globalID, instanceID);
        }

        @Override
        public void setLocalDS(IFrameworkComponent ds) {
            m_container.setLocalDS(ds);
        }

        @Override
        public void shutdown(int exitCode) {
            m_container.shutdown(exitCode);
        }

        @Override
        public void shutdown(int exitCode, boolean cleanRestart) {
            m_container.shutdown(exitCode, cleanRestart);
        }

        @Override
        public void logMessage(String id, String message, int severityLevel) {
            m_container.logMessage(id, message, severityLevel);
        }

        @Override
        public void logMessage(String id, Throwable exception, int severityLevel) {
            m_container.logMessage(id, exception, severityLevel);
        }

        @Override
        public void logMessage(String id, String message, Throwable exception, int severityLevel) {
            m_container.logMessage(id, message, exception, severityLevel);
        }

        @Override
        public IConnectorServer getConnectorServer() {
            return m_container.getConnectorServer();
        }

        @Override
        public IElement getConfigurationFromDS(String configID) {
            return m_container.m_directory.getElement(m_container.m_containerIdentity.getCanonicalName(), configID);
        }

        @Override
        public ArrayList prepareCacheForActivatedContainer(String adName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, HashMap activationProps) throws Exception {
            return m_container.prepareCacheForActivatedContainer(adName, containerName, containerID, containerWorkDirDirectoryName, cacheHostDirectoryName, cachePassword, activationProps);
        }

        @Override
        public File getCacheDirectory() {
            return m_container.m_configCache.getCacheRootDirectory();
        }
    }

    private final class ShutdownInProgressException
    extends RuntimeException {
        private ShutdownInProgressException() {
        }
    }

    private final class MBeanHolder {
        AbstractMBean mBean;
        private int requestCount;

        private MBeanHolder(AbstractMBean mBean) {
            this.mBean = mBean;
        }

        private synchronized void waitForRequestCompletion() {
            if (this.requestCount > 0) {
                String id = new CanonicalName(this.mBean.getObjectName().getCanonicalName()).getComponentName();
                ContainerImpl.this.logMessage(id, "Reload blocked awaiting request completion...", 3);
                while (this.requestCount > 0) {
                    try {
                        this.wait(100L);
                        if (!ContainerImpl.this.m_isClosing) continue;
                        return;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                ContainerImpl.this.logMessage(id, "...reload resumed after request completion", 3);
            }
        }

        private synchronized void incrementRequestCount() {
            ++this.requestCount;
        }

        private synchronized void decrementRequestCount() {
            --this.requestCount;
            if (this.requestCount < 0 && !ContainerImpl.this.m_isClosing) {
                CanonicalName name = new CanonicalName(this.mBean.getObjectName().getCanonicalName());
                Error e = new Error("Negative request count");
                ContainerImpl.this.logMessage(name.getComponentName(), "Request count error, please report the following trace to Sonic support...", e, 1);
                this.requestCount = 0;
            }
            if (this.requestCount == 0) {
                this.notifyAll();
            }
        }
    }

    private final class Monitor
    extends Thread {
        private boolean closing;
        private Object monitorLockObj;

        private Monitor() {
            super("Container Monitor");
            this.closing = false;
            this.monitorLockObj = new Object();
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            Object object = this.monitorLockObj;
            synchronized (object) {
                this.closing = true;
                this.monitorLockObj.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File abortFile = new File(ContainerImpl.this.m_containerIdentity.getCanonicalName() + ".abort");
            boolean abort = false;
            boolean lsd = Boolean.getBoolean("sonicsw.mf.lsd.colocate");
            while (!this.closing) {
                Object object;
                if (abort) {
                    return;
                }
                if (abortFile.exists()) {
                    abort = true;
                    abortFile.deleteOnExit();
                    ContainerImpl.this.logMessage(null, "** ABORT FILE DETECTED: CONTAINER WILL HALT IF NOT SHUT DOWN WITHIN " + Integer.getInteger("sonicsw.mf.qa.abort", 0) + " SECONDS **", 7);
                    object = this.monitorLockObj;
                    synchronized (object) {
                        try {
                            if (this.closing) {
                                return;
                            }
                            this.monitorLockObj.wait(Integer.getInteger("sonicsw.mf.qa.abort", 0) * 1000);
                            if (this.closing) {
                                return;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ContainerImpl.this.logMessage(null, "** CONTAINER SHUTDOWN NOT EXECUTED OR TIMED OUT, DUMPING THREAD LIST AND HALTING **", 7);
                    File threadListingFile = new File(ContainerImpl.this.m_containerIdentity.getCanonicalName() + ".threads");
                    threadListingFile.delete();
                    try {
                        PrintWriter out = new PrintWriter(new FileWriter(threadListingFile));
                        ThreadGroup tg = Thread.currentThread().getThreadGroup();
                        while (tg.getParent() != null) {
                            tg = tg.getParent();
                        }
                        Thread[] threads = new Thread[tg.activeCount() + 1000];
                        tg.enumerate(threads, true);
                        for (int i = 0; i < threads.length; ++i) {
                            if (threads[i] == null) continue;
                            out.println(threads[i]);
                        }
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!this.closing && !lsd) {
                        new File("start_timestamp").delete();
                        ContainerImpl.this.m_containerRunningLockFile.unlock();
                        Runtime.getRuntime().halt(-100);
                    }
                }
                object = this.monitorLockObj;
                synchronized (object) {
                    try {
                        if (this.closing) {
                            return;
                        }
                        this.monitorLockObj.wait(5000L);
                        if (this.closing) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final class ContainerLogger
    implements ILogger {
        String m_componentName;

        ContainerLogger() {
            this.m_componentName = null;
        }

        ContainerLogger(String componentName) {
            this.m_componentName = componentName;
        }

        public void logMessage(String message, int severityLevel) {
            ContainerImpl.this.logMessage(this.m_componentName, message, severityLevel);
        }

        public void logMessage(String message, Throwable error, int severityLevel) {
            ContainerImpl.this.logMessage(this.m_componentName, message, error, severityLevel);
        }
    }

    private final class ExternalRequestHandler
    extends RequestHandler {
        private ExternalRequestHandler() {
        }

        @Override
        public String getHandlerCommsType() {
            return "jmx";
        }

        @Override
        public Object invoke(ObjectName target, String operationName, Object[] params, String[] signature) throws Exception {
            return this.invoke(target, operationName, params, signature, true);
        }

        private Object invoke(ObjectName target, String operationName, Object[] params, String[] signature, boolean blockWhileReloading) throws Exception {
            return this.invoke(target, operationName, params, signature, blockWhileReloading, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invoke(ObjectName targetParam, String operationName, Object[] paramsParam, String[] signatureParam, boolean blockWhileReloading, boolean checkPermissions) throws Exception {
            String invokeOperationName;
            ObjectName target = targetParam;
            String[] signature = signatureParam;
            Object[] params = paramsParam;
            boolean isInvokeInvoke = operationName.equals("invoke");
            boolean isInvokeSetAttribute = operationName.startsWith(ContainerImpl.SET_ATTRIBUTE_METHOD_NAME);
            if (this.interceptNotificationRegistrationOperations(operationName, params)) {
                return null;
            }
            boolean isMFComponent = target != null && ObjectNameHelper.isMFComponentName((ObjectName)target);
            CanonicalName canonicalName = null;
            if (isMFComponent) {
                target = ObjectNameHelper.translateGlobalObjectName((ObjectName)target, (String)ContainerImpl.this.m_containerIdentity.getContainerName());
                canonicalName = new CanonicalName(target.getCanonicalName());
            }
            MBeanInfo mBeanInfo = target == null ? null : ContainerImpl.this.m_mbeanServer.getMBeanInfo(target);
            String string = invokeOperationName = isInvokeInvoke ? (String)params[1] : operationName;
            if (checkPermissions) {
                IPermissionsManager permissionsManager = ContainerImpl.this.m_agent.getPermissionsManager();
                permissionsManager.managePermissionCheck(target, invokeOperationName, mBeanInfo);
            }
            if (operationName.equals(ContainerImpl.ADD_NOTIFICATION_LISTENER_METHOD_NAME) && params.length > 4) {
                String[] newSignature = new String[4];
                Object[] newParams = new Object[4];
                for (int i = 0; i < 4; ++i) {
                    newSignature[i] = signature[i];
                    newParams[i] = params[i];
                }
                signature = newSignature;
                params = newParams;
            }
            Class[] parameterTypes = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                try {
                    parameterTypes[i] = Class.forName(signature[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    parameterTypes[i] = params[i].getClass();
                }
            }
            Object returnValue = null;
            try {
                Method method = ContainerImpl.this.m_mbeanServerClass.getMethod(operationName, parameterTypes);
                boolean isReloadRequest = isInvokeInvoke && (params[1].equals("reload") || params[1].equals("reloadComponent"));
                boolean requestCountIncremented = isMFComponent && blockWhileReloading && !isReloadRequest ? ContainerImpl.this.blockReload((ICanonicalName)canonicalName) : false;
                try {
                    returnValue = method.invoke((Object)ContainerImpl.this.m_mbeanServer, params);
                    if (checkPermissions) {
                        IAuditManager auditManager = ContainerImpl.this.m_agent.getAuditManager();
                        Object[] invokeParams = params;
                        if (isInvokeInvoke) {
                            invokeParams = (Object[])params[2];
                        }
                        if (isInvokeSetAttribute) {
                            invokeParams = new Object[]{params[1]};
                        }
                        auditManager.recordManageEvent(target, mBeanInfo, invokeOperationName, invokeParams, returnValue);
                    }
                }
                finally {
                    if (isMFComponent && requestCountIncremented) {
                        ContainerImpl.this.unblockReload((ICanonicalName)canonicalName);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionMapper.throwMappedException(e);
            }
            return returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean interceptNotificationRegistrationOperations(String operationName, Object[] params) {
            boolean isRemoveFilterHandbackPair;
            boolean isAdd = operationName.equals(ContainerImpl.ADD_NOTIFICATION_LISTENER_METHOD_NAME);
            boolean isRemove = operationName.equals(ContainerImpl.REMOVE_NOTIFICATION_LISTENER_METHOD_NAME);
            boolean bl = isRemoveFilterHandbackPair = isRemove && params.length == 4;
            if (!isAdd && !isRemove) {
                return false;
            }
            ObjectName objectName = this.removeFTInstanceNameFromObjectName((ObjectName)params[0]);
            objectName = ObjectNameHelper.translateGlobalObjectName((ObjectName)objectName, (String)ContainerImpl.this.m_containerIdentity.getContainerName());
            com.sonicsw.mf.jmx.client.NotificationListenerDelegate remoteListener = (com.sonicsw.mf.jmx.client.NotificationListenerDelegate)params[1];
            String remoteListenerKey = this.geRemoteListenerKey(objectName, remoteListener);
            NotificationListenerDelegate localListener = null;
            HashMap hashMap = ContainerImpl.this.m_notificationListeners;
            synchronized (hashMap) {
                localListener = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.get(remoteListenerKey);
                if (isAdd) {
                    if (localListener == null) {
                        localListener = new NotificationListenerDelegate(objectName, remoteListener);
                        ContainerImpl.this.m_notificationListeners.put(remoteListenerKey, localListener);
                        this.configLocalListenerAndStore(localListener, objectName, params);
                        params[2] = null;
                        params[3] = null;
                    } else {
                        if (ContainerImpl.this.m_mbeanServer.isRegistered(objectName)) {
                            this.configLocalListenerAndStore(localListener, objectName, params);
                            return true;
                        }
                        Boolean clearResult = this.clearNotifications(localListener, params, remoteListenerKey);
                        if (clearResult != null) {
                            return clearResult;
                        }
                    }
                } else if (isRemoveFilterHandbackPair) {
                    Boolean clearResult;
                    if (localListener != null && (clearResult = this.clearNotifications(localListener, params, remoteListenerKey)) != null) {
                        return clearResult;
                    }
                } else {
                    NotificationListenerDelegate delegate = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.remove(remoteListenerKey);
                    delegate.close();
                    localListener.removeAllHandbackFilterPairs();
                    ContainerImpl.this.deleteNotificationListenerSubscriptionsFromCache(localListener);
                }
            }
            params[1] = localListener;
            return false;
        }

        private Boolean clearNotifications(NotificationListenerDelegate localListener, Object[] params, String remoteListenerKey) {
            localListener.removeHandbackFilterPair(params[3], (NotificationFilter)params[2]);
            ContainerImpl.this.deleteNotificationListenerSubscriptionsFromCache(localListener);
            if (localListener.getHandbackFilterPairs().size() != 0) {
                return true;
            }
            NotificationListenerDelegate delegate = (NotificationListenerDelegate)ContainerImpl.this.m_notificationListeners.remove(remoteListenerKey);
            delegate.close();
            params[2] = null;
            params[3] = null;
            return null;
        }

        private void configLocalListenerAndStore(NotificationListenerDelegate localListener, ObjectName objectName, Object[] params) {
            localListener.setHandbackFilterPair(params[3], (NotificationFilter)params[2]);
            localListener.setNotificationSubscriptionTimeout((Long)params[4]);
            ContainerImpl.this.storeNotificationListenerSubscriptionsInCache(objectName, localListener);
        }

        private String geRemoteListenerKey(ObjectName name, com.sonicsw.mf.jmx.client.NotificationListenerDelegate remoteListener) {
            StringBuffer sb = new StringBuffer(remoteListener.m_destination);
            sb.append(':').append(remoteListener.m_listenerHash).append(':').append(name.getCanonicalName());
            return sb.toString();
        }

        private ObjectName removeFTInstanceNameFromObjectName(ObjectName objectName) {
            StringBuffer sb = new StringBuffer(ContainerImpl.this.m_containerIdentity.getCanonicalName());
            if (!objectName.getDomain().equals(sb.toString())) {
                sb.append(':');
                sb.append(objectName.getCanonicalKeyPropertyListString());
                try {
                    return new ObjectName(sb.toString());
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    // empty catch block
                }
            }
            return objectName;
        }
    }

    abstract class RequestHandler {
        RequestHandler() {
        }

        abstract String getHandlerCommsType();

        abstract Object invoke(ObjectName var1, String var2, Object[] var3, String[] var4) throws Exception;
    }

    private final class FSElementChange
    extends ElementChange
    implements IFSElementChange,
    Serializable {
        private String m_logicalPath;

        public FSElementChange() {
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.m_element);
            s.writeObject(this.m_logicalPath);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.m_element = (IBasicElement)s.readObject();
            this.m_logicalPath = (String)s.readObject();
        }

        FSElementChange(String logicalPath, IBasicElement element, boolean replacement) {
            this.m_logicalPath = logicalPath;
            this.m_element = element;
            this.m_replacement = replacement;
        }

        public String getLogicalPath() {
            return this.m_logicalPath;
        }
    }

    private class ElementChange
    implements IElementChange,
    Serializable {
        IBasicElement m_element;
        boolean m_replacement;

        public ElementChange() {
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.m_element);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.m_element = (IBasicElement)s.readObject();
        }

        ElementChange(IBasicElement element, boolean replacement) {
            this.m_element = element;
            this.m_replacement = replacement;
        }

        public IBasicElement getElement() {
            return this.m_element;
        }

        public short getChangeType() {
            if (this.m_element instanceof IDeltaElement) {
                return 1;
            }
            if (((IElement)this.m_element).isDeleted()) {
                return 2;
            }
            if (this.m_replacement) {
                return 3;
            }
            return 0;
        }
    }
}

