/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mf.framework.directory.storage.pse.PSEStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class DirectoryDump {
    private IDirectoryService m_ds;
    private static final String FILES_DUMP_SUFFIX = "_files";

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[0].equals("?")) {
            DirectoryDump.printUsage();
        }
        try {
            System.setProperty("DSDUMP", "true");
            new DirectoryDump(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryDump(String[] args) throws Exception {
        try {
            this.m_ds = this.createDSInstance(args[0]);
            boolean findBlobsDir = false;
            String dumpFile = null;
            String blobsDir = null;
            File blobsDirFile = null;
            for (int i = 1; i < args.length; ++i) {
                if (findBlobsDir) {
                    findBlobsDir = false;
                    blobsDir = args[i];
                    continue;
                }
                if (args[i].equals("-files")) {
                    findBlobsDir = true;
                    continue;
                }
                dumpFile = args[i];
            }
            if (blobsDir != null) {
                blobsDirFile = new File(blobsDir);
                if (!blobsDirFile.exists()) {
                    throw new DirectoryServiceException("Directory " + blobsDir + " doesn't exist");
                }
                blobsDirFile = new File(blobsDir, this.m_ds.getDomain() + FILES_DUMP_SUFFIX);
                if (blobsDirFile.exists()) {
                    throw new DirectoryServiceException("Directory " + blobsDirFile.getCanonicalPath() + " already exists. Please remove the directory " + blobsDirFile.getName() + " and try again");
                }
            }
            String contents = this.m_ds.exportDirectoryToXML("/");
            if (dumpFile != null) {
                System.out.println("Dumping configurations:");
                this.dumpXMLStringToFile(contents, dumpFile);
                System.out.println("Done.");
            }
            if (blobsDirFile != null) {
                System.out.println("Dumping files:");
                this.dumpBlobs(blobsDirFile, "/");
                System.out.println("Done.");
            }
            this.reportCorrupt(contents);
        }
        finally {
            if (this.m_ds != null) {
                this.m_ds.close();
            }
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: com.sonicsw.mf.framework.directory.storage.DirectoryDump <ds.xml> <out.xml> -files <files_directory>");
        System.out.println();
        System.out.println("Where: <ds.xml>          Directory Service configuration.");
        System.out.println("       <out.xml>         The Directory Service content in XML format.");
        System.out.println("       <files_directory> The directory to write the files stored in the Directory Service. ");
        System.out.println("                         This utility creates the <domain_name>_files subdirectory to dump the files into.");
        System.exit(1);
    }

    private void dumpXMLStringToFile(String xmlString, String dumpFilename) throws Exception {
        FileOutputStream fos = new FileOutputStream(dumpFilename);
        fos.write(xmlString.getBytes());
        fos.close();
    }

    private void dumpBlobs(File blobDirectory, String dsDir) throws Exception {
        IIdentity[] elIds = this.m_ds.listAll(dsDir);
        for (int i = 0; i < elIds.length; ++i) {
            IBlob blob;
            if (elIds[i] instanceof IDirIdentity) {
                this.dumpBlobs(blobDirectory, elIds[i].getName());
                continue;
            }
            String blobName = elIds[i].getName();
            if (PSEStorage.hasCorruptElements() && PSEStorage.getCorruptIds().keySet().contains(blobName) || (blob = this.m_ds.getBlob(blobName, false)) == null || blob.getBlobStream() == null) continue;
            File dumpBlobDir = new File(blobDirectory, blobName.substring(0, blobName.lastIndexOf(DSComponent.MF_DIR_SEPARATOR_STRING)));
            dumpBlobDir.mkdirs();
            File dumpBlobFile = new File(blobDirectory, blobName);
            FileOutputStream dumpStream = new FileOutputStream(dumpBlobFile);
            InputStream blobStream = blob.getBlobStream();
            BufferedOutputStream bufOut = new BufferedOutputStream(dumpStream, 1000000);
            BufferedInputStream bufIn = new BufferedInputStream(blobStream, 1000000);
            int byteRead = bufIn.read();
            while (byteRead != -1) {
                bufOut.write(byteRead);
                byteRead = bufIn.read();
            }
            blobStream.close();
            bufOut.close();
        }
    }

    private IDirectoryService createDSInstance(String dsXMLFile) throws Exception {
        IDirElement[] dsConfigs = ContainerUtil.importConfigurations(new File(dsXMLFile), IContainer.PASSWORD);
        IDirElement dsConfig = null;
        for (int i = 0; i < dsConfigs.length; ++i) {
            String elType = dsConfigs[i].getIdentity().getType();
            if (!elType.equals("MF_DIRECTORY_SERVICE") && !elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) continue;
            dsConfig = dsConfigs[i];
        }
        if (dsConfig == null) {
            throw new Exception("File " + dsXMLFile + " does not contain valid Directory Service boot information");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        if (domainName == null) {
            domainName = "Domain1";
        }
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null || tmp == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        return factory.createDirectoryService(domainName);
    }

    private void reportCorrupt(String dumpedXml) {
        if (PSEStorage.hasCorruptElements()) {
            HashMap corruptData = PSEStorage.getCorruptIds();
            boolean idCacheCorrupt = corruptData.containsKey("/_MFSystem/idcache");
            boolean onlyIdCacheIsCorrupt = idCacheCorrupt && corruptData.size() == 1;
            System.out.println();
            if (!onlyIdCacheIsCorrupt) {
                int problemIndex = 0;
                System.out.println("dsAdmin dump skipped over the following elements because they were found to be corrupt. Creating a new Directory Service using the dsadmin load option will remove the elements from the Directory Service: ");
                System.out.println();
                Iterator stringIT = corruptData.keySet().iterator();
                while (stringIT.hasNext()) {
                    String elId = (String)stringIT.next();
                    if (elId.equals("/_MFSystem/idcache")) continue;
                    System.out.println("**** Problem #" + ++problemIndex + " ****");
                    Object message = corruptData.get(elId);
                    this.printCorruptId(elId);
                    System.out.println();
                    this.printStackTrace((Object[])message);
                    if (elId.startsWith("/")) {
                        System.out.println();
                        this.findAndPrintReferences(elId, dumpedXml);
                    }
                    if (!stringIT.hasNext()) continue;
                    System.out.println();
                }
            }
            if (onlyIdCacheIsCorrupt) {
                System.out.println("The id cache was corrupt. Creating a new Directory Service using the dsadmin load option will recreate the id cache.");
            } else if (idCacheCorrupt) {
                System.out.println("The id cache was also corrupt and will be recreated when you use the dsadmin load option to create a new Directory Service");
            }
            System.out.println();
        }
    }

    private void findAndPrintReferences(String elId, String dumpedXml) {
        String ELEMENT_ID = "ElementID name=";
        if (elId.startsWith("/mx/configTypes")) {
            System.out.println("The element " + elId + " is referenced in all the elements of that type");
            return;
        }
        String searchId = this.getSearchId(elId);
        boolean done = false;
        ArrayList<String> referencedIn = new ArrayList<String>();
        int searchStart = 0;
        while (!done) {
            int foundLocation = dumpedXml.indexOf(searchId, searchStart);
            if (foundLocation > -1) {
                int endIdLocation;
                int elementIdLocation = dumpedXml.lastIndexOf("ElementID name=", foundLocation) + 16;
                String referenceId = dumpedXml.substring(elementIdLocation, endIdLocation = dumpedXml.indexOf(34, elementIdLocation));
                if (!referencedIn.contains(referenceId) && !referenceId.equals("/_MFSchema/view")) {
                    referencedIn.add(referenceId);
                }
                searchStart = foundLocation + elId.length();
                continue;
            }
            done = true;
        }
        if (!referencedIn.isEmpty()) {
            System.out.println("Element " + elId + " is referenced by the following elements:");
            for (String id : referencedIn) {
                System.out.print(id);
                try {
                    String logicalId = this.m_ds.storageToLogical(id);
                    if (logicalId != null) {
                        System.out.print("(" + logicalId + ")");
                    }
                }
                catch (DirectoryServiceException directoryServiceException) {
                    // empty catch block
                }
                System.out.println();
            }
        } else {
            System.out.println(elId + " is not referenced by other elements in the Directory Service");
        }
    }

    private String getSearchId(String id) {
        String SERVICE_PREFIX = "/xqServices/";
        String PROCESS_PREFIX = "/xqProcesses/";
        String ENDPOINT_PREFIX = "/xqEndpoints/";
        String CONNECTION_PREFIX = "/xqConnections/";
        String CONNECTION_TYPE_PREFIX = "/xqConnectionTypes/";
        String SERVICE_PROCESS_REF = "name=\"service_ref\" value=\"";
        String ENDPOINT_REF = "name=\"endpoint_ref\" value=\"";
        String CONNECTION_REF = "name=\"connection_ref\" value=\"";
        String CONNECTION_TYPE_REF = "name=\"type_ref\" value=\"";
        if (id.startsWith("/xqServices/") || id.startsWith("/xqProcesses/")) {
            return "name=\"service_ref\" value=\"" + id.substring(id.lastIndexOf(47) + 1) + "\"";
        }
        if (id.startsWith("/xqEndpoints/")) {
            return "name=\"endpoint_ref\" value=\"" + id.substring(id.lastIndexOf(47) + 1) + "\"";
        }
        if (id.startsWith("/xqConnections/")) {
            return "name=\"connection_ref\" value=\"" + id.substring(id.lastIndexOf(47) + 1) + "\"";
        }
        if (id.startsWith("/xqConnectionTypes/")) {
            return "name=\"type_ref\" value=\"" + id.substring(id.lastIndexOf(47) + 1) + "\"";
        }
        return id;
    }

    private void printStackTrace(Object[] info) {
        System.out.println(info[0]);
        System.out.println("Exception stack trace:");
        StackTraceElement[] stackTrace = (StackTraceElement[])info[1];
        for (int i = 0; i < stackTrace.length; ++i) {
            System.out.println(stackTrace[i].toString());
        }
    }

    private void printCorruptId(String elId) {
        block5: {
            if (elId.startsWith("/")) {
                try {
                    String logicalId = this.m_ds.storageToLogical(elId);
                    if (logicalId != null) {
                        System.out.println(elId + "(" + logicalId + ")");
                        break block5;
                    }
                    System.out.println(elId);
                }
                catch (DirectoryServiceException dirE) {
                    System.out.println(elId);
                }
            } else {
                System.out.println("UNKNOWN element");
            }
        }
    }
}

