/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class AsyncDeleteNote
extends AbstractNote
implements IRedoNoteInfo {
    private static final byte NOTE_TYPE = 80;
    private byte[] m_scratchBuffer = new byte[8];
    long m_dbkey;
    long m_transactionNum;

    AsyncDeleteNote() {
    }

    byte getType() {
        return 80;
    }

    public long getDbk() {
        return this.m_dbkey;
    }

    public long getTransID() {
        return this.m_transactionNum;
    }

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 17;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
        this.m_dbkey = BitUtil.getLong(buffer, currentOffset += 8);
    }

    void initNote(long transactionNum, long dbkey) {
        this.m_transactionNum = transactionNum;
        this.m_dbkey = dbkey;
    }

    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " dbkey: " + this.m_dbkey;
    }
}

