/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.http;

import com.sonicsw.blackbird.Version;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.http.EvsHTTPNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.http.prAccessor;
import com.sonicsw.blackbird.http.IHTTPConnection;
import com.sonicsw.blackbird.http.IHTTPMessage;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.client.HTTPClientFactory;
import com.sonicsw.blackbird.http.client.IHTTPClient;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.Enumeration;
import java.util.Properties;
import progress.message.resources.prMessageFormat;

public class EvsHTTPClientNetworkLink
extends EvsHTTPNetworkLink {
    private static final boolean DEBUG = EvsHTTPNetworkLink.DEBUG_NEW_HTTP;
    private static final boolean DEBUG_UNEXPECTED = EvsHTTPNetworkLink.DEBUG_UNEXPECTED;
    private static final boolean DEBUG_PERFORMANCE = EvsHTTPNetworkLink.DEBUG_PERFORMANCE;
    private static final boolean DEBUG_LIFECYCLE = EvsHTTPNetworkLink.DEBUG_LIFECYCLE;
    public static final boolean ALLOW_MULTI_RESPONSE_READ = false;
    private static final byte STATE_INIT = 0;
    private static final byte STATE_HTTP_CONNECT = 1;
    private static final byte STATE_HTTP_CONNECT_RESPONSE = 2;
    private static final byte STATE_CONNECTED = 3;
    private static final byte STATE_CLOSE_WRITE = 4;
    private static final byte STATE_CLOSE_READ = 5;
    private static final byte STATE_CLOSE_WAIT = 6;
    private static final byte STATE_CLOSED = 7;
    private byte m_connectState = 0;
    IHTTPRequest m_connectRequest = null;
    IHTTPResponse m_connectResponse = null;
    private String m_connectionId = "";
    private IHTTPClient m_httpWriteClient = null;
    private IHTTPClient m_httpReadClient = null;
    private IHTTPClient m_httpCloseClient = null;
    private final WriteContext m_writeContext;
    private final ReadContext m_readContext;
    private int MAX_READ_REQUESTS = EvsHTTPNetworkLink.HTTP_MAX_HTTP_READ_REQUESTS;
    private int PEER_TUNNELING_VERSION;
    private int MAX_MESSAGE_SIZE;
    private int IDLE_TIMEOUT = 5000;
    private int KEEPALIVE_INTERVAL = 2500;
    private final int CLOSE_TIMEOUT;
    private final int CONNECT_TIMEOUT;

    EvsHTTPClientNetworkLink(int type, SelectableChannel channel, INetworkLinkConfig config) throws EEvsIOException {
        super(config);
        String name;
        this.m_writeContext = new WriteContext();
        this.m_readContext = new ReadContext();
        this.CLOSE_TIMEOUT = config.getHTTPCloseTimeout();
        this.CONNECT_TIMEOUT = config.getHTTPConnectTimeout();
        this.MAX_MESSAGE_SIZE = config.getHTTPMaxMessagetSize();
        this.m_httpWriteClient = HTTPClientFactory.createHTTPClient(this.m_config);
        this.m_httpWriteClient.addStandardHeader("Cache-Control", "no-cache");
        this.m_httpWriteClient.addStandardHeader("Pragma", "no-cache");
        this.m_httpWriteClient.addStandardHeader("Content-Type", "application/octet-stream");
        this.m_httpWriteClient.setResponseTimeout(this.CONNECT_TIMEOUT);
        Enumeration<Object> e = this.m_config.getHTTPCustomHeaders().keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            this.m_httpWriteClient.addStandardHeader(name, this.m_config.getHTTPCustomHeaders().getProperty(name));
        }
        this.m_httpReadClient = HTTPClientFactory.createHTTPClient(this.m_config);
        this.m_httpReadClient.addStandardHeader("Cache-Control", "no-cache");
        this.m_httpReadClient.addStandardHeader("Pragma", "no-cache");
        this.m_httpReadClient.addStandardHeader("Content-Type", "application/octet-stream");
        e = this.m_config.getHTTPCustomHeaders().keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            this.m_httpReadClient.addStandardHeader(name, this.m_config.getHTTPCustomHeaders().getProperty(name));
        }
        if (!this.m_httpReadClient.getPipelineEnabled() || !this.m_config.getHTTPPipeliningEnabled() || this.m_config.getBlockingIO()) {
            this.MAX_READ_REQUESTS = 1;
        }
    }

    @Override
    public final boolean isBlocking() {
        return this.m_config.getBlockingIO();
    }

    @Override
    public void setSOTimeout(int timeout) throws EEvsIOException {
    }

    @Override
    public int getSOTimeout() throws EEvsIOException {
        return this.IDLE_TIMEOUT;
    }

    @Override
    public SelectableChannel getChannel() {
        return null;
    }

    @Override
    public SelectableChannel getServerChannel() {
        return null;
    }

    @Override
    public int getRemotePort() {
        IHTTPConnection connection = this.m_httpWriteClient.getHTTPConnection();
        if (connection != null) {
            return connection.getRemotePort();
        }
        return -1;
    }

    @Override
    public InetAddress getRemoteInetAddress() {
        IHTTPConnection connection = this.m_httpWriteClient.getHTTPConnection();
        if (connection != null) {
            return connection.getRemoteInetAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        IHTTPConnection connection = this.m_httpWriteClient.getHTTPConnection();
        if (connection != null) {
            return connection.getLocalPort();
        }
        return -1;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        IHTTPConnection connection = this.m_httpWriteClient.getHTTPConnection();
        if (connection != null) {
            return connection.getLocalInetAddress();
        }
        return null;
    }

    @Override
    public boolean connect(EvsNetworkLinkResult result) throws EEvsIOException {
        block8: while (true) {
            switch (this.m_connectState) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    throw new EEvsIOException(prAccessor.getString("Illegal State: Connection Closed"), null);
                }
                case 0: 
                case 1: {
                    if (this.m_connectRequest == null) {
                        this.m_connectRequest = this.m_httpWriteClient.createRequest();
                        this.m_connectRequest.setRequestURI(CONNECT_PATH);
                        this.addConnectHeaders(this.m_connectRequest);
                        this.m_httpWriteClient.addRequest(this.m_connectRequest);
                    }
                    this.m_connectRequest = null;
                    this.m_connectState = (byte)2;
                }
                case 2: {
                    if (this.m_connectResponse == null) {
                        this.m_connectResponse = this.m_httpWriteClient.getResponse(result);
                        if (this.m_connectResponse == null) {
                            if (DEBUG) {
                                this.debug("Unable to get connect response: " + result);
                            }
                            return false;
                        }
                    }
                    if (this.m_connectResponse.getStatusCode() != 200) {
                        if (DEBUG_UNEXPECTED) {
                            this.debug("Received invalid HTTP Connect Response: " + this.m_connectResponse);
                        }
                        if (!this.m_httpWriteClient.resetRequestQueue(false)) {
                            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Error creating HTTP Connection, bad response: {0}"), new Object[]{this.m_connectResponse.getStatusCode() + " " + this.m_connectResponse.getReasonPhrase()}));
                        }
                        this.m_connectResponse = null;
                        continue block8;
                    }
                    if (DEBUG) {
                        this.debug("Received 2XX HTTP Connect Response: " + this.m_connectResponse);
                    }
                    try {
                        this.m_httpCloseClient = HTTPClientFactory.createHTTPClient(this.m_config);
                        this.m_httpCloseClient.setResponseTimeout(this.CLOSE_TIMEOUT);
                    }
                    catch (EEvsIOException ioe) {
                        if (DEBUG_UNEXPECTED) {
                            this.debug("ERROR CREATING CLOSE CLIENT", ioe);
                        }
                        throw ioe;
                    }
                    this.m_httpCloseClient.addStandardHeader("Cache-Control", "no-cache");
                    this.m_httpCloseClient.addStandardHeader("Pragma", "no-cache");
                    this.m_httpCloseClient.addStandardHeader("Content-Type", "application/octet-stream");
                    Enumeration<Object> e = this.m_config.getHTTPCustomHeaders().keys();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        this.m_httpCloseClient.addStandardHeader(name, this.m_config.getHTTPCustomHeaders().getProperty(name));
                    }
                    this.handleConnectHeaders(this.m_connectResponse);
                    this.m_connectResponse.setHandled();
                    this.m_connectResponse = null;
                    this.m_connectState = (byte)3;
                }
                case 3: {
                    return true;
                }
            }
            break;
        }
        throw new EEvsIOException(prAccessor.getString("Illegal State in Link Connect"), null);
    }

    private final void addConnectHeaders(IHTTPMessage m) {
        m.setHeader("SonicTunnelingProtocol", "1");
        m.addHeader("SonicTunnelingParams", "client-id=java");
        m.addHeader("SonicTunnelingParams", "client-version=" + Version.getFullVersion());
        m.addHeader("SonicTunnelingParams", "max-msg-size=" + this.MAX_MESSAGE_SIZE);
        m.addHeader("SonicTunnelingParams", "pipeline-enabled=" + Boolean.toString(this.MAX_READ_REQUESTS > 1).toLowerCase());
    }

    private final void handleConnectHeaders(IHTTPResponse response) throws EEvsIOException {
        this.m_connectionId = response.getHeaderValue("ConnectionId");
        this.PEER_TUNNELING_VERSION = response.getHeaderAsInt("SonicTunnelingProtocol");
        if (this.PEER_TUNNELING_VERSION == 1) {
            Properties props = null;
            try {
                props = HTTPParseUtil.parseHeaderParams(response.getHeaderValue("SonicTunnelingParams"));
            }
            catch (Exception ex) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{"SonicTunnelingProtocol", response.getHeaderValue("SonicTunnelingProtocol")}), ex);
            }
            if (DEBUG) {
                this.debug("Got broker connection parameters: " + props);
            }
            this.IDLE_TIMEOUT = this.getIntConnectionHeaderProperty("idle-timeout", props, -1, true);
            if (this.IDLE_TIMEOUT <= 0) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{"idle-timeout", props.getProperty("idle-timeout")}));
            }
            this.KEEPALIVE_INTERVAL = response.getHeaderAsInt("SonicPingInterval");
            if (this.KEEPALIVE_INTERVAL <= 0) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{"SonicPingInterval", "" + this.KEEPALIVE_INTERVAL}));
            }
            this.MAX_MESSAGE_SIZE = this.getIntConnectionHeaderProperty("max-msg-size", props, -1, true);
            if (this.MAX_MESSAGE_SIZE <= 0) {
                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid connection parameter {0} - {1}"), new Object[]{"max-msg-size", props.getProperty("max-msg-size")}));
            }
            if (!this.getBooleanConnectionHeaderProperty("pipeline-enabled", props, false, true)) {
                this.MAX_READ_REQUESTS = 1;
            }
        } else {
            this.KEEPALIVE_INTERVAL = response.getHeaderAsInt("SonicPingInterval");
            this.IDLE_TIMEOUT = this.KEEPALIVE_INTERVAL * 2;
            this.MAX_READ_REQUESTS = 1;
            if (DEBUG_UNEXPECTED) {
                this.debug("Old tunneling version detected " + response);
            }
        }
        this.m_httpWriteClient.addStandardHeader("ConnectionId", this.m_connectionId);
        this.m_httpWriteClient.setResponseTimeout(this.IDLE_TIMEOUT);
        this.m_httpReadClient.addStandardHeader("ConnectionId", this.m_connectionId);
        this.m_httpReadClient.setResponseTimeout(this.IDLE_TIMEOUT);
        this.m_httpCloseClient.addStandardHeader("ConnectionId", this.m_connectionId);
        this.m_httpCloseClient.setResponseTimeout(this.CLOSE_TIMEOUT);
    }

    private final boolean hasClosedHeader(IHTTPMessage msg) {
        String val = msg.getHeaderValue("SonicConnection");
        return val != null && val.equalsIgnoreCase("closed");
    }

    @Override
    public IEvsNetworkLink accept(EvsNetworkLinkResult result) throws EEvsIOException {
        throw new EEvsIOException(prAccessor.getString("Accept not supported for client link"), null);
    }

    @Override
    public final void addWrite(ByteBuffer buffer, IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (buffer == null) {
            throw new NullPointerException("null write buffer");
        }
        this.m_writeContext.addWrite(buffer, listener);
    }

    @Override
    public final boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
        return this.m_writeContext.write(result);
    }

    @Override
    public long getKeepAlive() {
        return this.KEEPALIVE_INTERVAL;
    }

    @Override
    public int read(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
        return this.m_readContext.processReadState(buffer, result);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean close(EvsNetworkLinkResult result, boolean immediate) throws EEvsIOException {
        if (EvsHTTPClientNetworkLink.DEBUG || EvsHTTPClientNetworkLink.DEBUG_LIFECYCLE) {
            this.debug("In close " + Thread.currentThread() + this.m_connectState);
        }
        switch (this.m_connectState) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_connectState = (byte)4;
            }
            case 4: {
                try {
                    this.m_httpWriteClient.close(result);
                }
                catch (EEvsIOException ioe) {
                    if (!EvsHTTPClientNetworkLink.DEBUG && !EvsHTTPClientNetworkLink.DEBUG_UNEXPECTED) ** GOTO lbl14
                    this.debug("Error closing write client: " + ioe.getMessage(), ioe);
                }
lbl14:
                // 3 sources

                this.m_connectState = (byte)5;
            }
            case 5: {
                try {
                    this.m_httpReadClient.close(result);
                }
                catch (EEvsIOException ioe) {
                    if (!EvsHTTPClientNetworkLink.DEBUG && !EvsHTTPClientNetworkLink.DEBUG_UNEXPECTED) ** GOTO lbl23
                    this.debug("Error closing read client: " + ioe.getMessage(), ioe);
                }
lbl23:
                // 3 sources

                if (this.m_httpCloseClient == null) {
                    this.m_connectState = (byte)7;
                    return true;
                }
                request = this.m_httpCloseClient.createRequest();
                request.setHeader("Connection", "close");
                request.setRequestURI(EvsHTTPClientNetworkLink.CLOSE_PATH);
                this.m_httpCloseClient.addRequest(request);
                this.m_connectState = (byte)6;
            }
            case 6: {
                if (EvsHTTPClientNetworkLink.DEBUG || EvsHTTPClientNetworkLink.DEBUG_LIFECYCLE) {
                    this.debug("In close " + Thread.currentThread() + this.m_connectState);
                }
                if ((response = this.m_httpCloseClient.getResponse(result)) == null) {
                    if (!immediate) {
                        if (EvsHTTPClientNetworkLink.DEBUG || EvsHTTPClientNetworkLink.DEBUG_LIFECYCLE) {
                            this.debug("In close " + Thread.currentThread() + this.m_connectState);
                        }
                        return false;
                    }
                } else {
                    response.setHandled();
                }
                try {
                    this.m_httpCloseClient.close(result);
                }
                catch (EEvsIOException ioe) {
                    if (!EvsHTTPClientNetworkLink.DEBUG && !EvsHTTPClientNetworkLink.DEBUG_UNEXPECTED) ** GOTO lbl48
                    this.debug("Error closing close client: " + ioe.getMessage(), ioe);
                }
lbl48:
                // 3 sources

                this.m_connectState = (byte)7;
            }
            case 7: {
                return true;
            }
        }
        throw new IllegalStateException("Illegal state in close");
    }

    @Override
    public final int getRequestedHeaderReserve() {
        if (EvsHTTPNetworkLink.HTTP_HEADER_RESERVE == 0) {
            return 0;
        }
        return this.m_httpWriteClient.getRequestedHttpDataReserve();
    }

    @Override
    public final int getRequestedTrailerReserve() {
        return 0;
    }

    static /* synthetic */ IHTTPClient access$1300(EvsHTTPClientNetworkLink x0) {
        return x0.m_httpReadClient;
    }

    static /* synthetic */ int access$1400(EvsHTTPClientNetworkLink x0) {
        return x0.MAX_READ_REQUESTS;
    }

    static /* synthetic */ int access$1402(EvsHTTPClientNetworkLink x0, int x1) {
        x0.MAX_READ_REQUESTS = x1;
        return x0.MAX_READ_REQUESTS;
    }

    private final class ReadContext {
        private static final int STATE_NEW_READ = 0;
        private static final int STATE_DRAIN_EXCESS_BUFFER = 1;
        private static final int STATE_RESPONSE_WAIT = 2;
        private static final int STATE_RESPONSE_READ = 3;
        private static final int STATE_FILL_EXCESS_BUFFER = 4;
        private static final int STATE_ACK_DATA = 5;
        private int m_state = 2;
        private IHTTPResponse m_response = null;
        private int m_reqSeqNumber = 1;
        private int m_respSeqNumber = 2;
        private int m_lastRespSeqNo = 0;
        private int m_requestsOutstanding = 0;
        private int m_noResponseCount = 0;
        private int m_bytesRead = 0;
        private boolean m_continuedRead = false;
        private int m_readBufferRewindPos = 0;
        private ByteBuffer m_excessBuffer = null;
        private int m_excessBytesAlreadyRead = 0;
        private int m_readRequestCount = 1;
        private final boolean m_isBlocking;
        private boolean m_pipelineTested = false;
        private boolean m_pipelineDetect = false;
        private boolean m_pipelineCapable = false;

        private ReadContext() {
            this.m_isBlocking = EvsHTTPClientNetworkLink.this.m_config.getBlockingIO();
        }

        /*
         * Unable to fully structure code
         */
        private final int processReadState(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
            block16: while (true) {
                if (!this.m_pipelineTested && EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).getMaxPipelineLength() > 1) {
                    if (EvsHTTPClientNetworkLink.access$1400(EvsHTTPClientNetworkLink.this) <= 1) {
                        this.m_pipelineTested = true;
                        this.m_pipelineCapable = false;
                        EvsHTTPClientNetworkLink.access$1402(EvsHTTPClientNetworkLink.this, 1);
                    } else {
                        EvsHTTPClientNetworkLink.access$1402(EvsHTTPClientNetworkLink.this, Math.min(EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).getMaxPipelineLength(), EvsHTTPClientNetworkLink.access$1400(EvsHTTPClientNetworkLink.this)));
                        this.m_pipelineDetect = true;
                        this.m_readRequestCount = EvsHTTPClientNetworkLink.access$1400(EvsHTTPClientNetworkLink.this);
                    }
                }
                while (this.m_requestsOutstanding < this.m_readRequestCount) {
                    request = EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).createRequest();
                    if (this.m_pipelineDetect) {
                        request.setHeader("SonicPipelineTest", "true");
                    }
                    request.setRequestURI(EvsHTTPNetworkLink.GET_DATA_PATH);
                    request.setHeader("SequenceNumber", "" + this.m_reqSeqNumber++);
                    request.setHeader("SonicAckSeqNo", "" + this.m_lastRespSeqNo);
                    EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).addRequest(request);
                    ++this.m_requestsOutstanding;
                }
                if (this.m_pipelineDetect) {
                    this.m_pipelineTested = true;
                }
                switch (this.m_state) {
                    case 0: {
                        if (!buffer.hasRemaining()) {
                            throw new IllegalStateException("Buffer Underflow");
                        }
                        this.m_bytesRead = 0;
                        this.m_continuedRead = false;
                        this.m_state = 1;
                    }
                    case 1: {
                        if (this.m_excessBuffer != null) {
                            if (this.m_excessBuffer.remaining() > buffer.remaining()) {
                                limit = this.m_excessBuffer.limit();
                                this.m_excessBuffer.limit(this.m_excessBuffer.position() + buffer.remaining());
                                this.m_bytesRead = this.m_excessBuffer.remaining();
                                if (EvsHTTPClientNetworkLink.access$800()) {
                                    EvsHTTPClientNetworkLink.this.debug("Draining " + this.m_bytesRead + " from excess buffer");
                                }
                                buffer.put(this.m_excessBuffer);
                                this.m_excessBuffer.limit(limit);
                            } else {
                                this.m_bytesRead = this.m_excessBuffer.remaining();
                                if (EvsHTTPClientNetworkLink.access$800()) {
                                    EvsHTTPClientNetworkLink.this.debug("Completely Draining excess buffer: " + this.m_bytesRead);
                                }
                                buffer.put(this.m_excessBuffer);
                                this.m_excessBuffer = null;
                            }
                            this.m_state = 0;
                            return this.m_bytesRead;
                        }
                        this.m_state = 2;
                    }
                    case 2: {
                        this.m_response = EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).getResponse(result);
                        if (this.m_response == null) {
                            if (EvsHTTPClientNetworkLink.access$900() || EvsHTTPClientNetworkLink.access$800()) {
                                ++this.m_noResponseCount;
                                if (this.m_noResponseCount > 5) {
                                    EvsHTTPClientNetworkLink.this.debug("Still no read response available after: " + this.m_noResponseCount + " " + result);
                                }
                            }
                            if (this.m_continuedRead) {
                                this.m_state = 0;
                                return this.m_bytesRead;
                            }
                            if (this.m_isBlocking) continue block16;
                            return 0;
                        }
                        if (EvsHTTPClientNetworkLink.access$900() || EvsHTTPClientNetworkLink.access$800()) {
                            this.m_noResponseCount = 0;
                        }
                        if (EvsHTTPClientNetworkLink.access$1000(EvsHTTPClientNetworkLink.this) < 1) ** GOTO lbl83
                        seqNo = this.m_response.getHeaderAsInt("SequenceNumber");
                        if (this.m_response.getStatusCode() == 200) ** GOTO lbl75
                        if (this.m_response.getStatusCode() != 204) ** GOTO lbl83
lbl75:
                        // 2 sources

                        if (seqNo != this.m_respSeqNumber) {
                            if (EvsHTTPClientNetworkLink.access$900()) {
                                EvsHTTPClientNetworkLink.this.debug("Invalid read sequence header,  Expected: " + this.m_respSeqNumber + " from " + this.m_response);
                            }
                            if (this.m_continuedRead) {
                                this.m_state = 0;
                                return this.m_bytesRead;
                            }
                            if (EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).resetRequestQueue(false)) continue block16;
                            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Invalid read sequence header: {0}. Expected {1}"), new Object[]{this.m_response.getHeaderValue("SequenceNumber"), "" + this.m_respSeqNumber}), null);
                        }
lbl83:
                        // 4 sources

                        if (this.m_pipelineDetect && (pipeline = this.m_response.getHeaderValue("SonicPipelineTest")) != null) {
                            if (pipeline.trim().equalsIgnoreCase("true")) {
                                this.m_pipelineCapable = true;
                            } else {
                                if (EvsHTTPClientNetworkLink.access$500() || EvsHTTPClientNetworkLink.access$800()) {
                                    EvsHTTPClientNetworkLink.this.debug("Failed pipeline test!");
                                }
                                this.m_pipelineCapable = false;
                                EvsHTTPClientNetworkLink.access$1402(EvsHTTPClientNetworkLink.this, 1);
                                this.m_readRequestCount = EvsHTTPClientNetworkLink.access$1400(EvsHTTPClientNetworkLink.this);
                            }
                            this.m_pipelineDetect = false;
                        }
                        switch (this.m_response.getStatusCode()) {
                            case 200: {
                                this.m_state = 3;
                                if (!this.m_pipelineCapable || this.m_readRequestCount >= EvsHTTPClientNetworkLink.access$1400(EvsHTTPClientNetworkLink.this)) break;
                                ++this.m_readRequestCount;
                                break;
                            }
                            case 204: {
                                this.m_response.setHandled();
                                this.m_lastRespSeqNo = this.m_respSeqNumber++;
                                --this.m_requestsOutstanding;
                                if (this.m_pipelineCapable && this.m_readRequestCount > 1) {
                                    --this.m_readRequestCount;
                                }
                                this.m_state = 2;
                                continue block16;
                            }
                            default: {
                                if (EvsHTTPClientNetworkLink.access$500() || EvsHTTPClientNetworkLink.access$900()) {
                                    EvsHTTPClientNetworkLink.this.debug("Received bad response to get data request: " + this.m_response);
                                }
                                if (this.m_continuedRead) {
                                    this.m_state = 0;
                                    return this.m_bytesRead;
                                }
                                if (!EvsHTTPClientNetworkLink.access$1100(EvsHTTPClientNetworkLink.this, this.m_response) && EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).resetRequestQueue(false)) continue block16;
                                throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Bad Read response: {0} {1}"), new Object[]{"" + this.m_response.getStatusCode(), this.m_response.getReasonPhrase()}), null);
                            }
                        }
                        this.m_readBufferRewindPos = buffer.position();
                    }
                    case 3: {
                        if (!this.m_response.isFinished()) {
                            pos = buffer.position();
                            try {
                                EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).readResponseBody(buffer, result);
                                this.m_bytesRead += buffer.position() - pos;
                            }
                            catch (EEvsIOException eeioe) {
                                if (EvsHTTPClientNetworkLink.access$900()) {
                                    EvsHTTPClientNetworkLink.this.debug("IOException reading response " + this.m_bytesRead + " bytes read so far. Response: " + this.m_response, eeioe);
                                }
                                buffer.position(this.m_readBufferRewindPos);
                                this.m_state = 2;
                                if (EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).resetRequestQueue(false)) continue block16;
                                throw eeioe;
                            }
                        }
                        if (this.m_response.isFinished()) {
                            this.m_response.setHandled();
                            --this.m_requestsOutstanding;
                            this.m_lastRespSeqNo = this.m_respSeqNumber++;
                            this.m_state = 5;
                            continue block16;
                        }
                        if (buffer.hasRemaining()) {
                            if (EvsHTTPClientNetworkLink.access$500()) {
                                EvsHTTPClientNetworkLink.this.debug("Unable to finish reading response " + this.m_response.getRemainingBody() + " left in response. Read So far" + this.m_bytesRead + " " + result);
                            }
                            if (this.m_isBlocking) continue block16;
                            return 0;
                        }
                        this.m_excessBytesAlreadyRead = buffer.position() - this.m_readBufferRewindPos;
                        this.m_excessBuffer = this.m_response.getContentLength() >= 0 ? ByteBuffer.allocate(this.m_response.getContentLength() - this.m_excessBytesAlreadyRead) : ByteBuffer.allocate(EvsHTTPClientNetworkLink.access$600(EvsHTTPClientNetworkLink.this) - this.m_excessBytesAlreadyRead);
                        this.m_state = 4;
                    }
                    case 4: {
                        if (!this.m_response.isFinished()) {
                            try {
                                EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).readResponseBody(this.m_excessBuffer, result);
                            }
                            catch (EEvsIOException eeioe) {
                                if (EvsHTTPClientNetworkLink.access$900()) {
                                    EvsHTTPClientNetworkLink.this.debug("IOException reading request" + this.m_bytesRead + " bytes read so far. Response: " + this.m_response);
                                }
                                buffer.position(this.m_readBufferRewindPos);
                                this.m_excessBuffer = null;
                                this.m_state = 2;
                                if (EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).resetRequestQueue(false)) continue block16;
                                throw eeioe;
                            }
                        }
                        if (this.m_response.isFinished()) {
                            this.m_response.setHandled();
                            --this.m_requestsOutstanding;
                            this.m_lastRespSeqNo = this.m_respSeqNumber++;
                            this.m_excessBuffer.flip();
                            this.m_state = 5;
                            continue block16;
                        }
                        if (this.m_excessBuffer.hasRemaining()) {
                            if (EvsHTTPClientNetworkLink.access$500()) {
                                EvsHTTPClientNetworkLink.this.debug("Unable to finish reading response into excess buffer " + this.m_response.getRemainingBody() + " left in response. Read So far" + this.m_bytesRead + " " + result);
                            }
                            if (this.m_isBlocking) continue block16;
                            return 0;
                        }
                        capacity = this.m_excessBuffer.capacity();
                        if (EvsHTTPClientNetworkLink.access$900()) {
                            EvsHTTPClientNetworkLink.this.debug("Maximum request size exceeded: " + capacity + this.m_bytesRead + " bytes read, response: " + this.m_response);
                        }
                        buffer.position(this.m_readBufferRewindPos);
                        this.m_excessBuffer = null;
                        this.m_state = 2;
                        if (!EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).resetRequestQueue(false)) ** break;
                        continue block16;
                        throw new EEvsIOException("Maximum request size exceeded: " + capacity + this.m_bytesRead);
                    }
                    case 5: {
                        if (!EvsHTTPClientNetworkLink.access$1300(EvsHTTPClientNetworkLink.this).writeRequests(result) && EvsHTTPClientNetworkLink.access$800()) {
                            EvsHTTPClientNetworkLink.this.debug("Unable to write ack");
                        }
                        this.m_state = 0;
                        return this.m_bytesRead;
                    }
                }
                break;
            }
            throw new IllegalStateException(prMessageFormat.format(prAccessor.getString("Illegal state for HTTP client link read: {0}"), new Object[]{"" + this.m_state}));
        }
    }

    private final class WriteContext {
        private int m_writeRequestsOutstanding = 0;
        private int m_writeSeqNumber = 0;
        private boolean m_firstResponse = true;
        private final boolean m_isBlocking;

        WriteContext() {
            this.m_isBlocking = EvsHTTPClientNetworkLink.this.m_config.getBlockingIO();
        }

        private final void addWrite(ByteBuffer b, IEvsAsyncWriteListener listener) {
            if (DEBUG) {
                EvsHTTPClientNetworkLink.this.debug("Sending: " + b.remaining());
            }
            if (b.remaining() > EvsHTTPClientNetworkLink.this.MAX_MESSAGE_SIZE) {
                if (DEBUG) {
                    EvsHTTPClientNetworkLink.this.debug("Slicing buffer: " + b);
                }
                ByteBuffer dup = b.duplicate();
                dup.position(0);
                dup.limit(b.position() + EvsHTTPClientNetworkLink.this.MAX_MESSAGE_SIZE);
                int limit = b.limit();
                IHTTPRequest request = EvsHTTPClientNetworkLink.this.m_httpWriteClient.createRequest();
                request.setRequestURI(EvsHTTPNetworkLink.WRITE_DATA_PATH);
                request.setHeader("SequenceNumber", "" + this.m_writeSeqNumber++);
                ByteBuffer segment = dup.slice();
                segment.position(b.position());
                request.setBody(segment);
                request.setAttachment(null);
                EvsHTTPClientNetworkLink.this.m_httpWriteClient.addRequest(request);
                ++this.m_writeRequestsOutstanding;
                dup.position(dup.limit());
                dup.limit(limit);
                while (dup.remaining() > EvsHTTPClientNetworkLink.this.MAX_MESSAGE_SIZE) {
                    dup.limit(dup.position() + EvsHTTPClientNetworkLink.this.MAX_MESSAGE_SIZE);
                    request = EvsHTTPClientNetworkLink.this.m_httpWriteClient.createRequest();
                    request.setRequestURI(EvsHTTPNetworkLink.WRITE_DATA_PATH);
                    request.setHeader("SequenceNumber", "" + this.m_writeSeqNumber++);
                    segment = dup.slice();
                    request.setBody(segment);
                    request.setAttachment(null);
                    EvsHTTPClientNetworkLink.this.m_httpWriteClient.addRequest(request);
                    ++this.m_writeRequestsOutstanding;
                    dup.position(dup.limit());
                    dup.limit(limit);
                }
                request = EvsHTTPClientNetworkLink.this.m_httpWriteClient.createRequest();
                request.setRequestURI(EvsHTTPNetworkLink.WRITE_DATA_PATH);
                request.setHeader("SequenceNumber", "" + this.m_writeSeqNumber++);
                segment = dup.slice();
                request.setBody(segment);
                request.setAttachment(new ClientWriteInfo(b, listener));
                EvsHTTPClientNetworkLink.this.m_httpWriteClient.addRequest(request);
                ++this.m_writeRequestsOutstanding;
            } else {
                IHTTPRequest request = null;
                request = EvsHTTPClientNetworkLink.this.m_httpWriteClient.createRequest();
                request.setRequestURI(EvsHTTPNetworkLink.WRITE_DATA_PATH);
                request.setHeader("SequenceNumber", "" + this.m_writeSeqNumber++);
                request.setBody(b);
                request.setAttachment(new ClientWriteInfo(b, listener));
                EvsHTTPClientNetworkLink.this.m_httpWriteClient.addRequest(request);
                ++this.m_writeRequestsOutstanding;
            }
        }

        private final boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
            block4: while (this.m_writeRequestsOutstanding > 0) {
                IHTTPResponse response = EvsHTTPClientNetworkLink.this.m_httpWriteClient.getResponse(result);
                if (response == null) {
                    if (DEBUG && this.m_firstResponse) {
                        EvsHTTPClientNetworkLink.this.debug("Unable to read response: " + result);
                    }
                    if (!this.m_isBlocking) break;
                    continue;
                }
                if (DEBUG && this.m_firstResponse) {
                    this.m_firstResponse = false;
                    if (DEBUG_PERFORMANCE) {
                        EvsHTTPClientNetworkLink.this.debug("Got first response with a pipeline length of: " + this.m_writeRequestsOutstanding + " " + response);
                    }
                }
                switch (response.getStatusCode()) {
                    case 200: {
                        ClientWriteInfo writeInfo;
                        if (DEBUG_UNEXPECTED && EvsHTTPClientNetworkLink.this.PEER_TUNNELING_VERSION > 1 && response.getHeaderAsInt("SequenceNumber") != response.getHTTPRequest().getHeaderAsInt("SequenceNumber")) {
                            EvsHTTPClientNetworkLink.this.debug(prMessageFormat.format(prAccessor.getString("Invalid write sequence header in response: {0}. Expected {1}"), new Object[]{response.getHeaderValue("SequenceNumber"), "" + response.getHTTPRequest().getHeaderValue("SequenceNumber")}));
                        }
                        if ((writeInfo = (ClientWriteInfo)response.getHTTPRequest().getAttachment()) != null) {
                            writeInfo.listener.onAsyncWriteComplete(writeInfo.buffer);
                        }
                        response.setHandled();
                        --this.m_writeRequestsOutstanding;
                        continue block4;
                    }
                    case 204: {
                        if (DEBUG_UNEXPECTED) {
                            EvsHTTPClientNetworkLink.this.debug("Got 204 response for: " + response + ", Corresponding Request:\n" + response.getHTTPRequest());
                        }
                        EvsHTTPClientNetworkLink.this.m_httpWriteClient.resetRequestQueue(true);
                        continue block4;
                    }
                }
                if (!EvsHTTPClientNetworkLink.this.hasClosedHeader(response) && EvsHTTPClientNetworkLink.this.m_httpWriteClient.resetRequestQueue(false)) continue;
                EEvsIOException eioe = new EEvsIOException(prMessageFormat.format(prAccessor.getString("Bad HTTP Response: {0} {1}"), new Object[]{"" + response.getStatusCode(), response.getReasonPhrase()}), null);
                if (DEBUG_UNEXPECTED) {
                    EvsHTTPClientNetworkLink.this.debug("Bad HTTP Response: " + response);
                    eioe.printStackTrace();
                }
                throw eioe;
            }
            return this.m_writeRequestsOutstanding <= 0;
        }
    }

    final class ClientWriteInfo {
        final ByteBuffer buffer;
        final IEvsAsyncWriteListener listener;

        ClientWriteInfo(ByteBuffer buffer, IEvsAsyncWriteListener listener) {
            this.listener = listener;
            this.buffer = buffer;
        }
    }
}

