/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.tcp;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsAsyncWriteListener;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.evs.nio.nwlink.tcp.prAccessor;
import com.sonicsw.blackbird.evs.nio.nwlink.util.BufferSizeManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Random;

public final class EvsTCPNetworkLink
extends EvsNetworkLink {
    private final ServerSocketChannel ssc;
    private final SocketChannel sc;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_UNEXPECTED = false;
    private static final boolean DEBUG_PERFORMANCE = false;
    private static final boolean DEBUG_LIFECYCLE = false;
    private static final boolean GATHERING_WRITE_ENABLED;
    private static final boolean PREVENT_WRITE_BUFFER_OVERFLOW;
    private boolean m_enableRcvBufferResize = true;
    private int m_rcvBufferSize = 0;
    private boolean m_enableSendBufferResize = true;
    private int m_sendBufferSize = 0;
    private final WriteQueue m_writeQueue;
    private final BufferSizeManager m_sendBufMan = new BufferSizeManager(4096, 1.0E-4f, this.m_config.getSocketMaxSendBufferSize(), this.m_config.getSocketMinSendBufferSize(), this.m_config.getSocketInitialSendBufferSize(), 1);
    private final BufferSizeManager m_rcvBufMan = new BufferSizeManager(8192, 1.0E-5f, this.m_config.getSocketMaxRcvBufferSize(), this.m_config.getSocketMinRcvBufferSize(), this.m_config.getSocketInitialRcvBufferSize(), 2);

    private EvsTCPNetworkLink(int type, SelectableChannel channel, INetworkLinkConfig config) throws EEvsIOException {
        super(config);
        if (type == 0) {
            this.m_writeQueue = null;
            if (channel == null) {
                try {
                    this.ssc = ServerSocketChannel.open();
                    this.ssc.socket().setReuseAddress(true);
                }
                catch (IOException e) {
                    throw new EEvsIOException(prAccessor.getString("server channel create"), (Exception)e);
                }
                try {
                    this.ssc.socket().bind(new InetSocketAddress(this.m_config.getLocalInterfaceAddress(), this.m_config.getLocalPort()), this.m_config.getTCPServerBackLog());
                }
                catch (IOException e) {
                    throw new EEvsIOException(prAccessor.getString("server channel bind"), (Exception)e);
                }
            }
            this.ssc = (ServerSocketChannel)channel;
            try {
                this.ssc.configureBlocking(this.m_config.getBlockingIO());
            }
            catch (IOException e) {
                throw new EEvsIOException(prAccessor.getString("server channel blocking mode change"), (Exception)e);
            }
            try {
                if (this.m_config.getSocketMaxRcvBufferSize() > 0) {
                    this.ssc.socket().setReceiveBufferSize(this.m_config.getSocketMaxRcvBufferSize());
                }
            }
            catch (IOException e) {
                throw new EEvsIOException(prAccessor.getString("server channel socket properties set"), (Exception)e);
            }
            this.sc = null;
        } else if (type == 1) {
            if (channel == null) {
                try {
                    this.sc = SocketChannel.open(new InetSocketAddress(this.m_config.getRemoteInterfaceAddress(), this.m_config.getRemotePort()));
                }
                catch (IOException e) {
                    throw new EEvsIOException(prAccessor.getString("client channel create"), (Exception)e);
                }
            } else {
                this.sc = (SocketChannel)channel;
            }
            try {
                this.sc.configureBlocking(this.m_config.getBlockingIO());
            }
            catch (IOException e) {
                throw new EEvsIOException(prAccessor.getString("channel blocking mode change"), (Exception)e);
            }
            try {
                this.sc.socket().setKeepAlive(this.m_config.getTCPKeelAlive());
                this.sc.socket().setTcpNoDelay(this.m_config.getTCPNoDelay());
                this.sc.socket().setSoTimeout(this.m_config.getSocketSoTimeout());
            }
            catch (IOException e) {
                throw new EEvsIOException(prAccessor.getString("channel socket properties set"), (Exception)e);
            }
            if (this.m_config.getSocketMaxSendBufferSize() > 0) {
                if (!this.m_config.getBlockingIO() && this.m_config.getSocketMinSendBufferSize() < this.m_config.getSocketMaxSendBufferSize()) {
                    this.setSendBufferSize(this.m_sendBufMan.getBufferSize());
                } else {
                    this.setSendBufferSize(this.m_config.getSocketMaxSendBufferSize());
                    this.m_enableSendBufferResize = false;
                }
            } else {
                this.m_enableSendBufferResize = false;
            }
            if (this.m_config.getSocketMaxRcvBufferSize() > 0) {
                if (this.m_config.getSocketMinRcvBufferSize() < this.m_config.getSocketMaxRcvBufferSize()) {
                    this.setRcvBufferSize(this.m_rcvBufMan.getBufferSize());
                } else {
                    this.setRcvBufferSize(this.m_config.getSocketMaxRcvBufferSize());
                    this.m_enableRcvBufferResize = false;
                }
            } else {
                this.m_enableRcvBufferResize = false;
            }
            try {
                this.m_sendBufferSize = this.sc.socket().getSendBufferSize();
            }
            catch (SocketException se) {
                this.m_sendBufferSize = this.m_config.getSocketMaxSendBufferSize();
            }
            try {
                this.m_rcvBufferSize = this.sc.socket().getReceiveBufferSize();
            }
            catch (SocketException se) {
                this.m_rcvBufferSize = this.m_config.getSocketMaxRcvBufferSize();
            }
            this.m_writeQueue = new WriteQueue();
            this.ssc = null;
        } else {
            throw new IllegalArgumentException(prAccessor.getString("Invalid link type"));
        }
    }

    @Override
    public final boolean isBlocking() {
        return this.m_config.getBlockingIO();
    }

    @Override
    public void setSOTimeout(int timeout) throws EEvsIOException {
        if (this.sc != null) {
            try {
                this.sc.socket().setSoTimeout(timeout);
            }
            catch (SocketException e) {
                throw new EEvsIOException(e.getMessage(), (Exception)e);
            }
        }
    }

    @Override
    public int getSOTimeout() throws EEvsIOException {
        if (this.sc != null) {
            try {
                return this.sc.socket().getSoTimeout();
            }
            catch (SocketException e) {
                throw new EEvsIOException(e.getMessage(), (Exception)e);
            }
        }
        return -1;
    }

    public static IEvsNetworkLink create(int type, SelectableChannel channel, INetworkLinkConfig config) throws EEvsIOException {
        return new EvsTCPNetworkLink(type, channel, config);
    }

    @Override
    public final SelectableChannel getChannel() {
        return this.sc;
    }

    @Override
    public final SelectableChannel getServerChannel() {
        return this.ssc;
    }

    private final void setSendBufferSize(int size) {
        if (this.m_enableSendBufferResize && size != this.m_sendBufferSize) {
            try {
                this.sc.socket().setSendBufferSize(size);
                this.m_sendBufferSize = this.sc.socket().getSendBufferSize();
                if (this.m_sendBufferSize != size) {
                    this.m_enableSendBufferResize = false;
                }
            }
            catch (SocketException ex) {
                this.m_enableSendBufferResize = false;
            }
        }
    }

    private final void setRcvBufferSize(int size) {
        if (this.m_enableRcvBufferResize && size != this.m_rcvBufferSize) {
            try {
                this.sc.socket().setReceiveBufferSize(size);
                this.m_rcvBufferSize = this.sc.socket().getReceiveBufferSize();
                if (this.m_rcvBufferSize != size) {
                    this.m_enableRcvBufferResize = false;
                }
            }
            catch (SocketException ex) {
                this.m_enableRcvBufferResize = false;
            }
        }
    }

    @Override
    public boolean connect(EvsNetworkLinkResult result) throws EEvsIOException {
        if ((result.blockingOps & 8) > 0 && result.channel == this.sc) {
            return false;
        }
        if (this.sc.isConnected()) {
            result.blockingOps &= 0xFFFFFFF7;
            result.channel = this.sc;
            return true;
        }
        try {
            boolean retval;
            if (this.testMode == 2 && !this.sc.isConnectionPending() && new Random(System.currentTimeMillis()).nextInt(100) < 50) {
                this.sc.configureBlocking(true);
            }
            boolean bl = retval = !this.sc.isConnectionPending() ? this.sc.connect(new InetSocketAddress(this.m_config.getRemoteInterfaceAddress(), this.m_config.getRemotePort())) : this.sc.finishConnect();
            if (this.testMode == 2 && this.sc.isBlocking() && !this.m_config.getBlockingIO()) {
                this.sc.configureBlocking(false);
            }
            if (!retval) {
                result.blockingOps |= 8;
                result.channel = this.sc;
                return false;
            }
            result.channel = this.sc;
            result.blockingOps &= 0xFFFFFFF7;
            return true;
        }
        catch (IOException e) {
            throw new EEvsIOException(prAccessor.getString("connect") + this.m_config.getRemoteInterfaceAddress(), (Exception)e);
        }
    }

    @Override
    public int getRemotePort() {
        if (this.sc != null) {
            return this.sc.socket().getPort();
        }
        return -1;
    }

    @Override
    public InetAddress getRemoteInetAddress() {
        if (this.sc != null) {
            return this.sc.socket().getInetAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (this.sc != null) {
            return this.sc.socket().getLocalPort();
        }
        if (this.ssc != null) {
            return this.ssc.socket().getLocalPort();
        }
        return -1;
    }

    @Override
    public InetAddress getLocalInetAddress() {
        if (this.sc != null) {
            return this.sc.socket().getLocalAddress();
        }
        if (this.ssc != null) {
            return this.ssc.socket().getInetAddress();
        }
        return null;
    }

    @Override
    public final IEvsNetworkLink accept(EvsNetworkLinkResult result) throws EEvsIOException {
        try {
            SocketChannel channel = this.ssc.accept();
            if (channel != null) {
                result.blockingOps &= 0xFFFFFFEF;
                result.channel = this.ssc;
                return new EvsTCPNetworkLink(1, channel, this.m_config);
            }
            result.blockingOps |= 0x10;
            result.channel = this.ssc;
            return null;
        }
        catch (IOException e) {
            throw new EEvsIOException(prAccessor.getString("accept"), (Exception)e);
        }
    }

    @Override
    public final int read(ByteBuffer buffer, EvsNetworkLinkResult result) throws EEvsIOException {
        if ((result.blockingOps & 1) > 0 && result.channel == this.sc) {
            return 0;
        }
        int available = buffer.remaining();
        try {
            int read = this.sc.read(buffer);
            if (read == 0) {
                result.blockingOps |= 1;
                result.channel = this.sc;
            } else {
                result.blockingOps &= 0xFFFFFFFE;
                result.channel = this.sc;
            }
            if (this.m_enableRcvBufferResize && available >= this.m_rcvBufMan.getBufferSize()) {
                this.m_rcvBufMan.updateDataSize(read);
                this.setRcvBufferSize(this.m_rcvBufMan.getBufferSize());
            }
            return read;
        }
        catch (IOException e) {
            throw new EEvsIOException(prAccessor.getString("read"), (Exception)e);
        }
    }

    @Override
    public final void addWrite(ByteBuffer buffer, IEvsAsyncWriteListener listener) throws EEvsIOException {
        if (buffer == null) {
            throw new NullPointerException("null write buffer");
        }
        this.m_writeQueue.addWrite(buffer, listener);
    }

    @Override
    public final boolean write(EvsNetworkLinkResult result) throws EEvsIOException {
        if ((result.blockingOps & 4) > 0 && result.channel == this.sc) {
            return this.m_writeQueue.m_bufferCount == 0;
        }
        int written = 0;
        if (this.m_writeQueue.m_bufferCount == 0) {
            result.blockingOps &= 0xFFFFFFFB;
            result.channel = this.sc;
            return true;
        }
        if (this.m_enableSendBufferResize) {
            int targetSize = this.m_writeQueue.getMemorySize();
            if (PREVENT_WRITE_BUFFER_OVERFLOW) {
                ++targetSize;
            }
            this.m_sendBufMan.updateDataSize(targetSize);
            this.setSendBufferSize(this.m_sendBufMan.getBufferSize());
        }
        if (GATHERING_WRITE_ENABLED && this.m_writeQueue.m_bufferCount > 1) {
            if (PREVENT_WRITE_BUFFER_OVERFLOW && this.m_writeQueue.getMemorySize() >= this.m_sendBufferSize) {
                while (this.m_writeQueue.m_bufferCount > 0) {
                    block31: {
                        ByteBuffer[] bufs = this.m_writeQueue.getBufferArray();
                        int bufferLimit = 0;
                        int remainingSpace = this.m_sendBufferSize - 1;
                        int lastBufferLimit = 0;
                        int i = 0;
                        while (i < bufs.length) {
                            bufferLimit = i++;
                            ByteBuffer b = bufs[bufferLimit];
                            lastBufferLimit = b.limit();
                            if (b.remaining() > remainingSpace) {
                                b.limit(b.position() + remainingSpace);
                                break;
                            }
                            remainingSpace -= b.remaining();
                        }
                        try {
                            written = (int)((long)written + this.sc.write(bufs, 0, bufferLimit + 1));
                            if (!bufs[bufferLimit].hasRemaining()) break block31;
                            this.m_writeQueue.removeCompletedOps();
                            break;
                        }
                        catch (IOException ioe) {
                            throw new EEvsIOException(prAccessor.getString("write"), (Exception)ioe);
                        }
                        finally {
                            bufs[bufferLimit].limit(lastBufferLimit);
                        }
                    }
                    this.m_writeQueue.removeCompletedOps();
                }
            } else {
                try {
                    written = (int)((long)written + this.sc.write(this.m_writeQueue.getBufferArray()));
                }
                catch (IOException ioe) {
                    throw new EEvsIOException(prAccessor.getString("write"), (Exception)ioe);
                }
                this.m_writeQueue.removeCompletedOps();
            }
        } else {
            while (this.m_writeQueue.m_bufferCount > 0) {
                ByteBuffer b = this.m_writeQueue.m_head.buffer;
                if (PREVENT_WRITE_BUFFER_OVERFLOW && b.remaining() >= this.m_sendBufferSize) {
                    int limit = b.limit();
                    while (b.hasRemaining()) {
                        int newLimit = Math.min(limit, b.position() + (this.m_sendBufferSize - 1));
                        b.limit(newLimit);
                        try {
                            written += this.sc.write(b);
                            if (b.remaining() <= 0) continue;
                            break;
                        }
                        catch (IOException ioe) {
                            throw new EEvsIOException(prAccessor.getString("write"), (Exception)ioe);
                        }
                        finally {
                            b.limit(limit);
                        }
                    }
                } else {
                    try {
                        this.sc.write(b);
                    }
                    catch (IOException ioe) {
                        throw new EEvsIOException(prAccessor.getString("write"), (Exception)ioe);
                    }
                }
                if (b.remaining() <= 0) {
                    this.m_writeQueue.removeCompletedOps();
                    continue;
                }
                break;
            }
        }
        if (this.m_writeQueue.m_bufferCount == 0) {
            result.blockingOps &= 0xFFFFFFFB;
            result.channel = this.sc;
            return true;
        }
        result.blockingOps |= 4;
        result.channel = this.sc;
        return false;
    }

    @Override
    public long getKeepAlive() {
        return 0L;
    }

    @Override
    public final boolean close(EvsNetworkLinkResult result, boolean immediate) throws EEvsIOException {
        block13: {
            try {
                if (this.ssc != null) {
                    this.ssc.socket().close();
                }
                if (this.sc == null) break block13;
                if (this.sc.isConnected()) {
                    try {
                        if (this.m_config.getTCPLinger()) {
                            this.sc.socket().setSoLinger(true, this.m_config.getTCPLingerTime());
                        } else {
                            this.sc.socket().setSoLinger(false, 0);
                        }
                    }
                    catch (SocketException se) {
                        // empty catch block
                    }
                    try {
                        this.sc.socket().shutdownOutput();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this.sc.socket().shutdownInput();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.sc.socket().close();
            }
            catch (ClosedChannelException cce) {
            }
            catch (IOException ioe) {
                throw new EEvsIOException(prAccessor.getString("close"), (Exception)ioe);
            }
        }
        return true;
    }

    @Override
    public final int getRequestedHeaderReserve() {
        return 0;
    }

    @Override
    public final int getRequestedTrailerReserve() {
        return 0;
    }

    private static final void debug(String str, Throwable thrown) {
        if (thrown != null) {
            System.out.println("EvsTCPNetworkLink: " + str + " Related Exception: " + thrown.getMessage());
            thrown.printStackTrace();
        } else {
            System.out.println("EvsTCPNetworkLink: " + str);
        }
    }

    private static final void debug(String str) {
        EvsTCPNetworkLink.debug(str, null);
    }

    static {
        String jVersion = System.getProperty("java.version");
        GATHERING_WRITE_ENABLED = false;
        String os = System.getProperty("os.name");
        PREVENT_WRITE_BUFFER_OVERFLOW = os.toLowerCase().indexOf("windows") >= 0;
    }

    public final class WriteQueue {
        WriteOperation m_tail;
        WriteOperation m_head;
        int m_bufferCount = 0;
        int m_memorySize = 0;

        public final int getMemorySize() {
            if (this.m_bufferCount == 0) {
                return 0;
            }
            return this.m_memorySize - (this.m_head.size - this.m_head.buffer.remaining());
        }

        public final void addWrite(ByteBuffer buffer, IEvsAsyncWriteListener listener) {
            WriteOperation op = new WriteOperation(buffer, listener);
            if (this.m_tail != null) {
                this.m_tail.next = op;
                this.m_tail = op;
            } else {
                this.m_tail = this.m_head = op;
            }
            ++this.m_bufferCount;
            this.m_memorySize += op.size;
        }

        public final void removeCompletedOps() {
            while (this.m_head != null) {
                if (this.m_head.buffer.hasRemaining()) {
                    return;
                }
                WriteOperation op = this.removeFirst();
                if (op.listener == null) continue;
                op.listener.onAsyncWriteComplete(op.buffer);
            }
        }

        public final WriteOperation removeFirst() {
            if (this.m_head != null) {
                WriteOperation ret = this.m_head;
                --this.m_bufferCount;
                this.m_memorySize -= ret.size;
                if (this.m_head.next != null) {
                    this.m_head = this.m_head.next;
                } else {
                    this.m_tail = null;
                    this.m_head = null;
                }
                return ret;
            }
            return null;
        }

        public final ByteBuffer[] getBufferArray() {
            ByteBuffer[] array = new ByteBuffer[this.m_bufferCount];
            WriteOperation op = this.m_head;
            for (int i = 0; i < this.m_bufferCount; ++i) {
                array[i] = op.buffer;
                op = op.next;
            }
            return array;
        }

        public final void clear() {
            while (this.m_head != null) {
                this.removeFirst();
            }
        }

        public final String toString() {
            return "WS- Pending Buffers: " + this.m_bufferCount + ", Memory: " + this.m_memorySize;
        }
    }

    public final class WriteOperation {
        public WriteOperation next = null;
        public final ByteBuffer buffer;
        public final IEvsAsyncWriteListener listener;
        public final int size;

        public WriteOperation(ByteBuffer b, IEvsAsyncWriteListener listener) {
            this.buffer = b;
            this.listener = listener;
            this.size = b.remaining();
        }
    }
}

