/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl.client.auth;

import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.IHTTPAuthenticator;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.HTTPParseUtil;
import com.sonicsw.blackbird.http.impl.client.auth.RFC2617Authenticator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.StringTokenizer;

public class DigestAuthenticator
extends RFC2617Authenticator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_UNEXPECTED = HTTPConstants.DEBUG_UNEXPECTED;
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final String NC = "00000001";
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private int qopVariant = 0;
    private String cnonce;
    private String m_currentAuthString = null;
    private String m_currentPath = null;
    private String m_currentMethod = null;
    private String m_currentQuery = null;

    @Override
    public final IHTTPAuthenticator createNew() {
        return new DigestAuthenticator();
    }

    @Override
    public void processChallenge(Map challenge) throws HTTPAuthenticationException {
        super.processChallenge(challenge);
        this.m_currentAuthString = null;
        if (this.getParameter("realm") == null) {
            throw new HTTPAuthenticationException("missing realm in challange");
        }
        if (this.getParameter("nonce") == null) {
            throw new HTTPAuthenticationException("missing nonce in challange");
        }
        boolean unsupportedQop = false;
        String qop = this.getParameter("qop");
        if (qop != null) {
            StringTokenizer tok = new StringTokenizer(qop, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                if ("auth".equals(variant)) {
                    this.qopVariant = 2;
                    break;
                }
                if ("auth-int".equals(variant)) {
                    this.qopVariant = 1;
                    continue;
                }
                unsupportedQop = true;
                if (!DEBUG_UNEXPECTED) continue;
                DigestAuthenticator.debug("Unsupported qop detected: " + variant);
            }
        }
        if (unsupportedQop && this.qopVariant == 0) {
            throw new HTTPAuthenticationException("None of the qop methods is supported");
        }
        this.cnonce = DigestAuthenticator.createCnonce();
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        String s = this.getParameter("stale");
        if ("true".equalsIgnoreCase(s)) {
            return false;
        }
        return this.complete;
    }

    @Override
    public String getSchemeName() {
        return "digest";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String authenticate(IHTTPRequest request) throws HTTPAuthenticationException {
        if (this.m_credentials == null) {
            throw new HTTPAuthenticationException("Missing credentials for Digest authentication");
        }
        String method = request.getMethod();
        String path = request.getRequestURI().getPath();
        String query = request.getRequestURI().getQuery();
        if (this.m_currentAuthString != null && method.equals(this.m_currentMethod) && path.equals(this.m_currentPath) && (this.m_currentQuery == null ? query == null : this.m_currentQuery.equals(query))) {
            return this.m_currentAuthString;
        }
        this.getParameters().put("methodname", method);
        StringBuffer buffer = new StringBuffer(path);
        if (query != null) {
            if (query.indexOf("?") != 0) {
                buffer.append("?");
            }
            buffer.append(request.getRequestURI().getQuery());
        }
        this.getParameters().put("uri", buffer.toString());
        String charset = this.getParameter("charset");
        if (charset == null) {
            this.getParameters().put("charset", this.m_credentials.getCredentialsCharset());
        }
        String digest = this.createDigest(this.m_credentials.getUsername(), this.m_credentials.getPassword());
        this.m_currentAuthString = "Digest " + this.createDigestHeader(this.m_credentials.getUsername(), digest);
        this.m_currentMethod = method;
        this.m_currentPath = path;
        this.m_currentQuery = query;
        return this.m_currentAuthString;
    }

    private String createDigest(String uname, String pwd) throws HTTPAuthenticationException {
        String serverDigestValue;
        String charset;
        String digAlg = "MD5";
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String qop = this.getParameter("qop");
        String method = this.getParameter("methodname");
        String algorithm = this.getParameter("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((charset = this.getParameter("charset")) == null) {
            charset = "ISO-8859-1";
        }
        if (this.qopVariant == 1) {
            if (DEBUG_UNEXPECTED) {
                DigestAuthenticator.debug("qop=auth-int is not supported");
            }
            throw new HTTPAuthenticationException("Unsupported qop in HTTP Digest authentication");
        }
        MessageDigest md5Helper = DigestAuthenticator.getDigest("MD5");
        StringBuffer tmp = new StringBuffer(uname.length() + realm.length() + pwd.length() + 2);
        tmp.append(uname);
        tmp.append(':');
        tmp.append(realm);
        tmp.append(':');
        tmp.append(pwd);
        String a1 = tmp.toString();
        if ("MD5-sess".equals(algorithm)) {
            String tmp2 = DigestAuthenticator.encode(md5Helper.digest(HTTPParseUtil.encodeString(a1, charset)));
            StringBuffer tmp3 = new StringBuffer(tmp2.length() + nonce.length() + this.cnonce.length() + 2);
            tmp3.append(tmp2);
            tmp3.append(':');
            tmp3.append(nonce);
            tmp3.append(':');
            tmp3.append(this.cnonce);
            a1 = tmp3.toString();
        } else if (!"MD5".equals(algorithm) && DEBUG_UNEXPECTED) {
            DigestAuthenticator.debug("Unhandled algorithm " + algorithm + " requested");
        }
        String md5a1 = DigestAuthenticator.encode(md5Helper.digest(HTTPParseUtil.encodeString(a1, charset)));
        String a2 = null;
        if (this.qopVariant == 1) {
            if (DEBUG_UNEXPECTED) {
                DigestAuthenticator.debug("Unhandled qop auth-int");
            }
            throw new HTTPAuthenticationException("Unsupported qop auth-int");
        }
        a2 = method + ":" + uri;
        String md5a2 = DigestAuthenticator.encode(md5Helper.digest(HTTPParseUtil.getAsciiBytes(a2)));
        if (this.qopVariant == 0) {
            StringBuffer tmp2 = new StringBuffer(md5a1.length() + nonce.length() + md5a2.length());
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(md5a2);
            serverDigestValue = tmp2.toString();
        } else {
            String qopOption = this.getQopVariantString();
            StringBuffer tmp2 = new StringBuffer(md5a1.length() + nonce.length() + NC.length() + this.cnonce.length() + qopOption.length() + md5a2.length() + 5);
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(NC);
            tmp2.append(':');
            tmp2.append(this.cnonce);
            tmp2.append(':');
            tmp2.append(qopOption);
            tmp2.append(':');
            tmp2.append(md5a2);
            serverDigestValue = tmp2.toString();
        }
        String serverDigest = DigestAuthenticator.encode(md5Helper.digest(HTTPParseUtil.getAsciiBytes(serverDigestValue)));
        return serverDigest;
    }

    private String createDigestHeader(String uname, String digest) throws HTTPAuthenticationException {
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String opaque = this.getParameter("opaque");
        String response = digest;
        String algorithm = this.getParameter("algorithm");
        StringBuffer buf = new StringBuffer();
        HTTPParseUtil.appendParamValPair(buf, "username", uname, true, false);
        HTTPParseUtil.appendParamValPair(buf, "realm", realm, true, true);
        HTTPParseUtil.appendParamValPair(buf, "nonce", nonce, true, true);
        HTTPParseUtil.appendParamValPair(buf, "uri", uri, true, true);
        HTTPParseUtil.appendParamValPair(buf, "response", response, true, true);
        if (this.qopVariant != 0) {
            HTTPParseUtil.appendParamValPair(buf, "qop", this.getQopVariantString(), false, true);
            HTTPParseUtil.appendParamValPair(buf, "nc", NC, false, true);
            HTTPParseUtil.appendParamValPair(buf, "cnonce", this.cnonce, true, true);
        }
        if (algorithm != null) {
            HTTPParseUtil.appendParamValPair(buf, "algorithm", algorithm, true, true);
        }
        if (opaque != null) {
            HTTPParseUtil.appendParamValPair(buf, "opaque", opaque, true, true);
        }
        return buf.toString();
    }

    private String getQopVariantString() {
        String qopOption = this.qopVariant == 1 ? "auth-int" : "auth";
        return qopOption;
    }

    private static String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    public static String createCnonce() throws HTTPAuthenticationException {
        String digAlg = "MD5";
        MessageDigest md5Helper = DigestAuthenticator.getDigest("MD5");
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = DigestAuthenticator.encode(md5Helper.digest(HTTPParseUtil.getAsciiBytes(cnonce)));
        return cnonce;
    }

    private static final MessageDigest getDigest(String alg) throws HTTPAuthenticationException {
        NoSuchAlgorithmException nsae = null;
        for (int i = 1; i <= 3; ++i) {
            try {
                return MessageDigest.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                nsae = e;
                continue;
            }
        }
        throw new HTTPAuthenticationException("Unsupported algorithm in HTTP Digest authentication: " + alg, (Exception)nsae);
    }

    private static final void debug(String debug) {
        System.out.println("DigestAuthenticator: " + debug);
    }
}

