/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import progress.message.net.ssl.CRLCachePolicy;

public class AddNewCRLCachePolicyChangeHandler
implements IAttributeChangeHandler {
    private static volatile IComponentContext s_context = null;
    private static volatile ConfigurationChangeBindHelper s_bindHelper = null;

    public static void init(IComponentContext context) {
        s_context = context;
    }

    public AddNewCRLCachePolicyChangeHandler(ConfigurationChangeBindHelper bindHelper) {
        s_bindHelper = bindHelper;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newPolicies = delta.getNewAttributesNames();
        for (int i = 0; i < newPolicies.length; ++i) {
            String name = newPolicies[i];
            try {
                IAttributeSet ca = (IAttributeSet)delta.getNewValue(name);
                String dn = (String)ca.getAttribute("LDAP_DN");
                long refreshInterval = 86400L;
                Long interval = (Long)ca.getAttribute("PERIODIC_CACHE_REFRESH_TIME");
                if (interval != null) {
                    refreshInterval = interval;
                }
                long cacheLifeTime = -1L;
                Long lifetime = (Long)ca.getAttribute("MAX_CACHE_LIFETIME");
                if (lifetime != null) {
                    cacheLifeTime = lifetime;
                }
                CRLCachePolicy policy = CRLCachePolicy.addPolicy(null, dn, refreshInterval, cacheLifeTime);
                s_bindHelper.bindCRLCachePolicyChangeHandler(policy, ca);
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
    }
}

