/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.IBrokerAcceptorChangeHandlerDelegateFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class BrokerAcceptorChangeDelegator
implements IAttributeChangeHandler {
    private String m_bname;
    private IElement m_primarybce;
    private IComponentContext m_context = null;
    private BindAssistant m_assistant = null;
    private IBrokerAcceptorChangeHandlerDelegateFactory m_delegatesFactory = null;
    private List m_delegates = null;

    public BrokerAcceptorChangeDelegator(IBrokerAcceptorChangeHandlerDelegateFactory delegatesFactory, IComponentContext context, IElement primarybce, String bname) {
        this.m_delegatesFactory = delegatesFactory;
        this.m_context = context;
        this.m_primarybce = primarybce;
        this.m_bname = bname;
        this.m_assistant = new BindAssistant();
        this.m_delegates = this.m_delegatesFactory.createBrokerReferencesChangeHandlerDelegates(this.m_context, this.m_primarybce, this.m_bname);
        this.bindPrimaryAcceptorChangeListener();
        this.bindBackupAcceptorChangeListener();
    }

    public static void init() {
    }

    public void itemDeleted() {
        for (IAttributeChangeHandler delegate : this.m_delegates) {
            delegate.itemDeleted();
        }
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                this.attributeAdded(newAttributes[i], delta.getNewValue(newAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            try {
                this.attributeModified(modifiedAttributes[i], delta.getNewValue(modifiedAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            this.attributeDeleted(deletedAttributes[i], null);
        }
        for (IAttributeChangeHandler delegate : this.m_delegates) {
            delegate.itemModified(newValue);
        }
    }

    private void attributeAdded(String attribute, Object value) {
        if (attribute.equals("BACKUP_CONFIG_ELEMENT_REF")) {
            this.bindBackupAcceptorChangeListener();
        }
    }

    private void attributeModified(String attribute, Object value) {
    }

    private void attributeDeleted(String attribute, Object value) {
        if (attribute.equals("BACKUP_CONFIG_ELEMENT_REF")) {
            this.m_assistant.unregisterBackup();
        }
    }

    public void prepareToUnbind() {
        if (!this.m_bname.equals(this.getMyBrokerName())) {
            this.ungetConfiguration(this.m_primarybce.getIdentity().getName());
        }
        this.m_assistant.unregisterAll();
    }

    private void bindPrimaryAcceptorChangeListener() {
        IAttributeSet primarybuas = this.m_primarybce.getAttributes();
        IAttributeSet primarycers = (IAttributeSet)primarybuas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)primarycers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        this.bindAcceptorChangeListener(true, aref);
    }

    private void bindBackupAcceptorChangeListener() {
        IAttributeSet primarybuas = this.m_primarybce.getAttributes();
        IAttributeSet primarycers = (IAttributeSet)primarybuas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference bkref = (Reference)primarycers.getAttribute("BACKUP_CONFIG_ELEMENT_REF");
        if (bkref == null) {
            return;
        }
        String bkCID = bkref.getElementName();
        IElement bkce = this.m_context.getConfiguration(bkCID, false);
        IAttributeSet bkdas = bkce.getAttributes();
        IAttributeSet bkcers = (IAttributeSet)bkdas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference aref = (Reference)bkcers.getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        this.bindAcceptorChangeListener(false, aref);
    }

    private void bindAcceptorChangeListener(boolean primary, Reference aref) {
        this.bindAcceptorsHandler(primary, aref);
        String aCID = aref.getElementName();
        boolean needsUpdate = true;
        IElement ace = this.m_context.getConfiguration(aCID, needsUpdate);
        AttributeName an = new AttributeName("ACCEPTORS");
        IAttributeSet alas = (IAttributeSet)ace.getAttribute(an);
        for (Reference ref : alas.getAttributes().values()) {
            this.bindHandler(primary, ref);
        }
    }

    private void bindAcceptorsHandler(boolean primary, Reference ref) {
        if (ref == null) {
            return;
        }
        boolean needsUpdate = true;
        IElement i1 = this.m_context.getConfiguration(ref.getElementName(), needsUpdate);
        IAttributeSet aset = i1.getAttributes();
        AcceptorsChangeDelegator h = new AcceptorsChangeDelegator(primary, ref.getElementName());
        this.m_assistant.register(primary, ref.getElementName(), aset, h);
    }

    private void bindHandler(boolean primary, Reference ref) {
        if (ref == null) {
            return;
        }
        boolean needsUpdate = true;
        IElement i1 = this.m_context.getConfiguration(ref.getElementName(), needsUpdate);
        IAttributeSet aset = i1.getAttributes();
        AcceptorChangeDelegator h = new AcceptorChangeDelegator(primary, ref.getElementName());
        this.m_assistant.register(primary, ref.getElementName(), aset, h);
    }

    private void ungetConfiguration(String nm) {
    }

    private String deltaSummary(IDeltaAttributeSet das) {
        int i;
        String[] a = das.getModifiedAttributesNames();
        StringBuffer sb = new StringBuffer("");
        for (i = 0; i < a.length; ++i) {
            try {
                sb.append((i > 0 ? "," : "MODIFIED:") + a[i] + "=" + das.getNewValue(a[i]));
                continue;
            }
            catch (NotModifiedAttException nme) {
                // empty catch block
            }
        }
        a = das.getNewAttributesNames();
        for (i = 0; i < a.length; ++i) {
            try {
                sb.append((i > 0 ? "," : (sb.length() > 0 ? "\n" : "") + "NEW:") + a[i] + "=" + das.getNewValue(a[i]));
                continue;
            }
            catch (NotModifiedAttException nme) {
                // empty catch block
            }
        }
        a = das.getDeletedAttributesNames();
        for (i = 0; i < a.length; ++i) {
            sb.append((i > 0 ? "," : (sb.length() > 0 ? "\n" : "") + "DELETED:") + a[i]);
        }
        return sb.toString();
    }

    private String getMyBrokerName() {
        return BrokerComponent.getBrokerComponent().getBrokerName();
    }

    class AcceptorChangeDelegator
    implements IAttributeChangeHandler {
        private boolean m_primary = false;
        private String m_configElemName = "";
        private List m_delegates = null;

        AcceptorChangeDelegator(boolean primary, String configElemName) {
            this.m_primary = primary;
            this.m_configElemName = configElemName;
            this.m_delegates = BrokerAcceptorChangeDelegator.this.m_delegatesFactory.createAcceptorChangeHandlerDelegates(BrokerAcceptorChangeDelegator.this.m_context, BrokerAcceptorChangeDelegator.this.m_primarybce, BrokerAcceptorChangeDelegator.this.m_bname, this.m_primary, this.m_configElemName);
        }

        public void itemDeleted() {
            for (IAttributeChangeHandler delegate : this.m_delegates) {
                delegate.itemDeleted();
            }
        }

        public void itemModified(Object newValue) {
            for (IAttributeChangeHandler delegate : this.m_delegates) {
                delegate.itemModified(newValue);
            }
        }

        public String toString() {
            return "AcceptorChangeDelegator(" + (this.m_primary ? "on primary, " : "on backup ") + this.m_configElemName + ")";
        }
    }

    class AcceptorsChangeDelegator
    implements IAttributeChangeHandler {
        private boolean m_primary = false;
        private String m_configElemName = "";
        private List m_delegates = null;

        AcceptorsChangeDelegator(boolean primary, String configElemName) {
            this.m_primary = primary;
            this.m_configElemName = configElemName;
            this.m_delegates = BrokerAcceptorChangeDelegator.this.m_delegatesFactory.createAcceptorsChangeHandlerDelegates(BrokerAcceptorChangeDelegator.this.m_context, BrokerAcceptorChangeDelegator.this.m_primarybce, BrokerAcceptorChangeDelegator.this.m_bname, this.m_primary, this.m_configElemName);
        }

        public void itemDeleted() {
            for (IAttributeChangeHandler delegate : this.m_delegates) {
                delegate.itemDeleted();
            }
        }

        public void itemModified(Object newValue) {
            IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
            String[] a = das.getModifiedAttributesNames();
            for (int i = 0; i < a.length; ++i) {
                if (!a[i].equals("ACCEPTORS")) continue;
                IElement element = BrokerAcceptorChangeDelegator.this.m_context.getConfiguration(this.m_configElemName, true);
                IAttributeSet as = (IAttributeSet)element.getAttributes().getAttribute("ACCEPTORS");
                this.processModifiedAcceptorSet(as);
            }
            for (IAttributeChangeHandler delegate : this.m_delegates) {
                delegate.itemModified(newValue);
            }
        }

        private void processModifiedAcceptorSet(IAttributeSet alas) {
            Vector v = BrokerAcceptorChangeDelegator.this.m_assistant.listNamedAcceptors(this.m_primary);
            for (Reference ref : alas.getAttributes().values()) {
                if (!v.contains(ref.getElementName())) {
                    BrokerAcceptorChangeDelegator.this.bindHandler(this.m_primary, ref);
                }
                v.remove(ref.getElementName());
            }
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                BrokerAcceptorChangeDelegator.this.m_assistant.unregisterAcceptor(this.m_primary, (String)e.nextElement());
            }
        }

        public String toString() {
            return "AcceptorsChangeDelegator(" + this.m_configElemName + ")";
        }
    }

    class BindAssistant {
        private static final short TYPE_PRIMARY_SET = 0;
        private static final short TYPE_BACKUP_SET = 1;
        private static final short TYPE_MAX_SETS = 2;
        private static final short CAT_MAIN_ATTRIBUTES = 0;
        private static final short CAT_REFERENCED_ACCEPTORS_ATTRIBUTES = 1;
        private static final short MAX_CATS = 2;
        private Hashtable[][] _configElems;
        private Hashtable[][] _asets = new Hashtable[2][2];

        BindAssistant() {
            this._configElems = new Hashtable[2][2];
            for (int typ = 0; typ < 2; ++typ) {
                for (int cat = 0; cat < 2; ++cat) {
                    this._asets[typ][cat] = new Hashtable();
                    this._configElems[typ][cat] = new Hashtable();
                }
            }
        }

        void register(boolean primary, String configElemName, IAttributeSet as, AcceptorsChangeDelegator l) {
            as.registerAttributeChangeHandler((Object)BrokerAcceptorChangeDelegator.this.m_context, (IAttributeChangeHandler)l);
            int typ = primary ? 0 : 1;
            this._asets[typ][0].put(as, l);
            this._configElems[typ][0].put(configElemName, as);
        }

        void register(boolean primary, String configElemName, IAttributeSet as, AcceptorChangeDelegator l) {
            as.registerAttributeChangeHandler((Object)BrokerAcceptorChangeDelegator.this.m_context, (IAttributeChangeHandler)l);
            int typ = primary ? 0 : 1;
            this._asets[typ][1].put(as, l);
            this._configElems[typ][1].put(configElemName, as);
        }

        Vector listNamedAcceptors(boolean primary) {
            Vector v = new Vector();
            int typ = primary ? 0 : 1;
            Enumeration e = this._configElems[typ][1].keys();
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
            return v;
        }

        void unregisterAll() {
            for (short typ = 0; typ < 2; typ = (short)(typ + 1)) {
                for (short cat = 0; cat < 2; cat = (short)(cat + 1)) {
                    this.unregisterAcceptorChangeListeners(typ, cat);
                }
            }
        }

        void unregisterBackup() {
            for (short cat = 0; cat < 2; cat = (short)(cat + 1)) {
                this.unregisterAcceptorChangeListeners((short)1, cat);
            }
        }

        void unregisterAcceptor(boolean primary, String configElemRef) {
            int typ = primary ? 0 : 1;
            Hashtable nmToAset = this._configElems[typ][1];
            Hashtable asetToHandler = this._asets[typ][1];
            IAttributeSet aset = (IAttributeSet)nmToAset.get(configElemRef);
            if (aset == null) {
                return;
            }
            aset.unregisterAttributeChangeHandler((Object)BrokerAcceptorChangeDelegator.this.m_context);
            if (!BrokerAcceptorChangeDelegator.this.m_bname.equals(BrokerAcceptorChangeDelegator.this.getMyBrokerName())) {
                BrokerAcceptorChangeDelegator.this.ungetConfiguration(configElemRef);
            }
            nmToAset.remove(configElemRef);
            asetToHandler.remove(aset);
        }

        private void unregisterAcceptorChangeListeners(short typ, short cat) {
            Hashtable nmToAset = this._configElems[typ][cat];
            Hashtable asetToHandler = this._asets[typ][cat];
            Enumeration e = nmToAset.keys();
            while (e.hasMoreElements()) {
                String nm = (String)e.nextElement();
                IAttributeSet aset = (IAttributeSet)nmToAset.get(nm);
                if (aset != null) {
                    aset.unregisterAttributeChangeHandler((Object)BrokerAcceptorChangeDelegator.this.m_context);
                }
                if (BrokerAcceptorChangeDelegator.this.m_bname.equals(BrokerAcceptorChangeDelegator.this.getMyBrokerName())) continue;
                BrokerAcceptorChangeDelegator.this.ungetConfiguration(nm);
            }
            nmToAset.clear();
            asetToHandler.clear();
        }
    }
}

