/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import java.io.IOException;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Broker;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPSAcceptor;
import progress.message.net.ESocketConfigException;

public class BrokerAcceptorChangeHandler
implements IAttributeChangeHandler {
    private String m_configElementName = "";
    private String m_bname;
    private IElement m_primarybce;
    private IComponentContext m_context = null;

    BrokerAcceptorChangeHandler(IComponentContext context, IElement primarybce, String bname, boolean primary, String configElementName) {
        this.m_context = context;
        this.m_primarybce = primarybce;
        this.m_bname = bname;
        this.m_configElementName = configElementName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemDeleted() {
        AcceptorHolder holder;
        AcceptorHolder acceptorHolder = holder = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            Broker broker;
            Acceptor acceptor = holder.getAcceptor(this.m_configElementName);
            if (acceptor == null) {
                return;
            }
            if (acceptor instanceof HTTPAcceptor || acceptor instanceof HTTPSAcceptor) {
                // empty if block
            }
            if ((broker = Broker.getBroker()) != null && broker.getState() == 3) {
                acceptor.stopAcceptor();
            }
            holder.removeAcceptor(this.m_configElementName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemModified(Object newValue) {
        AcceptorHolder holder;
        AcceptorHolder acceptorHolder = holder = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            Acceptor acceptor = holder.getAcceptor(this.m_configElementName);
            if (acceptor == null) {
                return;
            }
            if (acceptor instanceof HTTPAcceptor || acceptor instanceof HTTPSAcceptor) {
                return;
            }
            Broker broker = Broker.getBroker();
            if (acceptor != null) {
                if (broker != null && broker.getState() == 3) {
                    this.m_context.logMessage(acceptor.getAcceptorName() + ": reconfiguring acceptor", 3);
                    acceptor.stopAcceptor();
                }
                holder.removeAcceptor(this.m_configElementName);
            }
            try {
                acceptor = ConfigPropertiesPopulator.newAcceptor(this.m_context, holder, this.m_configElementName, this.m_primarybce);
            }
            catch (ESocketConfigException e) {
                this.m_context.logMessage("Acceptor reconfiguration failure, trace follows...", (Throwable)e, 2);
            }
            try {
                if (broker != null) {
                    broker.initAcceptor(acceptor);
                }
            }
            catch (IOException e) {
                this.m_context.logMessage("Failed to reinitialize acceptor \"" + acceptor.getURL() + "\" , trace follows...", (Throwable)e, 2);
            }
        }
    }
}

