/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.cert.BrokerKeyStore;

public class BrokerKeyStoreChangeHandler
implements IAttributeChangeHandler {
    private BrokerKeyStore m_store = null;

    public BrokerKeyStoreChangeHandler(BrokerKeyStore store) {
        this.m_store = store;
    }

    public void itemDeleted() {
        this.m_store.reset();
    }

    public void itemModified(Object newValue) {
        String pwd;
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        boolean reload = false;
        for (i = 0; i < newAttributes.length; ++i) {
            if (newAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                try {
                    this.m_store.setURL((String)delta.getNewValue(newAttributes[i]));
                    reload = true;
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (!newAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            try {
                pwd = (String)delta.getNewValue(newAttributes[i]);
                this.m_store.setPassword(pwd == null ? null : pwd.toCharArray());
                reload = true;
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                try {
                    this.m_store.setURL((String)delta.getNewValue(modifiedAttributes[i]));
                    reload = true;
                }
                catch (NotModifiedAttException e) {}
                continue;
            }
            if (!modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            try {
                pwd = (String)delta.getNewValue(modifiedAttributes[i]);
                this.m_store.setPassword(pwd == null ? null : pwd.toCharArray());
                reload = true;
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (deletedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                this.m_store.setURL(null);
                reload = true;
                continue;
            }
            if (!deletedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
            this.m_store.setPassword(null);
            reload = true;
        }
        if (reload) {
            BrokerComponent.getComponentContext().logMessage("Reloading broker key store", 3);
            try {
                this.m_store.reload();
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(ex.getMessage(), 2);
            }
        }
    }
}

