/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.fc.FlowControlMonitor;

public class ClusterChangeHandler
implements IAttributeChangeHandler {
    public static void init() {
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        int i;
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                this.attributeModified(newAttributes[i], delta.getNewValue(newAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            try {
                this.attributeModified(modifiedAttributes[i], delta.getNewValue(modifiedAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            this.attributeDeleted(deletedAttributes[i]);
        }
    }

    private void attributeModified(String attribute, Object value) {
        if (attribute.equals("CLUSTER_BROKER_CONNECT_TIMEOUT")) {
            int newValue = (Integer)value;
            Config.CLUSTER_CONNECT_TIMEOUT = newValue * 1000;
        } else if (attribute.equals("CLUSTER_BROKER_PING_INTERVAL")) {
            int newValue = (Integer)value;
            Config.CLUSTER_PING_INTERVAL = newValue * 1000;
        } else if (attribute.equals("CLUSTER_BROKER_PING_TIMEOUT")) {
            int newValue = (Integer)value;
            Config.CLUSTER_PING_TIMEOUT = newValue * 1000;
        } else if (attribute.equals("CLUSTER_FC_MONITOR_INTERVAL")) {
            int newValue = (Integer)value;
            if (Config.ENABLE_INTERBROKER && newValue >= 0) {
                Config.BROKER_FC_MONITOR_INTERVAL = newValue;
                FlowControlMonitor fcm = AgentRegistrar.getAgentRegistrar().getFCMonitor();
                if (fcm != null) {
                    fcm.setMonitorInterval(newValue);
                }
            }
        } else if (attribute.equals("CLUSTER_FLOW_TO_DISK") && Config.ENABLE_INTERBROKER) {
            Config.FLOW_TO_DISK = (Boolean)value;
        } else if (attribute.equals("CLIENT_DEFAULT_FC_MONITOR_INTERVAL") && Config.ENABLE_INTERBROKER) {
            int newValue = (Integer)value;
            Config.CLIENT_DEFAULT_FC_MONITOR_INTERVAL = newValue = newValue == 0 ? 0 : Math.max(newValue, Config.CLIENT_DEFAULT_FC_MONITOR_INTERVAL_MIN);
        }
    }

    private void attributeDeleted(String attribute) {
        if (attribute.equals("CLUSTER_BROKER_CONNECT_TIMEOUT")) {
            Config.CLUSTER_CONNECT_TIMEOUT = 30000;
        } else if (attribute.equals("CLUSTER_BROKER_PING_INTERVAL")) {
            Config.CLUSTER_PING_INTERVAL = 30000;
        } else if (attribute.equals("CLUSTER_BROKER_PING_TIMEOUT")) {
            Config.CLUSTER_PING_TIMEOUT = 60000;
        } else if (attribute.equals("CLUSTER_FC_MONITOR_INTERVAL")) {
            if (Config.ENABLE_INTERBROKER) {
                int newValue;
                Config.BROKER_FC_MONITOR_INTERVAL = newValue = 15;
                FlowControlMonitor fcm = AgentRegistrar.getAgentRegistrar().getFCMonitor();
                if (fcm != null) {
                    fcm.setMonitorInterval(newValue);
                }
            }
        } else if (attribute.equals("CLUSTER_FLOW_TO_DISK") && Config.ENABLE_INTERBROKER) {
            Config.FLOW_TO_DISK = false;
        } else if (attribute.equals("CLIENT_DEFAULT_FC_MONITOR_INTERVAL") && Config.ENABLE_INTERBROKER) {
            Config.CLIENT_DEFAULT_FC_MONITOR_INTERVAL = 60;
        }
    }
}

