/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import java.io.IOException;
import java.util.Hashtable;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.InterbrokerHook;
import progress.message.db.EDatabaseException;
import progress.message.interbroker.IBConfigBean;
import progress.message.interbroker.Interbroker;

public class ClusterPeerBrokerReferencesChangeHandler
implements IAttributeChangeHandler {
    private String m_bname;
    private IElement m_primarybce;
    private IComponentContext m_context = null;
    private BrokerComponent m_component = null;

    public ClusterPeerBrokerReferencesChangeHandler(IComponentContext context, IElement primarybce, String bname) {
        this.m_context = context;
        this.m_primarybce = primarybce;
        this.m_bname = bname;
        this.m_component = BrokerComponent.getBrokerComponent();
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            if (!newAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            ClusterPeerBrokerReferencesChangeHandler.refreshPeerInfo(this.m_component, this.m_context, this.m_primarybce, this.m_bname);
            return;
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (!modifiedAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            ClusterPeerBrokerReferencesChangeHandler.refreshPeerInfo(this.m_component, this.m_context, this.m_primarybce, this.m_bname);
            return;
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (!deletedAttributes[i].equals("BACKUP_CONFIG_ELEMENT_REF")) continue;
            ClusterPeerBrokerReferencesChangeHandler.refreshPeerInfo(this.m_component, this.m_context, this.m_primarybce, this.m_bname);
            return;
        }
    }

    public static void refreshPeerInfo(BrokerComponent component, IComponentContext context, IElement primarybce, String bname) {
        FTPairPeerInfoHolder holder = ConfigPropertiesPopulator.getFTPairPeerInfoHolder(context, bname, primarybce);
        Hashtable<String, FTPairPeerInfoHolder> peerInfoTable = component.getPeerInfoTable();
        if (peerInfoTable != null) {
            peerInfoTable.remove(bname);
        }
        if (holder != null) {
            if (peerInfoTable == null) {
                peerInfoTable = new Hashtable<String, FTPairPeerInfoHolder>();
                component.setPeerInfoTable(peerInfoTable);
            }
            peerInfoTable.put(bname, holder);
        }
        try {
            if (InterbrokerHook.isSet()) {
                IBConfigBean configBean = Interbroker.getInterbroker().getConfigConnectionMgr().getConfigBean();
                configBean.newBroker(bname, holder);
            }
        }
        catch (EDatabaseException edbe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

