/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.DirectURLConfigChangeHandler;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;

public class DirectURLWSConfigChangeHandler
extends DirectURLConfigChangeHandler {
    private HTTPDirectInboundEntry m_urlEntry = null;
    private boolean TRACE = false;

    public DirectURLWSConfigChangeHandler(HTTPDirectInboundEntry urlEntry, String protocolEntryName, HTTPAcceptor acceptor) {
        super(urlEntry, protocolEntryName, acceptor);
        this.m_urlEntry = urlEntry;
        if (this.TRACE) {
            System.out.println("DirectURLWSConfigChangeHandler for URL " + urlEntry.getURL());
        }
    }

    @Override
    public void itemModified(Object newValue) {
        super.itemModified(newValue);
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = newAttributes[i];
            if (this.TRACE) {
                System.out.println("DirectURLWSConfigChangeHandler: new attributeName = " + attributeName);
            }
            this.setNewAttribute(attributeName, delta);
        }
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        len = modifiedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            if (this.TRACE) {
                System.out.println("DirectURLWSConfigChangeHandler: modified attributeName = " + attributeName);
            }
            this.setAttribute(attributeName, delta);
        }
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        len = deletedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = deletedAttributes[i];
            if (this.TRACE) {
                System.out.println("DirectURLWSConfigChangeHandler: deleted attributeName = " + attributeName);
            }
            this.setAttribute(attributeName, null);
        }
    }

    private void setNewAttribute(String attributeName, IDeltaAttributeSet delta) {
        if (attributeName.equals("MAP_CERTIFICATE_TO_USERNAME")) {
            try {
                Boolean map = (Boolean)delta.getNewValue("MAP_CERTIFICATE_TO_USERNAME");
                if (map != null) {
                    boolean b = map;
                    BrokerComponent.getComponentContext().logMessage((b ? "Enabling" : "Disabling") + " certificate to username mapping for " + this.m_urlEntry.getURL(), 3);
                    this.m_urlEntry.setCertificateToUsernameMapping(b);
                    return;
                }
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("SERVICE_TRUST_STORE")) {
            try {
                IAttributeSet serviceTrustStore = (IAttributeSet)delta.getNewValue("SERVICE_TRUST_STORE");
                this.setTrustStore(serviceTrustStore);
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("CREDENTIALS")) {
            try {
                IAttributeSet serviceCredentials = (IAttributeSet)delta.getNewValue("CREDENTIALS");
                this.setIdentity(serviceCredentials);
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        if (attributeName.equals("MAP_CERTIFICATE_TO_USERNAME")) {
            if (delta == null) {
                BrokerComponent.getComponentContext().logMessage("Enabling certificate to username mapping for " + this.m_urlEntry.getURL(), 3);
                this.m_urlEntry.setCertificateToUsernameMapping(true);
                return;
            }
            try {
                Boolean map = (Boolean)delta.getNewValue("MAP_CERTIFICATE_TO_USERNAME");
                if (map != null) {
                    boolean b = map;
                    BrokerComponent.getComponentContext().logMessage((b ? "Enabling" : "Disabling") + " certificate to username mapping for " + this.m_urlEntry.getURL(), 3);
                    this.m_urlEntry.setCertificateToUsernameMapping(b);
                    return;
                }
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("SERVICE_TRUST_STORE")) {
            if (delta == null) {
                BrokerComponent.getComponentContext().logMessage("Deleting per-service trust store for " + this.m_urlEntry.getURL(), 3);
                try {
                    this.m_urlEntry.deleteTrustStore();
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 2);
                }
                return;
            }
            IDeltaAttributeSet serviceTrustStoreDelta = null;
            String[] deletedAttributes = null;
            String[] modifiedAttributes = null;
            String[] newAttributes = null;
            if (delta != null) {
                try {
                    serviceTrustStoreDelta = (IDeltaAttributeSet)delta.getNewValue("SERVICE_TRUST_STORE");
                    deletedAttributes = serviceTrustStoreDelta.getDeletedAttributesNames();
                    modifiedAttributes = serviceTrustStoreDelta.getModifiedAttributesNames();
                    newAttributes = serviceTrustStoreDelta.getNewAttributesNames();
                }
                catch (NotModifiedAttException nmae) {
                    // empty catch block
                }
            }
            this.reloadTrustStore(serviceTrustStoreDelta, deletedAttributes, modifiedAttributes, newAttributes);
        } else if (attributeName.equals("CREDENTIALS")) {
            if (delta == null) {
                BrokerComponent.getComponentContext().logMessage("Resetting per-service identity for " + this.m_urlEntry.getURL(), 3);
                try {
                    this.m_urlEntry.setX509Alias(null);
                    this.m_urlEntry.setX509Password(null);
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 2);
                }
                return;
            }
            IDeltaAttributeSet serviceCredentialsDelta = null;
            String[] deletedAttributes = null;
            String[] modifiedAttributes = null;
            String[] newAttributes = null;
            try {
                serviceCredentialsDelta = (IDeltaAttributeSet)delta.getNewValue("CREDENTIALS");
                deletedAttributes = serviceCredentialsDelta.getDeletedAttributesNames();
                modifiedAttributes = serviceCredentialsDelta.getModifiedAttributesNames();
                newAttributes = serviceCredentialsDelta.getNewAttributesNames();
            }
            catch (NotModifiedAttException nmae) {
                // empty catch block
            }
            this.resetIdentity(serviceCredentialsDelta, deletedAttributes, modifiedAttributes, newAttributes);
        }
    }

    private void reloadTrustStore(IDeltaAttributeSet delta, String[] deletedAttributes, String[] modifiedAttributes, String[] newAttributes) {
        String pwd = null;
        if (delta != null) {
            int i;
            boolean reload = false;
            for (i = 0; i < newAttributes.length; ++i) {
                if (newAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                    try {
                        this.m_urlEntry.setKeystoreLocation((String)delta.getNewValue(newAttributes[i]));
                        reload = true;
                    }
                    catch (NotModifiedAttException e) {}
                    continue;
                }
                if (!newAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
                try {
                    pwd = (String)delta.getNewValue(newAttributes[i]);
                    this.m_urlEntry.setKeystorePassword(pwd == null ? null : pwd.toCharArray());
                    reload = true;
                    continue;
                }
                catch (NotModifiedAttException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < modifiedAttributes.length; ++i) {
                if (modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                    try {
                        this.m_urlEntry.setKeystoreLocation((String)delta.getNewValue(modifiedAttributes[i]));
                        reload = true;
                    }
                    catch (NotModifiedAttException e) {}
                    continue;
                }
                if (!modifiedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
                try {
                    pwd = (String)delta.getNewValue(modifiedAttributes[i]);
                    this.m_urlEntry.setKeystorePassword(pwd == null ? null : pwd.toCharArray());
                    reload = true;
                    continue;
                }
                catch (NotModifiedAttException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < deletedAttributes.length; ++i) {
                if (deletedAttributes[i].equalsIgnoreCase("KEYSTORE_LOCATION")) {
                    this.m_urlEntry.setKeystoreLocation(null);
                    reload = true;
                    continue;
                }
                if (!deletedAttributes[i].equalsIgnoreCase("KEYSTORE_PASSWORD")) continue;
                this.m_urlEntry.setKeystorePassword(null);
                reload = true;
            }
            if (reload) {
                BrokerComponent.getComponentContext().logMessage("Reloading per-service trust store for " + this.m_urlEntry.getURL(), 3);
                try {
                    this.m_urlEntry.createTrustStore();
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 2);
                }
            }
        }
    }

    private void resetIdentity(IDeltaAttributeSet delta, String[] deletedAttributes, String[] modifiedAttributes, String[] newAttributes) {
        String pwd = null;
        if (delta != null) {
            int i;
            for (i = 0; i < newAttributes.length; ++i) {
                if (newAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                    try {
                        this.m_urlEntry.setX509Alias((String)delta.getNewValue(newAttributes[i]));
                    }
                    catch (NotModifiedAttException e) {}
                    continue;
                }
                if (!newAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
                try {
                    pwd = (String)delta.getNewValue(newAttributes[i]);
                    this.m_urlEntry.setX509Password(pwd == null ? null : pwd.toCharArray());
                    continue;
                }
                catch (NotModifiedAttException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < modifiedAttributes.length; ++i) {
                if (modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                    try {
                        this.m_urlEntry.setX509Alias((String)delta.getNewValue(modifiedAttributes[i]));
                    }
                    catch (NotModifiedAttException e) {}
                    continue;
                }
                if (!modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
                try {
                    pwd = (String)delta.getNewValue(modifiedAttributes[i]);
                    this.m_urlEntry.setX509Password(pwd == null ? null : pwd.toCharArray());
                    continue;
                }
                catch (NotModifiedAttException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < deletedAttributes.length; ++i) {
                if (deletedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                    this.m_urlEntry.setX509Alias(null);
                    continue;
                }
                if (!deletedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
                this.m_urlEntry.setX509Password(null);
            }
        }
    }

    private void setTrustStore(IAttributeSet serviceTrustStore) {
        if (serviceTrustStore != null) {
            String keyStoreFormat = (String)serviceTrustStore.getAttribute("KEYSTORE_FORMAT");
            String keyStoreLocation = (String)serviceTrustStore.getAttribute("KEYSTORE_LOCATION");
            String keyStorePassword = (String)serviceTrustStore.getAttribute("KEYSTORE_PASSWORD");
            this.m_urlEntry.setKeystoreFormat(keyStoreFormat);
            this.m_urlEntry.setKeystoreLocation(keyStoreLocation);
            this.m_urlEntry.setKeystorePassword(keyStorePassword == null ? null : keyStorePassword.toCharArray());
            BrokerComponent.getComponentContext().logMessage("Reloading per-service trust store for endpoint " + this.m_urlEntry.getURL(), 3);
            try {
                this.m_urlEntry.createTrustStore();
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage("Failed to reload per-service trust store for endpoint " + this.m_urlEntry.getURL() + ": " + ex.getMessage(), (Throwable)ex, 2);
            }
        }
    }

    private void setIdentity(IAttributeSet credentials) {
        String x509Alias = null;
        String x509Pwd = null;
        if (credentials != null) {
            x509Alias = (String)credentials.getAttribute("X509TOKEN_ALIAS");
            if (x509Alias == null || x509Alias.length() == 0) {
                BrokerComponent.getComponentContext().logMessage("Failed to set service identity: Alias for the X.509 token cannot be null or empty string.", 2);
                return;
            }
            if (x509Alias != null && x509Alias.length() > 0) {
                x509Pwd = (String)credentials.getAttribute("X509TOKEN_PASSWORD");
                if (x509Pwd == null || x509Pwd.length() == 0) {
                    BrokerComponent.getComponentContext().logMessage("Failed to set service identity: Private key password for the X.509 token cannot be null or empty string.", 2);
                    return;
                }
                this.m_urlEntry.setX509Alias(x509Alias);
                this.m_urlEntry.setX509Password(x509Pwd.toCharArray());
            }
        }
    }
}

