/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mq.common.runtime.IBrowseToken;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.IMessage;
import com.sonicsw.mq.common.runtime.IMessageHeader;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import com.sonicsw.mq.common.runtime.MFDurableOperationException;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.prAccessor;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.durable.EDurableOperationException;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.MgramFactory;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SessionConfig;

class DurableOperationsHelper {
    private static IComponentContext s_mfContext;
    private static BrokerComponent s_component;
    private static IMessageProtection s_mp;

    DurableOperationsHelper() {
    }

    static synchronized void init(IComponentContext mfContext) {
        s_component = BrokerComponent.getBrokerComponent();
        s_mfContext = mfContext;
        if (Config.ENABLE_QOPSECURITY) {
            try {
                s_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
            }
            catch (Exception e) {
                s_mfContext.logMessage(prAccessor.getString("TRACE_FOLLOWS"), (Throwable)e, 1);
            }
        }
    }

    public static IBrowseToken createDurableBrowseTokenFromDSD(IDurableSubscriptionData dsd, Boolean isLocal) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (dsd == null) {
            throw new IllegalArgumentException("Invalid IDurableSubscriptionData");
        }
        if (isLocal == null) {
            throw new IllegalArgumentException("Invalid Boolean");
        }
        return DurableOperationsHelper.createDurableBrowseToken(dsd.getUser(), dsd.getClientID(), dsd.getSubscriptionName(), new Boolean(dsd.isConnectionConsumer()), isLocal);
    }

    public static IBrowseToken createDurableBrowseToken(String userId, String jmsClientId, String uniqueName, Boolean isConnectionConsumer, Boolean local) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (userId == null) {
            userId = "";
        }
        if (jmsClientId == null) {
            jmsClientId = "";
        }
        if (uniqueName == null) {
            throw new IllegalArgumentException("Invalid name");
        }
        if (isConnectionConsumer == null) {
            throw new IllegalArgumentException("Invalid isConnectionConsumer parameter");
        }
        if (local == null) {
            throw new IllegalArgumentException("Invalid isLocal parameter");
        }
        String appId = SessionConfig.createDurableAppid(jmsClientId, uniqueName, isConnectionConsumer);
        long clientId = AddrUtil.stringToClientId(userId, appId);
        IBrowseToken result = null;
        try {
            result = RuntimeDataFactory.createBrowseToken(clientId, AgentRegistrar.getAgentRegistrar().getDurableManager().reserveBrowser(clientId, local));
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
        return result;
    }

    public static ArrayList getBrowseMessages(IBrowseToken ibt, Integer maxMessages) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ibt == null) {
            throw new IllegalArgumentException("Invalid IBrowseToken");
        }
        if (maxMessages == null || maxMessages < 1) {
            throw new IllegalArgumentException("Invalid Integer");
        }
        Collection messages = null;
        try {
            IBrowseToken bt = ibt;
            long clientId = RuntimeDataFactory.getBrowseTokenClientId(bt);
            String tracking = RuntimeDataFactory.getBrowseTokenTracking(bt);
            messages = AgentRegistrar.getAgentRegistrar().getDurableManager().browse(clientId, tracking, maxMessages);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
        ArrayList<IMessageHeader> result = null;
        if (messages != null) {
            Iterator iter = messages.iterator();
            result = new ArrayList<IMessageHeader>();
            while (iter.hasNext()) {
                result.add(RuntimeDataFactory.createMessageHeaderFromDurableHeader((IDurableHeaderInfo)iter.next()));
            }
        }
        return result;
    }

    public static void trimMessages(IBrowseToken ibt, Long dateTime) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ibt == null) {
            throw new IllegalArgumentException("Invalid IBrowseToken");
        }
        if (dateTime < -1L) {
            throw new IllegalArgumentException("Invalid Integer");
        }
        try {
            IBrowseToken bt = ibt;
            long clientId = RuntimeDataFactory.getBrowseTokenClientId(bt);
            AgentRegistrar.getAgentRegistrar().getDurableManager().trimMessages(clientId, dateTime);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
    }

    public static void setBrowseInactiveTimeout(IBrowseToken bt, Integer timeout) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        try {
            String tracking = RuntimeDataFactory.getBrowseTokenTracking(bt);
            long clientId = RuntimeDataFactory.getBrowseTokenClientId(bt);
            AgentRegistrar.getAgentRegistrar().getDurableManager().setBrowserInactivityTimeout(tracking, clientId, timeout * 1000);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
    }

    public static IMessage getMessage(IMessageHeaderToken ht) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ht == null) {
            throw new IllegalArgumentException("Invalid IMessageHeaderToken");
        }
        IMgram reply = null;
        byte[] result = null;
        try {
            String jmsMessageID = RuntimeDataFactory.getMHTJMSMessageID(ht);
            String originationBroker = RuntimeDataFactory.getMHTOriginationBroker(ht);
            long clientId = RuntimeDataFactory.getMHTClientId(ht);
            reply = AgentRegistrar.getAgentRegistrar().getDurableManager().getMgram(jmsMessageID, clientId, originationBroker);
            if (s_mp != null && reply.isSecure()) {
                if (reply.getBrokerHandle().isEncrypted()) {
                    reply.getBrokerHandle().decryptMessageWithMessageKey(s_mp);
                }
                reply.setMgramNonSecure();
            }
            IMgramConverter converter = MgramFactory.getMgramConverter(26);
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            converter.deliver(reply, boas);
            result = boas.toByteArray();
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
        return RuntimeDataFactory.createBrowseMessage(result);
    }

    public static void removeMessage(IMessageHeaderToken ht) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ht == null) {
            throw new IllegalArgumentException("Invalid IMessageHeaderToken");
        }
        String jmsMessageID = RuntimeDataFactory.getMHTJMSMessageID(ht);
        String originationBroker = RuntimeDataFactory.getMHTOriginationBroker(ht);
        long clientId = RuntimeDataFactory.getMHTClientId(ht);
        try {
            AgentRegistrar.getAgentRegistrar().getDurableManager().remove(jmsMessageID, clientId, originationBroker);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
    }

    public static IMessageHeader searchMessage(IMessageHeaderToken ht) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (ht == null) {
            throw new IllegalArgumentException("Invalid IMessageHeaderToken");
        }
        IDurableHeaderInfo reply = null;
        String jmsMessageID = RuntimeDataFactory.getMHTJMSMessageID(ht);
        String originationBroker = RuntimeDataFactory.getMHTOriginationBroker(ht);
        long clientId = RuntimeDataFactory.getMHTClientId(ht);
        try {
            reply = AgentRegistrar.getAgentRegistrar().getDurableManager().search(jmsMessageID, clientId, originationBroker);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
        return RuntimeDataFactory.createMessageHeaderFromDurableHeader(reply);
    }

    public static IMessageHeaderToken createDurableMessageHeaderToken(String userId, String jmsClientId, String uniqueName, Boolean isConnectionConsumer, String messageId) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (userId == null) {
            userId = "";
        }
        if (uniqueName == null) {
            throw new IllegalArgumentException("Invalid name");
        }
        if (jmsClientId == null) {
            jmsClientId = "";
        }
        if (isConnectionConsumer == null) {
            throw new IllegalArgumentException("Invalid isConnectionConsumer");
        }
        if (messageId == null) {
            throw new IllegalArgumentException("Invalid messageId");
        }
        if (messageId.startsWith("ID:")) {
            messageId = messageId.substring(3);
        }
        String appId = SessionConfig.createDurableAppid(jmsClientId, uniqueName, isConnectionConsumer);
        long clientId = AddrUtil.stringToClientId(userId, appId);
        return RuntimeDataFactory.createMessageHeaderToken(messageId, clientId, null);
    }

    public static IMessageHeaderToken createDurableMessageHeaderTokenDSD(IDurableSubscriptionData dsd, String messageId) throws MFException {
        if (dsd == null) {
            throw new IllegalArgumentException("Invalid IDurableSubscriptionData");
        }
        if (messageId == null) {
            throw new IllegalArgumentException("Invalid String");
        }
        return DurableOperationsHelper.createDurableMessageHeaderToken(dsd.getUser(), dsd.getClientID(), dsd.getSubscriptionName(), new Boolean(dsd.isConnectionConsumer()), messageId);
    }

    public static void closeBrowser(IBrowseToken token) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        try {
            String tracking = RuntimeDataFactory.getBrowseTokenTracking(token);
            long clientId = RuntimeDataFactory.getBrowseTokenClientId(token);
            AgentRegistrar.getAgentRegistrar().getDurableManager().unreserveBrowser(tracking, clientId);
        }
        catch (EDurableOperationException e) {
            throw new MFDurableOperationException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            MFException mfe = new MFException(e.getMessage());
            mfe.setLinkedException(e);
            throw mfe;
        }
    }

    public static void deleteDurableSubscriptions(String user, ArrayList durableSubscriptions) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        if (user == null) {
            user = "";
        }
        if (user.indexOf(".") != -1) {
            user = user.replace('.', '$');
        }
        try {
            AgentRegistrar.getAgentRegistrar().deleteDurableSubscriptions(user, durableSubscriptions);
        }
        catch (Exception e) {
            MFException mfe = new MFException();
            mfe.setLinkedException(e);
            throw mfe;
        }
    }

    public static ArrayList getDurableSubscriptions(String user) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        try {
            if (user == null) {
                user = "";
            }
            if (user.indexOf(".") != -1) {
                user = user.replace('.', '$');
            }
            return AgentRegistrar.getAgentRegistrar().getDurableSubscriptions(user);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    public static ArrayList getUsersWithDurableSubscriptions(String prefix) throws MFException {
        s_component.validateState((short)3);
        s_component.validateBrokerActive();
        ArrayList al = AgentRegistrar.getAgentRegistrar().getUsersWithDurableSubscriptions(prefix);
        if (al == null) {
            return al;
        }
        Object[] users = al.toArray();
        if (users != null && users.length > 0) {
            for (int i = 0; i < users.length; ++i) {
                String s = (String)users[i];
                if (s == null || s.indexOf("$") == -1) continue;
                al.remove(s);
                al.add(s.replace('$', '.'));
            }
        }
        return al;
    }

    static {
        s_mp = null;
    }
}

