/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.prAccessor;
import com.sonicsw.security.pass.broker.ConnectionException;
import com.sonicsw.security.pass.broker.IAuthentication;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import progress.message.security.ENoAuthService;

public class ExternalDomainAuthSPIConfig {
    static final boolean DEBUG_PASS_CPP = true;
    static final boolean DEBUG_PASS_ASPI_EVENTS = true;
    public static final boolean DEBUG_PASS_ASPI_RUNTIME = true;
    private static boolean m_isExternalDomain;
    private static volatile String m_domainName;
    private static Map m_groupMap;
    private static volatile String m_authSPIReferenceName;
    private static volatile String m_authSPIName;
    private static volatile String m_className;
    private static List m_classpath;
    private static HashMap m_attributeSettings;

    final void setReferenceName(String referenceName) {
        m_authSPIReferenceName = referenceName;
    }

    final void setClassName(String className) {
        m_className = className;
    }

    final void setClasspath(ArrayList classpath) {
        m_classpath = classpath;
    }

    final void setAttributeSettings(HashMap attributeSettings) {
        m_attributeSettings = attributeSettings;
    }

    final String getAuthSPIName() {
        return m_authSPIName;
    }

    final void setAuthSPIName(String name) {
        m_authSPIName = name;
    }

    public final Map getGroupMap() {
        return m_groupMap;
    }

    final void setGroupMap(HashMap groupMap) {
        m_groupMap = Collections.synchronizedMap(groupMap);
    }

    final void setExternalDomainFlag(boolean externalDomain) {
        m_isExternalDomain = externalDomain;
    }

    final void setExternalDomainName(String externalDomainName) {
        m_domainName = externalDomainName;
    }

    public final IAuthentication getNewInstance() {
        try {
            if (m_authSPIName == null) {
                return null;
            }
            if (m_className == null || (m_className = m_className.trim()).length() == 0) {
                String error = "[-2000] Authentication SPI " + progress.message.client.prAccessor.getString("CLASS_NOT_FOUND");
                BrokerComponent.getComponentContext().logMessage(error, 1);
                return null;
            }
            if (m_classpath.isEmpty()) {
                String error = "[-2005] Authentication SPI " + progress.message.client.prAccessor.getString("CLASSPATH_NOT_FOUND");
                BrokerComponent.getComponentContext().logMessage(error, 2);
            }
            URL[] urls = new URL[m_classpath.size()];
            for (int i = 0; i < urls.length; ++i) {
                String path = (String)m_classpath.get(i);
                File file = new File(path);
                urls[i] = file.exists() ? file.toURL() : new URL(path);
            }
            URLClassLoader urlLoader = new URLClassLoader(urls, ((Object)((Object)BrokerComponent.getBrokerComponent())).getClass().getClassLoader());
            Class<?> c = urlLoader.loadClass(m_className);
            Object o = c.newInstance();
            if (!(o instanceof IAuthentication)) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("DYNAMIC_CLASS_LOADING_OF_AUTHENTICATION_SPI_FAILURE"), 2);
                c = Class.forName(m_className);
                o = c.newInstance();
            }
            IAuthentication spi = (IAuthentication)o;
            spi.setConfigInfo(m_attributeSettings);
            spi.init();
            return spi;
        }
        catch (ClassCastException e) {
            ENoAuthService ex = new ENoAuthService(-2001, "Authentication SPI " + progress.message.client.prAccessor.getString("CLASS_CAST_ERROR") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (ClassNotFoundException e) {
            ENoAuthService ex = new ENoAuthService(-2001, "Authentication SPI " + progress.message.client.prAccessor.getString("CLASS_NOT_FOUND") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (InstantiationException e) {
            ENoAuthService ex = new ENoAuthService(-2002, "Authentication SPI " + progress.message.client.prAccessor.getString("CANNOT_INST_CLASS") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (IllegalAccessException e) {
            ENoAuthService ex = new ENoAuthService(-2003, "Authentication SPI " + progress.message.client.prAccessor.getString("ACCESS_ERROR") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (SecurityException e) {
            ENoAuthService ex = new ENoAuthService(-2006, "Authentication SPI " + progress.message.client.prAccessor.getString("SECURITY_ERROR") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (ConnectionException e) {
            ENoAuthService ex = new ENoAuthService(-2008, progress.message.client.prAccessor.getString("AUTH_SPI_EXCEPTION") + m_className);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (Exception e) {
            ENoAuthService ex = new ENoAuthService(-1, "Authentication SPI " + progress.message.client.prAccessor.getString("LOAD_CLASS_FAILED") + m_className + " due to exception " + e);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        catch (Throwable e) {
            ENoAuthService ex = new ENoAuthService(-1, "Authentication SPI " + progress.message.client.prAccessor.getString("LOAD_CLASS_FAILED") + m_className + " due to exception " + e);
            ex.initCause(e);
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), (Throwable)ex, 1);
        }
        return null;
    }

    static void verbose() {
    }

    static {
        m_classpath = Collections.synchronizedList(new ArrayList());
    }
}

