/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.client.EUnknownPrincipal;
import progress.message.db.EDatabaseException;

public class GroupConfigChangeHelper {
    public static void handleConfigurationChange(IComponentContext context, IElementChange elementChange, String configID, Broker broker, ConfigurationChangeBindHelper bindHelper) {
        if (elementChange.getChangeType() == 0) {
            GroupConfigChangeHelper.handleNewGroup(context, elementChange, bindHelper);
        } else if (elementChange.getChangeType() == 1) {
            GroupConfigChangeHelper.handleGroupUpdate(context, elementChange, configID);
        } else if (elementChange.getChangeType() == 2) {
            GroupConfigChangeHelper.handleGroupRemoval(context, elementChange);
        } else if (elementChange.getChangeType() == 3) {
            // empty if block
        }
    }

    public static void handleNewGroup(IComponentContext context, IElementChange elementChange, ConfigurationChangeBindHelper bindHelper) {
        IAttributeSet gmas;
        IElement newElement = (IElement)elementChange.getElement();
        IAttributeSet das = newElement.getAttributes();
        String groupName = (String)das.getAttribute("GROUP_NAME");
        if (groupName != null) {
            try {
                AgentRegistrar.getAgentRegistrar().getSecurityBean().newGroup(groupName);
                bindHelper.bindRemoveGroupChangeHandler(groupName, das);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if ((gmas = (IAttributeSet)das.getAttribute("GROUP_MEMBERS")) != null) {
            HashMap map = gmas.getAttributes();
            Set set = map.entrySet();
            Iterator it = set.iterator();
            Map.Entry entry = null;
            while (it.hasNext()) {
                entry = it.next();
                if (entry == null) continue;
                IAttributeSet as = (IAttributeSet)entry.getValue();
                String memberName = (String)as.getAttribute("MEMBER_NAME");
                String memberType = (String)as.getAttribute("MEMBER_TYPE");
                if (memberName == null || memberType == null || !memberType.equalsIgnoreCase("USER")) continue;
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().addGroupMember(groupName, memberName);
                }
                catch (EUnknownPrincipal eup) {
                }
                catch (EDatabaseException ede) {
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void handleGroupUpdate(IComponentContext context, IElementChange elementChange, String configID) {
        IAttributeSet das;
        IDeltaElement delta = (IDeltaElement)elementChange.getElement();
        if (delta == null) {
            return;
        }
        IDeltaAttributeSet dltas = (IDeltaAttributeSet)delta.getDeltaAttributes();
        String[] modifiedNames = dltas.getModifiedAttributesNames();
        String groupName = null;
        IElement groupElement = context.getConfiguration(configID, false);
        if (groupElement != null && (das = groupElement.getAttributes()) != null) {
            groupName = (String)das.getAttribute("GROUP_NAME");
        }
        if (groupName != null) {
            int modLen = modifiedNames.length;
            for (int i = 0; i < modLen; ++i) {
                if (!modifiedNames[i].equalsIgnoreCase("GROUP_MEMBERS")) continue;
                try {
                    IDeltaAttributeSet gmas = (IDeltaAttributeSet)dltas.getNewValue(modifiedNames[i]);
                    String[] addedNames = gmas.getNewAttributesNames();
                    int addLen = addedNames.length;
                    IAttributeSet nmas = null;
                    for (int j = 0; j < addLen; ++j) {
                        try {
                            nmas = (IAttributeSet)gmas.getNewValue(addedNames[j]);
                            if (nmas == null) continue;
                            String memberName = (String)nmas.getAttribute("MEMBER_NAME");
                            String memberType = (String)nmas.getAttribute("MEMBER_TYPE");
                            if (memberName == null || memberType.equalsIgnoreCase("GROUP")) continue;
                            try {
                                AgentRegistrar.getAgentRegistrar().getSecurityBean().addGroupMember(groupName, memberName);
                            }
                            catch (EUnknownPrincipal eup) {
                            }
                            catch (EDatabaseException ede) {
                            }
                            catch (IOException ioe) {}
                            continue;
                        }
                        catch (NotModifiedAttException nmae) {
                            // empty catch block
                        }
                    }
                    for (String memberName : gmas.getDeletedAttributesNames()) {
                        if (memberName == null) continue;
                        try {
                            AgentRegistrar.getAgentRegistrar().getSecurityBean().removeGroupMember(groupName, memberName);
                        }
                        catch (EUnknownPrincipal eup) {
                        }
                        catch (EDatabaseException ede) {
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NotModifiedAttException nmae) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleGroupRemoval(IComponentContext context, IElementChange elementChange) {
        String groupName;
        IElement removedElement = (IElement)elementChange.getElement();
        if (removedElement == null) {
            return;
        }
        IAttributeSet das = removedElement.getAttributes();
        if (das != null && (groupName = (String)das.getAttribute("GROUP_NAME")) != null) {
            try {
                AgentRegistrar.getAgentRegistrar().getSecurityBean().delGroup(groupName);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

