/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.Config;
import progress.message.broker.interceptor.InterceptorManager;

public class LGConfigChangeHandler
implements IAttributeChangeHandler {
    public static LGConfigChangeHandler getInstance() {
        return LGConfigChangeLazyHolder.INSTANCE;
    }

    public static void init() {
        LGConfigChangeHandler.getInstance();
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                this.attributeModified(newAttributes[i], delta.getNewValue(newAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            try {
                this.attributeModified(modifiedAttributes[i], delta.getNewValue(modifiedAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException e) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            this.attributeDeleted(deletedAttributes[i]);
        }
    }

    private void attributeModified(String attribute, Object value) throws NotModifiedAttException {
        if (attribute.equalsIgnoreCase("ACTIONAL_INTERCEPTOR")) {
            boolean enabled = Config.LG_ENABLE;
            Config.LG_ENABLE = (Boolean)value;
            if (Config.LG_ENABLE && !enabled) {
                InterceptorManager.initAgentAdvisors();
            }
            if (enabled && !Config.LG_ENABLE || !enabled && Config.LG_ENABLE) {
                InterceptorManager.updateLGDynamicProperty("ACTIONAL_INTERCEPTOR", (Boolean)value);
            }
        }
        if (attribute.equalsIgnoreCase("PAYLOAD_CAPTURE")) {
            String newval = (String)value;
            if (newval.equalsIgnoreCase("NONE") || newval.equalsIgnoreCase("HEADER") || newval.equalsIgnoreCase("BODY") || newval.equalsIgnoreCase("ALL")) {
                InterceptorManager.updateLGDynamicProperty("PAYLOAD_CAPTURE", value);
            } else {
                throw new NotModifiedAttException();
            }
        }
        if (attribute.equalsIgnoreCase("INTERCEPTOR_DEBUG")) {
            InterceptorManager.updateLGDynamicProperty("INTERCEPTOR_DEBUG", value);
        }
        if (attribute.equalsIgnoreCase("INTERCEPTOR_FILTERS")) {
            InterceptorManager.updateLGDynamicProperty("INTERCEPTOR_FILTERS", value);
        }
        if (attribute.equalsIgnoreCase("MESSAGE_FIELDS")) {
            InterceptorManager.updateLGDynamicProperty("MESSAGE_FIELDS", value);
        }
        if (attribute.equalsIgnoreCase("EVENTS_LOG_FILE")) {
            InterceptorManager.updateLGDynamicProperty("EVENTS_LOG_FILE", value);
        }
    }

    private void attributeDeleted(String attribute) {
        if (attribute.equalsIgnoreCase("ACTIONAL_INTERCEPTOR")) {
            boolean enabled = Config.LG_ENABLE;
            Config.LG_ENABLE = false;
            if (enabled) {
                InterceptorManager.updateLGDynamicProperty("ACTIONAL_INTERCEPTOR", Boolean.FALSE);
            }
        }
        if (attribute.equalsIgnoreCase("PAYLOAD_CAPTURE")) {
            InterceptorManager.updateLGDynamicProperty("EVENTS_LOG_FILE", "NONE");
        }
        if (attribute.equalsIgnoreCase("INTERCEPTOR_DEBUG")) {
            InterceptorManager.updateLGDynamicProperty("INTERCEPTOR_DEBUG", Boolean.FALSE);
        }
        if (attribute.equalsIgnoreCase("INTERCEPTOR_FILTERS")) {
            InterceptorManager.updateLGDynamicProperty("INTERCEPTOR_FILTERS", null);
        }
        if (attribute.equalsIgnoreCase("MESSAGE_FIELDS")) {
            InterceptorManager.updateLGDynamicProperty("MESSAGE_FIELDS", null);
        }
        if (attribute.equalsIgnoreCase("EVENTS_LOG_FILE")) {
            InterceptorManager.updateLGDynamicProperty("EVENTS_LOG_FILE", null);
        }
    }

    static void handleLGConfigurationChange(IComponentContext mfContext, IElementChange elementChange) {
        int i;
        IBasicElement elem = elementChange.getElement();
        IDeltaElement changes = null;
        if (!(elem instanceof IDeltaElement)) {
            return;
        }
        changes = (IDeltaElement)elem;
        IDeltaAttributeSet deltaAttrs = (IDeltaAttributeSet)changes.getDeltaAttributes();
        String[] deletedAttributes = deltaAttrs.getDeletedAttributesNames();
        String[] modifiedAttributes = deltaAttrs.getModifiedAttributesNames();
        String[] newAttributes = deltaAttrs.getNewAttributesNames();
        for (i = 0; i < deletedAttributes.length; ++i) {
            try {
                LGConfigChangeHandler.getInstance().itemModified((IDeltaAttributeSet)deltaAttrs.getNewValue(deletedAttributes[i]));
                continue;
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), 2);
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            try {
                LGConfigChangeHandler.getInstance().itemModified((IDeltaAttributeSet)deltaAttrs.getNewValue(modifiedAttributes[i]));
                continue;
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), 2);
            }
        }
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                Object set = deltaAttrs.getNewValue(newAttributes[i]);
                if (set instanceof IDeltaAttributeSet) {
                    LGConfigChangeHandler.getInstance().itemModified((IDeltaAttributeSet)set);
                    continue;
                }
                if (!(set instanceof IAttributeSet)) continue;
                BrokerComponent.getBrokerComponent().getChangeBindHelper().bindLGConfigChangeHandler((IAttributeSet)set);
                for (String attribKey : ((IAttributeSet)set).getAttributes().keySet()) {
                    LGConfigChangeHandler.getInstance().attributeModified(attribKey, ((IAttributeSet)set).getAttributes().get(attribKey));
                }
                continue;
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage(e.getMessage(), 2);
            }
        }
    }

    private static class LGConfigChangeLazyHolder {
        private static final LGConfigChangeHandler INSTANCE = new LGConfigChangeHandler();

        private LGConfigChangeLazyHolder() {
        }
    }
}

