/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import progress.message.ft.ReplicationChannel;

public class ReplicationChannelChangeHandler
implements IAttributeChangeHandler {
    private ReplicationChannel m_rch = null;

    public ReplicationChannelChangeHandler(ReplicationChannel rch) {
        this.m_rch = rch;
    }

    public void itemDeleted() {
        ReplicationChannel.removeChannel(this.m_rch.getName());
        this.m_rch = null;
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = newAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        len = modifiedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        len = deletedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = deletedAttributes[i];
            if (!attributeName.equals("WEIGHT")) continue;
            ReplicationChannel.setWeight(this.m_rch.getName(), 1);
        }
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        if (attributeName.equals("WEIGHT")) {
            try {
                Integer weight = (Integer)delta.getNewValue(attributeName);
                if (weight != null) {
                    ReplicationChannel.setWeight(this.m_rch.getName(), weight);
                }
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("PRIMARY_ADDR")) {
            try {
                String primaryAddr = (String)delta.getNewValue(attributeName);
                if (primaryAddr != null && primaryAddr.trim().length() > 0) {
                    ReplicationChannel.setAcceptorAddress(this.m_rch.getName(), primaryAddr, true);
                }
            }
            catch (NotModifiedAttException nmae) {}
        } else if (attributeName.equals("BACKUP_ADDR")) {
            try {
                String backupAddr = (String)delta.getNewValue(attributeName);
                if (backupAddr != null && backupAddr.trim().length() > 0) {
                    ReplicationChannel.setAcceptorAddress(this.m_rch.getName(), backupAddr, false);
                }
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
    }
}

