/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.ByteArrayDataSource;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.mail.Header;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.naming.Referenceable;
import org.mortbay.util.B64Code;
import progress.message.jclient.BytesMessage;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.Message;
import progress.message.jclient.Part;
import progress.message.jclient.TextMessage;
import progress.message.jimpl.Queue;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.jimpl.xmessage.XMLMessage;

public abstract class Http2Mgram {
    protected Message m_message = null;
    protected boolean m_multipart = false;
    protected String m_charset = null;
    protected String m_authUser = null;
    protected String m_authPassword = null;
    protected int m_contentLength = -1;
    protected String m_contentType = null;
    private final String[] s_ignoreInMimePart = new String[]{"Content-Type", "Content-ID"};

    public abstract String getProperty(String var1, boolean var2) throws PropertyMissingException;

    public abstract int getPropertyInt(String var1, boolean var2) throws PropertyMissingException, PropertyBadValueException;

    public abstract long getPropertyLong(String var1, boolean var2) throws PropertyMissingException, PropertyBadValueException;

    public abstract Boolean getPropertyBoolean(String var1, boolean var2) throws PropertyMissingException, PropertyBadValueException;

    public abstract Hashtable getPropertySet();

    public abstract String getCharacterEncoding() throws UnsupportedEncodingException;

    protected final String[] getIgnoreInMimePart() {
        return this.s_ignoreInMimePart;
    }

    public int getContentLength() {
        if (this.m_contentLength > 0) {
            return this.m_contentLength;
        }
        int ret = -1;
        try {
            ret = this.getPropertyInt("Content-Length", false);
            if (ret == -1) {
                Hashtable props = this.getPropertySet();
                Enumeration enumeration = props.elements();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    if (key == null || !key.equalsIgnoreCase("Content-Length")) continue;
                    String length = (String)props.get(key);
                    if (length == null) {
                        return -1;
                    }
                    return Integer.parseInt(length);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String getContentType() {
        if (this.m_contentType != null) {
            return this.m_contentType;
        }
        String ret = null;
        try {
            ret = this.getProperty("Content-Type", false);
            if (ret == null || ret != null && ret.trim().length() < 1) {
                Hashtable props = this.getPropertySet();
                Enumeration enumeration = props.elements();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    if (key == null || !key.equalsIgnoreCase("Content-Type")) continue;
                    String type = (String)props.get(key);
                    return type;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected void handleMessagePart(progress.message.jclient.MultipartMessage multiMessage, MimeBodyPart mimePart) throws JMSException, MessageHandlingException {
        try {
            Part messagePart = multiMessage.createPart(mimePart.getDataHandler());
            multiMessage.addPart(messagePart);
            progress.message.jclient.Header msgHeader = messagePart.getHeader();
            msgHeader.setContentId(mimePart.getContentID());
            Enumeration enumeration = mimePart.getNonMatchingHeaders(this.s_ignoreInMimePart);
            while (enumeration.hasMoreElements()) {
                Header mimeHeader = (Header)enumeration.nextElement();
                msgHeader.setHeaderField(mimeHeader.getName(), mimeHeader.getValue());
                HttpConstants.DEBUG("Copying " + mimeHeader.getName() + "=" + mimeHeader.getValue() + " from HTTP part to MGRAM part", 1);
            }
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to handle a MIME Message Part");
        }
    }

    protected void handleMultipartContent(InputStream stream) throws JMSException, MessageHandlingException {
        try {
            progress.message.jclient.MultipartMessage multiMessage = (progress.message.jclient.MultipartMessage)this.m_message;
            MimeMultipart parts = new MimeMultipart((DataSource)new ByteArrayDataSource(stream, this.getContentType()));
            for (int i = 0; i < parts.getCount(); ++i) {
                this.handleMessagePart(multiMessage, (MimeBodyPart)parts.getBodyPart(i));
            }
            ((MultipartMessage)multiMessage).marshal();
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to read MultiPart message content: " + e.getMessage(), e);
        }
    }

    protected void handleSinglepartContent(byte[] content) throws PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException {
        if (content == null) {
            throw new MessageHandlingException("Message has no content.");
        }
        if (this.m_message instanceof TextMessage) {
            this.m_charset = this.getCharacterEncoding();
            if (this.m_charset == null) {
                this.m_charset = "ISO-8859-1";
            }
            ((TextMessage)this.m_message).setText(new String(content, this.m_charset));
        } else if (this.m_message instanceof BytesMessage) {
            ((BytesMessage)this.m_message).writeBytes(content);
        } else {
            throw new PropertyBadValueException("Invalid content type");
        }
    }

    protected void handleDestination(String queue, String topic) throws PropertyMissingException, PropertyBadValueException, JMSException {
        this.handleDestination(queue, topic, false);
    }

    protected void handleDestination(String queue, String topic, boolean skipValidation) throws PropertyMissingException, PropertyBadValueException, JMSException {
        progress.message.jimpl.Message implMessage = (progress.message.jimpl.Message)this.m_message;
        if (queue != null) {
            implMessage.setJMSDestination(new Queue(queue, skipValidation));
            implMessage.getEnvelope().getMgram().setType((byte)12);
        } else if (topic != null) {
            Topic topicDest = skipValidation ? new progress.message.jimpl.Topic(topic, skipValidation) : DestinationFactory.createTopic(topic);
            implMessage.setJMSDestination(topicDest);
            implMessage.getEnvelope().getMgram().setType((byte)2);
        }
    }

    protected void handleDestination(Destination dest) throws PropertyMissingException, PropertyBadValueException, JMSException {
        progress.message.jimpl.Message implMessage = (progress.message.jimpl.Message)this.m_message;
        if (dest != null) {
            if (dest instanceof javax.jms.Queue) {
                implMessage.getEnvelope().getMgram().setType((byte)12);
            } else {
                implMessage.getEnvelope().getMgram().setType((byte)2);
            }
            implMessage.setJMSDestination(dest);
            return;
        }
    }

    protected void handleDeliveryMode(String value, String key) throws PropertyBadValueException, JMSException {
        if (value != null) {
            if (value.equalsIgnoreCase("DISCARDABLE")) {
                this.m_message.setJMSDeliveryMode(DeliveryMode.DISCARDABLE);
            } else if (value.equalsIgnoreCase("PERSISTENT")) {
                this.m_message.setJMSDeliveryMode(2);
            } else if (value.equalsIgnoreCase("NON_PERSISTENT")) {
                this.m_message.setJMSDeliveryMode(1);
            } else if (value.equalsIgnoreCase("NON_PERSISTENT_REPLICATED")) {
                this.m_message.setJMSDeliveryMode(DeliveryMode.NON_PERSISTENT_REPLICATED);
            } else {
                throw new PropertyBadValueException(key, value);
            }
        }
    }

    protected void handlePriority(int value, String key) throws PropertyBadValueException, JMSException {
        if (value == -1) {
            return;
        }
        if (value > 9 || value < 0) {
            throw new PropertyBadValueException(key, value);
        }
        this.m_message.setJMSPriority(value);
    }

    protected void handleTimeToLive(long value) throws JMSException {
        if (value > 0L) {
            this.m_message.setJMSExpiration(System.currentTimeMillis() + value);
        } else if (value == 0L) {
            this.m_message.setJMSExpiration(0L);
        }
    }

    protected void handleCorrelationID(String value) throws JMSException {
        if (value != null) {
            this.m_message.setJMSCorrelationID(value);
        }
    }

    protected void handleType(String value) throws JMSException {
        if (value != null) {
            this.m_message.setJMSType(value);
        }
    }

    protected void handleReplyTo(String queue, String topic) throws PropertyBadValueException, JMSException {
        if (queue != null && queue.trim().length() > 0) {
            this.m_message.setJMSReplyTo(new Queue(queue));
        } else if (topic != null && topic.trim().length() > 0) {
            this.m_message.setJMSReplyTo(new progress.message.jimpl.Topic(topic));
        }
    }

    protected void handleNotifyUndeliv(Boolean value) throws JMSException {
        if (value != null) {
            this.m_message.setBooleanProperty("JMS_SonicMQ_notifyUndelivered", value);
        }
    }

    protected void handlePreserveUndeliv(Boolean value) throws JMSException {
        if (value != null) {
            this.m_message.setBooleanProperty("JMS_SonicMQ_preserveUndelivered", value);
        }
    }

    protected void handleDestinationUndeliv(String undelDestType, String undelDestName) throws JMSException {
        if (undelDestType != null && undelDestName != null) {
            Referenceable undelDest = undelDestType.equalsIgnoreCase("queue") ? new Queue(undelDestName) : new progress.message.jimpl.Topic(undelDestName);
            this.m_message.setDestinationProperty("JMS_SonicMQ_destinationUndelivered", (Destination)((Object)undelDest));
        }
    }

    protected void handleOptionalProperties(String id, int seq) throws PropertyMissingException, PropertyBadValueException, JMSException {
        if (id != null) {
            this.m_message.setStringProperty("JMSXGroupID", id);
        }
        if (seq != -1) {
            this.m_message.setIntProperty("JMSXGroupSeq", seq);
        }
    }

    protected boolean isIgnoredHTTPProperty(String key) {
        return HttpHelper.isIgnoredHTTPProperty(key);
    }

    protected String contentTypeToMessageType(String contentType, Hashtable contentMaps) {
        return this.contentTypeToMessageType(contentType, contentMaps, "BYTES");
    }

    protected String contentTypeToMessageType(String contentType, Hashtable contentMaps, String defaultType) {
        String mappedMessageType = null;
        String wildcard = null;
        if (contentMaps != null && (wildcard = (String)contentMaps.get("*/*")) != null) {
            defaultType = wildcard;
        }
        if (contentType == null) {
            return defaultType;
        }
        if (contentMaps != null) {
            int delimIndex;
            String mappedContentType = contentType;
            int index = mappedContentType.indexOf(";");
            if (index > 0) {
                mappedContentType = mappedContentType.substring(0, index);
            }
            if ((mappedMessageType = (String)contentMaps.get(mappedContentType = mappedContentType.toLowerCase())) == null && (delimIndex = mappedContentType.indexOf("/")) > 0) {
                mappedContentType = mappedContentType.substring(0, delimIndex);
                mappedMessageType = (String)contentMaps.get(mappedContentType);
            }
            if (mappedMessageType != null) {
                return mappedMessageType;
            }
            if (wildcard != null) {
                return wildcard;
            }
        }
        if (HttpHelper.startsWithIgnoreCase(contentType, "text/plain")) {
            mappedMessageType = "TEXT";
        } else if (HttpHelper.startsWithIgnoreCase(contentType, "text/xml")) {
            mappedMessageType = "XML";
        } else if (HttpHelper.startsWithIgnoreCase(contentType, "text/")) {
            mappedMessageType = "TEXT";
        } else if (HttpHelper.startsWithIgnoreCase(contentType, "application/")) {
            mappedMessageType = "BYTES";
        } else if (HttpHelper.startsWithIgnoreCase(contentType, "Multipart/Related")) {
            mappedMessageType = "MULTIPART";
        }
        if (mappedMessageType == null && defaultType != null) {
            mappedMessageType = defaultType;
        }
        return mappedMessageType;
    }

    protected Message createMessage(String type, String key) throws PropertyBadValueException, JMSException {
        if (type == null) {
            throw new PropertyBadValueException(key, type);
        }
        this.m_multipart = false;
        if (type.equalsIgnoreCase("TEXT")) {
            this.m_message = new progress.message.jimpl.TextMessage();
        } else if (type.equalsIgnoreCase("XML")) {
            this.m_message = new XMLMessage();
        } else if (type.equalsIgnoreCase("BYTES")) {
            this.m_message = new progress.message.jimpl.BytesMessage();
        } else if (type.equalsIgnoreCase("MULTIPART")) {
            this.m_message = new MultipartMessage();
            this.m_multipart = true;
        } else if (type.equalsIgnoreCase("MESSAGE")) {
            this.m_message = new progress.message.jimpl.Message();
        } else {
            throw new PropertyBadValueException(key, type);
        }
        return this.m_message;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public String getAuthUser() {
        return this.m_authUser;
    }

    public String getAuthPassword() {
        return this.m_authPassword;
    }

    public String[] handleAuthHeader() {
        String encodedAuth;
        String auth;
        int delim;
        String[] userpass = null;
        String authHeader = null;
        try {
            authHeader = this.getProperty("Authorization", false);
        }
        catch (PropertyMissingException e) {
            return null;
        }
        if (authHeader == null) {
            return null;
        }
        if (authHeader.toLowerCase().startsWith("Basic".toLowerCase()) && (delim = (auth = B64Code.decode((String)(encodedAuth = authHeader.substring("Basic".length() + 1)))).indexOf(":")) > 0) {
            userpass = new String[]{auth.substring(0, delim), auth.substring(delim + 1)};
            this.m_authUser = userpass[0];
            this.m_authPassword = userpass[1];
        }
        return userpass;
    }
}

