/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpProtocolHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.QueueMessageRestorer;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.SessionConfig;

public class HttpClientContextManager {
    private static HttpClientContextManager s_instance = null;
    private boolean mIsFactoryEnabled = false;
    private static Object _sync = new Object();
    private static final int MAX_CONTEXT_NUM = 512;
    private Hashtable m_active = new Hashtable();
    private IndexedList m_inactive = new IndexedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientContextManager getInstance() {
        if (s_instance == null) {
            Object object = _sync;
            synchronized (object) {
                if (s_instance == null) {
                    s_instance = new HttpClientContextManager();
                }
            }
        }
        return s_instance;
    }

    private HttpClientContextManager() {
    }

    public void enable() {
        this.mIsFactoryEnabled = true;
    }

    public boolean isFactoryEnabled() {
        return this.mIsFactoryEnabled;
    }

    public HttpClientContext connect(ProgressPasswordUser user) throws ConfigurationException, HttpServiceException {
        return this.connect(user.getName(), null, null, user);
    }

    public HttpClientContext connect(ProgressPasswordUser user, String appId) throws ConfigurationException, HttpServiceException {
        return this.connect(user.getName(), appId, null, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientContext connect(String userId, String appId, String password, ProgressPasswordUser user) throws ConfigurationException, HttpServiceException {
        long identity;
        if (appId != null) {
            identity = SessionConfig.stringToClientId(userId, appId);
        } else {
            String secondKey = "";
            identity = SessionConfig.stringToClientId(userId, secondKey);
        }
        Long idObject = new Long(identity);
        Object object = _sync;
        synchronized (object) {
            ReferenceCountedObject refObj = (ReferenceCountedObject)this.m_active.get(idObject);
            if (refObj != null) {
                refObj.increment();
            } else {
                refObj = (ReferenceCountedObject)this.m_inactive.get(identity);
                if (refObj != null) {
                    refObj.increment();
                    this.m_inactive.remove(identity);
                    this.m_active.put(idObject, refObj);
                } else {
                    int numContexts = this.m_active.size() + this.m_inactive.count();
                    if (numContexts >= 512) {
                        ListNode head = this.m_inactive.head();
                        if (head == null || (refObj = (ReferenceCountedObject)head.obj) == null) {
                            throw new HttpServiceException("Server busy.");
                        }
                        this.m_inactive.remove(refObj.getId());
                        HttpClientContext context = (HttpClientContext)refObj.getObject();
                        this.disconnect(context);
                        refObj.clear();
                    }
                    if (refObj == null) {
                        refObj = new ReferenceCountedObject();
                    }
                    if (!this.isFactoryEnabled()) {
                        throw new ConfigurationException("Internal server error.");
                    }
                    HttpClientContext context = this.createContext(userId, appId, password, user, identity);
                    if (context == null) {
                        throw new HttpServiceException("Internal server error.");
                    }
                    refObj.init(identity, context);
                    this.m_active.put(idObject, refObj);
                }
            }
            return (HttpClientContext)refObj.getObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(HttpClientContext context) {
        long identity = context.getId();
        Long idObject = new Long(identity);
        Object object = _sync;
        synchronized (object) {
            ReferenceCountedObject refObject = (ReferenceCountedObject)this.m_active.get(idObject);
            refObject.decrement();
            if (refObject.count() <= 0) {
                this.m_active.remove(idObject);
                try {
                    this.m_inactive.append(identity, refObject);
                }
                catch (EDuplicateKey dk) {
                    dk.printStackTrace();
                }
            }
        }
    }

    private void disconnect(HttpClientContext context) {
        context.disconnect();
        AgentRegistrar.getAgentRegistrar().disconnect(context.getId(), false);
    }

    private HttpClientContext createContext(String userId, String appId, String password, ProgressPasswordUser user, long clientId) {
        ClientSecurityContext csc;
        if (appId == null) {
            appId = HttpProtocolHandler.getNextAppId();
        }
        if ((csc = this.createSecurityContext(userId, password, user, appId, clientId)) == null) {
            return null;
        }
        csc.setDirectedAddr(new byte[0]);
        csc.setDirectedAddrString("");
        HttpClientContext httpCC = null;
        try {
            AgentRegistrar agentReg = AgentRegistrar.getAgentRegistrar();
            long cid = agentReg.connect(clientId, null, csc, false, (short)-1);
            httpCC = (HttpClientContext)agentReg.getClient(cid);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            if (httpCC != null) {
                AgentRegistrar.getAgentRegistrar().unregister(httpCC);
                httpCC = null;
            }
        }
        catch (Exception e) {
            httpCC = null;
            e.printStackTrace();
        }
        return httpCC;
    }

    private ClientSecurityContext createSecurityContext(String userId, String password, ProgressPasswordUser user, String appId, long clientId) {
        if (user == null) {
            user = new ProgressPasswordUser(userId, password);
        }
        return new ClientSecurityContext(user, userId, appId, clientId, Config.ENABLE_SECURITY, Config.ENABLE_QOPSECURITY, null, null, -1L);
    }

    private long getNextClientId(String uid) {
        return SessionConfig.stringToClientId(uid, HttpProtocolHandler.getNextAppId());
    }

    private long getClientId(String uid, String appId) {
        return SessionConfig.stringToClientId(uid, appId);
    }

    public void shutdown() {
        QueueMessageRestorer qRestorer = HttpClientContext.getQueueMessageRestorer();
        if (qRestorer != null) {
            qRestorer.shutdown();
        }
    }

    public class ReferenceCountedObject {
        private Object m_obj = null;
        private long m_id = -1L;
        private int m_count = 0;

        public ReferenceCountedObject() {
        }

        public ReferenceCountedObject(long id, Object obj) {
            this.init(id, obj);
        }

        public final void init(long id, Object obj) {
            this.m_id = id;
            this.m_obj = obj;
            this.m_count = 1;
        }

        public long getId() {
            return this.m_id;
        }

        public Object getObject() {
            return this.m_obj;
        }

        public int count() {
            return this.m_count;
        }

        public void increment() {
            ++this.m_count;
        }

        public void decrement() {
            --this.m_count;
            if (this.m_count < 0) {
                this.m_count = 0;
            }
        }

        public void clear() {
            this.m_obj = null;
            this.m_id = -1L;
            this.m_count = 0;
        }
    }
}

