/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.Http2Mgram;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.jclient.Message;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.SessionConfig;

public abstract class HttpOutResponse
extends Http2Mgram {
    private Hashtable table = new Hashtable();
    private int responseCode = -1;
    private String responseMessage = null;
    private int m_undeliverdReason = -1;
    private String m_undeliverdExplanation = null;
    private boolean m_isInternal = true;

    public boolean isInternal() {
        return this.m_isInternal;
    }

    public void setIsInternal(boolean isInteranl) {
        this.m_isInternal = isInteranl;
    }

    @Override
    public String getProperty(String name, boolean required) throws PropertyMissingException {
        String value = (String)this.table.get(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        return value;
    }

    @Override
    public int getPropertyInt(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = (String)this.table.get(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public long getPropertyLong(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = (String)this.table.get(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public Boolean getPropertyBoolean(String name, boolean required) throws PropertyMissingException, PropertyBadValueException {
        String value = (String)this.table.get(name);
        if (required && value == null) {
            throw new PropertyMissingException(name);
        }
        if (value == null) {
            return null;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            throw new PropertyBadValueException(name, value);
        }
    }

    @Override
    public Hashtable getPropertySet() {
        return this.table;
    }

    public void setProperty(String key, String value) {
        this.table.put(key, value);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int code) {
        this.responseCode = code;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String message) {
        this.responseMessage = message;
    }

    public int getUndeliverdReason() {
        return this.m_undeliverdReason;
    }

    public void setUndeliverdReason(int reason) {
        this.m_undeliverdReason = reason;
    }

    public String getUndeliverdExplanation() {
        return this.m_undeliverdExplanation;
    }

    public void setUndeliverdExplanation(String text) {
        this.m_undeliverdExplanation = text;
    }

    protected byte[] contentFromStream(InputStream stream, int length) throws IOException {
        byte[] content = null;
        if (stream == null || length == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int totalRead = 0;
        int len = 0;
        while ((len = stream.read(buf, 0, buf.length)) >= 0) {
            out.write(buf, 0, len);
            if (length > 0 && (totalRead += len) >= length) break;
            if (SessionConfig.MAX_MSG_SIZE <= 0 || totalRead <= SessionConfig.MAX_MSG_SIZE) continue;
            throw new EMsgTooBigException(length, SessionConfig.MAX_MSG_SIZE);
        }
        int outSize = out.size();
        if (length == -1) {
            this.setProperty("Content-Length", Integer.toString(outSize));
            HttpConstants.DEBUG("Outbound handler setting CONTENT_LENGTH for fault response, length =  " + outSize, 1);
        }
        if (length > 0 && outSize > length) {
            byte[] toobig = out.toByteArray();
            content = new byte[length];
            System.arraycopy(toobig, 0, content, 0, length);
        } else {
            content = out.toByteArray();
        }
        HttpConstants.DEBUG("Outbound response handler read from input stream, content: \n" + new String(content), 1);
        return content;
    }

    protected void handleSinglepartContent(InputStream stream, int contentLength) throws PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException, EMsgTooBigException {
        byte[] buffer = null;
        try {
            buffer = this.contentFromStream(stream, contentLength);
        }
        catch (EMsgTooBigException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MessageHandlingException(e.getMessage(), e);
        }
        super.handleSinglepartContent(buffer);
    }

    public void handleContent(InputStream stream, int length) throws PropertyBadValueException, JMSException, MessageHandlingException, EMsgTooBigException {
        if (SessionConfig.MAX_MSG_SIZE > 0 && length > SessionConfig.MAX_MSG_SIZE) {
            throw new EMsgTooBigException(length, SessionConfig.MAX_MSG_SIZE);
        }
        try {
            this.handleEncodedContent(stream, length);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageHandlingException(e.getMessage(), e);
        }
    }

    public void handleEncodedContent(InputStream stream, int length) throws PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException, EMsgTooBigException {
        if (this.m_multipart) {
            this.handleMultipartContent(stream);
        } else {
            this.handleSinglepartContent(stream, length);
        }
    }

    protected void handleCopyAllProperties() {
        Enumeration keys = this.table.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            try {
                if (this.isIgnoredHTTPProperty(key)) continue;
                this.m_message.setStringProperty(key, (String)this.table.get(key));
            }
            catch (Exception e) {
                HttpConstants.DEBUG(e, 0);
            }
        }
        try {
            this.m_message.setIntProperty("X-HTTP-ResponseCode", this.responseCode);
            if (this.responseMessage != null) {
                this.m_message.setStringProperty("X-HTTP-ResponseMessage", this.responseMessage);
            }
            if (this.m_undeliverdReason > 0) {
                this.m_message.setIntProperty("JMS_SonicMQ_undeliveredReasonCode", this.m_undeliverdReason);
            }
            if (this.m_undeliverdExplanation != null) {
                this.m_message.setStringProperty("JMS_SonicMQ_undeliveredExplanationText", this.m_undeliverdExplanation);
            }
        }
        catch (Exception e) {
            HttpConstants.DEBUG(e, 0);
        }
    }

    public void setMessageProperties(String dest, String deliveryMode, int prio, long ttl, String corrID, boolean preserveUndeliv, boolean notifyUndeliv, String destinationUndelivType, String destinationUndelivName) {
        try {
            if (dest.startsWith("$Q.")) {
                String node;
                String qname = dest.substring("$Q.".length());
                int index = qname.indexOf("::");
                if (index != -1 && (node = qname.substring(0, index)) != null && node.equals(Config.ROUTING_NODE_NAME)) {
                    boolean hasAnotherNode;
                    String queue = qname.substring(index + 2);
                    boolean bl = hasAnotherNode = queue.indexOf("::") != -1;
                    if (hasAnotherNode) {
                        qname = queue;
                    } else {
                        IAgentQueue iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(queue);
                        if (iaq != null && !iaq.isGlobal()) {
                            qname = queue;
                        }
                    }
                }
                this.handleDestination(qname, null, true);
            } else {
                String node;
                String tname = dest;
                int index = tname.indexOf("::");
                if (index != -1 && (node = tname.substring(0, index)) != null && node.equals(Config.ROUTING_NODE_NAME)) {
                    tname = tname.substring(index + 2);
                }
                this.handleDestination(null, tname, true);
            }
            this.handleDeliveryMode(deliveryMode, "deliveryMode");
            this.handlePriority(prio, "priority");
            this.m_message.setIntProperty("X-HTTP-ContentLength", this.getContentLength());
            this.handleTimeToLive(ttl);
            this.handleCorrelationID(corrID);
            this.handlePreserveUndeliv(preserveUndeliv);
            this.handleNotifyUndeliv(notifyUndeliv);
            this.handleDestinationUndeliv(destinationUndelivType, destinationUndelivName);
        }
        catch (Exception e) {
            HttpConstants.DEBUG(e, 0);
        }
        this.handleCopyAllProperties();
    }

    public Message createMessage(Hashtable contentMaps) {
        try {
            super.createMessage(this.contentTypeToMessageType(this.getContentType(), contentMaps), "Content-Type");
        }
        catch (Exception e) {
            this.m_message = null;
        }
        return this.m_message;
    }

    @Override
    public String getCharacterEncoding() throws UnsupportedEncodingException {
        if (this.m_charset != null) {
            return this.m_charset;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        this.m_charset = HttpHelper.extractCharset(contentType);
        return this.m_charset;
    }

    public abstract void buildResponse(HttpOutResponse var1, URLConnection var2, HttpOutboundHandler var3) throws HttpServiceException;

    protected void saveUndeliveredHeaders(Hashtable headers) {
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            try {
                this.table.put(key, (String)headers.get(key));
            }
            catch (Exception e) {
                HttpConstants.DEBUG(e, 0);
            }
        }
    }
}

