/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.direct;

import com.sonicsw.net.http.DestinationLookupException;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.mortbay.http.HttpRequest;
import progress.message.jclient.DestinationFactory;
import progress.message.jclient.Message;
import progress.message.jimpl.Queue;

public class DirectHttpInRequest
extends HttpInRequest {
    protected String m_destinationURLforReceive = null;

    public DirectHttpInRequest(HttpRequest req) {
        super(req);
    }

    protected Message createMessage(Hashtable contentMaps) throws PropertyMissingException, PropertyBadValueException, JMSException, MessageHandlingException {
        String messageType = null;
        if (this.isGet()) {
            messageType = "MESSAGE";
        }
        if (messageType == null) {
            String contentType = this.getProperty("Content-Type", false);
            messageType = this.contentTypeToMessageType(contentType, contentMaps);
        }
        return super.createMessage(messageType, "Content-Type");
    }

    @Override
    protected void handleDestination(String queue, String topic) throws PropertyMissingException, PropertyBadValueException, JMSException {
        Destination dest = this.getJMSDestionation();
        if (dest != null) {
            super.handleDestination(dest);
            return;
        }
        if (topic == null && queue == null) {
            throw new PropertyMissingException("DestinationQueue or DestinationTopic");
        }
        if (topic != null && queue != null) {
            throw new PropertyBadValueException("DestinationQueue and DestinationTopic defined.");
        }
        super.handleDestination(queue, topic);
    }

    @Override
    protected void handleReplyTo(String queue, String topic) throws PropertyBadValueException, JMSException {
        if (topic == null && queue == null) {
            return;
        }
        if (topic != null && queue != null) {
            throw new PropertyBadValueException("ReplyToQueue and ReplyToTopic defined.");
        }
        super.handleReplyTo(queue, topic);
    }

    public void handleCommonProperties(DirectHttpInConfig config) throws JMSException, PropertyBadValueException, PropertyMissingException {
        this.handleDestination(config.destinationQueue, config.destinationTopic);
        this.handleDeliveryMode(config.deliveryMode, "DeliveryMode");
        this.handlePriority(config.priority, "Priority");
        this.handleTimeToLive(config.timeToLive);
        this.handleReplyTo(config.replyToQueue, config.replyToTopic);
        this.handleType(config.type);
        this.handleNotifyUndeliv(config.notifyUndelivered);
        this.handlePreserveUndeliv(config.preserveUndelivered);
        this.handleDestinationUndeliv(config.undeliveredDestinationType, config.undeliveredDestinationName);
        this.handleCopyAllProperties();
        this.handleRequestURL();
        this.handleRequestMethod();
    }

    protected Message handleMessage(DirectHttpInConfig config) throws JMSException, PropertyBadValueException, PropertyMissingException, MessageHandlingException, UnsupportedEncodingException {
        Hashtable contentMaps = config.getContentMappings();
        this.createMessage(contentMaps);
        this.handleCommonProperties(config);
        this.handleEncodedContent();
        return this.m_message;
    }

    public void mapJMSDestination(DirectHttpInConfig config) throws Exception {
        if (this.m_jmsDestination == null) {
            this.m_jmsDestination = this.getJMSDestination(config, this.getRequest().getPath());
        }
    }

    public void mapReceiveDestination(DirectHttpInConfig config) throws Exception {
        String url;
        if (this.m_destinationURLforReceive == null && (url = this.getReceiveURL(config, this.getRequest().getPath())) != null) {
            if (HttpHelper.isJndi(url)) {
                Destination q = HttpHelper.jndiDestinationLookup(this, url);
                if (q != null) {
                    this.m_destinationURLforReceive = q.toString();
                }
            } else {
                this.m_destinationURLforReceive = url;
            }
        }
    }

    public Destination getJMSDestination(DirectHttpInConfig config, String requestPath) throws MalformedURLException, DestinationLookupException {
        if (this.m_jmsDestination != null) {
            return this.m_jmsDestination;
        }
        try {
            if (config.destinationURL != null) {
                String url = HttpHelper.applySuffix(config.urlEntryName, config.destinationURL, requestPath);
                if (HttpHelper.isSonic(url)) {
                    url = HttpHelper.sonicToJndiEntry(url);
                }
                this.m_jmsDestination = HttpHelper.jndiDestinationLookup(this, url);
            } else if (config.destinationQueue != null) {
                this.m_jmsDestination = new Queue(config.destinationQueue, true);
            } else if (config.destinationTopic != null) {
                this.m_jmsDestination = DestinationFactory.createTopic(config.destinationTopic);
            }
        }
        catch (JMSException e) {
            throw new DestinationLookupException((HttpInRequest)this, (Throwable)e);
        }
        return this.m_jmsDestination;
    }

    private String getReceiveURL(DirectHttpInConfig config, String requestPath) throws MalformedURLException, Exception {
        if (this.m_destinationURLforReceive != null) {
            return this.m_destinationURLforReceive;
        }
        if (config.receiveURL != null) {
            String url = HttpHelper.applySuffix(config.urlEntryName, config.receiveURL, requestPath);
            HttpConstants.DEBUG("request.getSonicfsURL for: " + requestPath + " result URL" + url, 0);
            if (url.indexOf("../") != -1) {
                throw new Exception("HTTP_NOT_AUTHORIZED: " + url);
            }
            if (!HttpHelper.isSonicfs(url) && !HttpHelper.isJndi(url)) {
                throw new Exception("sonicfs or JNDI protocol expected: " + url);
            }
            return url;
        }
        return null;
    }

    public byte[] readSonicfsFile() throws Exception {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            InputStream in = HttpHelper.getSonicfsFile(this.m_destinationURLforReceive);
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = in.read(buf)) >= 0) {
                bos.write(buf, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            throw new Exception("Failed to retrieve file: " + this.m_destinationURLforReceive);
        }
        return bos.toByteArray();
    }

    boolean isFileRetrival() {
        return this.m_destinationURLforReceive != null && HttpHelper.isSonicfs(this.m_destinationURLforReceive);
    }

    String getReceiveQueueName() {
        if (this.m_destinationURLforReceive != null && !HttpHelper.isSonicfs(this.m_destinationURLforReceive)) {
            return this.m_destinationURLforReceive;
        }
        return null;
    }
}

