/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpDupDetect;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.jms.JmsHttpCommand;
import com.sonicsw.net.http.jms.JmsHttpConfig;
import com.sonicsw.net.http.jms.JmsHttpInRequest;
import com.sonicsw.net.http.jms.JmsHttpInResponse;
import com.sonicsw.net.http.jms.prAccessor;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.jms.JMSException;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;

public class JmsHttpCommandSend
implements JmsHttpCommand {
    private JmsHttpConfig config = null;
    private HttpClientContext context = null;
    private long uniqueId = -1L;

    public JmsHttpCommandSend(JmsHttpConfig config, HttpClientContext httpContext) {
        this.config = config;
        this.context = httpContext;
    }

    @Override
    public Message parseRequest(JmsHttpInRequest request, JmsHttpConfig config) throws PropertyMissingException, PropertyBadValueException, JMSException, MessageHandlingException, UnsupportedEncodingException {
        Message message = request.createMessage(config);
        request.handleDestination(true);
        request.handleCommonProperties();
        if (config.isDupDetect()) {
            this.uniqueId = request.getPropertyLong("X-JMS-SonicMQ_UniqueID", false);
            if (this.uniqueId == -1L) {
                throw new PropertyMissingException("X-JMS-SonicMQ_UniqueID");
            }
            if (!HttpDupDetect.check(this.uniqueId, this.context.getCSC().getUid(), "http")) {
                Object[] obj = new Object[]{"X-JMS-SonicMQ_UniqueID", String.valueOf(this.uniqueId), HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP4JMS_DUPLICATE_MESSAGE_ID");
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 3);
                return null;
            }
        }
        request.handleEncodedContent();
        return request.getMessage();
    }

    @Override
    public void createResponse(JmsHttpInResponse response, Message message) {
        response.createOKResponse(this.uniqueId, message);
        if (this.config.isRequestConfirm()) {
            response.setProperty("X-JMS-Confirm", true);
        }
    }

    @Override
    public void createContentResponse(JmsHttpInResponse response, IMgram mgram) {
        this.createEncodedContentResponse(response, mgram, "ISO-8859-1");
    }

    @Override
    public void createEncodedContentResponse(JmsHttpInResponse response, IMgram mgram, String reqEncoding) {
        try {
            response.createEncodedContentResponse(mgram, reqEncoding);
        }
        catch (MessageHandlingException e) {
            response.createResponse(500, e.getMessage());
        }
        catch (Exception e) {
            response.createResponse(500, "Failed to process content reply.");
        }
    }
}

