/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.HttpOutRequest;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpRoutingInfo;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.UnsupportedJMSMessageTypeException;
import com.sonicsw.net.http.jms.JmsHttpHelper;
import com.sonicsw.net.http.prAccessor;
import java.io.UnsupportedEncodingException;
import progress.message.msg.IMgram;

public class JmsHttpOutRequest
extends HttpOutRequest {
    protected void handleMessageID(IMgram mgram) {
        this.setProperty("X-JMS-MessageID", this.getMessageID(mgram));
    }

    protected void handleDeliveryMode(IMgram mgram) {
        this.setProperty("X-JMS-DeliveryMode", this.getDeliveryMode(mgram));
    }

    protected void handleType(IMgram mgram) {
        String value = this.getType(mgram);
        if (value != null && !value.equals("")) {
            this.setProperty("X-JMS-Type", value);
        }
    }

    protected void handleCorrelationID(IMgram mgram) {
        String value = this.getCorrelationID(mgram);
        if (value != null && !value.equals("")) {
            this.setProperty("X-JMS-CorrelationID", value);
        }
    }

    protected void handlePriority(IMgram mgram) {
        this.setProperty("X-JMS-Priority", this.getPriority(mgram));
    }

    protected void handleTimeToLive(IMgram mgram) {
        this.setProperty("X-JMS-TimeToLive", this.getTimeToLive(mgram));
    }

    protected void handleDestination(IMgram mgram) {
        String queue = this.getDestinationQueue(mgram);
        String topic = this.getDestinationTopic(mgram);
        if (queue != null) {
            this.setProperty("X-JMS-DestinationQueue", queue);
        } else if (topic != null) {
            this.setProperty("X-JMS-DestinationTopic", topic);
        } else {
            System.out.println("**** ERROR : handleDestination error");
        }
    }

    protected void handleReplyTo(IMgram mgram) {
        String queue = this.getReplyToQueue(mgram);
        String topic = this.getReplyToTopic(mgram);
        if (queue != null) {
            this.setProperty("X-JMS-ReplyToQueue", queue);
        } else if (topic != null) {
            this.setProperty("X-JMS-ReplyToTopic", topic);
        }
    }

    protected void handleMessageType(IMgram mgram) throws MessageHandlingException {
        String msgType = JmsHttpOutRequest.getMessageType(mgram);
        if (msgType == null) {
            throw new UnsupportedJMSMessageTypeException(prAccessor.getString("HTTP_ROUTING_UNSUPPORTED_JMS_MESSAGE_TYPE"));
        }
        this.setProperty("X-JMS-MessageType", msgType);
    }

    protected void handleTimestamp(IMgram mgram) {
        this.setProperty("X-JMS-Timestamp", this.getTimestamp(mgram));
    }

    protected void handleAction(String action) {
        this.setProperty("X-JMS-Version", "jmshttp/1.0");
        this.setProperty("X-JMS-Action", action);
    }

    protected void handleUniqueID(long id) {
        this.setProperty("X-JMS-SonicMQ_UniqueID", id);
    }

    protected void handleReferenceID(long id) {
        this.setProperty("X-JMS-SonicMQ_ReferenceUniqueID", id);
    }

    protected void handleNotifyUndeliv(IMgram mgram) {
        String value = this.getNotifyUndeliv(mgram);
        if (value != null) {
            this.setProperty("X-JMS-SonicMQ_NotifyUndelivered", value);
        }
    }

    protected void handlePreserveUndeliv(IMgram mgram) {
        String value = this.getPreserveUndeliv(mgram);
        if (value != null) {
            this.setProperty("X-JMS-SonicMQ_PreserveUndelivered", value);
        }
    }

    protected void handleDestinationUndeliv(IMgram mgram) {
        String value = this.getDestinationUndeliv(mgram);
        if (value != null) {
            if (value.startsWith("$Q.")) {
                this.setProperty("X-JMS-SonicMQ_DestinationUndeliveredIsQueue", true);
                this.setProperty("X-JMS-SonicMQ_DestinationUndelivered", value.substring("$Q.".length()));
            } else {
                this.setProperty("X-JMS-SonicMQ_DestinationUndeliveredIsQueue", false);
                this.setProperty("X-JMS-SonicMQ_DestinationUndelivered", value);
            }
        }
    }

    protected void handleOptionalProperties(IMgram mgram) {
        String value = this.getGroupID(mgram);
        if (value != null) {
            this.setProperty("X-JMSX-GroupID", value);
        }
        if ((value = this.getGroupSeq(mgram)) != null) {
            this.setProperty("X-JMSX-GroupSeq", value);
        }
    }

    protected void handleProperties(IMgram mgram) {
        String value = JmsHttpOutRequest.getStringProperty(mgram, "X-JMS-Properties");
        if (value != null) {
            this.setProperty("X-JMS-Properties", value);
        }
    }

    @Override
    public void buildRequest(IMgram mgram, HttpOutboundHandler handler) throws MessageHandlingException {
        this.buildReceiveRequest(mgram, handler.getUniqueID(), handler.getHttpRoutingInfo());
    }

    public void buildReceiveRequest(IMgram mgram, long uniqueID, HttpRoutingInfo routingInfo) throws MessageHandlingException {
        this.handleAction("push-msg");
        this.handleMessageType(mgram);
        this.handleDestination(mgram);
        this.handleReplyTo(mgram);
        this.handlePriority(mgram);
        this.handleTimeToLive(mgram);
        this.handleCorrelationID(mgram);
        this.handleType(mgram);
        this.handleDeliveryMode(mgram);
        this.handleMessageID(mgram);
        this.handleTimestamp(mgram);
        this.handleUniqueID(uniqueID);
        this.handleNotifyUndeliv(mgram);
        this.handlePreserveUndeliv(mgram);
        this.handleDestinationUndeliv(mgram);
        this.handleOptionalProperties(mgram);
        this.handleProperties(mgram);
        this.handleCopyAllProperties(mgram);
        String username = JmsHttpOutRequest.getStringProperty(mgram, "X-JMS-User");
        String password = null;
        if (username != null) {
            password = JmsHttpOutRequest.getStringProperty(mgram, "X-JMS-Password");
        } else {
            username = routingInfo.getUsername();
            password = routingInfo.getPassword();
        }
        if (username != null && !username.equals("AUTHENTICATED")) {
            this.setProperty("X-JMS-User", username);
            if (password == null) {
                password = "";
            }
            this.setProperty("X-JMS-Password", password);
            try {
                this.setAuthorization(username, password);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        this.handleContentType(mgram);
        this.handleContent(mgram);
    }

    public void buildConfirmRequest(long id) {
        this.handleAction("confirm-push");
        this.handleReferenceID(id);
    }

    @Override
    protected boolean isIgnoredJMSProperty(String key) {
        if (JmsHttpHelper.isIgnoredJMSProperty(key)) {
            return true;
        }
        return super.isIgnoredJMSProperty(key);
    }
}

