/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.net.http.ws.WSHttpConfigInfo;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.wsdl.extensions.wsa.WSAUtils;
import com.sonicsw.wsdl.extensions.wsp.WSPUtils;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Broker;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.broker.PeerInfoHolder;
import progress.message.net.ProgressInetAddress;
import progress.message.util.DebugState;
import progress.message.util.DraDestUtil;
import progress.message.util.URLUtil;
import progress.message.zclient.DebugObject;

public class WSDLHelper
extends DebugObject {
    private static final String DEBUG_NAME = "WSDLHelper ";
    private String m_wsdlFileName = null;
    private WSDLFactory m_factory;
    private WSDLReader m_reader;
    private Definition m_def;
    private ExtensionRegistry m_registry;

    public Definition getDefinition() {
        return this.m_def;
    }

    public WSDLHelper(String wsdlFileName) throws WSDLException {
        super(DebugState.GLOBAL_DEBUG_ON ? DEBUG_NAME : null);
        this.m_wsdlFileName = wsdlFileName;
        if (this.DEBUG) {
            this.debug("WSDLHelper ctor for wsdl file: " + this.m_wsdlFileName);
        }
        this.m_factory = WSDLFactory.newInstance();
        this.m_reader = this.m_factory.newWSDLReader();
        ExtensionRegistry extreg = this.m_factory.newPopulatedExtensionRegistry();
        WSPUtils.register(extreg);
        WSAUtils.register(extreg);
        this.m_reader.setExtensionRegistry(extreg);
        this.m_def = this.m_reader.readWSDL(this.m_wsdlFileName);
        this.m_registry = this.m_def.getExtensionRegistry();
        DebugObjects.getHandlerDebug().debug("WSDLHelper ctor:  wsdl file name = " + this.m_wsdlFileName);
    }

    public WSDLHelper(InputStream is) {
        super(DebugState.GLOBAL_DEBUG_ON ? DEBUG_NAME : null);
        try {
            this.m_factory = WSDLFactory.newInstance();
            this.m_reader = this.m_factory.newWSDLReader();
            ExtensionRegistry extreg = this.m_factory.newPopulatedExtensionRegistry();
            WSPUtils.register(extreg);
            WSAUtils.register(extreg);
            this.m_reader.setExtensionRegistry(extreg);
            this.m_def = this.m_reader.readWSDL(null, new InputSource(is));
            this.m_registry = this.m_def.getExtensionRegistry();
            DebugObjects.getHandlerDebug().debug("WSDLHelper: ctor read wsdl from InputStream  target namespace = " + this.m_def.getTargetNamespace());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rewriteSoapAddressUrls(String path, String requestURL, WSHttpConfigInfo configInfo) throws Exception {
        HTTPAcceptor localAcceptor = configInfo.getHTTPAccptor();
        String acceptorName = localAcceptor.getAcceptorName();
        String localURL = localAcceptor.getExternalURL();
        localURL = localURL != null && !"".equals(localURL) ? localURL + path : requestURL;
        String localHttpAcceptorName = acceptorName != null && !"".equals(acceptorName) ? acceptorName : localAcceptor.getAcceptorName();
        Vector peerUrlList = this.getClusterPeerURLs(localAcceptor);
        if (this.DEBUG) {
            this.debug("rewriteSoapAddressUrls get localAccp name = ..." + localHttpAcceptorName);
            this.debug("rewriteSoapAddressUrls getClusterPeerURLs size = " + peerUrlList.size());
            for (int i = 0; i < peerUrlList.size(); ++i) {
                this.debug("rewriteSoapAddressUrls get peer url = ..." + (String)peerUrlList.elementAt(i));
            }
        }
        if (DebugObjects.getHandlerDebug().getDebug()) {
            String debugPeerURLs = "";
            for (int i = 0; i < peerUrlList.size(); ++i) {
                debugPeerURLs = debugPeerURLs + " " + (String)peerUrlList.elementAt(i);
            }
            DebugObjects.getHandlerDebug().debug("WSDLHelper.rewriteSoapAddressUrls() \nlocalURL = " + localURL + "\nlocalHttpAcceptorName = " + localHttpAcceptorName + "\npeer urls: " + debugPeerURLs);
        }
        Map services = this.m_def.getServices();
        HashMap<QName, Service> rewrittenServices = new HashMap<QName, Service>();
        Collection collection = services.values();
        Iterator servicesIter = collection.iterator();
        while (servicesIter.hasNext()) {
            Service service = (Service)servicesIter.next();
            QName serviceName = service.getQName();
            if (this.DEBUG) {
                this.debug("WSDLHelper process service name = ..." + service.getQName());
            }
            Map ports = service.getPorts();
            Iterator portsIter = ports.values().iterator();
            Service newService = this.m_def.createService();
            newService.setQName(service.getQName());
            newService.setDocumentationElement(service.getDocumentationElement());
            boolean isPopulated = false;
            while (portsIter.hasNext()) {
                Port port = (Port)portsIter.next();
                if (this.DEBUG) {
                    this.debug("WSDLHelper process port name = ..." + port.getName());
                }
                if (!this.populateSonicPorts(newService, port, path, localURL, peerUrlList)) continue;
                isPopulated = true;
                if (!this.DEBUG && !DebugObjects.getHandlerDebug().getDebug()) continue;
                this.printService(newService);
            }
            if (!isPopulated) continue;
            servicesIter.remove();
            rewrittenServices.put(newService.getQName(), newService);
        }
        servicesIter = rewrittenServices.values().iterator();
        while (servicesIter.hasNext()) {
            this.m_def.addService((Service)servicesIter.next());
        }
    }

    private void printService(Service service) {
        System.out.println("WSDLHelper after adding localhost port, dumping service ...");
        System.out.println("\n=>services name = ..." + service.getQName());
        Map ports = service.getPorts();
        for (Port port : ports.values()) {
            System.out.println("==>port name = ..." + port.getName());
            List list = port.getExtensibilityElements();
            for (ExtensibilityElement e : list) {
                System.out.println("====>ExtensibilityElement name = ..." + e.getElementType().toString());
                String address = "unknown";
                if (e instanceof SOAPAddress) {
                    address = ((SOAPAddress)e).getLocationURI();
                } else if (e instanceof HTTPAddress) {
                    address = ((HTTPAddress)e).getLocationURI();
                }
                System.out.println("======>Address  = ..." + address);
            }
        }
    }

    public void writeWSDL() throws Exception {
        String fileName = this.m_wsdlFileName != null ? this.m_wsdlFileName : "myWSDL";
        int i = fileName.lastIndexOf(".");
        String name = fileName.substring(0, i);
        String ext = fileName.substring(name.length(), fileName.length());
        fileName = name + "out" + ext;
        WSDLWriter writer = this.m_factory.newWSDLWriter();
        FileWriter file = new FileWriter(fileName);
        writer.writeWSDL(this.m_def, (Writer)file);
        file.flush();
        file.close();
    }

    public void writeWSDL(OutputStream os) throws Exception {
        WSDLWriter writer = this.m_factory.newWSDLWriter();
        writer.writeWSDL(this.m_def, os);
        os.flush();
    }

    private Port populatePort(Port oldPort, String requestURL, int index) throws Exception {
        List list = oldPort.getExtensibilityElements();
        Iterator elementIter = list.iterator();
        boolean isPortChanged = false;
        Port newPort = this.m_def.createPort();
        if (this.DEBUG) {
            this.debug("in populatePort for port: " + oldPort.getName() + " extElement number: " + list.size());
        }
        while (elementIter.hasNext()) {
            ExtensibilityElement e = (ExtensibilityElement)elementIter.next();
            QName ename = e.getElementType();
            String address = "unknown";
            ExtensibilityElement newE = null;
            if (e instanceof SOAPAddress) {
                address = ((SOAPAddress)e).getLocationURI();
                if (this.DEBUG) {
                    this.debug("SOAP address found in port: " + oldPort.getName() + " addr: " + address);
                }
                if (DraDestUtil.isHttpOrHttps(address)) {
                    newE = this.createSOAPAddress(requestURL, ename);
                }
            } else if (e instanceof HTTPAddress) {
                address = ((HTTPAddress)e).getLocationURI();
                if (this.DEBUG) {
                    this.debug("HTTP address found in port: " + oldPort.getName() + " addr: " + address);
                }
                if (DraDestUtil.isHttpOrHttps(address)) {
                    newE = this.createHTTPAddress(requestURL, ename);
                }
            }
            if (newE != null) {
                newPort.addExtensibilityElement(newE);
                isPortChanged = true;
            } else {
                newPort.addExtensibilityElement(e);
                if (this.DEBUG) {
                    this.debug("non-http element found in port: " + oldPort.getName() + " : " + e.getElementType().toString());
                }
            }
            DebugObjects.getHandlerDebug().debug("WSDLHelper.populatePort():  Port = " + oldPort.getName() + (isPortChanged ? " changed to " : " remaining ") + newPort.getName());
        }
        if (!isPortChanged) {
            return null;
        }
        newPort.setBinding(oldPort.getBinding());
        newPort.setDocumentationElement(oldPort.getDocumentationElement());
        String newPortName = oldPort.getName();
        if (index != 0) {
            newPortName = newPortName + new Integer(index).toString();
        }
        newPort.setName(newPortName);
        return newPort;
    }

    private ExtensibilityElement createSOAPAddress(String locationURI, QName name) throws Exception {
        SOAPAddress soapAddress = (SOAPAddress)this.m_registry.createExtension(Port.class, name);
        DebugObjects.getHandlerDebug().debug("WSDLHelper.createSOAPAddress(): for " + locationURI + ", qname =" + name);
        soapAddress.setLocationURI(locationURI);
        return soapAddress;
    }

    private ExtensibilityElement createHTTPAddress(String locationURI, QName name) throws Exception {
        HTTPAddress httpAddress = (HTTPAddress)this.m_registry.createExtension(Port.class, name);
        DebugObjects.getHandlerDebug().debug("WSDLHelper.createHTTPAddress(): for " + locationURI + ", qname" + name);
        httpAddress.setLocationURI(locationURI);
        return httpAddress;
    }

    private boolean populateSonicPorts(Service service, Port existingPort, String path, String localURL, Vector peerUrlList) throws Exception {
        String adjustedLocalURL = this.replaceLocalHostInUrl(localURL);
        DebugObjects.getHandlerDebug().debug("WSDLHelper.populateSonicPorts(): \nprocess servicename = " + service.getQName() + "\nport = " + existingPort.getName() + "\npath = " + path + "\nlocalURL = " + localURL + "\nadjusted LocalURL = " + adjustedLocalURL + "\npeers: " + peerUrlList);
        Port newPort = this.populatePort(existingPort, adjustedLocalURL, 0);
        if (newPort == null) {
            service.addPort(existingPort);
            return false;
        }
        service.addPort(newPort);
        if (peerUrlList == null || peerUrlList.isEmpty()) {
            return true;
        }
        String urlSuffix = path == null ? "" : path;
        for (int i = 0; i < peerUrlList.size(); ++i) {
            String peerURL = (String)peerUrlList.elementAt(i);
            peerURL = this.replaceLocalHostInUrl(peerURL);
            DebugObjects.getHandlerDebug().debug("WSDLHelper.populateSonicPorts() : checking if isSameURL( " + peerURL + path + ", " + adjustedLocalURL + ")");
            if (this.isSameURL(peerURL + path, adjustedLocalURL)) {
                DebugObjects.getHandlerDebug().debug("WSDLHelper.populateSonicPorts():  skipping " + newPort.getName() + " since it should already be in the list");
                continue;
            }
            newPort = this.populatePort(existingPort, peerURL + urlSuffix, i + 1);
            if (newPort == null) continue;
            DebugObjects.getHandlerDebug().debug("WSDLHelper.populateSonicPorts():  added port " + newPort.getName() + " url = " + peerURL + urlSuffix);
            service.addPort(newPort);
        }
        return true;
    }

    private boolean isSameURL(String urlString1, String urlString2) {
        boolean retval = false;
        URL url1 = null;
        URL url2 = null;
        try {
            url1 = new URL(urlString1);
            url2 = new URL(urlString2);
            if (url1.equals(url2)) {
                retval = true;
            }
        }
        catch (Exception e) {
            DebugObjects.getHandlerDebug().debug("WSDLHelper.isSameURL():  had a problem comparing urls: " + e.getMessage() + ", which was ignored.");
        }
        DebugObjects.getHandlerDebug().debug("WSDLHelper.isSameURL():  comparison of " + urlString1 + " and " + urlString2 + " = " + retval);
        return retval;
    }

    private Vector getClusterPeerURLs(Acceptor localAcceptor) {
        Vector peerURLs = new Vector();
        Hashtable peers = Broker.getBroker().getClusterPeerInfoTable();
        if (peers == null) {
            return peerURLs;
        }
        peers = (Hashtable)peers.clone();
        for (String brokerName : peers.keySet()) {
            FTPairPeerInfoHolder FTpih = (FTPairPeerInfoHolder)peers.get(brokerName);
            DebugObjects.getHandlerDebug().debug("WSDLHelper.getClusterPeerURLs():  looking for " + localAcceptor.getAcceptorName() + " on broker " + brokerName);
            if (FTpih == null) continue;
            PeerInfoHolder pih = null;
            pih = FTpih.getPrimaryPeerInfoHolder();
            Vector HttpUrls = this.getURLsFromPeerInfoHolder(localAcceptor, pih);
            this.addURLsToMainList(peerURLs, HttpUrls);
            pih = FTpih.getBackupPeerInfoHolder();
            HttpUrls = this.getURLsFromPeerInfoHolder(localAcceptor, pih);
            this.addURLsToMainList(peerURLs, HttpUrls);
        }
        return peerURLs;
    }

    private Vector getURLsFromPeerInfoHolder(Acceptor localAcceptor, PeerInfoHolder pih) {
        String acceptorName = localAcceptor.getAcceptorName();
        if (pih != null) {
            DebugObjects.getHandlerDebug().debug("WSDLHelper.getURLsFromPeerInfoHolder(): acceptorName = " + acceptorName + " PeerInforHolder for " + pih.getBrokerName());
            Hashtable pt = pih.getPeerTable();
            if (pt.containsKey(acceptorName)) {
                Enumeration protocols;
                Hashtable acceptorProtocols;
                Hashtable protocolTable;
                Enumeration holders;
                Hashtable<String, String> localAcceptorProtocols = new Hashtable<String, String>();
                HTTPDirectInboundHolder hdih = ((HTTPAcceptor)localAcceptor).getHTTPDirectInboundHolder();
                if (hdih != null && (holders = hdih.getHTTPDirectInboundProtocolHolders()) != null && holders.hasMoreElements()) {
                    HTTPDirectInboundProtocolHolder hdiph = (HTTPDirectInboundProtocolHolder)holders.nextElement();
                    localAcceptorProtocols.put(hdiph.getEntryName(), hdiph.getInboundProtocol());
                }
                if ((protocolTable = pih.getPeerProtocolsTable()) != null && !protocolTable.isEmpty() && protocolTable.containsKey(acceptorName) && (acceptorProtocols = (Hashtable)protocolTable.get(acceptorName)) != null && (protocols = acceptorProtocols.keys()).hasMoreElements()) {
                    String handlername = (String)protocols.nextElement();
                    String handlertype = (String)acceptorProtocols.get(handlername);
                    Enumeration locals = localAcceptorProtocols.keys();
                    while (locals.hasMoreElements()) {
                        String localHandlerName = (String)locals.nextElement();
                        String localHandlerType = (String)localAcceptorProtocols.get(localHandlerName);
                        if (!handlername.equalsIgnoreCase(localHandlerName) || !handlertype.equalsIgnoreCase(localHandlerType)) continue;
                        return (Vector)pt.get(acceptorName);
                    }
                }
            }
        }
        return null;
    }

    private void addURLsToMainList(Vector mainList, Vector subList) {
        if (subList == null || subList.isEmpty()) {
            DebugObjects.getHandlerDebug().debug("WSDLHelper.addURLsToMainList():  subList is empty");
            return;
        }
        for (int i = 0; i < subList.size(); ++i) {
            mainList.add(subList.elementAt(i));
            DebugObjects.getHandlerDebug().debug("WSDLHelper.addURLsToMainList():  adding " + (String)subList.elementAt(i) + " main list size now " + mainList.size());
        }
    }

    private Acceptor getLocalHttpAcceptor(String requestURL) {
        int requestPort = this.getRequestPort(requestURL);
        AcceptorHolder ah = AcceptorHolder.getAcceptorHolder();
        Enumeration e = ah.getAcceptors();
        while (e.hasMoreElements()) {
            Hashtable ht = (Hashtable)e.nextElement();
            Enumeration e2 = ht.elements();
            if (e2 == null) continue;
            while (e2.hasMoreElements()) {
                Acceptor acc = (Acceptor)e2.nextElement();
                DebugObjects.getHandlerDebug().debug("WSDLHelper.getLocalHttpAcceptor():  acc.getPort() = " + acc.getPort() + " requestPort = " + requestPort);
                if (acc.getPort() != requestPort) continue;
                DebugObjects.getHandlerDebug().debug("WSDLHelper.getLocalHttpAcceptor(): found match==> externalURL = " + acc.getExternalURL() + " internalURL = " + acc.getURL());
                return acc;
            }
        }
        return null;
    }

    private int getRequestPort(String urlString) {
        URL url = null;
        int port = -1;
        try {
            url = new URL(urlString);
        }
        catch (Exception e) {
            return port;
        }
        if (url != null) {
            return url.getPort();
        }
        return port;
    }

    private String replaceLocalHostInUrl(String url) {
        String hostname;
        int i = url.indexOf("://");
        int j = url.lastIndexOf(":");
        int hostNameStart = i + 3;
        int hostNameEnd = j;
        if (i < 0) {
            hostNameStart = 0;
        }
        if (j < hostNameStart) {
            hostNameEnd = url.length();
        }
        if ("".equals(hostname = url.substring(hostNameStart, hostNameEnd)) || "localhost".equals(hostname)) {
            String modifiedUrl = "";
            hostname = ProgressInetAddress.getLocalHostName();
            if (hostname == null) {
                return url;
            }
            if (hostNameStart > 0) {
                modifiedUrl = url.substring(0, hostNameStart);
            }
            modifiedUrl = modifiedUrl + URLUtil.wrapIPv6Address(hostname);
            if (hostNameEnd < url.length()) {
                modifiedUrl = modifiedUrl + url.substring(hostNameEnd);
            }
            return modifiedUrl;
        }
        return url;
    }
}

