/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import com.sonicsw.net.http.soap.SoapHttpInRequest;
import com.sonicsw.security.cert.TrustStore;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import org.mortbay.http.HttpRequest;
import progress.message.zclient.DebugObject;

public class WSHttpInRequest
extends SoapHttpInRequest {
    private static final String DEBUG_NAME = "WSHttpInRequest";
    private static final String WSDL_QUERY = "WSDL";
    private String m_wsdlLocation = null;
    private TrustStore m_trustStore = null;
    private boolean m_cert2uid = true;
    private String m_serviceAlias = null;
    private char[] m_servicePrivateKeyPwd = null;
    private String m_soapActor = null;
    private X509Certificate m_signingCert = null;

    public WSHttpInRequest(HttpRequest req) {
        super(req);
    }

    void setTrustStore(TrustStore ts, boolean cert2uid) {
        this.m_trustStore = ts;
        this.m_cert2uid = cert2uid;
    }

    void setServiceIdentity(String alias, char[] pwd) {
        this.m_serviceAlias = alias;
        this.m_servicePrivateKeyPwd = pwd;
    }

    void setSoapActor(String actor) {
        this.m_soapActor = actor;
    }

    public TrustStore getTrustStore() {
        return this.m_trustStore;
    }

    public boolean isCertificateToUidEnabled() {
        return this.m_cert2uid;
    }

    public String getServiceAlias() {
        return this.m_serviceAlias;
    }

    public char[] getServicePrivateKeyPwd() {
        return this.m_servicePrivateKeyPwd;
    }

    public void setSigningCertificate(X509Certificate cert) {
        this.m_signingCert = cert;
    }

    public X509Certificate getSigningCert() {
        return this.m_signingCert;
    }

    public String getSoapActor() {
        return this.m_soapActor;
    }

    InputStream getWSDLInputStream(String wsdlURL) throws IOException {
        Object is = null;
        if (HttpHelper.isSonicfs(wsdlURL)) {
            return HttpHelper.getSonicfsFile(wsdlURL);
        }
        throw new IllegalArgumentException("WSDL URL " + wsdlURL + " not supported.");
    }

    String getWSDLLocation(DirectHttpInConfig config, String requestPath) throws MalformedURLException, Exception {
        if (this.m_wsdlLocation != null) {
            return this.m_wsdlLocation;
        }
        if (config.wsdlLocation != null) {
            this.m_wsdlLocation = HttpHelper.applySuffix(config.urlEntryName, config.wsdlLocation, requestPath);
            if (HttpHelper.isSonic(this.m_wsdlLocation)) {
                this.m_wsdlLocation = HttpHelper.jndiWsdlLookup(this, HttpHelper.sonicToJndiWSDL(this.m_wsdlLocation));
            }
        } else if (config.destinationURL != null && HttpHelper.isSonic(config.destinationURL)) {
            String sonicURL = HttpHelper.applySuffix(config.urlEntryName, config.destinationURL, requestPath);
            this.m_wsdlLocation = HttpHelper.jndiWsdlLookup(this, HttpHelper.sonicToJndiWSDL(sonicURL));
        }
        return this.m_wsdlLocation;
    }

    void setXHTTPMappedURL(DirectHttpInConfig config, String requestLine) throws MalformedURLException, Exception {
        if (config.destinationURL != null && HttpHelper.isSonic(config.destinationURL)) {
            String completeRequest = this.getCompleteRequest(requestLine);
            if (completeRequest == null) {
                return;
            }
            String mappedURL = HttpHelper.applySuffix(config.urlEntryName, config.destinationURL, completeRequest);
            if (mappedURL != null) {
                this.notifySetMappedURL(mappedURL);
                DebugObject.class_debug(DEBUG_NAME, "set X-HTTP-MappedURL to " + mappedURL);
            }
        }
    }

    private String getCompleteRequest(String requestLine) {
        StringTokenizer st = new StringTokenizer(requestLine, " ");
        st.nextToken();
        return st.nextToken();
    }

    public boolean isWSDLQuery() {
        String queryString = this.req.getQuery();
        if (queryString == null) {
            return false;
        }
        return queryString.equalsIgnoreCase(WSDL_QUERY);
    }
}

