/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.soap.SoapHttpOutResponse;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.CreateOperationContext;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import org.apache.axis.MessageContext;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;
import progress.message.jclient.Message;

public class WSHttpOutResponse
extends SoapHttpOutResponse {
    private org.apache.axis.Message m_axisResponse = null;

    @Override
    public void buildResponse(HttpOutResponse response, URLConnection connection, HttpOutboundHandler handler) throws HttpServiceException {
        try {
            if (this.m_axisResponse != null) {
                Iterator it = this.m_axisResponse.getSOAPPart().getAllMimeHeaders();
                String key = null;
                String value = null;
                while (it.hasNext()) {
                    MimeHeader mh = (MimeHeader)it.next();
                    key = mh.getName();
                    value = mh.getValue();
                    if (key == null || value == null) continue;
                    if ("Content-Type".equalsIgnoreCase(key)) {
                        if (response.getContentType() != null) continue;
                        response.setProperty("Content-Type", value);
                        continue;
                    }
                    if ("Content-Length".equalsIgnoreCase(key)) {
                        if (response.getContentLength() >= 0) continue;
                        response.setProperty("Content-Length", value);
                        continue;
                    }
                    response.setProperty(key, value);
                }
            }
            if (response.getContentType() == null) {
                response.setProperty("Content-Type", "text/xml");
            }
            response.createMessage(handler.getContentMappings());
            InputStream internalFaultStream = ((SoapHttpOutResponse)response).getInternalFaultStream();
            ByteArrayInputStream axisStream = null;
            if (this.m_axisResponse != null && (internalFaultStream == null || HandlerUtils.hasSOAPEnvelope(this.m_axisResponse))) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (HandlerUtils.hasSOAPEnvelope(this.m_axisResponse)) {
                    this.m_axisResponse.writeTo((OutputStream)baos);
                    axisStream = new ByteArrayInputStream(baos.toByteArray());
                } else {
                    axisStream = new ByteArrayInputStream(new byte[0]);
                }
            }
            if (axisStream != null) {
                response.handleContent(axisStream, response.getContentLength());
            } else {
                response.handleContent(internalFaultStream, -1);
            }
        }
        catch (Exception e) {
            throw new HttpServiceException(e);
        }
    }

    public void setAxisResponse(org.apache.axis.Message response) {
        this.m_axisResponse = response;
    }

    public org.apache.axis.Message getAxisResponse() {
        return this.m_axisResponse;
    }

    @Override
    public void saveUndeliveredHeaders(Hashtable ht) {
        super.saveUndeliveredHeaders(ht);
    }

    @Override
    protected void handleCopyAllProperties() {
        super.handleCopyAllProperties();
        if (this.m_axisResponse != null) {
            MessageContext mc = this.m_axisResponse.getMessageContext();
            SOAPConstants sc = null;
            String soapVersion = "SOAP 1.1";
            SequenceCapsule cap = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
            CreateOperationContext coc = (CreateOperationContext)mc.getProperty("com.sonicsw.ws.rm.common.CreateOperationContext");
            String mepCorrelator = (String)mc.getProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR");
            Message m = this.getMessage();
            try {
                if (cap != null) {
                    m.setStringProperty("JMSXGroupID", cap.getId());
                    m.setIntProperty("JMSXGroupSeq", cap.getNr().intValue());
                    m.setBooleanProperty("JMS_SonicMQ_lastMessageInGroup", cap.getLast());
                    if (cap.getReturnId() != null) {
                        m.setStringProperty("X-WS-ReturnGroupID", cap.getReturnId());
                    }
                } else if (coc != null && coc.getOfferContext() != null) {
                    m.setStringProperty("X-WS-ReturnGroupID", coc.getOfferContext().getId());
                }
                if (!m.propertyExists("X-HTTP-SOAPVersion")) {
                    sc = mc.getSOAPConstants();
                    if (sc != null && sc instanceof SOAP12Constants) {
                        soapVersion = "SOAP 1.2";
                    }
                    m.setStringProperty("X-HTTP-SOAPVersion", soapVersion);
                }
                if (mepCorrelator != null) {
                    m.setStringProperty("X-WS-MessageExchangeCorrelator", mepCorrelator);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

