/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.ws;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutRequest;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.soap.SOAPUtils;
import com.sonicsw.net.http.soap.SoapHttpOutboundHandler;
import com.sonicsw.net.http.ws.AxisMessageContextApplier;
import com.sonicsw.net.http.ws.HTTPSender;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.net.http.ws.WSHttpOutResponse;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.AddressingFromJMSHandler;
import com.sonicsw.ws.axis.handlers.AddressingHandlerWrapper;
import com.sonicsw.ws.axis.handlers.AddressingToJMSHandler;
import com.sonicsw.ws.axis.handlers.ApplicationResponseHandler;
import com.sonicsw.ws.axis.handlers.LogHandler;
import com.sonicsw.ws.axis.handlers.NullifyRecorder;
import com.sonicsw.ws.axis.handlers.PolicyFromJMSHandler;
import com.sonicsw.ws.axis.handlers.PolicyFromOperationContextHandler;
import com.sonicsw.ws.axis.handlers.RMHandler;
import com.sonicsw.ws.axis.handlers.SOAPFixer;
import com.sonicsw.ws.axis.handlers.SecurityHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.msg.IMgram;

public class WSHttpOutboundHandler
extends SoapHttpOutboundHandler {
    private AxisClient m_axisEngine;
    private SimpleTargetedChain m_axisChain;
    private SimpleTargetedChain m_axisResendChain;
    private LogHandler m_logHandler = null;

    public WSHttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config) throws ConfigurationException, HttpServiceException {
        super(connectInfo, config, true);
        this.constructAxisEngine();
    }

    @Override
    public HttpOutRequest getHttpOutRequest(IMgram m) {
        return new WSHttpOutRequest();
    }

    @Override
    public HttpOutResponse getHttpOutResponse(IMgram m) {
        return new WSHttpOutResponse();
    }

    @Override
    public void sendMgram(IMgram mgram, Thread dispatchThread) {
        HttpLock lock = new HttpLock(610L);
        boolean responseAvailable = false;
        boolean isContentReply = this.isSyncRequest(mgram);
        lock.setContentReplyExpected(isContentReply);
        HttpOutRequest request = this.getHttpOutRequest(mgram);
        HttpOutResponse response = this.getHttpOutResponse(mgram);
        MessageContext mc = null;
        try {
            if (isContentReply && this.m_httpCC == null) {
                throw new HttpServiceException("Failed to authenticate reply-to user.");
            }
            request.buildRequest(mgram, this);
            mc = new MessageContext((AxisEngine)this.m_axisEngine);
            this.sendAxis(mc, request, response, this, lock, mgram);
            responseAvailable = false;
        }
        catch (HttpServiceException e) {
            BrokerComponent.getComponentContext().logMessage("Error processing HTTP Direct outbound request: ", (Throwable)e, BrokerComponent.getLevelWarning().intValue());
            responseAvailable = true;
            lock.setMessage(e.getClass().getName() + ", " + e.getMessage());
            lock.setError(612);
        }
        catch (MessageHandlingException e) {
            BrokerComponent.getComponentContext().logMessage("Error processing HTTP Direct outbound request: ", (Throwable)e, BrokerComponent.getLevelWarning().intValue());
            responseAvailable = true;
            lock.setError(610);
            lock.setMessage(e.getClass().getName() + ", " + e.getMessage());
        }
        catch (AxisFault af) {
            this.handleAxisFault(request, mgram, response, lock, mc, af);
            return;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage(t, BrokerComponent.getLevelWarning().intValue());
            responseAvailable = true;
            lock.setError(610);
            lock.setMessage(t.getClass().getName() + ", " + t.getMessage());
        }
        if (!responseAvailable) {
            return;
        }
        response.setResponseCode(lock.getErrorType());
        response.setResponseMessage(lock.getMessage());
        this.onResponse(lock, mgram, request, response);
    }

    private void handleAxisFault(HttpOutRequest request, IMgram m, HttpOutResponse response, HttpLock lock, MessageContext mc, AxisFault af) {
        String msg = null;
        msg = mc != null && mc.getPastPivot() ? "Error processing HTTP Direct outbound reply: " : "Error processing HTTP Direct outbound request: ";
        String fault = null;
        Message axisMessage = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants("SOAP 1.1"));
        try {
            SOAPFault soapFault = (SOAPFault)axisMessage.getSOAPBody().addFault();
            af.setFaultString(msg + af.getFaultString());
            soapFault.setFault(af);
            fault = axisMessage.getSOAPEnvelope().toString();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fault == null) {
            fault = af.dumpToString();
        }
        lock.setError(616);
        lock.setMessage(fault);
        response.setResponseCode(lock.getErrorType());
        response.setResponseMessage(lock.getMessage());
        String wscorr = null;
        if (mc != null) {
            wscorr = (String)mc.getProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR");
        }
        if (wscorr != null) {
            response.setProperty("X-WS-MessageExchangeCorrelator", wscorr);
        }
        this.onResponse(lock, m, request, response);
    }

    public void onResponse(HttpLock lock, IMgram mgram, HttpOutRequest request, HttpOutResponse response) {
        try {
            this.ackOrDmq(lock, mgram);
            ((WSHttpOutResponse)response).saveUndeliveredHeaders(request.getInvalidHeaders());
            this.handleResponse(lock, mgram, null, response);
        }
        catch (Throwable t) {
            HttpConstants.DEBUG(t, 0);
        }
    }

    private void constructAxisEngine() {
        if (DebugObjects.getProtocolDebug().getDebug()) {
            this.m_logHandler = new LogHandler(BrokerComponent.getBrokerComponent().getBrokerName() + ".wsoutbound.log");
        }
        SimpleChain requestChain = new SimpleChain();
        requestChain.addHandler((Handler)new NullifyRecorder());
        requestChain.addHandler((Handler)new PolicyFromJMSHandler());
        requestChain.addHandler((Handler)new AddressingFromJMSHandler());
        requestChain.addHandler((Handler)new RMHandler());
        requestChain.addHandler((Handler)new AddressingHandlerWrapper());
        requestChain.addHandler((Handler)new SOAPFixer());
        requestChain.addHandler((Handler)new SecurityHandler());
        if (this.m_logHandler != null) {
            requestChain.addHandler((Handler)this.m_logHandler);
        }
        SimpleChain responseChain = new SimpleChain();
        if (this.m_logHandler != null) {
            responseChain.addHandler((Handler)this.m_logHandler);
        }
        responseChain.addHandler((Handler)new PolicyFromOperationContextHandler());
        responseChain.addHandler((Handler)new SecurityHandler());
        responseChain.addHandler((Handler)new AddressingHandlerWrapper());
        responseChain.addHandler((Handler)new RMHandler());
        responseChain.addHandler((Handler)new AddressingToJMSHandler());
        responseChain.addHandler((Handler)new ApplicationResponseHandler());
        HTTPSender sender = new HTTPSender();
        this.m_axisChain = new SimpleTargetedChain((Handler)requestChain, (Handler)sender, (Handler)responseChain);
        this.m_axisChain.init();
        SimpleChain requestResendChain = new SimpleChain();
        RMHandler resendRMHandler = new RMHandler();
        resendRMHandler.reserveForResending();
        requestResendChain.addHandler((Handler)resendRMHandler);
        if (this.m_logHandler != null) {
            requestResendChain.addHandler((Handler)this.m_logHandler);
        }
        this.m_axisResendChain = new SimpleTargetedChain((Handler)requestResendChain, (Handler)sender, (Handler)responseChain);
        this.m_axisResendChain.init();
        this.m_axisEngine = new AxisClient();
    }

    public void sendAxis(MessageContext mc, HttpOutRequest request, HttpOutResponse response, HttpOutboundHandler handler, HttpLock lock, IMgram mg) throws AxisFault, SOAPException, IOException {
        mc.setProperty("enableNamespacePrefixOptimization", (Object)new Boolean(false));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Hashtable properties = request.getProperties();
        request.contentToStream(baos);
        SOAPConstants soapConstants = SOAPUtils.getSoapConstants(((WSHttpOutRequest)request).getSoapVersion());
        mc.setSOAPConstants(soapConstants);
        Message m = new Message((Object)baos.toString());
        SOAPEnvelope env = m.getSOAPEnvelope();
        SOAPBody b = (SOAPBody)env.getBody();
        Vector v = env.getHeaders();
        env.removeHeaders();
        for (int i = 0; i < v.size(); ++i) {
            env.addHeader((SOAPHeaderElement)v.elementAt(i));
        }
        if (b != null) {
            b.detachNode();
            env.setBody(b);
        }
        mc.setProperty("com.sonicsw.net.http.HttpOutRequest", (Object)request);
        mc.setProperty("com.sonicsw.net.http.HttpOutResponse", (Object)response);
        mc.setProperty("HTTP_OUT_REQUEST_PROPERTIES", (Object)properties);
        mc.setProperty("com.sonicsw.net.http.HttpOutboundHandler", (Object)handler);
        mc.setProperty("progress.message.msg.IMgram", (Object)mg);
        mc.setProperty("com.sonicsw.net.http.HttpLock", (Object)lock);
        mc.setMessage((SOAPMessage)m);
        this.sendAxis(mc);
    }

    public AxisClient getAxisClient() {
        return this.m_axisEngine;
    }

    public void resendAxis(MessageContext mc) throws AxisFault, SOAPException, IOException {
        this.sendAxis(this.m_axisResendChain, mc);
    }

    public void sendAxis(MessageContext mc) throws AxisFault, SOAPException, IOException {
        this.sendAxis(this.m_axisChain, mc);
    }

    public void sendAxis(SimpleTargetedChain chain, MessageContext mc) throws AxisFault, SOAPException, IOException {
        try {
            AxisMessageContextApplier.applyCurrentMessageContext(mc);
            chain.invoke(mc);
        }
        catch (AxisFault af) {
            if (mc.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") != af) {
                throw af;
            }
            DebugObjects.getHandlerDebug().debug("Fault Handled");
        }
    }
}

