/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import progress.message.util.StringUtil;

public class CipherSuiteInfo {
    private static final short CURRENT_VERSION = 0;
    private static final String PROVIDER_HEADER = " $P$ ";
    private static final String VERSION_HEADER = " $V$ ";
    private static final String CIPHER_HEADER = " $C$ ";
    private static final String DIGEST_HEADER = " $D$ ";
    private ArrayList m_providerPriorityList = new ArrayList();
    private HashMap m_providerVersionTable = new HashMap();
    private HashMap m_providerCipherTable = new HashMap();
    private HashMap m_providerDigestTable = new HashMap();

    public final ArrayList getProviders() {
        return this.m_providerPriorityList;
    }

    public final void setProvider(String provider, String version) {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal or inappropriate argument.");
        }
        provider = provider.trim();
        version = version.trim();
        if (!this.m_providerPriorityList.contains(provider)) {
            this.m_providerPriorityList.add(provider);
        }
        Object obj = this.m_providerVersionTable.get(provider);
        ArrayList versionList = new ArrayList();
        if (obj != null) {
            versionList = (ArrayList)obj;
            if (!versionList.contains(version)) {
                versionList.add(version);
                this.m_providerVersionTable.put(provider, versionList);
            }
        } else {
            versionList.add(version);
            this.m_providerVersionTable.put(provider, versionList);
        }
    }

    public final ArrayList getProviderVersions(String provider) {
        if (provider == null || provider.trim().length() == 0) {
            return null;
        }
        Object obj = this.m_providerVersionTable.get(provider = provider.trim());
        if (obj != null) {
            return (ArrayList)obj;
        }
        return null;
    }

    public final void setCipherInfo(String provider, String version, String transformation) throws IllegalArgumentException {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0 || transformation == null || transformation.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal or inappropriate argument.");
        }
        provider = provider.trim();
        version = version.trim();
        transformation = transformation.trim();
        this.setProvider(provider, version);
        String key = provider + version;
        Object obj = this.m_providerCipherTable.get(key);
        ArrayList cipherList = new ArrayList();
        if (obj != null) {
            cipherList = (ArrayList)obj;
            if (!cipherList.contains(transformation)) {
                cipherList.add(transformation);
                this.m_providerCipherTable.put(key, cipherList);
            }
        } else {
            cipherList.add(transformation);
            this.m_providerCipherTable.put(key, cipherList);
        }
    }

    public final ArrayList getCipherInfo(String provider, String version) {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0) {
            return null;
        }
        provider = provider.trim();
        version = version.trim();
        String key = provider + version;
        Object obj = this.m_providerCipherTable.get(key);
        if (obj != null) {
            return (ArrayList)obj;
        }
        return null;
    }

    public final String[] getTransformation(int index) {
        if (this.m_providerPriorityList == null || this.m_providerVersionTable == null || this.m_providerCipherTable == null) {
            return null;
        }
        int transformationPriority = -1;
        for (int i = 0; i < this.m_providerPriorityList.size(); ++i) {
            Object obj;
            String provider = (String)this.m_providerPriorityList.get(i);
            if (provider == null || (obj = this.m_providerVersionTable.get(provider)) == null) continue;
            ArrayList versionList = (ArrayList)obj;
            for (int j = 0; j < versionList.size(); ++j) {
                ArrayList cipherList;
                String version = (String)versionList.get(j);
                if (version == null || (cipherList = this.getCipherInfo(provider, version)) == null) continue;
                for (int k = 0; k < cipherList.size(); ++k) {
                    String transformation = (String)cipherList.get(k);
                    if (transformation == null || ++transformationPriority != index) continue;
                    String[] retval = new String[]{provider, version, transformation};
                    return retval;
                }
            }
        }
        return null;
    }

    public final void setDigestInfo(String provider, String version, String digest) throws IllegalArgumentException {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0 || digest == null || digest.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal or inappropriate argument.");
        }
        provider = provider.trim();
        version = version.trim();
        digest = digest.trim();
        this.setProvider(provider, version);
        String key = provider + version;
        Object obj = this.m_providerDigestTable.get(key);
        ArrayList digestList = new ArrayList();
        if (obj != null) {
            digestList = (ArrayList)obj;
            if (!digestList.contains(digest)) {
                digestList.add(digest);
                this.m_providerDigestTable.put(key, digestList);
            }
        } else {
            digestList.add(digest);
            this.m_providerDigestTable.put(key, digestList);
        }
    }

    public final ArrayList getDigestInfo(String provider, String version) {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0) {
            return null;
        }
        provider = provider.trim();
        version = version.trim();
        String key = provider + version;
        Object obj = this.m_providerDigestTable.get(key);
        if (obj != null) {
            return (ArrayList)obj;
        }
        return null;
    }

    public final String[] getDigest(int index) {
        if (this.m_providerPriorityList == null || this.m_providerVersionTable == null || this.m_providerDigestTable == null) {
            return null;
        }
        int digestPriority = -1;
        for (int i = 0; i < this.m_providerPriorityList.size(); ++i) {
            Object obj;
            String provider = (String)this.m_providerPriorityList.get(i);
            if (provider == null || (obj = this.m_providerVersionTable.get(provider)) == null) continue;
            ArrayList versionList = (ArrayList)obj;
            for (int j = 0; j < versionList.size(); ++j) {
                ArrayList digestList;
                String version = (String)versionList.get(j);
                if (version == null || (digestList = this.getDigestInfo(provider, version)) == null) continue;
                for (int k = 0; k < digestList.size(); ++k) {
                    String digest = (String)digestList.get(k);
                    if (digest == null || ++digestPriority != index) continue;
                    String[] retval = new String[]{provider, version, digest};
                    return retval;
                }
            }
        }
        return null;
    }

    public final boolean deleteProviders() {
        try {
            if (this.m_providerPriorityList != null) {
                ArrayList providerList = (ArrayList)this.m_providerPriorityList.clone();
                for (int i = 0; i < providerList.size(); ++i) {
                    String provider = (String)providerList.get(i);
                    this.deleteProvider(provider);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean deleteProvider(String provider) {
        if (provider == null || provider.trim().length() == 0) {
            return false;
        }
        try {
            provider = provider.trim();
            ArrayList providerList = (ArrayList)this.m_providerPriorityList.clone();
            if (providerList.contains(provider)) {
                HashMap versionMap = (HashMap)this.m_providerVersionTable.clone();
                Object obj = versionMap.get(provider);
                if (obj != null) {
                    ArrayList versionList = (ArrayList)obj;
                    for (int i = 0; i < versionList.size(); ++i) {
                        String key = provider + (String)versionList.get(i);
                        this.m_providerCipherTable.remove(key);
                        this.m_providerDigestTable.remove(key);
                    }
                    this.m_providerVersionTable.remove(provider);
                }
                this.m_providerPriorityList.remove(provider);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean deleteProvider(String provider, String version) {
        if (provider == null || provider.trim().length() == 0 || version == null || version.trim().length() == 0) {
            return false;
        }
        try {
            provider = provider.trim();
            version = version.trim();
            if (this.m_providerPriorityList.contains(provider)) {
                ArrayList versionList;
                this.m_providerPriorityList.remove(provider);
                Object obj = this.m_providerVersionTable.get(provider);
                if (obj != null && (versionList = (ArrayList)obj).contains(version)) {
                    String key = provider + version;
                    this.m_providerCipherTable.remove(key);
                    this.m_providerDigestTable.remove(key);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final byte[] writeBytes() throws IOException, UTFDataFormatException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(0);
        for (int i = 0; i < this.m_providerPriorityList.size(); ++i) {
            Object obj;
            String provider = (String)this.m_providerPriorityList.get(i);
            buffer.append(PROVIDER_HEADER);
            buffer.append(provider);
            if (!this.m_providerVersionTable.containsKey(provider) || (obj = this.m_providerVersionTable.get(provider)) == null) continue;
            ArrayList versionList = (ArrayList)obj;
            for (int j = 0; j < versionList.size(); ++j) {
                int k;
                Object obj2;
                String version = (String)versionList.get(j);
                if (version == null) continue;
                buffer.append(VERSION_HEADER);
                buffer.append(version);
                String compositeKey = provider + version;
                if (this.m_providerCipherTable.containsKey(compositeKey) && (obj2 = this.m_providerCipherTable.get(compositeKey)) != null) {
                    ArrayList cipherList = (ArrayList)obj2;
                    for (k = 0; k < cipherList.size(); ++k) {
                        String transformation = (String)cipherList.get(k);
                        if (transformation == null) continue;
                        buffer.append(CIPHER_HEADER);
                        buffer.append(transformation);
                    }
                }
                if (!this.m_providerDigestTable.containsKey(compositeKey) || (obj2 = this.m_providerDigestTable.get(compositeKey)) == null) continue;
                ArrayList digestList = (ArrayList)obj2;
                for (k = 0; k < digestList.size(); ++k) {
                    String digest = (String)digestList.get(k);
                    if (digest == null) continue;
                    buffer.append(DIGEST_HEADER);
                    buffer.append(digest);
                }
            }
        }
        return StringUtil.stringToUTF(buffer.toString());
    }

    public final void readBytes(byte[] utfData) throws IOException, UTFDataFormatException, IllegalArgumentException {
        if (utfData == null || utfData.length == 0) {
            throw new IllegalArgumentException("Illegal or inappropriate argument.");
        }
        String str = StringUtil.UTFToString(utfData, 0);
        int endPos = str.indexOf(PROVIDER_HEADER, 0);
        String token = str.substring(0, endPos);
        short classVersion = Short.parseShort(token);
        boolean readingProvider = false;
        boolean readingVersion = false;
        boolean readingCipher = false;
        boolean readingDigest = false;
        String provider = null;
        String version = null;
        String cipher = null;
        String digest = null;
        StringTokenizer st = new StringTokenizer(str.substring(endPos, str.length()));
        switch (classVersion) {
            case 0: {
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (readingProvider) {
                        provider = token;
                        readingProvider = false;
                        continue;
                    }
                    if (readingVersion) {
                        version = token;
                        if (provider != null && version != null) {
                            this.setProvider(provider, version);
                        }
                        readingVersion = false;
                        continue;
                    }
                    if (readingCipher) {
                        cipher = token;
                        if (provider != null && version != null && cipher != null) {
                            this.setCipherInfo(provider, version, cipher);
                        }
                        cipher = null;
                        readingCipher = false;
                        continue;
                    }
                    if (readingDigest) {
                        digest = token;
                        if (provider != null && version != null && digest != null) {
                            this.setDigestInfo(provider, version, digest);
                        }
                        digest = null;
                        readingDigest = false;
                        continue;
                    }
                    if (token.equals(PROVIDER_HEADER.trim())) {
                        readingProvider = true;
                        provider = null;
                        version = null;
                        cipher = null;
                        digest = null;
                        continue;
                    }
                    if (token.equals(VERSION_HEADER.trim())) {
                        readingVersion = true;
                        version = null;
                        cipher = null;
                        digest = null;
                        continue;
                    }
                    if (token.equals(CIPHER_HEADER.trim())) {
                        readingCipher = true;
                        cipher = null;
                        digest = null;
                        continue;
                    }
                    if (!token.equals(DIGEST_HEADER.trim())) continue;
                    readingDigest = true;
                    cipher = null;
                    digest = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal or inappropriate argument.");
            }
        }
    }

    public final String verbose() {
        StringBuffer retValue = new StringBuffer();
        return null;
    }

    public static final void main(String[] args) {
    }

    public final byte[] writeBytesWithoutKeySize() throws IOException, UTFDataFormatException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(0);
        for (int i = 0; i < this.m_providerPriorityList.size(); ++i) {
            Object obj;
            String provider = (String)this.m_providerPriorityList.get(i);
            buffer.append(PROVIDER_HEADER);
            buffer.append(provider);
            if (!this.m_providerVersionTable.containsKey(provider) || (obj = this.m_providerVersionTable.get(provider)) == null) continue;
            ArrayList versionList = (ArrayList)obj;
            for (int j = 0; j < versionList.size(); ++j) {
                int k;
                Object obj2;
                String version = (String)versionList.get(j);
                if (version == null) continue;
                buffer.append(VERSION_HEADER);
                buffer.append(version);
                String compositeKey = provider + version;
                if (this.m_providerCipherTable.containsKey(compositeKey) && (obj2 = this.m_providerCipherTable.get(compositeKey)) != null) {
                    ArrayList cipherList = (ArrayList)obj2;
                    for (k = 0; k < cipherList.size(); ++k) {
                        String s;
                        String transformation = (String)cipherList.get(k);
                        if (transformation == null) continue;
                        buffer.append(CIPHER_HEADER);
                        String cipher = s = transformation;
                        boolean keySize = false;
                        int pos = 0;
                        int count = 0;
                        while (pos != -1) {
                            if ((pos = s.indexOf("/", pos + 1)) == -1) continue;
                            ++count;
                        }
                        if (count == 3) {
                            transformation = s.substring(0, s.lastIndexOf("/"));
                        }
                        buffer.append(transformation);
                    }
                }
                if (!this.m_providerDigestTable.containsKey(compositeKey) || (obj2 = this.m_providerDigestTable.get(compositeKey)) == null) continue;
                ArrayList digestList = (ArrayList)obj2;
                for (k = 0; k < digestList.size(); ++k) {
                    String digest = (String)digestList.get(k);
                    if (digest == null) continue;
                    buffer.append(DIGEST_HEADER);
                    buffer.append(digest);
                }
            }
        }
        return StringUtil.stringToUTF(buffer.toString());
    }
}

