/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.pcs;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.ListIterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import progress.message.client.ESecurityGeneralException;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.CryptoInfo;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.IMessageProtection;

public final class PluggableMessageProtection
implements IMessageProtection {
    private static boolean DEBUG_ALL = false;
    private static boolean DEBUG_MAC = false;
    private static boolean DEBUG_MKEY_ENCRYPTION = false;
    private static boolean DEBUG_SKEY_ENCRYPTION = false;
    private String m_digestAlgorithm;
    private int m_hashLength;
    private String m_cipherTransformation;
    private String m_cipherAlgorithm;
    private int m_encodedSecretKeyLengthInBytes;
    public int m_blockSize;
    private Cipher m_cipher = null;
    private Cipher m_encyptionCipher = null;
    private Key m_key = null;
    private MessageDigest m_digest = null;
    private byte[] m_pad_1;
    private byte[] m_pad_2;
    private byte[] m_tempMacBuffer = null;

    public PluggableMessageProtection() throws EInvalidCipherSuiteException {
        this.m_cipherTransformation = AbstractCipherSuite.s_cipherTransformation;
        this.m_cipherAlgorithm = AbstractCipherSuite.s_cipherAlgorithm;
        this.m_encodedSecretKeyLengthInBytes = AbstractCipherSuite.m_encodedSecretKeyLengthInBytes;
        this.m_blockSize = AbstractCipherSuite.m_blockSize;
        this.m_digestAlgorithm = AbstractCipherSuite.s_digestAlgorithm;
        this.m_hashLength = AbstractCipherSuite.m_hashLength;
        try {
            this.m_digest = MessageDigest.getInstance(this.m_digestAlgorithm);
            this.initMAC();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException("NoSuchAlgorithmException. Cannot create a MessageDigest. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    public PluggableMessageProtection(IPluggableCipherSuite cipherSuite) throws EInvalidCipherSuiteException {
        this.m_cipherTransformation = cipherSuite.getCipherTransformation();
        this.m_cipherAlgorithm = cipherSuite.getCipherAlgorithm();
        this.m_encodedSecretKeyLengthInBytes = cipherSuite.getEncodedSecretKeyLengthInBytes();
        this.m_blockSize = cipherSuite.getBlockSize();
        this.m_digestAlgorithm = cipherSuite.getDigestAlgorithm();
        this.m_hashLength = cipherSuite.getHashLength();
        try {
            this.m_digest = MessageDigest.getInstance(this.m_digestAlgorithm);
            this.initMAC();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException("NoSuchAlgorithmException. Cannot create a MessageDigest. " + ex.getMessage(), ex);
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage(), ex);
        }
    }

    @Override
    public final boolean isSonicCipherSuite() {
        return false;
    }

    @Override
    public final void init(int operation, byte[] sessionKey) {
        block12: {
            SecretKey key = null;
            try {
                if (this.m_cipherAlgorithm.equalsIgnoreCase("DES") || this.m_cipherAlgorithm.equalsIgnoreCase("DESEDE") || this.m_cipherAlgorithm.equalsIgnoreCase("AES") || this.m_cipherAlgorithm.equalsIgnoreCase("Blowfish")) {
                    key = this.keygen(this.m_cipherAlgorithm, sessionKey);
                } else {
                    SecretKeySpec keySpec = new SecretKeySpec(sessionKey, this.m_cipherAlgorithm);
                    key = keySpec;
                }
            }
            catch (Exception ex) {
                throw new EAssertFailure(ex);
            }
            this.m_key = key;
            try {
                if (operation == 1) {
                    this.m_cipher = AbstractCipherSuite.getNewCipherInstance(this.m_cipherTransformation);
                    if (AbstractCipherSuite.isCipherModeECB()) {
                        this.m_cipher.init(1, key);
                    } else {
                        this.m_cipher.init(1, (Key)key, AbstractCipherSuite.getAlgorithmParameterSpec(sessionKey, 0, sessionKey.length));
                    }
                    break block12;
                }
                if (operation == 2) {
                    this.m_cipher = AbstractCipherSuite.getNewCipherInstance(this.m_cipherTransformation);
                    this.m_encyptionCipher = AbstractCipherSuite.getNewCipherInstance(this.m_cipherTransformation);
                    if (AbstractCipherSuite.isCipherModeECB()) {
                        this.m_cipher.init(2, key);
                        this.m_encyptionCipher.init(1, key);
                    } else {
                        this.m_cipher.init(2, (Key)key, AbstractCipherSuite.getAlgorithmParameterSpec(sessionKey, 0, sessionKey.length));
                        this.m_encyptionCipher.init(1, (Key)key, AbstractCipherSuite.getAlgorithmParameterSpec(sessionKey, 0, sessionKey.length));
                    }
                    break block12;
                }
                String mf99 = prAccessor.getString("STR034");
                Object[] ob99 = new Object[]{Integer.toString(operation)};
                throw new EAssertFailure(MessageFormat.format(mf99, ob99));
            }
            catch (Exception ex) {
                throw new EAssertFailure(ex);
            }
        }
    }

    private SecretKey keygen(String algorithm, byte[] secret) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        SecretKey key = null;
        SecretKeyFactory keyFactory = null;
        byte[] keyBytes = new byte[AbstractCipherSuite.m_encodedSecretKeyLengthInBytes];
        System.arraycopy(secret, 0, keyBytes, 0, keyBytes.length);
        if (algorithm.equalsIgnoreCase("DES")) {
            DESKeySpec keySpec = new DESKeySpec(keyBytes);
            keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            key = secretKey;
        } else if (algorithm.equalsIgnoreCase("DESEDE")) {
            DESedeKeySpec keySpec = new DESedeKeySpec(keyBytes);
            keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            key = secretKey;
        } else {
            SecretKeySpec keySpec;
            key = keySpec = new SecretKeySpec(keyBytes, algorithm);
        }
        return key;
    }

    private void initMAC() {
        int padsize = 64 - this.m_hashLength;
        this.m_pad_1 = new byte[padsize];
        this.m_pad_2 = new byte[padsize];
        for (int i = 0; i < padsize; ++i) {
            this.m_pad_1[i] = 54;
            this.m_pad_2[i] = 92;
        }
        this.m_tempMacBuffer = new byte[this.m_hashLength];
    }

    @Override
    public final int getSecretKeyLength() {
        return this.m_encodedSecretKeyLengthInBytes;
    }

    @Override
    public final byte[] generateSessionKey(byte[] masterSecret, int bits) {
        byte[] sessionKey = new byte[this.m_encodedSecretKeyLengthInBytes];
        int pos = 0;
        int emptyBytes = sessionKey.length;
        while (emptyBytes > 0) {
            int len = emptyBytes > masterSecret.length ? masterSecret.length : emptyBytes;
            System.arraycopy(masterSecret, 0, sessionKey, pos, len);
            emptyBytes -= len;
            pos += len;
        }
        return sessionKey;
    }

    @Override
    public final byte[] generateDigestKey(byte[] masterSecret) {
        if (masterSecret.length < this.m_encodedSecretKeyLengthInBytes * 2) {
            byte[] b = new byte[this.m_encodedSecretKeyLengthInBytes * 2];
            System.arraycopy(masterSecret, 0, b, 0, masterSecret.length);
            int destPos = masterSecret.length;
            for (int remainder = b.length - masterSecret.length; remainder > 0; remainder -= masterSecret.length) {
                if (remainder < masterSecret.length) {
                    System.arraycopy(masterSecret, 0, b, destPos, remainder);
                    break;
                }
                System.arraycopy(masterSecret, 0, b, destPos, masterSecret.length);
                destPos += masterSecret.length;
            }
            masterSecret = b;
        }
        byte[] digestKey = new byte[this.m_encodedSecretKeyLengthInBytes];
        System.arraycopy(masterSecret, this.m_encodedSecretKeyLengthInBytes, digestKey, 0, this.m_encodedSecretKeyLengthInBytes);
        return digestKey;
    }

    @Override
    public final int encrypt(byte[] key, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        throw new ESecurityGeneralException("This operation is not supported for PluggableMessageProtection class.");
    }

    @Override
    public final synchronized byte[] encrypt(byte[] rawKey, CryptoInfoLinkedList cryptoInfoList) throws ESecurityGeneralException {
        byte[] extraBytes = null;
        SecretKey key = null;
        try {
            if (this.m_cipherAlgorithm.equalsIgnoreCase("DES") || this.m_cipherAlgorithm.equalsIgnoreCase("DESEDE") || this.m_cipherAlgorithm.equalsIgnoreCase("AES") || this.m_cipherAlgorithm.equalsIgnoreCase("Blowfish")) {
                key = this.keygen(this.m_cipherAlgorithm, rawKey);
            } else {
                SecretKeySpec keySpec = new SecretKeySpec(rawKey, this.m_cipherAlgorithm);
                key = keySpec;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException("NoSuchAlgorithmException. Cannot create right key for Cipher. " + ex.getMessage());
        }
        catch (InvalidKeyException ex) {
            throw new EInvalidCipherSuiteException("InvalidKeyException. Key generation error. " + ex.getMessage());
        }
        catch (InvalidKeySpecException ex) {
            throw new EInvalidCipherSuiteException("InvalidKeySpecException. Key generation error. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
        Cipher cipher = null;
        try {
            cipher = AbstractCipherSuite.getNewCipherInstance(this.m_cipherTransformation);
            if (AbstractCipherSuite.isCipherModeECB()) {
                cipher.init(1, key);
            } else {
                cipher.init(1, (Key)key, AbstractCipherSuite.getAlgorithmParameterSpec(rawKey, 0, rawKey.length));
            }
        }
        catch (InvalidKeyException ex) {
            throw new ESecurityGeneralException("InvalidKeyException. Wrong key/key type used init the cipher. " + ex.getMessage());
        }
        catch (GeneralSecurityException ex) {
            throw new EInvalidCipherSuiteException("GeneralSecurityException. " + ex.getMessage());
        }
        try {
            int inputLen = 0;
            ListIterator cryptoInfoIterator = cryptoInfoList.listIterator();
            while (cryptoInfoIterator.hasNext()) {
                Object item = cryptoInfoIterator.next();
                if (item == null) continue;
                CryptoInfo info = (CryptoInfo)item;
                inputLen += info.getMessageLength();
            }
            int outputLen = cipher.getOutputSize(inputLen);
            int outputOffset = 0;
            byte[] output = new byte[outputLen];
            cryptoInfoIterator = cryptoInfoList.listIterator();
            int totalBytesStored = 0;
            while (cryptoInfoIterator.hasNext()) {
                Object item = cryptoInfoIterator.next();
                if (item == null) continue;
                CryptoInfo info = (CryptoInfo)item;
                int bytesStored = cipher.update(info.getBuffer(), info.getOffset(), info.getMessageLength(), output, outputOffset);
                totalBytesStored += bytesStored;
                outputOffset += bytesStored;
            }
            int lastBlocksize = cipher.doFinal(output, outputOffset);
            totalBytesStored += lastBlocksize;
            extraBytes = this.refillCryptInfo(cryptoInfoList, output, 0, output.length);
            return extraBytes;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (ShortBufferException ex) {
            throw new ESecurityGeneralException("ShortBufferException. Output buffer too short. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    private byte[] refillCryptInfo(CryptoInfoLinkedList cryptoInfoList, byte[] src, int srcOffset, int srcLen) {
        int srcLenRemainingToProcess = srcLen - srcOffset;
        int srcPos = 0;
        ListIterator cryptoInfoIterator = cryptoInfoList.listIterator();
        while (cryptoInfoIterator.hasNext()) {
            byte[] buffer;
            Object item = cryptoInfoIterator.next();
            byte[] dataToCopy = null;
            if (item == null || srcLenRemainingToProcess <= 0) continue;
            CryptoInfo info = (CryptoInfo)item;
            int lenToCopy = info.getMessageLength();
            if (srcLenRemainingToProcess >= lenToCopy) {
                dataToCopy = new byte[lenToCopy];
                System.arraycopy(src, srcPos, dataToCopy, 0, lenToCopy);
                srcPos += lenToCopy;
                srcLenRemainingToProcess -= lenToCopy;
                buffer = info.getBuffer();
                System.arraycopy(dataToCopy, 0, buffer, info.getOffset(), dataToCopy.length);
                info.setBuffer(buffer, info.getOffset(), dataToCopy.length);
                continue;
            }
            if (srcLenRemainingToProcess >= lenToCopy) continue;
            dataToCopy = new byte[srcLenRemainingToProcess];
            System.arraycopy(src, srcPos, dataToCopy, 0, srcLenRemainingToProcess);
            srcPos += srcLenRemainingToProcess;
            buffer = info.getBuffer();
            int newSize = buffer.length - (info.getMessageLength() - srcLenRemainingToProcess);
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(buffer, 0, newBuffer, 0, info.getOffset());
            System.arraycopy(dataToCopy, 0, newBuffer, info.getOffset(), dataToCopy.length);
            System.arraycopy(buffer, info.getOffset() + info.getMessageLength(), newBuffer, info.getOffset() + dataToCopy.length, buffer.length - info.getOffset() - info.getMessageLength());
            info.setBuffer(newBuffer, info.getOffset(), dataToCopy.length);
            srcLenRemainingToProcess = 0;
        }
        byte[] extraBytes = null;
        if (srcLenRemainingToProcess > 0) {
            extraBytes = new byte[srcLenRemainingToProcess];
            System.arraycopy(src, srcPos, extraBytes, 0, srcLenRemainingToProcess);
        }
        return extraBytes;
    }

    private void refillAllIntoCryptInfo(CryptoInfoLinkedList cryptoInfoList, byte[] extraBytes) {
    }

    @Override
    public final synchronized int encryptWithSessionKey(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        try {
            int count = this.m_cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
            return count;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (ShortBufferException ex) {
            throw new ESecurityGeneralException("ShortBufferException. Output buffer too short. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    @Override
    public final int decrypt(byte[] key, byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        throw new ESecurityGeneralException("This operation is not supported for PluggableMessageProtection class.");
    }

    @Override
    public final synchronized void decrypt(byte[] rawKey, CryptoInfoLinkedList cryptoInfoList) throws ESecurityGeneralException {
        SecretKey key = null;
        try {
            if (this.m_cipherAlgorithm.equalsIgnoreCase("DES") || this.m_cipherAlgorithm.equalsIgnoreCase("DESEDE") || this.m_cipherAlgorithm.equalsIgnoreCase("AES") || this.m_cipherAlgorithm.equalsIgnoreCase("Blowfish")) {
                key = this.keygen(this.m_cipherAlgorithm, rawKey);
            } else {
                SecretKeySpec keySpec = new SecretKeySpec(rawKey, this.m_cipherAlgorithm);
                key = keySpec;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EInvalidCipherSuiteException("NoSuchAlgorithmException. Cannot create right key for Cipher. " + ex.getMessage());
        }
        catch (InvalidKeyException ex) {
            throw new EInvalidCipherSuiteException("InvalidKeyException. Key generation error. " + ex.getMessage());
        }
        catch (InvalidKeySpecException ex) {
            throw new EInvalidCipherSuiteException("InvalidKeySpecException. Key generation error. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
        Cipher cipher = null;
        try {
            cipher = AbstractCipherSuite.getNewCipherInstance(this.m_cipherTransformation);
            if (AbstractCipherSuite.isCipherModeECB()) {
                cipher.init(2, key);
            } else {
                cipher.init(2, (Key)key, AbstractCipherSuite.getAlgorithmParameterSpec(rawKey, 0, rawKey.length));
            }
        }
        catch (InvalidKeyException ex) {
            throw new ESecurityGeneralException("InvalidKeyException. Wrong key/key type used init the cipher. " + ex.getMessage());
        }
        catch (GeneralSecurityException ex) {
            throw new EInvalidCipherSuiteException("GeneralSecurityException. " + ex.getMessage());
        }
        try {
            int inputLen = 0;
            ListIterator cryptoInfoIterator = cryptoInfoList.listIterator();
            while (cryptoInfoIterator.hasNext()) {
                Object item = cryptoInfoIterator.next();
                if (item == null) continue;
                CryptoInfo info = (CryptoInfo)item;
                inputLen += info.getMessageLength();
            }
            int outputLen = cipher.getOutputSize(inputLen);
            int outputOffset = 0;
            byte[] output = new byte[outputLen];
            cryptoInfoIterator = cryptoInfoList.listIterator();
            int totalBytesStored = 0;
            while (cryptoInfoIterator.hasNext()) {
                Object item = cryptoInfoIterator.next();
                if (item == null) continue;
                CryptoInfo info = (CryptoInfo)item;
                int bytesStored = cipher.update(info.getBuffer(), info.getOffset(), info.getMessageLength(), output, outputOffset);
                totalBytesStored += bytesStored;
                outputOffset += bytesStored;
            }
            int lastBlocksize = cipher.doFinal(output, outputOffset);
            byte[] extraBytes = this.refillCryptInfo(cryptoInfoList, output, 0, totalBytesStored += lastBlocksize);
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (ShortBufferException ex) {
            throw new ESecurityGeneralException("ShortBufferException. Output buffer too short. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    @Override
    public final synchronized int decryptWithSessionKey(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ESecurityGeneralException {
        try {
            int count = this.m_cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
            return count;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (ShortBufferException ex) {
            throw new ESecurityGeneralException("ShortBufferException. Output buffer too short. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    @Override
    public final synchronized int getOutputSize(int inputSize) {
        Cipher encryptionCipher = this.m_encyptionCipher;
        if (encryptionCipher == null) {
            encryptionCipher = this.m_cipher;
        }
        int outputSize = 0;
        outputSize = encryptionCipher.getOutputSize(inputSize);
        return outputSize;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    @Override
    public final synchronized int digest(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int outputLen) throws ESecurityGeneralException {
        this.m_digest.update(input, inputOffset, inputLen);
        int noOfBytes = 0;
        try {
            noOfBytes = this.m_digest.digest(output, outputOffset, outputLen);
        }
        catch (DigestException ex) {
            throw new ESecurityGeneralException("DigestException. Unable to digest the buffer. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
        return noOfBytes;
    }

    @Override
    public final synchronized int mac(byte[] keyBuffer, int keyOffset, int keyLength, byte[] messageBuffer, int messageOffset, int messageLength, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        int noOfBytes = 0;
        try {
            this.m_digest.update(keyBuffer, keyOffset, keyLength);
            this.m_digest.update(this.m_pad_1, 0, this.m_pad_1.length);
            this.m_digest.update(messageBuffer, messageOffset, messageLength);
            noOfBytes = this.m_digest.digest(this.m_tempMacBuffer, 0, this.m_hashLength);
            this.m_digest.update(keyBuffer, keyOffset, keyLength);
            this.m_digest.update(this.m_pad_2, 0, this.m_pad_2.length);
            this.m_digest.update(this.m_tempMacBuffer, 0, this.m_hashLength);
            noOfBytes = this.m_digest.digest(macBuffer, macOffset, macLength);
        }
        catch (DigestException ex) {
            throw new ESecurityGeneralException("DigestException. Unable to digest the buffer. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
        return noOfBytes;
    }

    @Override
    public final synchronized int mac(byte[] keyBuffer, int keyOffset, int keyLength, CryptoInfoLinkedList cryptoInfo, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        CryptoInfo info;
        int noOfBytes = 0;
        this.m_digest.update(keyBuffer, keyOffset, keyLength);
        this.m_digest.update(this.m_pad_1, 0, this.m_pad_1.length);
        while ((info = cryptoInfo.removeFirst()) != null) {
            this.m_digest.update(info.getBuffer(), info.getOffset(), info.getMessageLength());
        }
        try {
            noOfBytes = this.m_digest.digest(this.m_tempMacBuffer, 0, this.m_hashLength);
        }
        catch (DigestException ex) {
            throw new ESecurityGeneralException("DigestException. Unable to digest the buffer. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
        this.m_digest.update(keyBuffer, keyOffset, keyLength);
        this.m_digest.update(this.m_pad_2, 0, this.m_pad_2.length);
        this.m_digest.update(this.m_tempMacBuffer, 0, this.m_hashLength);
        try {
            noOfBytes = this.m_digest.digest(macBuffer, macOffset, macLength);
        }
        catch (DigestException ex) {
            throw new ESecurityGeneralException("DigestException. Unable to digest the buffer. " + ex.getMessage(), ex);
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage(), ex);
        }
        return noOfBytes;
    }

    @Override
    public final synchronized boolean verifyMac(byte[] keyBuffer, int keyOffset, int keyLength, byte[] messageBuffer, int messageOffset, int messageLength, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        this.mac(keyBuffer, keyOffset, keyLength, messageBuffer, messageOffset, messageLength, this.m_tempMacBuffer, 0, this.m_hashLength);
        boolean ret = true;
        for (int i = 0; i < this.m_hashLength; ++i) {
            if (macBuffer[macOffset + i] == this.m_tempMacBuffer[i]) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    public final synchronized boolean verifyMac(byte[] keyBuffer, int keyOffset, int keyLength, CryptoInfoLinkedList macStack, byte[] macBuffer, int macOffset, int macLength) throws ESecurityGeneralException {
        this.mac(keyBuffer, keyOffset, keyLength, macStack, this.m_tempMacBuffer, 0, this.m_hashLength);
        boolean ret = true;
        for (int i = 0; i < this.m_hashLength; ++i) {
            if (macBuffer[macOffset + i] == this.m_tempMacBuffer[i]) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    public final int getHashSize() {
        return this.m_hashLength;
    }

    byte[] update(byte[] input, int offset, int len) {
        byte[] output = this.m_cipher.update(input, offset, len);
        return output;
    }

    byte[] update(Cipher cipher, byte[] input, int offset, int len) {
        byte[] output = cipher.update(input, offset, len);
        return output;
    }

    byte[] doFinal(byte[] input, int offset, int len) throws ESecurityGeneralException {
        try {
            byte[] output = this.m_cipher.doFinal(input, offset, len);
            return output;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    byte[] doFinal(Cipher cipher, byte[] input, int offset, int len) throws ESecurityGeneralException {
        try {
            byte[] output = cipher.doFinal(input, offset, len);
            return output;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    byte[] doFinal() throws ESecurityGeneralException {
        try {
            byte[] output = this.m_cipher.doFinal();
            return output;
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("Bad padding. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    byte[] doFinal(Cipher cipher) throws ESecurityGeneralException {
        try {
            byte[] output = cipher.doFinal();
            return output;
        }
        catch (IllegalStateException ex) {
            throw new ESecurityGeneralException("IllegalStateException. " + ex.getMessage());
        }
        catch (IllegalBlockSizeException ex) {
            throw new ESecurityGeneralException("IllegalBlockSizeException. Bad block size. " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new ESecurityGeneralException("BadPaddingException. Bad padding. " + ex.getMessage());
        }
        catch (SecurityException ex) {
            throw new EInvalidCipherSuiteException("SecurityException. " + ex.getMessage());
        }
    }

    public static final void main(String[] args) {
    }

    private void testRefillOutputIntoCryptInfo(boolean verbose) {
    }

    private void testEncryptDecrypt_CryptoInfoLinkedList(boolean verbose) {
    }

    private void testGenerateDigestKey(boolean verbose) {
    }

    private void testGenerateSessionKey(boolean verbose) {
    }

    private CryptoInfoLinkedList createSendCryptoInfoLinkedList() {
        return null;
    }

    private CryptoInfoLinkedList createReceiveCryptoInfoLinkedList() {
        return null;
    }
}

