/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import com.sonicsw.security.ssl.JSSEConfig;
import com.sonicsw.security.ssl.SSLUtil;
import com.sonicsw.security.ssl.X509KeyManagerClientImpl;
import com.sonicsw.security.ssl.X509KeyManagerServerImpl;
import com.sonicsw.security.ssl.X509KeyManagerWrapper;
import com.sonicsw.security.ssl.X509TrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.jms.JMSSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.net.ssl.jsse.jsseSSLControl;
import progress.message.zclient.SessionConfig;

public final class JSSEConfigManager
implements JSSEConfig {
    private Object m_properties;
    private boolean m_debugFlag = false;
    private KeyManager[] m_keyManagers;
    private TrustManager[] m_trustManagers;
    private jsseSSLControl m_control;
    private boolean m_useKeyStoreFromPKCS = false;

    public JSSEConfigManager(Object properties, boolean isSSLServerSocket, boolean debugFlag, jsseSSLControl control) throws JMSSecurityException {
        this.m_properties = properties;
        this.m_debugFlag = debugFlag;
        this.m_control = control;
        String trustManagerAlgorithem = TrustManagerFactory.getDefaultAlgorithm();
        String keyManagerAlgorithem = KeyManagerFactory.getDefaultAlgorithm();
        String keyStoreLocation = null;
        String keyStoreType = null;
        String keyStorePassword = null;
        String trustStoreLocation = null;
        String trustStoreType = null;
        String trustStorePassword = null;
        String customTrustManagerClass = null;
        String customKeyManagerClass = null;
        Boolean isClientAuthentication = null;
        String keyAlias = null;
        String keyPassword = null;
        if (isSSLServerSocket) {
            keyAlias = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_ALIAS", null);
            if (keyAlias == null) {
                keyAlias = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreServerAlias", null);
            }
            if ((keyPassword = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_KEY_PASSWORD", null)) == null) {
                keyPassword = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreKeyPassword", null);
            }
        } else if (SessionConfig.IN_BROKER) {
            keyAlias = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_ALIAS", null);
            if (keyAlias == null) {
                keyAlias = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreServerAlias", null);
            }
            if ((keyPassword = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_KEY_PASSWORD", null)) == null) {
                keyPassword = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreKeyPassword", null);
            }
        } else {
            keyAlias = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreClientAlias", null);
            keyPassword = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyStoreKeyPassword", null);
        }
        if ((keyStoreLocation = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_LOCATION", null)) == null) {
            keyStoreLocation = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.keyStore", null);
        }
        if ((keyStoreType = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_TYPE", null)) == null) {
            keyStoreType = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.keyStoreType", JSSEConfig.JSSE_KEYSTORE_TYPE_VALID_VALUES.get(0));
        }
        if ((keyStorePassword = SSLUtil.getProperty(this.m_properties, "JSSE_KEYSTORE_PASSWORD", null)) == null) {
            keyStorePassword = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.keyStorePassword", "");
        }
        if ((trustStoreLocation = SSLUtil.getProperty(this.m_properties, "JSSE_TRUSTSTORE_LOCATION", null)) == null) {
            trustStoreLocation = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.trustStore", null);
        }
        if ((trustStoreType = SSLUtil.getProperty(this.m_properties, "JSSE_TRUSTSTORE_TYPE", null)) == null) {
            trustStoreType = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.trustStoreType", JSSEConfig.JSSE_TRUSTSTORE_TYPE_VALID_VALUES.get(0));
        }
        if ((trustStorePassword = SSLUtil.getProperty(this.m_properties, "JSSE_TRUSTSTORE_PASSWORD", null)) == null) {
            trustStorePassword = SSLUtil.getProperty(this.m_properties, "javax.net.ssl.trustStorePassword", "");
        }
        if ((customTrustManagerClass = SSLUtil.getProperty(this.m_properties, "JSSE_TRUSTMANAGER", null)) == null) {
            customTrustManagerClass = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.trustManager", null);
        }
        if ((customKeyManagerClass = SSLUtil.getProperty(this.m_properties, "JSSE_KEYMANAGER", null)) == null) {
            customKeyManagerClass = SSLUtil.getProperty(this.m_properties, "sonic.mq.ssl.keyManager", null);
        }
        isClientAuthentication = SSLUtil.getBooleanProperty(this.m_properties, "SSL_CLIENT_AUTHENTICATION", Boolean.FALSE);
        if (debugFlag) {
            System.out.println("key store url: " + keyStoreLocation);
            System.out.println("key store type: " + keyStoreType);
            System.out.println("key store password: " + keyStorePassword);
            String serverOrClient = isSSLServerSocket ? "server" : "client";
            System.out.println("key store " + serverOrClient + " alias: " + keyAlias);
            System.out.println("key store " + serverOrClient + " key password: " + keyPassword);
            System.out.println("trust store url: " + trustStoreLocation);
            System.out.println("trust store type: " + trustStoreType);
            System.out.println("trust store password: " + trustStorePassword);
            System.out.println("custom key manager class: " + customKeyManagerClass);
            System.out.println("KeyManagerFactory.getDefaultAlgorithm(): " + keyManagerAlgorithem);
            System.out.println("custom trust manager class: " + customTrustManagerClass);
            System.out.println("TrustManagerFactory.getDefaultAlgorithm(): " + trustManagerAlgorithem);
            if (isSSLServerSocket) {
                System.out.println("is client authentication required: " + isClientAuthentication);
            }
        }
        KeyStore keyStore = this.createKeyStore(keyStoreLocation, keyStoreType, keyStorePassword);
        if (this.m_useKeyStoreFromPKCS) {
            keyStorePassword = this.m_control.getKeyStorePassword();
            keyAlias = this.m_control.getKeyStoreAlias();
        }
        this.m_keyManagers = this.createKeyManager(customKeyManagerClass, keyManagerAlgorithem, keyStore, keyStorePassword, keyAlias, keyPassword, isSSLServerSocket);
        KeyStore trustStore = this.createTrustStore(trustStoreLocation, trustStoreType, trustStorePassword);
        this.m_trustManagers = this.createTrustManager(customTrustManagerClass, trustManagerAlgorithem, trustStore, trustStorePassword);
    }

    public TrustManager[] getTrustManagers() {
        return this.m_trustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.m_keyManagers;
    }

    private KeyStore createTrustStore(String trustStoreLocation, String trustStoreType, String trustStorePassword) throws JMSSecurityException {
        KeyStore trustStore = null;
        if (trustStoreLocation != null && trustStoreLocation.trim().length() > 0) {
            InputStream storeInputStream = null;
            try {
                storeInputStream = this.getStoreInputStream(trustStoreLocation.trim());
                trustStore = KeyStore.getInstance(trustStoreType);
                trustStore.load(storeInputStream, trustStorePassword.toCharArray());
            }
            catch (Exception e) {
                if (this.m_debugFlag) {
                    e.printStackTrace();
                }
                throw JMSExceptionUtil.createJMSSecurityException(e);
            }
            finally {
                block13: {
                    if (storeInputStream != null) {
                        try {
                            storeInputStream.close();
                        }
                        catch (IOException e) {
                            if (!this.m_debugFlag) break block13;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.m_control.getTrustStore() != null) {
            trustStore = this.m_control.getTrustStore();
        }
        return trustStore;
    }

    private TrustManager[] createTrustManager(String customTrustManagerClass, String trustManagerAlgorithem, KeyStore trustStore, String trustStorePassword) throws JMSSecurityException {
        if (customTrustManagerClass != null && customTrustManagerClass.trim().length() > 0) {
            try {
                Class<?> c = Class.forName(customTrustManagerClass.trim());
                TrustManager tm = (TrustManager)c.newInstance();
                if (tm instanceof X509TrustManager) {
                    // empty if block
                }
                this.m_trustManagers = new TrustManager[]{tm};
            }
            catch (ClassCastException e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException(customTrustManagerClass.trim() + " " + prAccessor.getString("CLASS_CAST_ERROR") + "TrustManager", -2001, e);
            }
            catch (ClassNotFoundException e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException("TrustManager" + prAccessor.getString("CLASS_NOT_FOUND"), -2000, e);
            }
            catch (InstantiationException e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException("TrustManager" + prAccessor.getString("CANNOT_INST_CLASS"), -2002, e);
            }
            catch (IllegalAccessException e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException("TrustManager" + prAccessor.getString("ACCESS_ERROR"), -2003, e);
            }
            catch (SecurityException e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException("TrustManager" + prAccessor.getString("SECURITY_ERROR"), -2006, e);
            }
            catch (Exception e) {
                SessionConfig.logln(e.getMessage());
                throw JMSExceptionUtil.createJMSSecurityException("TrustManager" + prAccessor.getString("LOAD_CLASS_FAILED"), -1, e);
            }
        }
        try {
            if (this.m_debugFlag && trustStore != null) {
                System.out.println("Initializing " + trustManagerAlgorithem + " trust manager factory with the trust store, entries in the trustStore:\n");
                try {
                    Enumeration<String> list = trustStore.aliases();
                    while (list.hasMoreElements()) {
                        System.out.println(list.nextElement());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            TrustManagerFactory tm = TrustManagerFactory.getInstance(trustManagerAlgorithem);
            tm.init(trustStore);
            this.m_trustManagers = tm.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            if (this.m_debugFlag) {
                e.printStackTrace();
            }
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (KeyStoreException e) {
            if (this.m_debugFlag) {
                e.printStackTrace();
            }
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        return this.m_trustManagers;
    }

    private KeyStore createKeyStore(String keyStoreLocation, String keyStoreType, String keyStorePassword) throws JMSSecurityException {
        KeyStore keyStore = null;
        if (keyStoreLocation != null && keyStoreLocation.trim().length() > 0) {
            InputStream storeInputStream = null;
            try {
                storeInputStream = this.getStoreInputStream(keyStoreLocation.trim());
                keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(storeInputStream, keyStorePassword.toCharArray());
            }
            catch (Exception e) {
                if (this.m_debugFlag) {
                    e.printStackTrace();
                }
                throw JMSExceptionUtil.createJMSSecurityException(e);
            }
            finally {
                block13: {
                    if (storeInputStream != null) {
                        try {
                            storeInputStream.close();
                        }
                        catch (IOException e) {
                            if (!this.m_debugFlag) break block13;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.m_control.getKeyStore() != null) {
            keyStore = this.m_control.getKeyStore();
            this.m_useKeyStoreFromPKCS = true;
        }
        return keyStore;
    }

    private KeyManager[] createKeyManager(String customKeyManagerClass, String keyManagerAlgorithem, KeyStore keyStore, String keyStorePassword, String keyAlias, String keyPassword, boolean isSSLServerSocket) throws JMSSecurityException {
        int i;
        String keyManagerClass = customKeyManagerClass;
        if (keyManagerClass == null || keyManagerClass.trim().length() == 0) {
            if (keyAlias != null && keyAlias.trim().length() > 0) {
                keyManagerClass = isSSLServerSocket ? X509KeyManagerServerImpl.class.getName() : X509KeyManagerClientImpl.class.getName();
            } else {
                KeyManagerFactory kmf = null;
                try {
                    if (this.m_debugFlag) {
                        System.out.println("Intializing " + keyManagerAlgorithem + " key manager factory for default key manager, " + (this.m_useKeyStoreFromPKCS ? "key entries in the PKCS keyStore:\n" : "key entries in the configured JSSE keyStore:\n"));
                        if (keyStore != null) {
                            try {
                                Enumeration<String> aliases = keyStore.aliases();
                                while (aliases.hasMoreElements()) {
                                    String alias = aliases.nextElement();
                                    if (!keyStore.isKeyEntry(alias)) continue;
                                    keyStore.getKey(alias, keyStorePassword.toCharArray());
                                    Certificate[] certs = keyStore.getCertificateChain(alias);
                                    System.out.println("Key entry by alias \"" + alias + "\" contains certificate:\n");
                                    for (int i2 = 0; i2 < certs.length; ++i2) {
                                        System.out.println("cert[" + i2 + "]:\n" + certs[i2]);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    kmf = KeyManagerFactory.getInstance(keyManagerAlgorithem);
                    kmf.init(keyStore, keyStorePassword.toCharArray());
                    this.m_keyManagers = kmf.getKeyManagers();
                    return this.m_keyManagers;
                }
                catch (NoSuchAlgorithmException e) {
                    if (this.m_debugFlag) {
                        e.printStackTrace();
                    }
                    SessionConfig.logln(e.getMessage());
                    throw JMSExceptionUtil.createJMSSecurityException("KeyManager " + e.getMessage(), -2006, e);
                }
                catch (KeyStoreException e) {
                    if (this.m_debugFlag) {
                        e.printStackTrace();
                    }
                    SessionConfig.logln(e.getMessage());
                    throw JMSExceptionUtil.createJMSSecurityException("KeyManager " + e.getMessage(), -2006, e);
                }
                catch (UnrecoverableKeyException e) {
                    if (this.m_debugFlag) {
                        e.printStackTrace();
                    }
                    SessionConfig.logln(e.getMessage());
                    throw JMSExceptionUtil.createJMSSecurityException("KeyManager " + e.getMessage(), -2006, e);
                }
            }
        }
        if (this.m_debugFlag) {
            System.out.println("Intializing " + keyManagerAlgorithem + " key manager factory for key manager of " + keyManagerClass + (isSSLServerSocket ? ", server alias = " : ", client alias = ") + keyAlias + (this.m_useKeyStoreFromPKCS ? ", key entries in the PKCS keyStore:\n" : ", key entries in the configured JSSE keyStore:\n"));
            if (keyStore != null) {
                try {
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!keyStore.isKeyEntry(alias)) continue;
                        keyStore.getKey(alias, keyStorePassword.toCharArray());
                        Certificate[] certs = keyStore.getCertificateChain(alias);
                        System.out.println("Key entry by alias \"" + alias + "\" contains certificate:\n");
                        for (i = 0; i < certs.length; ++i) {
                            System.out.println("cert[" + i + "]:\n" + certs[i]);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithem);
            kmf.init(keyStore, keyStorePassword.toCharArray());
            this.m_keyManagers = kmf.getKeyManagers();
            KeyManager customKeyManager = null;
            Class<?> c = Class.forName(keyManagerClass.trim());
            for (i = 0; i < this.m_keyManagers.length; ++i) {
                if (!(this.m_keyManagers[i] instanceof X509KeyManager)) continue;
                customKeyManager = (KeyManager)c.newInstance();
                if (customKeyManager instanceof X509KeyManagerWrapper) {
                    X509KeyManagerWrapper km = (X509KeyManagerWrapper)customKeyManager;
                    km.setDelegate((X509KeyManager)this.m_keyManagers[i], keyStore);
                    km.setKeyAlias(keyAlias, keyPassword != null ? keyPassword.toCharArray() : null);
                    if (this.m_debugFlag) {
                        km.setDebug(true);
                    }
                }
                this.m_keyManagers[i] = customKeyManager;
            }
        }
        catch (ClassCastException e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -2001, e);
        }
        catch (ClassNotFoundException e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -2000, e);
        }
        catch (InstantiationException e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -2002, e);
        }
        catch (IllegalAccessException e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -2003, e);
        }
        catch (SecurityException e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -2006, e);
        }
        catch (Exception e) {
            SessionConfig.logln(e.getMessage());
            throw JMSExceptionUtil.createJMSSecurityException("KeyManager - " + e.getMessage(), -1, e);
        }
        return this.m_keyManagers;
    }

    private InputStream getStoreInputStream(String location) throws IOException {
        if (!location.contains("://")) {
            Path storeLocation = Paths.get(location, new String[0]).toAbsolutePath().normalize();
            if (Files.exists(storeLocation, new LinkOption[0])) {
                return Files.newInputStream(storeLocation, new OpenOption[0]);
            }
            location = "file:///" + location;
        }
        URL ks = new URL(location);
        return ks.openStream();
    }
}

