/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.net.http.HttpLock;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.receiver.fsm.RequestAsynchronousSendEvent;
import com.sonicsw.wsdl.WSDLContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import progress.message.util.StringUtil;

public class AddressingHandlerWrapper
extends AddressingHandler {
    private static final String WSA_UNSPECIFIED_ACTOR_URI = null;
    private static final boolean WSA_DONT_PROCESS = false;
    private static final boolean WSA_DONT_REMOVE = false;
    private static final boolean WSA_MUST_UNDERSTAND = true;
    private static final List WSA_EMPTY_REFERENCE_PROPERTIES = null;

    public void init() {
        this.setOption("allowNonSpecificActions", "true");
        super.init();
    }

    public void invoke(org.apache.axis.MessageContext mc) throws AxisFault {
        try {
            if (this.suppressWSA(mc)) {
                return;
            }
            Message m = (Message)mc.getMessage();
            if (m == null || !HandlerUtils.hasSOAPEnvelope(m)) {
                return;
            }
            if (mc.isClient()) {
                if (!mc.getPastPivot()) {
                    DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onClientRequest:" + mc.hashCode());
                    super.invoke(mc);
                } else {
                    DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onClientResponse:" + mc.hashCode());
                    Message msg = mc.getResponseMessage();
                    Message request = mc.getRequestMessage();
                    ReliableHeaders rh = new ReliableHeaders();
                    rh.fromSOAPEnvelope(request.getSOAPEnvelope());
                    HttpLock lock = (HttpLock)mc.getProperty("com.sonicsw.net.http.HttpLock");
                    if (rh.getTerminateSequence() != null && lock != null && (lock.getErrorType() == 200 || lock.getErrorType() == 202)) {
                        DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerResponse:Ignoring Non SOAP TerminateSequenceReply" + mc.hashCode());
                    } else {
                        super.invoke(mc);
                    }
                }
            } else if (!mc.getPastPivot()) {
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerRequest:" + mc.hashCode());
                super.invoke(mc);
                boolean anonReplyTo = true;
                AddressingHeaders headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
                if (headers != null) {
                    if (headers.getReplyTo() == null) {
                        anonReplyTo = headers.getFrom() == null ? true : com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(headers.getFrom().getAddress().toString());
                    } else {
                        String address;
                        AttributedURI attrURI;
                        EndpointReference replyToEndPointRef = headers.getReplyTo();
                        if (replyToEndPointRef != null && (attrURI = replyToEndPointRef.getAddress()) != null && (address = attrURI.toString()) != null && !com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(address)) {
                            anonReplyTo = false;
                        }
                    }
                }
                mc.setProperty("COM_SONIC_WS_ANONYMOUS_REPLYTO", (Object)new Boolean(anonReplyTo));
            } else {
                Action outputAction;
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerResponse:" + mc.hashCode());
                if (mc.isPropertyTrue("COM_SONIC_WS_ANONYMOUS_REPLYTO") && (outputAction = this.getOutputAction(mc)) != null) {
                    AddressingUtils.getResponseHeaders((MessageContext)mc).setAction(outputAction);
                }
                super.invoke(mc);
                Action resAction = null;
                AddressingHeaders resHeaders = AddressingUtils.getResponseHeaders((MessageContext)mc);
                if (resHeaders != null) {
                    resAction = resHeaders.getAction();
                }
                if (resAction != null) {
                    mc.setProperty("addressing.responseAction", (Object)resAction.toString());
                }
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private void routePreparedWSAResponse(org.apache.axis.MessageContext mc) throws Exception {
        AddressingHeaders rh = new AddressingHeaders((SOAPEnvelope)mc.getResponseMessage().getSOAPEnvelope(), WSA_UNSPECIFIED_ACTOR_URI, false, false, true, WSA_EMPTY_REFERENCE_PROPERTIES);
        To to = rh.getTo();
        if (to != null) {
            Action resAction;
            String uri = to.toString();
            if (uri != null && !com.sonicsw.ws.addressing.AddressingUtils.isAnonymousURI(uri) && !com.sonicsw.ws.addressing.AddressingUtils.isNoneURI(uri)) {
                this.respondAsync(mc);
                mc.setResponseMessage(null);
            }
            if ((resAction = rh.getAction()) != null) {
                mc.setProperty("addressing.responseAction", (Object)resAction.toString());
            }
        }
    }

    private void respondAsync(org.apache.axis.MessageContext mc) throws Exception {
        RequestAsynchronousSendEvent evt = new RequestAsynchronousSendEvent();
        evt.setContext(mc);
        evt.setEnvelope(mc.getCurrentMessage().getSOAPEnvelope());
        SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
        RMSequenceSupport support = null;
        if (capsule != null) {
            support = RMManager.getRMManager().getRMSendSequenceSupport(capsule.getId());
        } else {
            capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
            if (capsule != null) {
                support = RMManager.getRMManager().getRMReceiveSequenceSupport(capsule.getId());
            }
        }
        mc.setResponseMessage(null);
        if (support != null) {
            support.enqueue(evt, 12);
        } else {
            evt.execute();
        }
    }

    protected void forwardMessage(EndpointReferenceType epr, Message msg) throws Exception {
        AttributedURI address = epr.getAddress();
        AddressingHeaders headers = null;
        org.apache.axis.MessageContext mc = msg.getMessageContext();
        if (mc != null) {
            headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        }
        if (headers == null) {
            headers = new AddressingHeaders();
        }
        headers.setTo(address);
        headers.setReferenceProperties(epr.getProperties());
        headers.setReferenceParameters(epr.getParameters());
        headers.toEnvelope((SOAPEnvelope)msg.getSOAPEnvelope());
        this.respondAsync(mc);
    }

    public void onFault(org.apache.axis.MessageContext mc) {
        if (this.suppressWSA(mc)) {
            return;
        }
        if (mc.isClient()) {
            if (!mc.getPastPivot()) {
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onClientRequestFault:" + mc.hashCode());
                super.onFault(mc);
            } else {
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onClientResponseFault:" + mc.hashCode());
                super.onFault(mc);
            }
        } else if (!mc.getPastPivot()) {
            DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerRequestFault:" + mc.hashCode());
            super.onFault(mc);
        } else {
            DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerResponseFault:" + mc.hashCode());
            if (mc.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") == null) {
                super.onFault(mc);
            } else {
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper:onServerResponseFault:DeliberateFaultIgnoring" + mc.hashCode());
                try {
                    this.routePreparedWSAResponse(mc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean suppressWSA(org.apache.axis.MessageContext mc) {
        String p = (String)mc.getProperty("COM_SONIC_WSA_SUPRESS");
        return p != null && p.equalsIgnoreCase("true");
    }

    private Action getOutputAction(org.apache.axis.MessageContext mc) {
        block15: {
            String wsdlOutAction;
            block14: {
                WSDLContext.DispatchContext dispctx;
                block13: {
                    dispctx = (WSDLContext.DispatchContext)mc.getProperty("com.sonicsw.wsdl.WSDLContext$DispatchContext");
                    if (dispctx == null) {
                        return null;
                    }
                    wsdlOutAction = null;
                    try {
                        Set attribs = dispctx.getOperation().getOutput().getExtensionAttributes().entrySet();
                        for (Map.Entry attrib : attribs) {
                            QName name = (QName)attrib.getKey();
                            if (!"Action".equals(name.getLocalPart())) continue;
                            if (com.sonicsw.ws.addressing.AddressingUtils.isAddressingWSDLNS(name.getNamespaceURI())) {
                                // empty if block
                            }
                            wsdlOutAction = (String)attrib.getValue();
                        }
                    }
                    catch (Exception e) {
                        if (!DebugObjects.getHandlerDebug().getDebug()) break block13;
                        DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper: exception caught while looking up output action: " + e);
                        e.printStackTrace();
                    }
                }
                if (wsdlOutAction == null) {
                    try {
                        char delim;
                        WSDLContext wsdlctx = (WSDLContext)mc.getProperty("com.sonicsw.wsdl.WSDLContext");
                        String targetNameSpace = wsdlctx.getDefinition().getTargetNamespace();
                        String portTypeName = dispctx.getPort().getBinding().getPortType().getQName().getLocalPart();
                        String outputName = dispctx.getOperation().getOutput().getName();
                        char c = delim = this.isURN(targetNameSpace) ? (char)':' : '/';
                        if (!(StringUtil.isNullOrEmpty(targetNameSpace) || StringUtil.isNullOrEmpty(portTypeName) || StringUtil.isNullOrEmpty(outputName))) {
                            StringBuffer actionBuff = new StringBuffer();
                            actionBuff.append(targetNameSpace);
                            if (delim != '/' || !targetNameSpace.endsWith("/")) {
                                actionBuff.append(delim);
                            }
                            actionBuff.append(portTypeName).append(delim).append(outputName);
                            wsdlOutAction = actionBuff.toString();
                        }
                    }
                    catch (Exception e) {
                        if (!DebugObjects.getHandlerDebug().getDebug()) break block14;
                        DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper: exception caught while building default output action: " + e);
                        e.printStackTrace();
                    }
                }
            }
            try {
                if (wsdlOutAction != null) {
                    return new Action(new URI(wsdlOutAction));
                }
            }
            catch (Exception e) {
                if (!DebugObjects.getHandlerDebug().getDebug()) break block15;
                DebugObjects.getHandlerDebug().debug("AddressingHandlerWrapper: invalid action uri: " + e);
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean isURN(String uri) {
        return uri != null && uri.length() > 4 && uri.substring(0, 4).equalsIgnoreCase("urn:");
    }
}

