/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.net.http.ws.WSHttpOutResponse;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import com.sonicsw.net.http.ws.WSHttpProtocolHandler;
import com.sonicsw.ws.addressing.AddressingUtils;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.axis.handlers.UniversalHandler;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.common.SequencedDataContext;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.AckRequested;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.RMPolicyFault;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.Sequence;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.receiver.fsm.CreateInboundSequenceEvent;
import com.sonicsw.ws.rm.receiver.fsm.InboundDataEvent;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.receiver.fsm.RequestAckEvent;
import com.sonicsw.ws.rm.receiver.fsm.TerminateInboundSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.AckEvent;
import com.sonicsw.ws.rm.sender.fsm.CreateSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.CreateSequenceResponseEvent;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import com.sonicsw.ws.rm.sender.fsm.SendCompleteEvent;
import com.sonicsw.ws.rm.sender.fsm.TerminateSequenceEvent;
import com.sonicsw.ws.rm.sender.fsm.TerminateSequenceResponseEvent;
import java.net.SocketException;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.MessageID;
import progress.message.msg.IMgram;

public class RMHandler
extends UniversalHandler {
    boolean m_reservedForResends = false;

    public void reserveForResending() {
        this.m_reservedForResends = true;
    }

    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        try {
            Boolean last;
            this.debug("RMHandler:handleClientRequest", mc);
            if (this.m_reservedForResends) {
                SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
                SequencedDataContext sdc = new SequencedDataContext(capsule, mc, true);
                if (capsule != null) {
                    RMManager.getRMManager().setPendingSequencedData(sdc);
                }
                return;
            }
            Message request = mc.getRequestMessage();
            ReliableHeaders rh = new ReliableHeaders();
            rh.fromSOAPEnvelope(request.getSOAPEnvelope());
            IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
            String id = (String)m.getSidebandData().getProperty("JMSXGroupID");
            Integer iseq = (Integer)m.getSidebandData().getProperty("JMSXGroupSeq");
            Constants RMConstants = this.getRMConstants(request);
            mc.setProperty("COM_SONIC_WS_RM_CONSTANTS", (Object)RMConstants);
            mc.setProperty("COM_SONIC_RM_REQUEST_HEADERS", (Object)rh);
            Long seq = null;
            if (iseq != null) {
                seq = new Long(iseq.longValue());
            }
            if ((last = (Boolean)m.getSidebandData().getProperty("JMS_SonicMQ_lastMessageInGroup")) == null) {
                last = new Boolean(false);
            }
            if (id != null) {
                RMSendSequence ss = RMManager.getRMManager().getRMSendSequenceSupport(id);
                if (ss != null) {
                    RMConstants = ss.getConstants();
                }
                mc.setProperty("COM_SONIC_WS_RM_CONSTANTS", (Object)RMConstants);
                ElementCreator.addNamespaceDeclarations(request.getSOAPEnvelope(), RMConstants);
                SequenceCapsule cap = new SequenceCapsule(id, seq, last);
                SequencedDataContext sdc = new SequencedDataContext(cap, mc, false);
                mc.setProperty("com.sonicsw.ws.rm.common.SequenceCapsule", (Object)cap);
                RMManager.getRMManager().setPendingSequencedData(sdc);
                ElementCreator.insertSequenceElement(request.getSOAPEnvelope(), id, seq != null ? Long.valueOf(seq) : null, last, RMConstants);
                if (last.booleanValue()) {
                    ElementCreator.insertAckRequestedElement(request.getSOAPEnvelope(), id, RMConstants);
                }
            } else {
                if (this.isTerminateMessage(rh)) {
                    RMManager rmm = RMManager.getRMManager();
                    TerminateSequenceEvent tse = new TerminateSequenceEvent();
                    String seqId = rh.getTerminateSequence().getIdentifier().getIdentifier();
                    tse.setSequence(rmm.getRMSendSequenceSupport(seqId));
                    tse.setContext(mc);
                    tse.execute();
                } else if (this.isCreateMessage(rh)) {
                    CreateSequenceEvent cse = new CreateSequenceEvent();
                    cse.setContext(mc);
                    cse.execute();
                }
                if (mc.getResponseMessage() != null) {
                    this.handleClientResponse(mc);
                    WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
                    WSHttpOutResponse response = (WSHttpOutResponse)mc.getProperty("com.sonicsw.net.http.HttpOutResponse");
                    WSHttpOutRequest wrequest = (WSHttpOutRequest)mc.getProperty("com.sonicsw.net.http.HttpOutRequest");
                    HttpLock lock = (HttpLock)mc.getProperty("com.sonicsw.net.http.HttpLock");
                    lock.setError(202);
                    response.setAxisResponse(mc.getResponseMessage());
                    response.setResponseCode(lock.getErrorType());
                    response.setResponseMessage(lock.getMessage());
                    handler.onResponse(lock, m, wrequest, response);
                    AxisFault af = new AxisFault();
                    mc.setProperty("COM_SONIC_WS_AXISFAULT_PROCESSED", (Object)af);
                    throw af;
                }
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        try {
            this.debug("RMHandler:handleClientResponse:", mc);
            SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
            ReliableHeaders rhsent = (ReliableHeaders)mc.getProperty("COM_SONIC_RM_REQUEST_HEADERS");
            HttpLock lock = (HttpLock)mc.getProperty("com.sonicsw.net.http.HttpLock");
            Message response = mc.getResponseMessage();
            RMManager rmm = RMManager.getRMManager();
            if (capsule != null) {
                boolean cancelled;
                boolean bl = cancelled = RMManager.getRMManager().getAndClearPendingSequencedData(capsule) == null;
                if (!(lock != null && lock.getErrorType() != 200 && lock.getErrorType() != 202 || cancelled)) {
                    SendCompleteEvent se = new SendCompleteEvent();
                    RMSendSequence sentSeq = RMManager.getRMManager().getRMSendSequenceSupport(capsule.getId());
                    se.setSequence(sentSeq);
                    se.setContext(mc);
                    se.execute();
                }
            }
            if (rhsent != null && this.isTerminateMessage(rhsent)) {
                TerminateSequenceResponseEvent tsre = new TerminateSequenceResponseEvent();
                String seqId = rhsent.getTerminateSequence().getIdentifier().getIdentifier();
                tsre.setSequence(rmm.getRMSendSequenceSupport(seqId));
                tsre.setContext(mc);
                tsre.execute();
            }
            if ((response = mc.getResponseMessage()) == null || !HandlerUtils.hasSOAPEnvelope(response)) {
                return;
            }
            SequenceFault sf = SequenceFault.fromSOAPEnvelope(response.getSOAPEnvelope());
            if (sf != null) {
                AddressingHeaders headers;
                MessageID mid;
                String id = sf.getSequenceId();
                if (id == null && capsule != null) {
                    id = capsule.getId();
                }
                if (id != null) {
                    RMSendSequence support = rmm.getRMSendSequenceSupport(id);
                    if (support != null) {
                        support.markForTermination(null);
                        support.uncirculateSequence(false);
                        rmm.removeRMSequenceSupport(support);
                    }
                    rmm.onSequenceFault(id, response);
                }
                if (this.isCreateMessage(rhsent) && (mid = (headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS")).getMessageID()) != null) {
                    RMManager.getRMManager().removeCreateOperationContext(mid.toString());
                }
                return;
            }
            if (lock != null && lock.getErrorType() != 200 && lock.getErrorType() != 202) {
                return;
            }
            ReliableHeaders rhrecvd = new ReliableHeaders();
            if (lock != null && lock.getErrorType() != 202) {
                rhrecvd.fromSOAPEnvelope(response.getSOAPEnvelope());
            }
            this.processCommon(mc, rhrecvd, response);
            if (this.isCreateResponseMessage(rhrecvd)) {
                CreateSequenceResponseEvent csre = new CreateSequenceResponseEvent();
                csre.setContext(mc);
                csre.execute();
            } else {
                this.stripHeaders(response);
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        try {
            RMEvent csre;
            this.debug("RMHandler:handleServerRequest:", mc);
            Message m = mc.getRequestMessage();
            if (m == null || m.getContentLength() <= 0L) {
                return;
            }
            Message request = mc.getRequestMessage();
            ReliableHeaders rh = new ReliableHeaders();
            rh.fromSOAPEnvelope(request.getSOAPEnvelope());
            Constants RMConstants = this.getRMConstants(request);
            mc.setProperty("COM_SONIC_WS_RM_CONSTANTS", (Object)RMConstants);
            Object receivedMessageCapsule = null;
            boolean ackRequestedForReceiveMessage = false;
            SequenceFault sf = SequenceFault.fromSOAPEnvelope(request.getSOAPEnvelope());
            if (sf != null) {
                boolean unknownSequence;
                boolean postedFaultDestination = false;
                String id = sf.getSequenceId();
                if (id != null) {
                    RMManager rmm = RMManager.getRMManager();
                    RMSendSequence sendSupport = rmm.getRMSendSequenceSupport(id);
                    if (sendSupport != null) {
                        sendSupport.markForTermination(null);
                        sendSupport.faultSequence(m);
                        postedFaultDestination = true;
                        rmm.removeRMSequenceSupport(sendSupport);
                    } else {
                        rmm.clearPendingSequencedData(id);
                    }
                    rmm.onSequenceFault(id, request);
                }
                boolean bl = unknownSequence = sf.getSubode() != null && sf.getSubode().indexOf("UnknownSequence") != -1;
                if (!mc.containsProperty("DEST")) {
                    mc.setPastPivot(true);
                } else if (postedFaultDestination) {
                    mc.setPastPivot(true);
                } else if (!unknownSequence) {
                    mc.setPastPivot(true);
                }
            }
            RMPolicy rmp = (RMPolicy)mc.getProperty("com.sonicsw.ws.rm.policy.RMPolicy");
            if (DebugObjects.getHandlerDebug().getDebug()) {
                DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest:RM Headers present:" + rh.isAnyHeaderBlockPresent());
                if (rmp != null) {
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest:RMPolicy required:" + rmp.isRMPolicyRequired());
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest:RMPolicy:" + rmp.hashCode());
                } else {
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest: No RMPolicy in context");
                }
            }
            if (rmp != null && rmp.isRMPolicyRequired() && !rh.isAnyHeaderBlockPresent()) {
                throw RMPolicyFault.makeRMPolicyFault(RMConstants);
            }
            if (this.isCreateMessage(rh)) {
                if (DebugObjects.getHandlerDebug().getDebug()) {
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest:Processing Create Control Message");
                }
                csre = new CreateInboundSequenceEvent();
                csre.setContext(mc);
                ((CreateInboundSequenceEvent)csre).execute();
            }
            this.processCommon(mc, rh, request);
            if (this.isCreateResponseMessage(rh)) {
                if (DebugObjects.getHandlerDebug().getDebug()) {
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerRequest:Processing Create Response Control Message");
                }
                csre = new CreateSequenceResponseEvent();
                csre.setContext(mc);
                ((CreateSequenceResponseEvent)csre).execute();
            }
            if (rh.getSequence() != null) {
                this.stripHeaders(request);
            }
            if (mc.getResponseMessage() != null || mc.getPastPivot()) {
                AxisFault af = new AxisFault();
                mc.setProperty("COM_SONIC_WS_AXISFAULT_PROCESSED", (Object)af);
                mc.setProperty("org.apache.axis.SimpleChain.caughtFaultInResponse", (Object)Boolean.TRUE);
                throw af;
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        try {
            this.debug("RMHandler:handleServerResponse:", mc);
            m = mc.getRequestMessage();
            if (m == null || m.getContentLength() <= 0L) {
                return;
            }
            discardedRequest = false;
            removeMessage = (Boolean)mc.getProperty("COM_SONIC_RM_REMOVE_MESSAGE");
            discardedRequest = removeMessage != null && removeMessage != false;
            terminateAnonId = (String)mc.getProperty("COM_SONIC_TERMINATE_SEQUENCE_TO_ANONYMOUS");
            resendAnonId = (String)mc.getProperty("COM_SONIC_RESEND_SEQUENCE_TO_ANONYMOUS");
            if (terminateAnonId != null && mc.getResponseMessage() == null && (sendSupport = (rmm = RMManager.getRMManager()).getRMSendSequenceSupport(terminateAnonId)) != null) {
                RMConstants = sendSupport.getConstants();
                env = ElementCreator.createTerminateSequence(terminateAnonId, sendSupport.getSequenceState().getEndpointReference(), sendSupport.getSOAPConstants(), (Constants)RMConstants);
                ElementCreator.addNamespaceDeclarations(env, (Constants)RMConstants);
                ah = new AddressingHeaders((javax.xml.soap.SOAPEnvelope)env, false, true);
                axisMessage = new Message((Object)env);
                axisMessage.setMessageContext(mc);
                mc.setResponseMessage(axisMessage);
                mc.setProperty("addressing.responseAction", (Object)RMConstants.getTerminateSequenceAction());
                rmm.removeRMSequenceSupport(sendSupport);
            }
            if ((capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule")) == null) {
                return;
            }
            rrs = RMManager.getRMManager().getRMReceiveSequenceSupport(capsule.getId());
            if (rrs == null) {
                return;
            }
            if (!discardedRequest) {
                RMConstants = rrs.getSequenceState();
                synchronized (RMConstants) {
                    reqContext = (HttpRequestContext)mc.getProperty("com.sonicsw.net.http.HttpRequestContext");
                    if (reqContext != null && (lock = reqContext.getHttpLock()).getErrorType() == 507) {
                        rrs.getSequenceState().backoutReceivedMessage(capsule);
                        rrs.messageBlocked(mc);
                        return;
                    }
                    rrs.getSequenceState().commitReceivedMessage(capsule);
                    rrs.messageSent(mc);
                    buffered = rrs.getSequenceState().tryRetrieveBufferedMessage();
                    while (buffered != null) {
                        bufferedMc = buffered.getMsgContext();
                        handler = (WSHttpProtocolHandler)bufferedMc.getProperty("com.sonicsw.net.http.ws.WSHttpProtocolHandler");
                        try {
                            handler.sendBufferedMessageToSOAPStack(bufferedMc);
                            capsule2 = (SequenceCapsule)bufferedMc.getProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
                            reqContext = (HttpRequestContext)bufferedMc.getProperty("com.sonicsw.net.http.HttpRequestContext");
                            if (reqContext != null && (lock = reqContext.getHttpLock()).getErrorType() == 507) {
                                rrs.getSequenceState().backoutReceivedMessage(capsule2);
                                rrs.messageBlocked(bufferedMc);
                                return;
                            }
                            rrs.messageSent(bufferedMc);
                            rrs.getSequenceState().commitReceivedMessage(capsule2);
                        }
                        catch (Exception e) {
                            BrokerComponent.getComponentContext().logMessage("Problem delivering reliable sequenced message from buffer.", (Throwable)e, BrokerComponent.getLevelWarning().intValue());
                            break;
                        }
                        buffered = rrs.getSequenceState().tryRetrieveBufferedMessage();
                    }
                }
            }
            if ((a2 = rrs.getSequenceState().getAcksTo()) == null || AddressingUtils.isAnonymousURI(a2.getAddress().getAddress().toString())) {
                DebugObjects.getHandlerDebug().debug("RMHandler:handleServerResponse: Piggybacking SequenceAck");
                try {
                    useRMAckAction = false;
                    if (mc.getResponseMessage() == null) {
                        env = new SOAPEnvelope(mc.getSOAPConstants());
                        axisMessage = new Message((Object)env);
                        axisMessage.setMessageContext(mc);
                        mc.setResponseMessage(axisMessage);
                        useRMAckAction = true;
                    }
                    rrs.getSequenceState().getSequenceAcknowledgement().toSOAPEnvelope(mc.getResponseMessage().getSOAPEnvelope());
                    if (!useRMAckAction) ** GOTO lbl84
                    mc.setProperty("addressing.responseAction", (Object)rrs.getConstants().getSequenceAcknowledgementAction());
                }
                catch (Exception e) {
                    throw new AxisFault(e.getMessage());
                }
            } else if (!discardedRequest && capsule.getLast().booleanValue()) {
                evt = new RequestAckEvent();
                evt.setContext(mc);
                evt.setSequence(rrs);
                rrs.enqueue(evt, 12);
            }
lbl84:
            // 5 sources

            mg = (IMgram)mc.getProperty("COM_SONIC_RESPONSEMGRAM");
            if (mg != null) {
                if (DebugObjects.getHandlerDebug().getDebug()) {
                    DebugObjects.getHandlerDebug().debug("RMHandler:handleServerResponse: ResponseMgram: " + mg.toString());
                }
                response = mc.getResponseMessage();
                rh = new ReliableHeaders();
                rh.fromSOAPEnvelope(response.getSOAPEnvelope());
                id = (String)mg.getSidebandData().getProperty("JMSXGroupID");
                iseq = (Integer)mg.getSidebandData().getProperty("JMSXGroupSeq");
                RMConstants = this.getRMConstants(response);
                mc.setProperty("COM_SONIC_WS_RM_CONSTANTS", (Object)RMConstants);
                mc.setProperty("COM_SONIC_RM_REQUEST_HEADERS", (Object)rh);
                seq = null;
                if (iseq != null) {
                    seq = new Long(iseq.longValue());
                }
                if ((last = (Boolean)mg.getSidebandData().getProperty("JMS_SonicMQ_lastMessageInGroup")) == null) {
                    last = new Boolean(false);
                }
                if (id != null) {
                    ss = RMManager.getRMManager().getRMSendSequenceSupport(id);
                    if (ss != null) {
                        RMConstants = ss.getConstants();
                    }
                    mc.setProperty("COM_SONIC_WS_RM_CONSTANTS", (Object)RMConstants);
                    ElementCreator.addNamespaceDeclarations(response.getSOAPEnvelope(), RMConstants);
                    mc.setProperty("com.sonicsw.ws.rm.common.SequenceCapsule", (Object)new SequenceCapsule(id, seq, last));
                    if (seq != null) {
                        ElementCreator.insertSequenceElement(response.getSOAPEnvelope(), id, seq, last, RMConstants);
                    }
                    if (last.booleanValue()) {
                        ElementCreator.insertAckRequestedElement(response.getSOAPEnvelope(), id, RMConstants);
                    }
                    if (ss != null) {
                        se = new SendCompleteEvent();
                        se.setSequence(ss);
                        se.setContext(mc);
                        se.execute();
                    }
                }
            }
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    public void stripHeaders(Message m) throws AxisFault, SOAPException {
        if (!HandlerUtils.hasSOAPEnvelope(m)) {
            return;
        }
        HandlerUtils.stripHeaders((javax.xml.soap.SOAPEnvelope)m.getSOAPEnvelope(), "http://schemas.xmlsoap.org/ws/2005/02/rm");
        HandlerUtils.stripHeaders((javax.xml.soap.SOAPEnvelope)m.getSOAPEnvelope(), "http://schemas.xmlsoap.org/ws/2004/03/rm");
    }

    @Override
    public void onClientRequestFault(MessageContext mc) {
        this.debug("RMHandler:onClientRequestFault:", mc);
        AxisFault af = (AxisFault)((Object)mc.getProperty("COM_SONIC_WS_AXISFAULT"));
        WSHttpOutboundHandler handler = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        SequenceCapsule capsule = (SequenceCapsule)mc.getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
        ReliableHeaders rh = (ReliableHeaders)mc.getProperty("COM_SONIC_RM_REQUEST_HEADERS");
        if (capsule == null && !this.isControlMessage(rh)) {
            return;
        }
        boolean cancelled = false;
        if (capsule != null) {
            boolean bl = cancelled = RMManager.getRMManager().getAndClearPendingSequencedData(capsule) == null;
        }
        if (mc.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") == af) {
            return;
        }
        if (capsule != null) {
            Throwable cause = af.getCause();
            if (cause != null && cause instanceof SocketException) {
                if (!cancelled) {
                    RMSendSequence sentSeq = RMManager.getRMManager().getRMSendSequenceSupport(capsule.getId());
                    SendCompleteEvent se = new SendCompleteEvent();
                    se.setSequence(sentSeq);
                    se.setContext(mc);
                    se.execute();
                }
                mc.setProperty("COM_SONIC_WS_AXISFAULT_PROCESSED", (Object)af);
            }
        } else if (this.isCreateMessage(rh)) {
            AddressingHeaders headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            MessageID id = headers.getMessageID();
            if (id != null) {
                RMManager.getRMManager().removeCreateOperationContext(id.toString());
            }
        } else if (this.isTerminateMessage(rh)) {
            TerminateSequenceResponseEvent tsre = new TerminateSequenceResponseEvent();
            String seqId = rh.getTerminateSequence().getIdentifier().getIdentifier();
            tsre.setSequence(RMManager.getRMManager().getRMSendSequenceSupport(seqId));
            tsre.setContext(mc);
            tsre.execute();
            mc.setProperty("COM_SONIC_WS_AXISFAULT_PROCESSED", (Object)af);
        } else {
            mc.setProperty("COM_SONIC_WS_AXISFAULT_PROCESSED", (Object)af);
        }
    }

    @Override
    public void onClientResponseFault(MessageContext mc) {
        this.debug("RMHandler:onClientResponseFault:", mc);
    }

    @Override
    public void onServerRequestFault(MessageContext mc) {
        this.debug("RMHandler:onServetResponseFault:", mc);
    }

    @Override
    public void onServerResponseFault(MessageContext mc) {
        this.debug("RMHandler:onServerResponseFault:", mc);
    }

    public Constants getRMConstants(Message m) throws Exception {
        SOAPEnvelope env = m.getSOAPEnvelope();
        String ns = env.getNamespaceURI("wsrm");
        if (ns != null && ns.equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm")) {
            return Constants.MAR2004_CONSTANTS;
        }
        return Constants.FEB2005_CONSTANTS;
    }

    public boolean isCreateResponseMessage(ReliableHeaders rh) {
        return rh.getCreateSequenceResponse() != null;
    }

    public boolean isCreateMessage(ReliableHeaders rh) {
        return rh.getCreateSequence() != null;
    }

    public boolean isTerminateMessage(ReliableHeaders rh) {
        return rh.getTerminateSequence() != null;
    }

    public boolean isControlMessage(Message m) throws Exception {
        if (!HandlerUtils.hasSOAPEnvelope(m)) {
            return false;
        }
        ReliableHeaders rh = new ReliableHeaders();
        rh.fromSOAPEnvelope(m.getSOAPEnvelope());
        return this.isControlMessage(rh);
    }

    public boolean isControlMessage(ReliableHeaders rh) {
        if (rh == null) {
            return false;
        }
        if (rh.getCreateSequence() != null) {
            return true;
        }
        if (rh.getCreateSequenceResponse() != null) {
            return true;
        }
        return rh.getTerminateSequence() != null;
    }

    public void processCommon(MessageContext mc, ReliableHeaders rhrecvd, Message recvdMsg) {
        RMSequenceSupport support;
        RMReceiveSequence support2;
        String ID;
        RMManager rmm = RMManager.getRMManager();
        SequenceCapsule receivedMessageCapsule = null;
        boolean ackRequestedForReceiveMessage = false;
        if (this.isTerminateMessage(rhrecvd)) {
            boolean forwarded = false;
            ID = rhrecvd.getTerminateSequence().getIdentifier().getIdentifier();
            support2 = rmm.getRMReceiveSequenceSupport(ID);
            if (support2 == null) {
                String brokerId = ID.substring(ID.lastIndexOf("-") + 1);
                if (brokerId != null) {
                    forwarded = rmm.onMsgReceived(brokerId, ID, recvdMsg);
                }
            } else {
                TerminateInboundSequenceEvent tsre = new TerminateInboundSequenceEvent();
                tsre.setSequence(support2);
                tsre.setContext(mc);
                tsre.execute();
            }
        } else if (rhrecvd.getSequence() != null) {
            String brokerId;
            Sequence seqID = rhrecvd.getSequence();
            ID = seqID.getIdentifier().getIdentifier();
            support2 = rmm.getRMReceiveSequenceSupport(ID);
            boolean forwarded = false;
            if (support2 == null && ID != null && (brokerId = ID.substring(ID.lastIndexOf("-") + 1)) != null) {
                forwarded = rmm.onMsgReceived(brokerId, ID, recvdMsg);
            }
            if (forwarded) {
                mc.setProperty("COM_SONIC_RM_REMOVE_MESSAGE", (Object)new Boolean(true));
            } else {
                Long seq = new Long(seqID.getMessageNumber().getMessageNumber());
                Boolean last = new Boolean(false);
                if (seqID.getLastMessage() != null) {
                    last = new Boolean(true);
                }
                InboundDataEvent ide = new InboundDataEvent();
                receivedMessageCapsule = new SequenceCapsule(ID, seq, last);
                if (support2 != null) {
                    receivedMessageCapsule.setReturnId(support2.getSequenceState().getReturnSequenceIdentifier());
                }
                mc.setProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule", (Object)receivedMessageCapsule);
                ide.setSequence(support2);
                ide.setContext(mc);
                ide.execute();
                if (mc.getResponseMessage() != null && (support2 = RMManager.getRMManager().getRMReceiveSequenceSupport(ID)) != null && last.booleanValue()) {
                    ackRequestedForReceiveMessage = true;
                    RequestAckEvent evt = new RequestAckEvent();
                    evt.setContext(mc);
                    evt.setSequence(support2);
                    support2.enqueue(evt, 12);
                }
            }
        }
        Vector v = rhrecvd.getSequenceAcknowledgements();
        if (v != null) {
            for (SequenceAcknowledgement sa : v) {
                String id = sa.getIdentifier().getIdentifier();
                support = rmm.getRMSendSequenceSupport(id);
                rmm.onAckReceived(sa);
                if (support == null) continue;
                AckEvent ae = new AckEvent();
                ae.setSequence(support);
                ae.setContext(mc);
                ae.setAcknowledgement(sa);
                ae.execute();
            }
        }
        if ((v = rhrecvd.getAckRequests()) != null) {
            for (AckRequested ar : v) {
                String id = ar.getIdentifier().getIdentifier();
                support = RMManager.getRMManager().getRMReceiveSequenceSupport(id);
                if (support == null || receivedMessageCapsule != null && receivedMessageCapsule.getId().equals(id) && ackRequestedForReceiveMessage || receivedMessageCapsule != null && receivedMessageCapsule.getId().equals(id) && !mc.getPastPivot() && receivedMessageCapsule.getLast().booleanValue()) continue;
                RequestAckEvent evt = new RequestAckEvent();
                evt.setContext(mc);
                evt.setSequence(support);
                support.enqueue(evt, 12);
            }
        }
    }
}

