/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.common;

import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpProtocolHandler;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.IRMAckListener;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.common.SequencedDataContext;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.AcknowledgementRange;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jms.Destination;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReference;
import progress.message.broker.Config;
import progress.message.util.server.ReOrderBuffer;
import progress.message.zclient.DebugObject;

public class RMSequence
extends DebugObject {
    private Date m_expires;
    private long m_lastActivity;
    private Constants m_rmConstants;
    private RMPolicy m_policy;
    private AcksTo m_acksTo;
    private SortedMap m_messageList;
    private ReOrderBuffer m_buffer;
    private EndpointReference m_endpoint;
    private Destination m_internalFaultDestination;
    private Identifier m_sequenceIdentifier;
    private String m_returnSequenceIdentifier;
    private long m_nextMessageNo;
    private long m_maxReceivedMessageNumber;
    private boolean m_isClientAssigned;
    private long m_lastConsumedMessageNumber;
    private long m_designatedLastMessageNumber;
    private boolean m_allAcknowledged;

    public RMSequence(Identifier identifier) {
        super("RMSequence");
        this.m_sequenceIdentifier = identifier;
        this.m_returnSequenceIdentifier = null;
        this.m_messageList = Collections.synchronizedSortedMap(new TreeMap());
        this.m_nextMessageNo = 1L;
        this.m_maxReceivedMessageNumber = 0L;
        this.m_lastConsumedMessageNumber = 0L;
        this.m_designatedLastMessageNumber = 0L;
        this.m_buffer = new ReOrderBuffer(Config.FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE);
    }

    public RMSequence() {
        super("RMSequence");
        this.m_messageList = Collections.synchronizedSortedMap(new TreeMap());
        this.m_nextMessageNo = 1L;
        this.m_allAcknowledged = false;
        this.m_maxReceivedMessageNumber = 0L;
        this.m_lastConsumedMessageNumber = 0L;
        this.m_designatedLastMessageNumber = 0L;
        this.m_returnSequenceIdentifier = null;
        this.m_buffer = new ReOrderBuffer(Config.FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE);
    }

    public Identifier getSequenceIdentifier() {
        return this.m_sequenceIdentifier;
    }

    public void setSequenceIdentifier(Identifier identifier) {
        this.m_sequenceIdentifier = identifier;
    }

    public AcksTo getAcksTo() {
        return this.m_acksTo;
    }

    public void setAcksTo(AcksTo a2) {
        this.m_acksTo = a2;
    }

    public EndpointReference getEndpointReference() {
        return this.m_endpoint;
    }

    public Destination getInternalFaultDestination() {
        return this.m_internalFaultDestination;
    }

    public void setEndpointReference(EndpointReference epr) {
        this.m_endpoint = epr;
    }

    public void setInternalFaultDestination(Destination dest) {
        this.m_internalFaultDestination = dest;
    }

    public Constants getRMConstants() {
        return this.m_rmConstants;
    }

    public void setRMConstants(Constants c) {
        this.m_rmConstants = c;
    }

    public String getReturnSequenceIdentifier() {
        return this.m_returnSequenceIdentifier;
    }

    public void setReturnSequenceIdentifier(String identifier) {
        this.m_returnSequenceIdentifier = identifier;
    }

    public synchronized void insertProducedMessage(ReliableMessageWrapper message) {
        if (this.m_policy == null) {
            this.setPolicy((RMPolicy)message.getMsgContext().getProperty("com.sonicsw.ws.rm.policy.RMPolicy"));
        }
        this.m_messageList.put(message.getSequenceInfo().getNr(), message);
    }

    public synchronized boolean insertReceivedMessage(ReliableMessageWrapper message) {
        long msgNo = message.getSequenceInfo().getNr();
        boolean last = message.getSequenceInfo().getLast();
        if (this.m_messageList.get(new Long(msgNo)) != null) {
            return true;
        }
        if (msgNo == this.m_maxReceivedMessageNumber + 1L) {
            Object state;
            if (this.m_maxReceivedMessageNumber >= 1L && (state = this.m_messageList.get(new Long(this.m_maxReceivedMessageNumber))) != null && !state.equals("COMMITED")) {
                try {
                    int size = (int)message.getMsgContext().getRequestMessage().getContentLength();
                    this.prepareToBuffer(message);
                    this.m_buffer.buffer(message, msgNo, size);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
            this.m_messageList.put(new Long(msgNo), "INSERTED");
            this.m_maxReceivedMessageNumber = msgNo;
            if (last) {
                this.m_designatedLastMessageNumber = msgNo;
            }
            this.m_buffer.clearTo(this.m_maxReceivedMessageNumber + 1L);
            return false;
        }
        if (msgNo > this.m_maxReceivedMessageNumber + 1L) {
            try {
                int size = (int)message.getMsgContext().getRequestMessage().getContentLength();
                this.prepareToBuffer(message);
                this.m_buffer.buffer(message, msgNo, size);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized boolean backoutReceivedMessage(SequenceCapsule capsule) {
        long msgNo = capsule.getNr();
        boolean last = capsule.getLast();
        if (msgNo != this.m_maxReceivedMessageNumber) {
            return false;
        }
        this.m_messageList.remove(new Long(this.m_maxReceivedMessageNumber));
        --this.m_maxReceivedMessageNumber;
        if (this.m_designatedLastMessageNumber == msgNo) {
            this.m_designatedLastMessageNumber = 0L;
        }
        return true;
    }

    private void prepareToBuffer(ReliableMessageWrapper message) throws Exception {
        MessageContext ctx = message.getMsgContext();
        WSHttpInRequest request = (WSHttpInRequest)ctx.getProperty("com.sonicsw.net.http.HttpInRequest");
        ctx.setProperty("HTTP_IN_REQUEST_PATH", (Object)request.getRequest().getPath());
        WSHttpProtocolHandler pro = (WSHttpProtocolHandler)ctx.getProperty("com.sonicsw.net.http.ws.WSHttpProtocolHandler");
        if (HandlerUtils.hasSOAPEnvelope(message.getMsgContext().getRequestMessage())) {
            pro.createJmsMessage(message.getMsgContext());
        }
    }

    public synchronized boolean insertReceivedMessage(long msgNo, boolean last) {
        if (this.m_messageList.get(new Long(msgNo)) != null) {
            return true;
        }
        if (msgNo == this.m_maxReceivedMessageNumber + 1L) {
            this.m_messageList.put(new Long(msgNo), "INSERTED");
            this.m_maxReceivedMessageNumber = msgNo;
            if (last) {
                this.m_designatedLastMessageNumber = msgNo;
            }
        } else {
            return true;
        }
        this.m_buffer.clearTo(this.m_maxReceivedMessageNumber + 1L);
        return false;
    }

    public synchronized void commitReceivedMessage(SequenceCapsule capsule) {
        long msgNo = capsule.getNr();
        this.commitReceivedMessage(msgNo, capsule.getLast());
    }

    public synchronized void commitReceivedMessage(long msgNo, boolean last) {
        this.m_messageList.put(new Long(msgNo), "COMMITED");
        if (msgNo > this.m_maxReceivedMessageNumber) {
            this.m_maxReceivedMessageNumber = msgNo;
            if (last) {
                this.m_designatedLastMessageNumber = msgNo;
            }
        }
    }

    public synchronized ReliableMessageWrapper tryRetrieveBufferedMessage() {
        ReliableMessageWrapper rmw = null;
        try {
            if (!this.m_buffer.available()) {
                return null;
            }
            rmw = (ReliableMessageWrapper)this.m_buffer.remove();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (rmw != null && this.insertReceivedMessage(rmw)) {
            rmw = null;
        }
        return rmw;
    }

    public ReliableMessageWrapper retrieveMessage(Long messageNo) {
        ReliableMessageWrapper message = (ReliableMessageWrapper)this.m_messageList.get(messageNo);
        return message;
    }

    public SequenceAcknowledgement getSequenceAcknowledgement() {
        SequenceAcknowledgement seqAck = new SequenceAcknowledgement(this.m_rmConstants);
        long min = 0L;
        long max = 0L;
        boolean gotMsgRange = false;
        if (this.m_maxReceivedMessageNumber > 0L) {
            for (long i = 1L; i <= this.m_maxReceivedMessageNumber + 1L; ++i) {
                Object state = this.m_messageList.get(new Long(i));
                if (state != null && state.equals("COMMITED")) {
                    if (gotMsgRange) continue;
                    min = i;
                    gotMsgRange = true;
                    continue;
                }
                if (!gotMsgRange) continue;
                max = i - 1L;
                gotMsgRange = false;
                AcknowledgementRange ackRange = new AcknowledgementRange(this.m_rmConstants);
                ackRange.setMinValue(min);
                ackRange.setMaxValue(max);
                seqAck.addAckRanges(ackRange);
            }
        }
        seqAck.setIdentifier(this.getSequenceIdentifier());
        return seqAck;
    }

    public void updateAckedMessages(SequenceAcknowledgement acknowledgement, IRMAckListener listener) {
        List msgList = acknowledgement.getAckRanges();
        Iterator ite = msgList.iterator();
        boolean contiguous = true;
        boolean lastAcked = false;
        long max = 0L;
        long min = 0L;
        while (ite.hasNext()) {
            AcknowledgementRange range = (AcknowledgementRange)ite.next();
            if (range != null) {
                min = range.getMinValue();
                if (min != max + 1L) {
                    contiguous = false;
                }
                max = range.getMaxValue();
                for (long i = min; i <= max; ++i) {
                    ReliableMessageWrapper msg = (ReliableMessageWrapper)this.m_messageList.get(new Long(i));
                    if (msg == null) {
                        SequenceCapsule sc = new SequenceCapsule(this.getSequenceIdentifier().getIdentifier(), new Long(i), new Boolean(false));
                        SequencedDataContext sdc = RMManager.getRMManager().getAndClearPendingSequencedData(sc);
                        if (sdc != null) {
                            msg = new ReliableMessageWrapper();
                            msg.setLastSentTime(System.currentTimeMillis());
                            msg.setMsgContext(sdc.getContext());
                            msg.setSequenceInfo(sdc.getCapsule());
                            this.setLastActivity(System.currentTimeMillis());
                            this.insertProducedMessage(msg);
                            msg.setLastSentTime(System.currentTimeMillis());
                            msg.incrementTransmissionCount();
                        }
                    }
                    if (msg != null && msg.getSequenceInfo().getLast().booleanValue()) {
                        lastAcked = true;
                    }
                    if (this.DEBUG) {
                        this.debug("UPDATE ACKED :" + i + "-" + (msg != null ? msg.getSequenceInfo().toString() : "???"));
                    }
                    if (msg == null || msg.getAcknowledged()) continue;
                    msg.setAcknowledged(true);
                    if (listener == null) continue;
                    listener.onAck(msg);
                }
            }
            if (!lastAcked || !contiguous) continue;
            this.m_allAcknowledged = true;
        }
    }

    public void setPolicy(RMPolicy p) {
        this.m_policy = p;
    }

    public RMPolicy getPolicy() {
        return this.m_policy;
    }

    public long getLastActivity() {
        return this.m_lastActivity;
    }

    public void setLastActivity(long t) {
        this.m_lastActivity = t;
    }

    public Date getExpires() {
        return this.m_expires;
    }

    public void setExpires(Date d) {
        this.m_expires = d;
    }

    public long getLastConsumedMessageNumber() {
        return this.m_lastConsumedMessageNumber;
    }

    public long getDesignatedLastMessageNumber() {
        return this.m_designatedLastMessageNumber;
    }

    public long getMaxReceivedMessageNumber() {
        return this.m_maxReceivedMessageNumber;
    }

    public SortedMap getMessageList() {
        return this.m_messageList;
    }

    public void setLastConsumedMessageNumber(long l) {
        this.m_lastConsumedMessageNumber = l;
    }

    public void setDesignatedLastMessageNumber(long l) {
        this.m_designatedLastMessageNumber = l;
    }

    public void setMaxReceivedMessageNumber(long l) {
        this.m_maxReceivedMessageNumber = l;
    }

    public boolean isClientAssigned() {
        return this.m_isClientAssigned;
    }

    public boolean isAllAcknowledged() {
        return this.m_allAcknowledged;
    }

    public void setClientAssigned(boolean b) {
        this.m_isClientAssigned = b;
    }

    public long getPendingReorderCount() {
        if (this.m_buffer != null) {
            return this.m_buffer.getCount();
        }
        return 0L;
    }

    public ReOrderBuffer getReorderBuffer() {
        return this.m_buffer;
    }

    @Override
    public String toString() {
        return this.m_sequenceIdentifier.getIdentifier() + " to: " + this.m_endpoint.getAddress() + (this.m_expires != null ? " expires:" + this.m_expires : "");
    }
}

