/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.sender.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ws.WSHttpOutboundHandler;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.net.SocketException;
import org.apache.axis.MessageContext;

public class RequestResendEvent
extends RMEvent {
    @Override
    public void execute() {
        block7: {
            MessageContext mc = null;
            try {
                SequenceCapsule capsule = (SequenceCapsule)this.getContext().getProperty("com.sonicsw.ws.rm.common.SequenceCapsule");
                RMSendSequence support = RMManager.getRMManager().getRMSendSequenceSupport(capsule.getId());
                if (support == null) {
                    return;
                }
                ReliableMessageWrapper rmc = support.getSequenceState().retrieveMessage(capsule.getNr());
                if (rmc == null) {
                    return;
                }
                if (DebugObjects.getSenderFSMDebug().getDebug()) {
                    DebugObjects.getSenderFSMDebug().debug("RequestResendEvent-" + capsule.toString());
                }
                rmc.setEnqueuedForResend(false);
                mc = this.cloneForResend(this.getContext());
                WSHttpOutboundHandler hndlr = (WSHttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
                if (hndlr != null) {
                    hndlr.resendAxis(mc);
                } else {
                    BrokerComponent.getComponentContext().logMessage("No transport available to resend reliable sequence message to:" + this.getSequence().getSequenceState().getEndpointReference().getAddress() + ", id=" + this.getSequence().getId() + ". This may be addressed to an anonymous replyTo destination, for which no transport is defined to resend.", BrokerComponent.getLevelWarning().intValue());
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof SocketException) break block7;
                BrokerComponent.getComponentContext().logMessage("Failure attempting to resend over reliable sequence:" + this.getSequence().getId(), (Throwable)e, BrokerComponent.getLevelWarning().intValue());
            }
        }
    }

    public MessageContext cloneForResend(MessageContext mc) {
        mc.removeProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        mc.removeProperty("com.sonicsw.ws.rm.common.RxSequenceCapsule");
        mc.removeProperty("COM_SONIC_RM_REMOVE_MESSAGE");
        mc.removeProperty("COM_SONIC_WS_AXISFAULT_PROCESSED");
        mc.removeProperty("COM_SONIC_WS_AXISFAULT");
        mc.setPastPivot(false);
        mc.setResponseMessage(null);
        return mc;
    }

    public String toString() {
        return "RequestResendEvent";
    }
}

