/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.MessageParts;
import com.sonicsw.ws.security.policy.SSPConstants;
import com.sonicsw.ws.security.policy.SecurityTokenAssertion;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.WSPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2002.x12.secext.AlgorithmType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.ChallengeOrIntegrity;
import org.xmlsoap.schemas.ws.x2002.x12.secext.XPathSoap;

public class IntegrityAssertion
extends Assertion {
    private Signature m_signature = new Signature();
    private ArrayList m_tokenAssertionList;

    @Override
    public Object getAction() {
        return this.m_signature;
    }

    @Override
    public final int getType() {
        return INTEGRITY_ASSERTION;
    }

    public String getAlgCanonicalization() {
        return this.m_signature.getAlgCanonicalization();
    }

    public final void setAlgCanonicalization(String alg) {
        this.m_signature.setAlgCanonicalization(alg);
    }

    public String getAlgDigest() {
        return this.m_signature.getAlgDigest();
    }

    public final void setAlgDigest(String alg) {
        this.m_signature.setAlgDigest(alg);
    }

    public String getAlgSignature() {
        return this.m_signature.getAlgSignature();
    }

    public void setAlgSignature(String alg) {
        this.m_signature.setAlgSignature(alg);
    }

    public String getAlgTransform() {
        return this.m_signature.getAlgTransform();
    }

    public final void setAlgTransform(String alg) {
        this.m_signature.setAlgTransform(alg);
    }

    public List getTokenList() {
        return this.m_signature.getTokenList();
    }

    public void setTokenList(List tokenList) {
        this.m_signature.setTokenList(tokenList);
    }

    public IntegrityAssertion() {
    }

    public IntegrityAssertion(String soapEnvNSUri, ChallengeOrIntegrity integrityBean) throws PolicyException {
        this.initIntegrityAssertion(soapEnvNSUri, integrityBean);
    }

    private void initIntegrityAssertion(String soapEnvNSUri, ChallengeOrIntegrity integrityBean) throws PolicyException {
        XmlObject[] algorithmBeans = integrityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_ALGORITHM));
        for (int i = 0; i < algorithmBeans.length; ++i) {
            AlgorithmType algorithm = (AlgorithmType)algorithmBeans[i];
            QName type = algorithm.getType();
            String algURI = algorithm.getURI();
            if (type.equals(WSSPConstants.QN_ALGTYPE_CANONICALIZATION)) {
                this.setAlgCanonicalization(algURI);
                DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_ALGTYPE_CANONICALIZATION, Alg: " + algURI);
                continue;
            }
            if (type.equals(WSSPConstants.QN_ALGTYPE_DIGEST)) {
                this.setAlgDigest(algURI);
                DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_ALGTYPE_DIGEST, Alg: " + algURI);
                continue;
            }
            if (type.equals(WSSPConstants.QN_ALGTYPE_SIGNATURE)) {
                this.setAlgSignature(algURI);
                DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_ALGTYPE_SIGNATURE, Alg: " + algURI);
                continue;
            }
            if (type.equals(WSSPConstants.QN_ALGTYPE_TRANSFORM)) {
                this.setAlgTransform(algURI);
                DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_ALGTYPE_TRANSFORM, Alg: " + algURI);
                continue;
            }
            DebugObjects.getPolicyDebug().debug("type: UNKNOWN");
        }
        XmlObject[] tokens = integrityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_SECURITY_TOKEN));
        ArrayList<Object> tokenList = new ArrayList<Object>(3);
        this.m_tokenAssertionList = new ArrayList();
        for (int i = 0; i < tokens.length; ++i) {
            SecurityTokenAssertion sta = new SecurityTokenAssertion(tokens[i]);
            tokenList.add(sta.getAction());
            this.m_tokenAssertionList.add(sta);
            if (!sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_X509V3)) continue;
            XmlObject[] keyStoreBeans = tokens[i].selectPath(WSPUtils.childElementXPath(SSPConstants.QN_KEYSTORE_ENTRY));
            if (keyStoreBeans != null && keyStoreBeans.length > 0) {
                XmlObject[] privateKeyPasswordBeans;
                XmlObject keyStoreBean = keyStoreBeans[0];
                XmlObject[] aliasBeans = keyStoreBean.selectPath(WSPUtils.childElementXPath(SSPConstants.QN_ALIAS));
                if (aliasBeans != null && aliasBeans.length > 0) {
                    this.setX509TokenAlias(IntegrityAssertion.getTextContent(aliasBeans[0]));
                    DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_TOKENTYPE_X509V3, X509TokenRefIssuer: " + this.getX509TokenAlias());
                }
                if ((privateKeyPasswordBeans = keyStoreBean.selectPath(WSPUtils.childElementXPath(SSPConstants.QN_PRIVATE_KEY_PASSWORD))) != null && privateKeyPasswordBeans.length > 0) {
                    this.setX509TokenPrivateKeyPassword(IntegrityAssertion.getTextContent(privateKeyPasswordBeans[0]));
                    DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_TOKENTYPE_X509V3, X509TokenRefSerialNumber: " + this.getX509TokenPrivateKeyPassword());
                }
            }
            this.setX509TokenRef(sta.getX509TokenRef());
        }
        this.m_signature.setTokenList(tokenList);
        DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_MESSAGE_PARTS");
        XmlObject[] messagePartsBeans = integrityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_MESSAGE_PARTS));
        ArrayList<MessageParts> partList = new ArrayList<MessageParts>(3);
        for (int i = 0; i < messagePartsBeans.length; ++i) {
            XPathSoap messagePartsBean = (XPathSoap)messagePartsBeans[i];
            String dialect = messagePartsBean.getDialect();
            List signer = messagePartsBean.getSigner();
            Map nsMap = IntegrityAssertion.getInScopeNamespaces((XmlObject)messagePartsBean);
            String expression = IntegrityAssertion.getTextContent((XmlObject)messagePartsBean);
            MessageParts part = new MessageParts(dialect, nsMap, expression, signer, soapEnvNSUri);
            DebugObjects.getPolicyDebug().debug("part #" + (i + 1) + ": " + (part == null ? "null" : part.toString()));
            partList.add(part);
        }
        this.m_signature.addParts(partList);
    }

    public QName getX509TokenRef() {
        return this.m_signature.getX509TokenRef();
    }

    public String getX509TokenRefURI() {
        return this.m_signature.getX509TokenRefURI();
    }

    public String getX509TokenRefIssuer() {
        return this.m_signature.getX509TokenRefIssuer();
    }

    public String getX509TokenRefSerialNumber() {
        return this.m_signature.getX509TokenRefSerialNumber();
    }

    public String getX509TokenAlias() {
        return this.m_signature.getX509TokenAlias();
    }

    public String getX509TokenPrivateKeyPassword() {
        return this.m_signature.getX509TokenPrivateKeyPassword();
    }

    public void setX509TokenRef(QName X509TokenRef) {
        this.m_signature.setX509TokenRef(X509TokenRef);
    }

    public void setX509TokenRefURI(String X509TokenRefURI) {
        this.m_signature.setX509TokenRefURI(X509TokenRefURI);
    }

    public void setX509TokenRefIssuer(String X509TokenRefIssuer) {
        this.m_signature.setX509TokenRefIssuer(X509TokenRefIssuer);
    }

    public void setX509TokenRefSerialNumber(String X509TokenRefSerialNumber) {
        this.m_signature.setX509TokenRefSerialNumber(X509TokenRefSerialNumber);
    }

    public void setX509TokenAlias(String X509TokenAlias) {
        this.m_signature.setX509TokenAlias(X509TokenAlias);
    }

    public void setX509TokenPrivateKeyPassword(String X509TokenPrivateKeyPassword) {
        this.m_signature.setX509TokenPrivateKeyPassword(X509TokenPrivateKeyPassword);
    }

    private static Map getInScopeNamespaces(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        TreeMap m = new TreeMap();
        c.getAllNamespaces(m);
        c.dispose();
        return m;
    }

    private static String getTextContent(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        c.toFirstChild();
        return c.getTextValue();
    }

    public String toString() {
        String NEWLINE = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("-----------------------------------------------------------\n");
        buf.append("Assertion: Integrity").append("\n");
        buf.append("/Integrity/Algorithm/@Canonicalization: ").append(this.getAlgCanonicalization()).append("\n");
        buf.append("/Integrity/Algorithm/@Digest: ").append(this.getAlgDigest()).append("\n");
        buf.append("/Integrity/Algorithm/@Signature: ").append(this.getAlgSignature()).append("\n");
        buf.append("/Integrity/Algorithm/@Transform: ").append(this.getAlgTransform()).append("\n");
        buf.append("/Integrity/SecurityToken/ssp:KeyStoreEntry/ssp:Alias: ").append(this.getX509TokenAlias()).append("\n");
        buf.append("/Integrity/SecurityToken/ssp:KeyStoreEntry/ssp:PrivateKeyPassword: ").append(this.getX509TokenPrivateKeyPassword()).append("\n");
        buf.append("\nSupported Tokens: ").append("\n");
        for (SecurityTokenAssertion sta : this.m_tokenAssertionList) {
            buf.append(sta.toString());
        }
        buf.append("Message Parts").append("\n");
        buf.append(this.m_signature.getPartsAsString());
        buf.append("-----------------------------------------------------------\n");
        buf.append("\n");
        return buf.toString();
    }
}

