/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.security.policy.MessagePartWSS4J;
import com.sonicsw.wsp.PolicyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class MessageParts {
    private String m_dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    private List m_signer;
    private String m_expression;
    private MessagePartWSS4J[] m_parts;

    public MessageParts(String dialect, Map namespaceMap, String expression, List signer, String soapEnvNSUri) throws PolicyException {
        if (dialect != null) {
            this.m_dialect = dialect;
        }
        this.m_expression = expression;
        this.m_signer = signer;
        this.m_parts = this.computeWss4jParts(namespaceMap, soapEnvNSUri);
    }

    private String getSOAPDialectFunctionPrefix(String exprToken) throws PolicyException {
        if (exprToken == null) {
            throw new IllegalArgumentException("Null SOAP Dialect expression token");
        }
        int sepIndex = exprToken.indexOf(58);
        if (sepIndex == -1) {
            throw new PolicyException("Invalid MessageParts expression token: " + exprToken);
        }
        return exprToken.substring(0, sepIndex);
    }

    private String getSOAPDialectFunction(String exprToken) throws PolicyException {
        if (exprToken == null) {
            throw new IllegalArgumentException("Null SOAP Dialect expression token");
        }
        int sepIndex = exprToken.indexOf(58);
        if (sepIndex == -1) {
            throw new PolicyException("Invalid MessageParts expression token: " + exprToken);
        }
        return exprToken.substring(sepIndex + 1);
    }

    private MessagePartWSS4J[] computeWss4jParts(Map namespaceMap, String soapEnvNSUri) throws PolicyException {
        if (this.m_expression == null) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(this.m_expression);
        ArrayList<MessagePartWSS4J> parts = new ArrayList<MessagePartWSS4J>();
        while (stk.hasMoreTokens()) {
            String mode = null;
            String exprToken = stk.nextToken();
            QName qName = null;
            if (this.m_dialect.equals("http://schemas.xmlsoap.org/2002/12/wsse#part")) {
                String nsPrefix = this.getSOAPDialectFunctionPrefix(exprToken);
                String function = this.getSOAPDialectFunction(exprToken);
                qName = this.evaluateSoap(namespaceMap, nsPrefix, function, soapEnvNSUri);
                parts.add(new MessagePartWSS4J(mode, qName));
                continue;
            }
            if (this.m_dialect.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                throw new PolicyException("Unsupported MessagePart dialect: " + this.m_dialect);
            }
            if (this.m_dialect.equals("http://www.sonicsw.com/2005/06/wssp-ext#part")) {
                MessagePartWSS4J part = this.evaluateParts(exprToken, soapEnvNSUri);
                parts.add(part);
                continue;
            }
            throw new PolicyException("Unsupported MessagePart dialect: " + this.m_dialect);
        }
        MessagePartWSS4J[] wss4jParts = new MessagePartWSS4J[parts.size()];
        parts.toArray(wss4jParts);
        if (wss4jParts == null || wss4jParts.length == 0) {
            wss4jParts = null;
        }
        return wss4jParts;
    }

    private QName evaluateXPath(Map namespaceMap, String prefix, String local) throws PolicyException {
        String nsuri = (String)namespaceMap.get(prefix);
        if (nsuri == null) {
            throw new PolicyException("Undeclared prefix " + prefix + " in MessageParts expression");
        }
        return new QName(nsuri, local);
    }

    private QName evaluateSoap(Map namespaceMap, String prefix, String function, String soapEnvNSUri) throws PolicyException {
        String nsuri = "http://schemas.xmlsoap.org/ws/2004/09/policy";
        String HEADER = "Header";
        String BODY = "Body";
        int openParenIndex = function.indexOf(40);
        if (openParenIndex == -1) {
            throw new PolicyException("Unrecognized MessageParts SOAP Dialect expression: \"" + function + "\"");
        }
        String fname = function.substring(0, openParenIndex);
        int closeParenIndex = function.indexOf(41, openParenIndex + 1);
        if (closeParenIndex == -1) {
            throw new PolicyException("Unrecognized MessageParts SOAP Dialect expression: \"" + function + "\"");
        }
        String args = function.substring(openParenIndex + 1, closeParenIndex);
        if (nsuri.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            if (fname.equals("Body")) {
                return new QName(soapEnvNSUri, "Body");
            }
            if (fname.startsWith("Header")) {
                String headerQName = args.trim();
                String headerPrefix = MessageParts.getNSPrefix(headerQName);
                String headerLocalName = MessageParts.getLocalName(headerQName);
                String headerNamespace = (String)namespaceMap.get(headerPrefix);
                if (headerNamespace == null) {
                    throw new PolicyException("Invalid MessagePart expression: " + prefix + ":" + function + " - No declaration found for prefix");
                }
                return new QName(headerNamespace, headerLocalName);
            }
            throw new PolicyException("Unrecognized MessageParts SOAP Dialect function: \"" + fname + "\"");
        }
        throw new PolicyException("Unrecognized MessagePart SOAP Dialect function namespace {" + nsuri + "} in expression \"" + prefix + ":" + function + "\"");
    }

    private MessagePartWSS4J evaluateParts(String function, String soapEnvNSUri) throws PolicyException {
        String HEADER = "Header";
        String BODY = "Body";
        String TOKEN = "Token";
        String CONTENT = "Content";
        String ELEMENT = "Element";
        int openParenIndex = function.indexOf(40);
        if (openParenIndex == -1) {
            throw new PolicyException("Unrecognized MessageParts expression: \"" + function + "\" for dialect \"" + "http://www.sonicsw.com/2005/06/wssp-ext#part");
        }
        String fname = function.substring(0, openParenIndex);
        int closeParenIndex = function.indexOf(41, openParenIndex + 1);
        if (closeParenIndex == -1) {
            throw new PolicyException("Unrecognized MessageParts expression: \"" + function + "\" for dialect \"" + "http://www.sonicsw.com/2005/06/wssp-ext#part");
        }
        String args = function.substring(openParenIndex + 1, closeParenIndex).trim();
        if (fname.equals("Token")) {
            return new MessagePartWSS4J(null, new QName("Token"));
        }
        if (fname.equals("Body") && (args == null || args.length() == 0)) {
            return new MessagePartWSS4J("Content", new QName(soapEnvNSUri, "Body"));
        }
        if (fname.equals("Body") || fname.equals("Header")) {
            if (args == null || args.length() == 0) {
                throw new PolicyException("Unrecognized message part: \"" + function + "\"");
            }
            StringTokenizer st = new StringTokenizer(args, "}");
            String[] partDef = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                partDef[i++] = st.nextToken();
            }
            String mode = "Content";
            String nmSpace = soapEnvNSUri;
            String element = null;
            if (partDef.length == 1) {
                element = partDef[0].trim();
            } else if (partDef.length == 2) {
                String ns = partDef[0].trim();
                if (ns.length() > 1) {
                    nmSpace = ns.substring(1);
                }
                element = partDef[1].trim();
            } else if (partDef.length == 3) {
                String ns;
                String modifier = partDef[0].trim();
                if (modifier.length() > 1) {
                    mode = modifier.substring(1);
                }
                if ((ns = partDef[1].trim()).length() > 1) {
                    nmSpace = ns.substring(1);
                }
                element = partDef[2].trim();
            } else {
                throw new PolicyException("Unrecognized message part: \"" + function + "\"");
            }
            return new MessagePartWSS4J(mode, new QName(nmSpace, element));
        }
        throw new PolicyException("Unrecognized message part: \"" + function + "\"");
    }

    private static String getNSPrefix(String qname) {
        return qname.substring(0, qname.lastIndexOf(58));
    }

    private static String getLocalName(String qname) {
        return qname.substring(qname.lastIndexOf(58) + 1);
    }

    public List getSigner() {
        return this.m_signer;
    }

    public void setSigner(List signer) {
        this.m_signer = signer;
    }

    public String getDialect() {
        return this.m_dialect;
    }

    public void setDialect(String dialect) {
        this.m_dialect = dialect;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    public MessagePartWSS4J[] getParts() {
        return this.m_parts;
    }

    public void setParts(MessagePartWSS4J[] parts) {
        this.m_parts = parts;
    }

    public String toString() {
        String NEWLINE = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("Dialect: ").append(this.getDialect()).append("\n");
        buf.append("Signer: ").append(this.getSigner()).append("\n");
        buf.append("PartsStr: ").append(this.m_expression).append("\n");
        return buf.toString();
    }
}

