/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.security.policy.model.HttpsToken;
import com.sonicsw.ws.security.policy.model.TransportToken;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.w3c.dom.Element;

public class HttpsTokenProcessor {
    private String htpID = null;
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedHttpsToken = false;

    private void initializeHttpsToken(SecurityPolicyToken spt) throws NoSuchMethodException {
    }

    public Object doHttpsToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedHttpsToken) break;
                try {
                    this.initializeHttpsToken(spt);
                    HttpsToken httpsToken = (HttpsToken)spc.readCurrentPolicyEngineData();
                    String requireCert = spc.getAssertion().getAttribute(new QName("", "RequireClientCertificate"));
                    if (requireCert != null) {
                        httpsToken.setClientCertificateRequired(requireCert);
                    }
                    ((TransportToken)spc.readPreviousPolicyEngineData()).setTransportToken(httpsToken);
                    this.initializedHttpsToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        this.htpID = elem.getAttributeNS(null, "Id");
    }

    public String getId() {
        return this.htpID;
    }
}

