/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.ws.security.processingresult.SignatureResult;
import com.sonicsw.ws.security.processingresult.SupportingTokenResult;
import java.util.Vector;

public class ProcessingResult {
    private String actor;
    private Vector results;

    public ProcessingResult(String actor, Vector wsResults) {
        this.actor = actor;
        this.results = wsResults;
    }

    public String getActor() {
        return this.actor;
    }

    public String[] getUsernames() {
        if (this.results == null || this.results.isEmpty()) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        for (int i = 0; i < this.results.size(); ++i) {
            if (!(this.results.get(i) instanceof SupportingTokenResult)) continue;
            temp.add(((SupportingTokenResult)this.results.get(i)).getUsername());
        }
        if (temp.isEmpty()) {
            return null;
        }
        Object[] users = new String[temp.size()];
        temp.copyInto(users);
        return users;
    }

    public String[] getSigners() {
        if (this.results == null || this.results.isEmpty()) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        for (int i = 0; i < this.results.size(); ++i) {
            if (!(this.results.get(i) instanceof SignatureResult)) continue;
            temp.add(((SignatureResult)this.results.get(i)).getCertificate().getSubjectX500Principal().getName());
        }
        if (temp.isEmpty()) {
            return null;
        }
        Object[] signers = new String[temp.size()];
        temp.copyInto(signers);
        return signers;
    }
}

