/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.security.action.TransportBindingAction;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.model.HttpsToken;
import com.sonicsw.ws.security.policy.model.SonicAlgorithmSuiteUtils;
import com.sonicsw.ws.security.policy.model.TransportToken;
import com.sonicsw.wsp.PolicyException;
import org.apache.axis.MessageContext;
import org.apache.ws.security.policy.model.AlgorithmSuite;

public class TransportBindingResult {
    private String m_algorithmSuiteUsed_standardized = null;
    private String m_protocol = null;
    private String m_status = null;

    public TransportBindingResult(MessageContext mc) throws PolicyException {
        DebugObjects.getHandlerDebug().debug("TransportBindingResult: checking message context for properties");
        String inboundUrl = HandlerUtils.evaluateInboundHandlerURL(mc);
        if (inboundUrl != null) {
            this.m_protocol = HttpHelper.isHttps(inboundUrl) ? "https" : "http";
        } else {
            String outboundUrl = HandlerUtils.evaluateOutboundTransportURL(mc);
            if (outboundUrl != null) {
                this.m_protocol = HttpHelper.isHttps(outboundUrl) ? "https" : "http";
            } else {
                throw new PolicyException("Unable to determine the actual protocol that the current message uses.");
            }
        }
        String cipherSuiteUsed = (String)mc.getProperty("X-HTTPS-WS-BindingCipherSuite");
        if (cipherSuiteUsed != null) {
            this.m_algorithmSuiteUsed_standardized = SonicAlgorithmSuiteUtils.getWSAlgorithmSuiteName(cipherSuiteUsed);
        }
    }

    public boolean validate(TransportBindingAction transport) {
        if (transport == null || !transport.getTokenType().equals(WSSPConstants.QN_TRANSPORT_BINDING)) {
            this.setStatus("TransportBindingResult: TransportBinding unable to validate undefined TransportBinding action");
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        try {
            TransportToken transportToken = transport.getTransportToken();
            if (transportToken == null) {
                this.setStatus("TransportBindingResult: TransportBinding to find associated TokenToken, policy not correctly defined.");
                DebugObjects.getHandlerDebug().debug(this.getStatus());
                return false;
            }
            HttpsToken httpsToken = transport.getHttpsTokenToken();
            if (httpsToken == null) {
                this.setStatus("TransportBindingResult: TransportBinding to find associated HttpsToken");
                DebugObjects.getHandlerDebug().debug(this.getStatus());
                return false;
            }
            if (!this.m_protocol.equalsIgnoreCase("https")) {
                this.setStatus("TransportBindingResult: TransportBinding requires HTTPS, configuration trying to use HTTP instead");
                DebugObjects.getHandlerDebug().debug(this.getStatus());
                return false;
            }
            if (HttpHelper.ENABLE_TRANSPORTBINDING_SUITE_CHECKING) {
                AlgorithmSuite expectedSuite = transport.getAlgorithmSuite();
                String expectedStandardSuiteName = SonicAlgorithmSuiteUtils.getAlgorithmSuiteName(expectedSuite);
                if (this.m_algorithmSuiteUsed_standardized == null || expectedStandardSuiteName == null) {
                    this.setStatus("TransportBindingResult: TransportBinding unable to verify suite suite used = " + this.m_algorithmSuiteUsed_standardized + " suite expected = " + expectedStandardSuiteName);
                    DebugObjects.getHandlerDebug().debug(this.getStatus());
                    return false;
                }
                if (!this.m_algorithmSuiteUsed_standardized.equalsIgnoreCase(expectedStandardSuiteName)) {
                    this.setStatus("TransportBindingResult: TransportBinding AlgorithmSuite mismatch  suite used = " + this.m_algorithmSuiteUsed_standardized + " suite expected = " + expectedStandardSuiteName);
                    DebugObjects.getHandlerDebug().debug(this.getStatus());
                    return false;
                }
            }
        }
        catch (PolicyException e) {
            this.setStatus(e.getMessage());
            DebugObjects.getHandlerDebug().debug(this.getStatus());
            return false;
        }
        return true;
    }

    public void setStatus(String err) {
        this.m_status = err;
    }

    public String getStatus() {
        return this.m_status;
    }
}

