/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util.xml;

import com.sonicsw.ws.util.xml.SonicNamespaceReducer;
import java.io.Writer;
import java.util.Properties;
import net.sf.saxon.Controller;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.om.NodeInfo;

public class SaxonSerializationUtils {
    public static final int ALL_NAMESPACES = 1;
    public static final int LOCAL_NAMESPACES = 2;
    public static final int USED_NAMESPACES = 3;

    public static void serializeNodeToWriter(NodeOverNodeInfo node, Writer writer) {
        SaxonSerializationUtils.serializeNodeToWriter(node, writer, 3);
    }

    public static void serializeNodeToWriter(NodeOverNodeInfo node, Writer writer, int namespaceMode) {
        NodeOverNodeInfo noni = node;
        NodeInfo ni = noni.getUnderlyingNodeInfo();
        SaxonSerializationUtils.serializeNodeToWriter(ni, writer, namespaceMode);
    }

    public static void serializeNodeToWriter(NodeInfo node, Writer writer) {
        SaxonSerializationUtils.serializeNodeToWriter(node, writer, 3);
    }

    public static boolean serializeNodeToWriter(NodeInfo node, Writer writer, int namespaceMode) {
        boolean isXML = false;
        try {
            int type = node.getNodeKind();
            switch (type) {
                case 9: {
                    isXML = true;
                    break;
                }
                case 1: {
                    isXML = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    String result = node.getStringValue();
                    writer.write(result);
                    return false;
                }
            }
            Controller controller = new Controller(node.getConfiguration());
            PipelineConfiguration pc = controller.makePipelineConfiguration();
            Properties outputProperties = new Properties();
            outputProperties.setProperty("omit-xml-declaration", "true");
            XMLEmitter xmlEmitter = new XMLEmitter();
            xmlEmitter.setPipelineConfiguration(pc);
            xmlEmitter.setWriter(writer);
            xmlEmitter.setOutputProperties(outputProperties);
            SonicNamespaceReducer proxy = new SonicNamespaceReducer();
            proxy.setPipelineConfiguration(pc);
            proxy.setUnderlyingReceiver((Receiver)xmlEmitter);
            node.copy((Receiver)proxy, namespaceMode == 2 ? 1 : 2, false, 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        return isXML;
    }
}

