/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.util.ArrayList;
import java.util.HashMap;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.PublishLimiter;
import progress.message.broker.PublishLimiterCC;
import progress.message.broker.RecipientVector;
import progress.message.broker.RecipientWrap;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageProtection;

public final class AMPScratchPad {
    BrokerSearchResults m_bsr = new BrokerSearchResults();
    ArrayList m_matches = null;
    RecipientVector m_guarClients = new RecipientVector();
    RecipientVector m_relClients = new RecipientVector();
    RecipientVector m_ptpClients = new RecipientVector();
    HashMap m_clients;
    public LBSTrackingInfo m_groupSubscriptionList = null;
    public boolean m_groupSubscriptionOnly = false;
    public boolean m_gsRedeliveryOk = false;
    public LongHashTable m_groupSubscriptionsByNeighbor = null;
    public boolean m_forceDeliverOnFlush = false;
    LongHashTable m_proxyRecipsTable;
    PublishLimiter m_pubLimiter = null;
    IClientContext m_publisher;
    boolean m_xonce;
    boolean m_persist;
    IMessageProtection m_mp = null;
    byte[] m_tempMessageKeyBuffer = null;
    long m_dispatchId = -1L;
    boolean m_isBatchable = false;
    boolean m_isBatchAtomic = false;
    boolean m_dmqOverride = false;

    public AMPScratchPad() {
        if (!Config.ENABLE_QOPSECURITY) {
            return;
        }
        try {
            this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 1);
            throw new EAssertFailure(e);
        }
        this.m_tempMessageKeyBuffer = new byte[this.m_mp.getSecretKeyLength()];
    }

    public void setClientContext(IClientContext cc) {
        this.m_publisher = cc;
        this.m_pubLimiter = cc.getPublishLimiter();
        if (this.m_pubLimiter == null) {
            this.m_pubLimiter = new PublishLimiterCC(cc);
        }
    }

    void undoPubDispatch() {
        if (this.m_guarClients != null) {
            AMPScratchPad.undoPubDispatch(this.m_guarClients);
        }
        if (this.m_relClients != null) {
            AMPScratchPad.undoPubDispatch(this.m_relClients);
        }
        if (this.m_ptpClients != null) {
            AMPScratchPad.undoPubDispatch(this.m_ptpClients);
        }
    }

    public static void undoPubDispatch(FastVector subscribers) {
        for (int ii = 0; ii < subscribers.m_count; ++ii) {
            IClientContext cc;
            RecipientWrap rw = (RecipientWrap)subscribers.m_data[ii];
            if (rw == null || (cc = rw.getClient()) == null) continue;
            cc.undoPubDispatch();
        }
    }
}

