/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AdministrativelyCreatedQueue;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IMessageGroupHandle;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.ISavableAgentQueue;
import progress.message.broker.ISizeChangeListener;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.cwaq.ClusteredQueueManager;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.QueueUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.Subject;

public class AgentAdministrativelyCreatedQueue
extends BaseAgentQueue
implements IAgentQueue,
ISavableAgentQueue,
IMessageGroupHandle {
    private String m_name;
    private ISubject m_subject;
    AgentRegistrar m_reg;
    private Label m_emptyLabel;
    AdministrativelyCreatedQueue m_queue;
    private int m_state = 0;
    private boolean m_global = false;
    private boolean m_clustered = false;
    private Hashtable m_selectorInfoTable;
    private LongHashTable m_selectorStringbyClientId;
    private LongHashTable m_outstandingRemoteRequest;
    private int m_nonDelayableReceiverCount = 0;
    private boolean m_readOnly = false;
    private boolean m_readExclusive = false;
    private boolean m_writeOnly = false;
    private boolean m_writeExclusive = false;

    public AgentAdministrativelyCreatedQueue(String qName, AdministrativelyCreatedQueue acq, AgentRegistrar reg) {
        super("AgentAdministrativelyCreatedQueue");
        this.m_queue = acq;
        this.m_queue.setParent(this);
        this.initInstance(qName, reg);
    }

    @Override
    public void clearExpiredMsgs() throws InterruptedException {
        this.m_queue.checkForExpiredMsgs();
    }

    @Override
    public void onOutstandingLocalClientGetRequests() {
        if (this.m_clustered) {
            this.generateRemoteGetRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(long cid, short requestType, int count, boolean isRemoteGetRequest) {
        IMgram m = null;
        if (this.DEBUG) {
            this.debug("get: handling get request for cid = " + cid + " count = " + count + " isRemoteGetRequest = " + isRemoteGetRequest);
        }
        switch (requestType) {
            case 1: {
                if (this.DEBUG) {
                    this.debug("RCV request from CID:" + cid + ", Count:" + count);
                }
                this.addRequest(cid, count, isRemoteGetRequest);
                break;
            }
            case 2: {
                if (this.DEBUG) {
                    this.debug("RCVNOWAIT request from CID:" + cid + ", Count:" + count);
                }
                AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
                synchronized (administrativelyCreatedQueue) {
                    m = (IMgram)this.m_queue.dequeue(cid);
                    try {
                        IClientContext cc = this.m_reg.getClient(cid);
                        String subject = QueueUtil.getQueueClientSubject(cc.getUid(), cc.getAppid(), m == null ? "queueEmpty" : "queueNotEmpty");
                        Envelope env = new Envelope(new Message(subject));
                        this.m_reg.getAdminSession().publish(env, 0, false);
                        if (this.DEBUG) {
                            this.debug("Sent notification to:" + subject);
                        }
                        if (m != null) {
                            long enqTm = m.getBrokerHandle().getPtpEnqueueTime();
                            long tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
                            boolean delivered = this.deliver(m, cid);
                            if (delivered) {
                                this.updateQueueDelvStats(m);
                                if (tmInQueue > 0L) {
                                    this.updateStatistic(this.m_timeInQueueStat, tmInQueue);
                                }
                            }
                        } else {
                            this.onOutstandingLocalClientGetRequests();
                        }
                        break;
                    }
                    catch (EClientNotRegistered e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                    catch (ESecurityGeneralException e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                    catch (EGeneralException e) {
                        this.m_queue.reenqueue(m, true);
                        return;
                    }
                }
            }
            case 3: {
                if (this.DEBUG) {
                    this.debug("BROWSE request from CID:" + cid + ", Count:" + count + ", for queue:" + this.getQueueName());
                }
                try {
                    while (count > 0 && (m = (IMgram)this.m_queue.browse(cid)) != null) {
                        if (m.isGuarenteed()) {
                            m.setReliable();
                        }
                        this.deliver(m, cid);
                        --count;
                    }
                    if (count <= 0) break;
                    IClientContext cc = null;
                    cc = this.m_reg.getClient(cid);
                    String uid = cc.getUid();
                    String appid = cc.getAppid();
                    AgentAdminSession sn = this.m_reg.getAdminSession();
                    Message reply = new Message();
                    reply.setSubject(QueueUtil.getQueueClientSubject(uid, appid, "endOfBrowse"));
                    try {
                        sn.publish(reply, 0, false);
                    }
                    catch (EGeneralException ge) {}
                    break;
                }
                catch (EClientNotRegistered e) {
                    return;
                }
                catch (ESecurityGeneralException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getQueueName() {
        return this.m_name;
    }

    @Override
    public String getQueueAddress() {
        return this.m_subject.getSubjectString();
    }

    @Override
    public void restore(IndexedList unacked, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        this.restore(unacked.elements(), preserveRedelivery, notifyMsgEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(Enumeration enu, boolean preserveRedelivery, boolean notifyMsgEnqueued) {
        if (!enu.hasMoreElements()) {
            return;
        }
        Vector v = new Vector();
        while (enu.hasMoreElements()) {
            v.addElement(enu.nextElement());
        }
        Object[] msgs = new Object[v.size()];
        v.copyInto(msgs);
        if (this.DEBUG) {
            this.debug("restoring " + msgs.length + " messages to queue");
        }
        AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
        synchronized (administrativelyCreatedQueue) {
            for (int i = msgs.length - 1; i >= 0; --i) {
                IMgram m = (IMgram)msgs[i];
                m.setNoOutqueueExpire(false);
                if (this.DEBUG) {
                    this.debug("restoring " + m.getGuarenteedTrackingNum());
                }
                this.m_queue.reenqueue(m, preserveRedelivery);
            }
        }
        if (notifyMsgEnqueued) {
            this.initiateDispatching();
        }
    }

    @Override
    public void unreserve(int size) {
        this.m_queue.unreserve(size);
    }

    @Override
    public void acknowledge(long tracking, long ackTracking) {
    }

    @Override
    public void clear() throws InterruptedException {
        this.m_queue.clear();
    }

    @Override
    public synchronized void close() {
        if (this.m_state == 3) {
            this.m_state = 4;
            this.dispatchShutdown();
            this.cleanupMetrics();
            this.m_state = 5;
        }
    }

    @Override
    public boolean closeBrowser(long clientId) {
        return this.m_queue.closeBrowser(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeReceiver(long clientId) {
        if (this.DEBUG) {
            this.debug(": closeReceiver: called for clientId:" + clientId);
        }
        boolean dupClose = !this.m_queue.isLocalJMSReceiverOpen(clientId);
        this.m_queue.closeLocalJMSReceiver(clientId);
        this.clearLocalRequests(clientId);
        if (this.m_clustered && !dupClose) {
            AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
            synchronized (administrativelyCreatedQueue) {
                String selector = null;
                if (this.m_selectorStringbyClientId != null) {
                    selector = (String)this.m_selectorStringbyClientId.remove(clientId);
                }
                if (selector == null) {
                    selector = "";
                }
                if (this.DEBUG) {
                    this.debug(": closeReceiver: the receiver contained selector: " + (selector.equals("") ? " NO SELECTOR" : selector));
                }
                Counter receiverCount = null;
                if (this.m_selectorInfoTable.size() >= 1) {
                    receiverCount = (Counter)this.m_selectorInfoTable.get(selector);
                }
                if (receiverCount != null) {
                    receiverCount.decrement();
                    if (this.DEBUG) {
                        this.debug(": closeReceiver: the receiverCount for that selector is " + receiverCount.getIntValue());
                    }
                    if (receiverCount.getIntValue() == 0) {
                        this.generateCloseRemoteReceiverMgrams(selector);
                        this.m_selectorInfoTable.remove(selector);
                        if (this.DEBUG) {
                            this.debug(": closeReceiver: removed selector: " + (selector.equals("") ? " NO SELECTOR" : selector) + " from m_selectorInfoTable because receiverCount.getIntValue():" + receiverCount.getIntValue() + " is equal to 0");
                        }
                        if (this.m_selectorInfoTable.isEmpty()) {
                            this.m_outstandingRemoteRequest.clear();
                            if (this.DEBUG) {
                                this.debug(": closeReceiver: clearing all outstanding get request counters after the last receiver has closed.");
                            }
                        }
                    }
                }
            }
        }
    }

    public void closeRemoteReceiver(long clientId, String selector) {
        boolean clearRemoteGetRequests;
        if (!this.m_clustered) {
            return;
        }
        if (this.DEBUG) {
            this.debug(": closeRemoteReceiver: received request with cliendId: " + clientId + " selector: " + (selector.equals("") ? " NO SELECTOR" : selector));
        }
        if (clearRemoteGetRequests = this.m_queue.closeRemoteReceiver(clientId, selector)) {
            this.clearRemoteRequests(clientId);
            if (this.DEBUG) {
                this.debug(": closeRemoteReceiver: cleared remote requests for cliendId: " + clientId + " selector: " + (selector.equals("") ? " NO SELECTOR" : selector));
            }
        }
    }

    @Override
    public IMgram dequeue(long clientId) throws InterruptedException {
        IMgram m = (IMgram)this.m_queue.dequeueWait(clientId);
        if (this.DEBUG) {
            if (m != null) {
                this.debug("Dequeued TKID:" + m.getGuarenteedTrackingNum() + " for CID:" + clientId + ", from Queue:" + this.getQueueName() + ", Total Queue Size:" + this.m_queue.getCurrentTotalSize() + ", Total Enqueued Count:" + this.m_queue.getCurrentEnqueuedCount());
            } else {
                this.debug("Dequeued NULL for CID:" + clientId + ", from Queue:" + this.getQueueName());
            }
        }
        return m;
    }

    @Override
    public IMgram dequeueByTrackingNum(long trackingNum) {
        IMgram m = (IMgram)this.m_queue.dequeueByTrackingNum(trackingNum);
        if (this.DEBUG) {
            if (m != null) {
                this.debug("Dequeued TKID:" + m.getGuarenteedTrackingNum() + ", from Queue:" + this.getQueueName() + ", Total Queue Size:" + this.m_queue.getCurrentTotalSize() + ", Total Enqueued Count:" + this.m_queue.getCurrentEnqueuedCount());
            } else {
                this.debug("Dequeued NULL, from Queue:" + this.getQueueName());
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public int dispatch(long clientId, int count, boolean forRemoteBroker) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("AgentQueue.dispatch: clientId = " + clientId + ", count = " + count + " forRemoteBroker = " + forRemoteBroker);
            this.debug("AgentQueue.dispatch: count of enqueued msgs = " + this.getTotalEnqueued());
        }
        try {
            IClientContext cc = this.m_reg.getClient(clientId);
            if (!cc.okToDispatchQueueMsgs(this)) {
                if (this.DEBUG) {
                    this.debug("AgentQueue.dispatch: CC not ready for dispatch:" + cc);
                }
                return 0;
            }
        }
        catch (EClientNotRegistered cnre) {
            return 0;
        }
        if (forRemoteBroker) {
            return this.dispatchToRemote(clientId, count);
        }
        int deliveredCount = 0;
        boolean delivered = false;
        AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
        synchronized (administrativelyCreatedQueue) {
            for (int i = 0; i < count; ++i) {
                IMgram m = (IMgram)this.m_queue.dequeue(clientId);
                if (this.DEBUG) {
                    this.debug("AgentQueue.dispatch: in loop, count of enqueued msgs = " + this.getTotalEnqueued());
                }
                if (m != null) {
                    if (this.DEBUG) {
                        this.debug("dequeued mgram " + m.getGuarenteedTrackingNum());
                    }
                    try {
                        long enqTm = m.getBrokerHandle().getPtpEnqueueTime();
                        long tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
                        delivered = this.deliver(m, clientId);
                        if (delivered) {
                            ++deliveredCount;
                            this.updateQueueDelvStats(m);
                            if (tmInQueue > 0L) {
                                this.updateStatistic(this.m_timeInQueueStat, tmInQueue);
                            }
                        }
                        if (!this.DEBUG) continue;
                        this.debug("mgram delivered = " + delivered + ", delivery count = " + deliveredCount);
                    }
                    catch (EClientNotRegistered e) {
                        if (this.DEBUG) {
                            this.debug("client not registered, restoring to queue", e);
                        }
                        this.m_queue.reenqueue(m, true);
                    }
                    catch (ESecurityGeneralException e) {
                        BrokerComponent.getComponentContext().logMessage("Security exception processing mgram: ", (Throwable)e, 1);
                    }
                    continue;
                }
                if (this.DEBUG) {
                    this.debug("dequeue returned null, delivery count = " + deliveredCount);
                }
                int n = deliveredCount;
                return n;
            }
        }
        if (this.m_clustered && this.getTotalEnqueued() <= Config.CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD && this.getReceiverCount() > 0) {
            this.generateRemoteGetRequests();
        }
        if (this.DEBUG) {
            this.debug("count = " + count + ", delivery count = " + deliveredCount);
        }
        return deliveredCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int dispatchToRemote(long clientId, int count) throws InterruptedException {
        IRemoteBroker irb;
        if (this.DEBUG) {
            this.debug("IAgentQueue.dispatchToRemote: clientId = " + clientId + ", count = " + count);
            this.debug("IAgentQueue.dispatchToRemote: count of enqueued msgs = " + this.getTotalEnqueued());
        }
        if ((irb = this.m_reg.getClusteredQueueManager().getRemoteBrokerforClusteredQueue(this.m_name, clientId)) == null) {
            return -1;
        }
        int deliveredCount = 0;
        boolean delivered = false;
        AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
        synchronized (administrativelyCreatedQueue) {
            int i = 0;
            while (i < count) {
                block18: {
                    if (!irb.isOkToDispatch(this)) {
                        if (!this.DEBUG) return deliveredCount;
                        this.debug(this.m_name + " ++++++FLOW CONTROLLED++++++ !!!!!! AgentQueue.dispatchToRemote: remote broker not ready for sending so skip over requests deliveredCount = " + deliveredCount);
                        return deliveredCount;
                    }
                    IMgram m = (IMgram)this.m_queue.dequeue(clientId);
                    if (this.DEBUG) {
                        this.debug("dispatchToRemote: " + this.m_name + " in loop m = " + m + " , count of enqueued msgs = " + this.getTotalEnqueued() + " deliveredCount = " + deliveredCount);
                    }
                    if (m != null) {
                        if (this.DEBUG) {
                            this.debug("dequeued mgram " + m.getGuarenteedTrackingNum());
                        }
                        try {
                            m.setNoOutqueueExpire(true);
                            long enqTm = m.getBrokerHandle().getPtpEnqueueTime();
                            long tmInQueue = enqTm > 0L ? System.currentTimeMillis() - enqTm : 0L;
                            delivered = this.deliverToRemote(m, irb);
                            if (delivered) {
                                ++deliveredCount;
                                this.updateQueueDelvStats(m);
                                if (tmInQueue > 0L) {
                                    this.updateStatistic(this.m_timeInQueueStat, tmInQueue);
                                }
                            }
                            if (this.DEBUG) {
                                this.debug("mgram delivered = " + delivered + ", delivery count = " + deliveredCount);
                            }
                            break block18;
                        }
                        catch (EClientNotRegistered e) {
                            if (this.DEBUG) {
                                this.debug("client not registered, restoring to queue", e);
                            }
                            m.setNoOutqueueExpire(false);
                            this.m_queue.reenqueue(m, true);
                        }
                        catch (ESecurityGeneralException e) {
                            BrokerComponent.getComponentContext().logMessage("Security exception processing mgram: ", (Throwable)e, 1);
                        }
                        break block18;
                    }
                    if (!this.DEBUG) return deliveredCount;
                    this.debug(this.m_name + "dequeue returned null, delivery count = " + deliveredCount);
                    return deliveredCount;
                }
                ++i;
            }
            return deliveredCount;
        }
    }

    @Override
    public void enqueue(IMgram m) {
        long size = 0L;
        if (!m.isGuarenteed()) {
            throw new EAssertFailure("Attemped to enqueue unguaranteed message");
        }
        this.m_queue.enqueue(m);
        if (this.DEBUG) {
            size = this.m_queue.getCurrentTotalSize();
        }
        this.initiateDispatching(true);
        this.updateQueueRcvdStats(m);
        if (this.DEBUG) {
            this.debug("Enqueued TKID:" + m.getGuarenteedTrackingNum() + ", PRI:" + m.getPriority() + ", Queue Size:" + size + (m.isJMSPersistent() ? " PERSISTENT" : ""));
        }
    }

    @Override
    public boolean forceReserve(IMgram m) {
        return this.m_queue.forceReserve(m);
    }

    @Override
    public void forcedSave() {
        this.m_queue.forcedSave();
    }

    @Override
    public Object getDequeueLock() {
        return this.m_queue;
    }

    @Override
    public int getMaxQueueSizeInKiloBytes() {
        return this.m_queue.getMaxQueueSizeInKiloBytes();
    }

    @Override
    public synchronized int getNonDelayableReceiverCount() {
        return this.m_nonDelayableReceiverCount;
    }

    @Override
    public long getMaxQueueSizeInBytes() {
        return this.m_queue.getMaxQueueSizeInBytes();
    }

    @Override
    public int getQueueType() {
        return 0;
    }

    @Override
    public int getReceiverCount() {
        return this.m_queue.getLocalJMSReceiverCount();
    }

    @Override
    public int getSaveThresholdInKiloBytes() {
        return this.m_queue.getSaveThresholdInKiloBytes();
    }

    @Override
    public int getTotalEnqueued() {
        return this.m_queue.getCurrentEnqueuedCount();
    }

    @Override
    public long getTotalSize() {
        return this.m_queue.getCurrentEnqueuedSize();
    }

    @Override
    protected long getOldestEnqueueTime() {
        return this.m_queue.getMinEnqueueTime();
    }

    @Override
    public boolean isReadExclusive() {
        return this.m_readExclusive;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public boolean isWriteExclusive() {
        return this.m_writeExclusive;
    }

    @Override
    public boolean isWriteOnly() {
        return this.m_writeOnly;
    }

    @Override
    public boolean isGlobal() {
        return this.m_global;
    }

    @Override
    public boolean isClustered() {
        return this.m_clustered;
    }

    public void onNewClusteredQueueInstance(IRemoteBroker irb) {
        this.generateOpenRemoteReceiverMgramForEachSelector(irb);
        this.generateRemoteGetsIfNeeded();
    }

    public void onRemoveClusteredQueueInstance(long clientId) {
        if (this.DEBUG) {
            this.debug("onRemoveClusteredQueueInstance: disconnecting clustered queue instance on q = " + this + " on neighbor irb with clientId = " + clientId);
        }
        if (this.m_clustered) {
            this.clearRemoteRequests(clientId);
            this.m_queue.closeRemoteReceiver(clientId);
            if (this.DEBUG) {
                this.debug("onRemoveClusteredQueueInstance: removing counter from m_outstandingRemoteRequest on q =  " + this + " for neighbor with clientId = " + clientId);
            }
            this.m_outstandingRemoteRequest.remove(clientId);
        }
    }

    @Override
    public boolean openBrowser(long clientId) throws ParseException, TokenMgrError {
        return this.m_queue.openBrowser(clientId, null);
    }

    @Override
    public boolean openBrowser(long clientId, String selector) throws ParseException, TokenMgrError {
        return this.m_queue.openBrowser(clientId, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openReceiver(long clientId) throws ParseException, TokenMgrError {
        if (this.DEBUG) {
            this.debug("openReceiver: m_readExclusive = " + this.m_readExclusive + ", receiver count = " + this.m_queue.getLocalJMSReceiverCount());
        }
        boolean dupOpen = this.m_queue.isLocalJMSReceiverOpen(clientId);
        if (this.m_readExclusive && this.m_queue.getLocalJMSReceiverCount() > 0 && !dupOpen) {
            return false;
        }
        if (this.DEBUG) {
            this.debug("openReceiver: invoking m_queue.openReceiver, cliendID = " + clientId);
        }
        this.m_queue.openLocalJMSReceiver(clientId, null);
        if (this.m_clustered && !dupOpen) {
            AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
            synchronized (administrativelyCreatedQueue) {
                Counter receiverCount = (Counter)this.m_selectorInfoTable.get("");
                if (receiverCount == null) {
                    if (this.DEBUG) {
                        this.debug(" openReceiver: The receiver = " + clientId + " is the first receiver with NO selector to be opened on this clustered queue instance.");
                    }
                    receiverCount = new Counter(1);
                    this.m_selectorInfoTable.put("", receiverCount);
                    this.generateOpenRemoteReceiverMgrams("");
                } else {
                    receiverCount.increment();
                    if (this.DEBUG) {
                        this.debug(" openReceiver: The receiver = " + clientId + " is the NOT the first receiver with NO selector to be opened on this clustered queue instance. So the count was incremented count to: " + receiverCount.getIntValue());
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openReceiver(long clientId, String selector) throws ParseException, TokenMgrError {
        boolean dupOpen = this.m_queue.isLocalJMSReceiverOpen(clientId);
        if (this.m_readExclusive && this.m_queue.getLocalJMSReceiverCount() > 0 && !dupOpen) {
            return false;
        }
        this.m_queue.openLocalJMSReceiver(clientId, selector);
        if (this.m_clustered && !dupOpen) {
            AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
            synchronized (administrativelyCreatedQueue) {
                if (this.m_selectorStringbyClientId == null) {
                    this.m_selectorStringbyClientId = new LongHashTable();
                }
                this.m_selectorStringbyClientId.put(clientId, selector);
                Counter receiverCount = (Counter)this.m_selectorInfoTable.get(selector);
                if (this.DEBUG) {
                    this.debug(": openReceiver: for selector: " + selector + " the receiverCount: " + (receiverCount == null ? 0 : receiverCount.getIntValue()));
                }
                if (receiverCount == null) {
                    if (this.DEBUG) {
                        this.debug(" openReceiver: The receiver with clientId = " + clientId + " is the first receiver with selector: " + selector + " to be opened on this clustered queue instance.");
                    }
                    receiverCount = new Counter(1);
                    this.m_selectorInfoTable.put(selector, receiverCount);
                    this.generateOpenRemoteReceiverMgrams(selector);
                } else {
                    receiverCount.increment();
                    if (this.DEBUG) {
                        this.debug(" openReceiver: The receiver = " + clientId + " is the NOT the first receiver with NO selector to be opened on this clustered queue instance. So the count was incremented count to: " + receiverCount.getIntValue());
                    }
                }
            }
        }
        return true;
    }

    public boolean openRemoteReceiver(long clientId, String selector) {
        if (!this.m_clustered) {
            return true;
        }
        this.m_queue.openRemoteReceiver(clientId, selector);
        this.initiateDispatching();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(IMgram mgrm, long sender_cid) {
        boolean generateRemoteGets = false;
        AgentAdministrativelyCreatedQueue agentAdministrativelyCreatedQueue = this;
        synchronized (agentAdministrativelyCreatedQueue) {
            Counter counter;
            if (this.DEBUG) {
                this.debug("put: for sender_cid = " + sender_cid);
            }
            if (this.m_clustered && (counter = (Counter)this.m_outstandingRemoteRequest.get(sender_cid)) != null) {
                if (this.DEBUG) {
                    this.debug("put: decrementing counter of outstanding remote request for sender_cid = " + sender_cid + " counter = " + counter);
                }
                Counter counter2 = counter;
                synchronized (counter2) {
                    counter.decrement();
                }
                if (this.getTotalEnqueued() <= Config.CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD) {
                    generateRemoteGets = true;
                }
            }
            this.enqueue(mgrm);
        }
        if (generateRemoteGets && this.getReceiverCount() > 0) {
            IRemoteBroker irb = this.m_reg.getClusteredQueueManager().getRemoteBrokerforClusteredQueue(this.m_name, sender_cid);
            this.generateRemoteGetRequest(irb);
        }
    }

    @Override
    public boolean reserve(IMgram m) {
        return this.m_queue.reserve(m);
    }

    @Override
    public boolean reserve(int size) {
        return this.m_queue.reserve(size);
    }

    @Override
    public synchronized void restore(List elems) {
        Object[] obj1;
        int numElements = elems.size();
        Object[] obj = new Object[]{new Integer(elems.size()).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_COUNT"), obj), 3);
        int count = this.m_queue.restore(elems);
        if (count < numElements) {
            obj1 = new Object[]{new Integer(numElements - count).toString(), this.getQueueName()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("MESSAGES_EXPIRED"), obj1), 3);
        }
        obj1 = new Object[]{new Integer(count).toString(), this.getQueueName()};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORED_COUNT"), obj1), 3);
    }

    @Override
    public void setFlowControl(boolean fc) {
    }

    @Override
    public void setGlobal(boolean global) {
        this.m_global = global;
    }

    @Override
    public void setClustered(boolean clustered) {
        if (this.m_clustered != clustered) {
            this.m_clustered = clustered;
            ClusteredQueueManager cqm = this.m_reg.getClusteredQueueManager();
            if (cqm != null) {
                if (clustered) {
                    cqm.onNewClustered(this.m_name);
                } else {
                    cqm.onRemoveClustered(this.m_name);
                    this.m_outstandingRemoteRequest.clear();
                    this.clearAllRemoteRequests();
                }
            }
        } else {
            return;
        }
    }

    @Override
    public void setMaxQueueSizeInBytes(long max) {
        this.m_queue.setMaxQueueSizeInBytes(max);
    }

    @Override
    public void setMaxQueueSizeInKiloBytes(int max) {
        this.m_queue.setMaxQueueSizeInKiloBytes(max);
    }

    @Override
    public void setReadExclusiveMode(boolean mode) {
        this.m_readExclusive = mode;
    }

    @Override
    public void setReadOnlyMode(boolean mode) {
        this.m_readOnly = mode;
    }

    @Override
    public void setSaveThresholdInKiloBytes(int newSaveThreshold) {
        this.m_queue.setSaveThresholdInKiloBytes(newSaveThreshold);
    }

    @Override
    public void setWriteExclusiveMode(boolean mode) {
        this.m_writeExclusive = mode;
    }

    @Override
    public void setWriteOnlyMode(boolean mode) {
        this.m_writeOnly = mode;
    }

    @Override
    public synchronized void start() {
        if (!this.m_reg.getQueueProc().isStarted()) {
            String gl = this.isGlobal() ? prAccessor.getString("GLOBAL") : prAccessor.getString("LOCAL");
            String se = this.isReadExclusive() ? prAccessor.getString("EXCLUSIVE") : prAccessor.getString("SHARED");
            String cl = this.isClustered() ? prAccessor.getString("CLUSTERED") : prAccessor.getString("NONCLUSTERED");
            Object[] obj = new Object[]{this.getQueueName(), gl, cl, se, new Integer(this.getSaveThresholdInKiloBytes()).toString(), new Integer(this.getMaxQueueSizeInKiloBytes()).toString()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STARTING_QUEUE"), obj), 3);
        }
        this.dispatchStartup(this.m_reg.getQueueProc().getDispatcher());
        this.m_state = 3;
    }

    private boolean deliver(IMgram m, long clientId) throws EClientNotRegistered, ESecurityGeneralException {
        IClientContext cc = null;
        int sendStatus = 0;
        if (this.DEBUG) {
            this.debug("Message sent as " + (m.isGuarenteed() ? "guaranteed" : "reliable"));
        }
        cc = this.m_reg.getClient(clientId);
        if (this.DEBUG) {
            this.debug("Sending mgram: " + m + " to client " + clientId);
        }
        sendStatus = cc.xOnceQSend(m, this.m_emptyLabel, false);
        if (this.DEBUG) {
            String stat = null;
            switch (sendStatus) {
                case 1: {
                    stat = "REJECTED";
                    break;
                }
                case 2: {
                    stat = "DISCARDED";
                    break;
                }
                case 0: {
                    stat = "ACCEPTED";
                    break;
                }
                default: {
                    stat = "UNKNOWN";
                }
            }
            this.debug("Mgram sent to CID: " + clientId + ", status = " + stat);
        }
        if (sendStatus == 1) {
            this.m_queue.reenqueue(m, true);
            return false;
        }
        return true;
    }

    private boolean deliverToRemote(IMgram m, IRemoteBroker irb) throws EClientNotRegistered, ESecurityGeneralException, InterruptedException {
        if (this.DEBUG) {
            this.debug("deliverToRemote: Sending mgram: " + m + " to irb.getClientId(): " + irb.getClientID() + ", irb.getBrokerName(): = " + irb.getBrokerName());
        }
        return irb.send(m);
    }

    private void generateRemoteGetRequests() {
        IRemoteBroker irb = null;
        Enumeration enu = this.m_reg.getClusteredQueueManager().getRemoteBrokersforClusteredQueue(this.m_name);
        if (enu != null) {
            while (enu.hasMoreElements()) {
                irb = (IRemoteBroker)enu.nextElement();
                if (this.DEBUG) {
                    this.debug(" generateRemoteGetRequests(): found irb: " + irb.getBrokerName());
                }
                if (!irb.isNeighbor()) continue;
                this.generateRemoteGetRequest(irb);
            }
        }
    }

    private void generateOpenRemoteReceiverMgrams(String selector) {
        IMgram qOpenReceiverMgram = MgramFactory.getMgramFactory().buildQueueOpenRemoteReceiverMgram(Config.ENABLE_QOPSECURITY, 0, this.m_subject, selector);
        IRemoteBroker irb = null;
        Enumeration enu = this.m_reg.getClusteredQueueManager().getRemoteBrokersforClusteredQueue(this.m_name);
        if (enu != null) {
            while (enu.hasMoreElements()) {
                irb = (IRemoteBroker)enu.nextElement();
                if (this.DEBUG) {
                    this.debug("generateRemoteOpenReceiverMgrams: found irb: " + irb.getBrokerName());
                }
                if (!irb.isNeighbor()) continue;
                if (this.DEBUG) {
                    this.debug("generateRemoteOpenReceiverMgrams: sending open receiver to neighbor: " + irb.getBrokerName() + " with selector = " + (selector.equals("") ? " NO SELECTOR" : selector));
                }
                irb.sendThrough(qOpenReceiverMgram);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOpenRemoteReceiverMgramForEachSelector(IRemoteBroker irb) {
        AdministrativelyCreatedQueue administrativelyCreatedQueue = this.m_queue;
        synchronized (administrativelyCreatedQueue) {
            IMgram qOpenReceiverMgram = null;
            String selector = null;
            Enumeration keyEnum = this.m_selectorInfoTable.keys();
            while (keyEnum.hasMoreElements()) {
                selector = (String)keyEnum.nextElement();
                qOpenReceiverMgram = MgramFactory.getMgramFactory().buildQueueOpenRemoteReceiverMgram(Config.ENABLE_QOPSECURITY, 0, this.m_subject, selector);
                if (this.DEBUG) {
                    this.debug(": generateOpenRemoteReceiverMgramForEachSelector: sending open receiver to neighbor: " + irb.getBrokerName() + " with selector = " + (selector.equals("") ? " NO SELECTOR" : selector));
                }
                irb.sendThrough(qOpenReceiverMgram);
            }
        }
    }

    private void generateCloseRemoteReceiverMgrams(String selector) {
        IMgram qCloseReceiverMgram = MgramFactory.getMgramFactory().buildQueueCloseRemoteReceiverMgram(Config.ENABLE_QOPSECURITY, 0, this.m_subject, selector);
        IRemoteBroker irb = null;
        Enumeration enu = this.m_reg.getClusteredQueueManager().getRemoteBrokersforClusteredQueue(this.m_name);
        if (enu != null) {
            while (enu.hasMoreElements()) {
                irb = (IRemoteBroker)enu.nextElement();
                if (!irb.isNeighbor()) continue;
                if (this.DEBUG) {
                    this.debug(" generateRemoteCloseReceiverMgrams: sending close receiver to neighbor: " + irb.getBrokerName() + " with selector = " + selector);
                }
                irb.sendThrough(qCloseReceiverMgram);
            }
        }
    }

    @Override
    public synchronized void decrementNonDelayableReceiverCount() {
        --this.m_nonDelayableReceiverCount;
    }

    @Override
    public synchronized void incrementNonDelayableReceiverCount() {
        ++this.m_nonDelayableReceiverCount;
    }

    private void initInstance(String qName, AgentRegistrar reg) {
        this.m_name = qName;
        this.m_subject = new Subject("$Q." + this.m_name);
        this.m_reg = reg;
        this.m_outstandingRemoteRequest = new LongHashTable();
        this.m_selectorInfoTable = new Hashtable();
        this.m_emptyLabel = new Label();
        super.initMetrics();
        this.m_queue.setSizeChangeListener(new ISizeChangeListener(){

            @Override
            public void onSizeChange() {
                AgentAdministrativelyCreatedQueue.this.updateQueueStats();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateRemoteGetRequest(IRemoteBroker irb) {
        long clientId = irb.getClientID();
        Counter count = null;
        LongHashTable longHashTable = this.m_outstandingRemoteRequest;
        synchronized (longHashTable) {
            count = (Counter)this.m_outstandingRemoteRequest.get(clientId);
            if (count == null) {
                count = new Counter(0);
                this.m_outstandingRemoteRequest.put(clientId, count);
            }
        }
        IMgram getRequest = null;
        Counter counter = count;
        synchronized (counter) {
            if (count.getIntValue() <= Config.CLUSTERED_Q_PREFETCH_THRESHOLD) {
                int needed = Config.CLUSTERED_Q_PREFETCH_COUNT - count.getIntValue();
                getRequest = MgramFactory.getMgramFactory().buildQueueGetRequestMgram(Config.ENABLE_QOPSECURITY, 0, (short)1, needed, this.m_subject, true);
                if (Config.ENABLE_SECURITY && Config.ENABLE_QOPSECURITY) {
                    BrokerSearchResults bsr = new BrokerSearchResults();
                    this.m_reg.m_regSub.get(this.m_subject, bsr);
                    short qop = bsr.m_qop.getProtection();
                    try {
                        getRequest.setSecurityAttribute(SecurityLogic.AttribsFromPublic((byte)4, (byte)qop));
                        if (this.DEBUG) {
                            this.debug(" Q m_name " + this.m_name + "set qop for remote get request to : " + qop);
                        }
                    }
                    catch (Exception e) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                }
                count.add(needed);
                if (this.DEBUG) {
                    this.debug(" generateRemoteGetRequests(): sending get request to neighbor: " + irb.getBrokerName() + " incremented oustandingGet count = " + count);
                }
            } else if (this.DEBUG) {
                this.debug(" generateRemoteGetRequests(): skipping request to neighbor: " + irb.getBrokerName() + " outstandingGet count = " + count);
            }
        }
        if (getRequest != null) {
            irb.sendThrough(getRequest);
        }
    }

    @Override
    public long getPercentageFull() {
        return this.m_queue.getCurrentEnqueuedSize() * 100L / this.m_queue.getMaxQueueSizeInBytes();
    }

    void enableMessageGroup(String groupID, int idleTimeoutInSeconds, int maxWaitTimeInSeconds, int minReceivers) {
        this.m_queue.enableMessageGroup(groupID, idleTimeoutInSeconds, maxWaitTimeInSeconds, minReceivers);
    }

    @Override
    public IMessageGroupHandle getMessageGroupHandle() {
        return this;
    }

    @Override
    public boolean isMessageGroupEnabled() {
        return this.m_queue.isMessageGroupEnabled();
    }

    @Override
    public void onDisconnectClient(long clientId) {
        if (this.m_queue.onDisconnectClient(clientId)) {
            this.initiateDispatching();
        }
    }

    @Override
    public boolean onNewMgram(IMgram m, IClientContext publisher) {
        this.m_queue.onNewMgram(m, publisher);
        return true;
    }

    @Override
    public void onQueueMessageGroupSubscription(long clientId, String groupName) {
        this.m_queue.redoQueueMessageGroupAssign(clientId, groupName);
    }

    @Override
    public void redoQueueMessageGroupAssign(long clientId, String groupName) {
        this.m_queue.redoQueueMessageGroupAssign(clientId, groupName);
    }

    @Override
    public void redoQueueMessageGroupUnassign(List<String> groupNames) {
        this.m_queue.redoQueueMessageGroupUnassign(groupNames);
    }

    @Override
    public void redoSyncQueueMessageGroups(long clientId, List<String> groupNames) {
        this.m_queue.redoSyncQueueMessageGroups(clientId, groupNames);
    }

    @Override
    public void setMessageGroupIdleTimeoutInSeconds(int timeoutInSeconds) {
        this.m_queue.setMessageGroupIdleTimeoutInMiliSeconds(timeoutInSeconds * 1000);
    }

    @Override
    public void setMessageGroupMaxWaitTimeInSeconds(int waitTimeInSeconds) {
        this.m_queue.setMessageGroupMaxWaitTimeInMiliSeconds(waitTimeInSeconds * 1000);
    }

    @Override
    public void setMessageGroupMinReceivers(int minReceivers) {
        this.m_queue.setMessageGroupMinReceivers(minReceivers);
    }

    @Override
    public void writeSyncGroupAssignments() throws ECannotFlushEvents {
        this.m_queue.writeSyncGroupAssignments();
    }

    class Counter {
        private int m_value = 0;

        Counter(int value) {
            this.m_value = value;
        }

        public void add(int add) {
            this.m_value += add;
        }

        public void subtract(int sub) {
            this.m_value -= sub;
        }

        public void increment() {
            ++this.m_value;
        }

        public void decrement() {
            --this.m_value;
        }

        public int getIntValue() {
            return this.m_value;
        }

        public String toString() {
            return this.m_value + "";
        }
    }
}

