/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.QMsgStateMgr;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.QueueMsgEvt;
import progress.message.broker.SyncQueueMsgEvt;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.ListNode;
import progress.message.zclient.DebugObject;
import progress.message.zclient.xonce.IMsgTracker;

public final class AgentQueueMsgTracker
extends DebugObject
implements IMsgTracker {
    private static volatile AgentRegistrar s_reg;
    static volatile QMsgStateMgr s_qMsgStateMgr;
    private QueueMsgEvt m_evt;
    private long m_tracking;
    private IMgram m_msg;
    private long m_origSender;
    private long m_origTracking;
    private boolean m_needGuarAck;
    private long m_receiverId;
    private boolean m_delivered;
    private String m_localQueueName;
    private long m_oldTracking;
    private AgentGuarMsgTracker m_parentTracker;
    private boolean m_saved;
    private int m_tid;
    private boolean m_syncQueueMsgEvtWritten = false;
    private volatile boolean m_splitBatch = false;
    private boolean m_batchedPublish = false;
    private boolean m_isTemp = false;
    private byte m_priority;
    private long m_expiration;
    private long m_enqueuedSize;
    private boolean m_splitting = false;
    private boolean m_replicateOnly = false;

    static void initClass(AgentRegistrar reg) {
        s_reg = reg;
        s_qMsgStateMgr = reg.getQMsgStateMgr();
    }

    AgentQueueMsgTracker(long tracking, QueueMsgEvt evt, boolean needGuarAck, boolean startSplitting) throws EDuplicateKey {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentQueueMsgTracker " + tracking : null);
        this.m_tracking = tracking;
        this.m_evt = evt;
        this.m_needGuarAck = needGuarAck;
        this.m_origSender = this.m_evt.getOrigSender();
        this.m_origTracking = this.m_evt.getOrigTracking();
        this.m_msg = this.m_evt.getMessage();
        this.m_localQueueName = this.m_evt.getLocalQueueName();
        if (this.m_localQueueName == null) {
            throw new EAssertFailure("null queue name");
        }
        this.m_tid = this.m_evt.getTransactionId();
        this.m_splitBatch = evt.splitBatch();
        this.m_batchedPublish = evt.isBatchedPublish();
        this.m_isTemp = evt.isTempQueue();
        this.m_priority = evt.getPriority();
        this.m_expiration = evt.getExpiration();
        this.m_enqueuedSize = evt.getEnqueuedSize();
        this.m_splitting = startSplitting;
        if (this.m_msg != null) {
            this.m_replicateOnly = this.m_msg.isNonPersistentReplicated();
        }
        AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.append(this.m_tracking, this);
        if (this.DEBUG) {
            this.debug("Created");
        }
    }

    public AgentQueueMsgTracker(long tracking, String queueName, byte priority, long expiration, long enqueuedSize) throws EDuplicateKey {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentQueueMsgTracker " + tracking : null);
        if (queueName == null) {
            throw new EAssertFailure("null queue name");
        }
        this.m_tracking = tracking;
        this.m_priority = priority;
        this.m_localQueueName = queueName.intern();
        this.m_expiration = expiration;
        this.m_enqueuedSize = enqueuedSize;
        AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.append(this.m_tracking, this);
        if (this.DEBUG) {
            this.debug("Created");
        }
    }

    public AgentQueueMsgTracker(long tracking, IMgram msg, String queueName, long oldTracking) throws EDuplicateKey {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentQueueMsgTracker " + tracking : null);
        if (queueName == null) {
            throw new EAssertFailure("null queue name");
        }
        this.m_tracking = tracking;
        this.m_msg = msg;
        this.m_priority = msg.getPriority();
        if (msg.isTTE()) {
            this.m_expiration = msg.getTTE();
        }
        this.m_enqueuedSize = msg.getEnqueuedSize();
        this.m_localQueueName = queueName.intern();
        this.m_oldTracking = oldTracking;
        if (this.m_msg != null) {
            this.m_replicateOnly = this.m_msg.isNonPersistentReplicated();
        }
        AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.append(this.m_tracking, this);
        if (this.DEBUG) {
            this.debug("Created");
        }
    }

    public AgentQueueMsgTracker(long tracking, AgentGuarMsgTracker parentTracker, IMgram msg, String queueName) throws EDuplicateKey {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentQueueMsgTracker " + tracking : null);
        if (queueName == null) {
            throw new EAssertFailure("null queue name");
        }
        this.m_tracking = tracking;
        this.m_parentTracker = parentTracker;
        this.m_msg = msg;
        this.m_priority = msg.getPriority();
        if (msg.isTTE()) {
            this.m_expiration = msg.getTTE();
        }
        this.m_enqueuedSize = msg.getEnqueuedSize();
        this.m_localQueueName = queueName.intern();
        if (this.m_parentTracker != null) {
            this.m_replicateOnly = this.m_parentTracker.isReplicateOnly();
        }
        AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.append(this.m_tracking, this);
        if (this.DEBUG) {
            this.debug("Created parent tracker is " + parentTracker);
        }
    }

    public synchronized void startSplitting() {
        this.m_splitting = true;
    }

    public synchronized void endSplitting() {
        this.m_splitting = false;
    }

    @Override
    public short getType() {
        return 0;
    }

    @Override
    public long getTracking() {
        return this.m_tracking;
    }

    public boolean needGuarAck() {
        return this.m_needGuarAck;
    }

    public String getLocalQueueName() {
        return this.m_localQueueName;
    }

    public synchronized long getReceiverId() {
        return this.m_receiverId;
    }

    public boolean isDelivered() {
        return this.m_delivered;
    }

    @Override
    public boolean isReplicateOnly() {
        return this.m_replicateOnly;
    }

    void setReplicateOnly(boolean replicateOnly) {
        this.m_replicateOnly = replicateOnly;
    }

    public long getOldTracking() {
        return this.m_oldTracking;
    }

    public AgentGuarMsgTracker getParentTracker() {
        return this.m_parentTracker;
    }

    public long getOrigSender() {
        return this.m_origSender;
    }

    long getOrigTracking() {
        return this.m_origTracking;
    }

    IMgram getMessage() {
        return this.m_msg;
    }

    public void setOrigSender(long sender) {
        this.m_origSender = sender;
    }

    void setOrigTracking(long tracking) {
        this.m_origTracking = tracking;
    }

    void setDelivered(boolean delivered) {
        this.m_delivered = delivered;
    }

    void setNeedGuarAck(boolean needGuarAck) {
        this.m_needGuarAck = needGuarAck;
    }

    void setMessage(IMgram msg) {
        this.m_msg = msg;
    }

    void setMsgSavedInDatabase(boolean value) {
        this.m_saved = value;
    }

    void setOldTracking(long tracking) {
        this.m_oldTracking = tracking;
    }

    void setTransacted(int tid) {
        this.m_tid = tid;
    }

    void setNonTransacted() {
        this.m_tid = 0;
    }

    boolean isTransacted() {
        return this.m_tid != 0;
    }

    int getTransactionId() {
        return this.m_tid;
    }

    void setTemporary(boolean isTemp) {
        this.m_isTemp = isTemp;
    }

    boolean isTemporary() {
        return this.m_isTemp;
    }

    long getExpiration() {
        return this.m_expiration;
    }

    byte getPriority() {
        return this.m_priority;
    }

    long getEnqueuedSize() {
        return this.m_enqueuedSize;
    }

    public boolean splitBatch() {
        return this.m_splitBatch;
    }

    public void setSplitBatch(boolean splitBatch) {
        this.m_splitBatch = splitBatch;
    }

    public synchronized void setReceiverId(long clientId) {
        this.m_receiverId = clientId;
    }

    public void setLocalQueueName(String queueName) {
        this.m_localQueueName = queueName;
        if (this.m_localQueueName == null) {
            throw new EAssertFailure("null queue name");
        }
    }

    @Override
    public synchronized boolean guarAckDone() {
        this.m_needGuarAck = false;
        this.removeTracker();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledged(IMgram ack, boolean flush) {
        QueueMsgEvt qevt = null;
        String qname_for_delete = null;
        boolean removed = false;
        boolean syncQueueMsgEvtWritten = false;
        boolean saved = false;
        boolean needGuarAck = false;
        AgentQueueMsgTracker agentQueueMsgTracker = this;
        synchronized (agentQueueMsgTracker) {
            qname_for_delete = this.m_localQueueName;
            this.resetAcknowledge();
            qevt = this.m_evt;
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Message acknowledged; Trying to remove event");
            }
            removed = this.removeEvtIfOk();
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Trying to remove tracker");
            }
            this.removeTracker();
            syncQueueMsgEvtWritten = this.m_syncQueueMsgEvtWritten;
            saved = this.m_saved;
            this.m_saved = false;
            needGuarAck = this.m_needGuarAck;
            this.m_evt = null;
        }
        boolean logQAck = qevt == null || qevt.isLogged() || qevt.isTransacted() || this.m_batchedPublish || syncQueueMsgEvtWritten || saved || needGuarAck || Config.REPLICATED;
        boolean deleted = false;
        if (saved) {
            deleted = s_reg.getQueueMsgSaver().deleteMsg(qname_for_delete, this.m_tracking, logQAck);
        }
        if (removed && qevt != null) {
            qevt.onFlush();
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Called onFlush() to acknowledge to sender");
            }
        }
        if ((this.debugFlags & 0x100) != 0) {
            this.debug("Message " + this.m_tracking + " logging ACK event");
        }
        if (logQAck) {
            QueueMsgAckedEvt evt = new QueueMsgAckedEvt(this.m_tracking, ack, deleted);
            evt.setReplicateOnly(this.m_replicateOnly);
            if (ack != null && ack.isGuarenteed() && !ack.getBrokerHandle().isAckNoReply() && flush && (removed || qevt != null && qevt.isLogged())) {
                s_reg.getLogManager().addHighPriorityEvt(evt, flush);
            } else {
                s_reg.getLogManager().addEvent(evt, flush);
            }
        } else {
            QueueMsgAckedEvt evt = new QueueMsgAckedEvt(this.m_tracking, ack, deleted);
            evt.setReplicateOnly(this.m_replicateOnly);
            evt.onFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledged() {
        QueueMsgEvt qevt = this.m_evt;
        AgentQueueMsgTracker agentQueueMsgTracker = this;
        synchronized (agentQueueMsgTracker) {
            this.resetAcknowledge();
            this.m_evt = null;
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Trying to remove tracker");
            }
            this.removeTracker();
        }
    }

    private void resetAcknowledge() {
        this.m_delivered = true;
        this.m_receiverId = 0L;
        this.m_msg = null;
        if (this.m_parentTracker != null) {
            this.m_parentTracker.qRcptAcknowledged(this.m_tracking);
            this.m_parentTracker = null;
        }
    }

    void canceled(boolean flush) throws InterruptedException {
        this.canceled(flush, flush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueMsgAckedEvt canceled(boolean flush, boolean waitForFlush) throws InterruptedException {
        QueueMsgAckedEvt evt = null;
        boolean deleted = false;
        boolean splitBatch = false;
        boolean saved = false;
        String qname_for_delete = this.m_localQueueName;
        AgentQueueMsgTracker agentQueueMsgTracker = this;
        synchronized (agentQueueMsgTracker) {
            this.resetAcknowledge();
            if (this.m_evt != null) {
                splitBatch = this.m_evt.splitBatch();
            }
            this.m_evt = null;
            this.setNonTransacted();
            this.removeTracker();
            saved = this.m_saved;
            this.m_saved = false;
        }
        if (saved) {
            deleted = s_reg.getQueueMsgSaver().deleteMsg(qname_for_delete, this.m_tracking, true);
        }
        if (!splitBatch) {
            evt = new QueueMsgAckedEvt(this.m_tracking, null, deleted);
            evt.setReplicateOnly(this.m_replicateOnly);
            s_reg.getLogManager().addEvent(evt, flush);
            if (waitForFlush) {
                s_reg.getLogManager().waitForFlush(evt);
            }
        }
        return evt;
    }

    void prepareSave() {
        this.m_saved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saved() {
        QueueMsgEvt qevt = null;
        boolean removed = false;
        AgentQueueMsgTracker agentQueueMsgTracker = this;
        synchronized (agentQueueMsgTracker) {
            this.m_msg = null;
            qevt = this.m_evt;
            this.m_saved = true;
            if (this.m_parentTracker != null) {
                this.m_parentTracker.qRcptAcknowledged(this.m_tracking);
                this.m_parentTracker = null;
            }
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Message acknowledged; Trying to remove event");
            }
            removed = this.removeEvtIfOk();
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Trying to remove tracker");
            }
            this.removeTracker();
            this.m_evt = null;
        }
        if (removed && qevt != null) {
            qevt.onFlush();
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("Called onFlush() to acknowledge to sender");
            }
        }
        if ((this.debugFlags & 0x100) != 0) {
            this.debug("Msg saved in db");
        }
    }

    void removeTracker() {
        ListNode obj = null;
        if (this.m_delivered && !this.m_needGuarAck && !this.m_splitting) {
            obj = AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.remove(this.m_tracking);
            if (this.DEBUG) {
                this.debug("removed from active list");
            }
        }
    }

    public static AgentQueueMsgTracker getTracker(long tracking) {
        Object tracker = AgentQueueMsgTracker.s_qMsgStateMgr.m_activeList.get(tracking);
        return (AgentQueueMsgTracker)tracker;
    }

    long estimatedSyncSize() {
        long size = 0L;
        if (this.m_msg != null) {
            size += (long)this.m_msg.serializedLength();
        }
        return size += 20L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeSyncRecord() throws ECannotFlushEvents {
        SyncQueueMsgEvt evt;
        AgentQueueMsgTracker agentQueueMsgTracker = this;
        synchronized (agentQueueMsgTracker) {
            this.m_syncQueueMsgEvtWritten = true;
            evt = new SyncQueueMsgEvt(this);
        }
        s_reg.getLogManager().tryAddEvent(evt, false);
        return evt.memsize();
    }

    boolean removeEvtIfOk() {
        if (this.m_evt == null) {
            return false;
        }
        if (this.m_batchedPublish) {
            return false;
        }
        if (this.m_evt.getMessage().getBrokerHandle().isTransactionalPublish()) {
            return false;
        }
        if (this.m_needGuarAck) {
            return false;
        }
        if (Config.REPLICATED) {
            return false;
        }
        s_reg.getLogManager().removeEvent(this.m_evt);
        if (this.DEBUG) {
            this.debug("Removed Event from log");
        }
        return true;
    }
}

