/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.common.runtime.IQueueData;
import com.sonicsw.mq.common.runtime.impl.RoutingStatistic;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentDeadMessageQueue;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentQueueDispatcher;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.AgentTemporaryQueue;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.BatchSplitEvt;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.DMQElement;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.broker.INeighbor;
import progress.message.broker.IQueueInfo;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.ISavableAgentQueue;
import progress.message.broker.IStateListener;
import progress.message.broker.ITempQueueDeleteListener;
import progress.message.broker.IUndeliveredMessageProcessor;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LogManager;
import progress.message.broker.QMsgStateMgr;
import progress.message.broker.QueueAttributes;
import progress.message.broker.QueueCleanupThread;
import progress.message.broker.QueueFactory;
import progress.message.broker.QueueHolder;
import progress.message.broker.QueueMsgEvt;
import progress.message.broker.QueueTypeConstants;
import progress.message.broker.RecipientWrap;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.SavableQElement;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SyncTempQueueEvt;
import progress.message.broker.TempQueueCreationEvt;
import progress.message.broker.TempQueueDeletionEvt;
import progress.message.broker.TransactionMgr;
import progress.message.broker.TxMsgQueue;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EExclusiveQueueOpen;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnauthorizedClient;
import progress.message.db.EDatabaseException;
import progress.message.dbsc.data.IDbDataEnum;
import progress.message.dbsc.data.IDbQMsgData;
import progress.message.dbsc.data.IDbQueueData;
import progress.message.dbsc.data.impl.DbQMsgData;
import progress.message.ft.ReplicationManager;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.gr.RouteForwarder;
import progress.message.gr.RouterManager;
import progress.message.interbroker.Interbroker;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.DestinationInfo;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;
import progress.message.util.QueueUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.xonce.IXOnceHandle;

public class AgentQueueProcessor
extends DebugObject
implements IUndeliveredMessageProcessor,
IStateListener,
QueueTypeConstants {
    private AgentRegistrar m_agentReg;
    private LogManager m_logMgr;
    private ReplicationManager m_replMgr = null;
    private TransactionMgr m_txnmgr;
    private Hashtable<String, IAgentQueue> m_queues;
    private final Object m_queues_lock = new Object();
    private MessageHandler m_mh;
    private QueueFactory m_qfactory;
    private AgentQueueDispatcher m_dispatcher;
    private QMsgStateMgr m_qMsgStateMgr;
    private ITempQueueDeleteListener m_tempQDeleteListener = null;
    private AgentRoutingQueue m_routingQ;
    RemoteBrokerHelper m_rbHelper = null;
    private static int DFLT_DEAD_MSG_QUEUE_SIZE = 10000;
    private AgentDeadMessageQueue m_dmq;
    private LongHashTable m_tempQueues = new LongHashTable();
    private LongHashTable m_clientReg = new LongHashTable();
    private LongHashTable m_clientBrowserReg = new LongHashTable();
    IMessageProtection m_mp = null;
    byte[] m_tempMessageKeyBuffer = null;
    boolean m_started = false;
    QueueCleanupThread m_cleanupThread = null;
    public static final int ERRCODE_GENERIC = 0;
    public static final int ERRCODE_IO = 1;
    private Object m_queueStartMutex = new Object();
    private boolean m_queuesStarted = false;
    private boolean m_isActive = false;
    private HashMap m_msgsSentBeforeStart = new HashMap();
    private static final String[] ERROR_MESSAGES = new String[]{"Exception while attempting to send close receiver notification...", "Message discarded for tid; %1$s %2$s ", "Unable to write %1$s reply", "Unable to read the request", "Exception while composing reply message", "Error while processing message in '%1$s'", "Exception while attempting to send open receiver notification..."};
    private static final String ERROR = "error";

    public IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    AgentQueueProcessor(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentQueueProcessor" : null);
        if (this.DEBUG) {
            this.debug("Constructing.");
        }
        this.m_agentReg = reg;
    }

    @Override
    public void stateChanging(int newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AQPStartup() throws EDatabaseException {
        this.m_logMgr = this.m_agentReg.getLogManager();
        this.m_txnmgr = this.m_agentReg.getTransactionMgr();
        Object object = this.m_queues_lock;
        synchronized (object) {
            this.m_queues = new Hashtable();
        }
        if (this.m_cleanupThread == null) {
            this.m_cleanupThread = new QueueCleanupThread(this);
            this.m_cleanupThread.setDaemon(true);
        }
        this.m_rbHelper = new RemoteBrokerHelper(this.m_agentReg, this.m_agentReg.getRouterManager(), this.m_agentReg.getRouterManager().getRouteForwarder());
        try {
            BrokerStateManager.getBrokerStateManager().registerListener(this.m_rbHelper);
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        this.m_qfactory = new QueueFactory();
        this.createConfiguredQueues();
    }

    private void AQPActive() {
        if (!this.m_isActive) {
            try {
                BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.m_agentReg);
            }
            catch (Throwable t) {
                if (!Broker.exiting) {
                    BrokerComponent.getComponentContext().logMessage(t, 2);
                }
                return;
            }
            this.m_cleanupThread.start();
            this.m_dispatcher.start();
            this.m_replMgr = this.m_agentReg.getReplicationManager();
            this.m_isActive = true;
        }
    }

    private void logException(String message, Object[] params, Throwable e) {
        if (params != null && params.length > 0) {
            message = String.format(message, params);
        }
        this.debug(message, e);
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 7: {
                this.AQPStartup();
                break;
            }
            case 1: {
                this.AQPActive();
            }
        }
    }

    boolean isStarted() {
        return this.m_started;
    }

    void start() throws EGeneralException, EDatabaseException {
        if (this.DEBUG) {
            this.debug("Starting...");
        }
        this.m_qMsgStateMgr = this.m_agentReg.getQMsgStateMgr();
        this.m_mh = new MessageHandler(new AdminDefaultHandler());
        this.m_mh.setName("AQP admin handler");
        this.m_agentReg.getAdminConnection().addMessageHandler(this.m_mh);
        try {
            this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EAssertFailure(e);
        }
        this.m_tempMessageKeyBuffer = new byte[this.m_mp.getSecretKeyLength()];
        String prefix = Config.getAdminPrefix("*", "*");
        this.m_mh.bind(prefix + ".setQueue", (IMessageHandler)new AdminCreateQueueHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminCreateQueueHandler to " + prefix + ".setQueue");
        }
        this.m_mh.bind(prefix + ".delQueue", (IMessageHandler)new AdminDeleteHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminDeleteHandler to " + prefix + ".delQueue");
        }
        this.m_mh.bind(prefix + ".getQueues", (IMessageHandler)new AdminGetQueuesHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminGetQueuesHandler to " + prefix + ".getQueues");
        }
        this.m_mh.bind(prefix + ".clearQueue", (IMessageHandler)new AdminClearQueueHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminClearQueueHandler to " + prefix + ".clearQueue");
        }
        this.m_mh.bind(prefix + ".openReceiver", (IMessageHandler)new OpenReceiverHandler());
        if (this.DEBUG) {
            this.debug("Bound OpenReceiverHandler to " + prefix + ".openReceiver");
        }
        this.m_mh.bind(prefix + ".openSender", (IMessageHandler)new OpenSenderHandler());
        if (this.DEBUG) {
            this.debug("Bound OpenSenderHandler to " + prefix + ".openSender");
        }
        this.m_mh.bind(prefix + ".openBrowser", (IMessageHandler)new OpenBrowserHandler());
        if (this.DEBUG) {
            this.debug("Bound OpenBrowserHandler to " + prefix + ".openBrowser");
        }
        this.m_mh.bind(prefix + ".closeReceiver", (IMessageHandler)new CloseReceiverHandler());
        if (this.DEBUG) {
            this.debug("Bound CloseReceiverHandler to " + prefix + ".closeReceiver");
        }
        this.m_mh.bind(prefix + ".closeBrowser", (IMessageHandler)new CloseBrowserHandler());
        if (this.DEBUG) {
            this.debug("Bound CloseBrowserHandler to " + prefix + ".closeBrowser");
        }
        this.m_mh.bind(prefix + ".setTempQueue", (IMessageHandler)new AdminCreateTempQueueHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminCreateTempQueueHandler to " + prefix + ".setTempQueue");
        }
        this.m_mh.bind(prefix + ".delTempQueue", (IMessageHandler)new AdminDelTempQueueHandler());
        if (this.DEBUG) {
            this.debug("Bound AdminDelTempQueueHandler to " + prefix + ".delTempQueue");
        }
        this.m_dispatcher = new AgentQueueDispatcher();
        Hashtable<String, IAgentQueue> agentQueues = null;
        if (this.m_tempQueues != null && !this.m_tempQueues.isEmpty()) {
            agentQueues = new Hashtable<String, IAgentQueue>(this.m_tempQueues.size());
            Enumeration cidEnum = this.m_tempQueues.elements();
            while (cidEnum.hasMoreElements()) {
                Vector v = (Vector)cidEnum.nextElement();
                Enumeration tqEnum = v.elements();
                while (tqEnum.hasMoreElements()) {
                    IAgentQueue tempQ = (IAgentQueue)tqEnum.nextElement();
                    agentQueues.put(tempQ.getQueueName(), tempQ);
                }
            }
        }
        if (agentQueues != null) {
            Enumeration enu = agentQueues.elements();
            IAgentQueue iaq = null;
            while (enu.hasMoreElements()) {
                iaq = (IAgentQueue)enu.nextElement();
                String qName = iaq.getQueueName();
                if (this.DEBUG) {
                    this.debug("NAME: " + qName);
                }
                this.connectQueue(iaq);
            }
        }
    }

    void createConfiguredQueues() throws EDatabaseException {
        Enumeration enu = null;
        Hashtable queues = Broker.s_broker.getQueuesHashtable();
        enu = queues.elements();
        QueueHolder qHolder = null;
        String queueName = null;
        Hashtable<String, BaseAgentQueue> agentQueues = new Hashtable<String, BaseAgentQueue>(queues.size());
        while (enu.hasMoreElements()) {
            qHolder = (QueueHolder)enu.nextElement();
            queueName = qHolder.getQueueName();
            if (queueName.equals("SonicMQ.routingQueue")) {
                AgentRoutingQueue arq = (AgentRoutingQueue)QueueFactory.getQueueFactory().createAgentQueue(4, queueName, qHolder.getMaxSize());
                arq.setSaveThresholdInKiloBytes(qHolder.getSaveThreshold());
                arq.setReadExclusiveMode(qHolder.isReadExclusive());
                arq.setGlobal(false);
                arq.setClustered(false);
                agentQueues.put(queueName, arq);
            } else if (queueName.equals("SonicMQ.deadMessage")) {
                AgentDeadMessageQueue dmq = (AgentDeadMessageQueue)QueueFactory.getQueueFactory().createAgentQueue(3, queueName, qHolder.getMaxSize());
                dmq.setSaveThresholdInKiloBytes(qHolder.getSaveThreshold());
                dmq.setFlowControl(false);
                dmq.setReadExclusiveMode(qHolder.isReadExclusive());
                dmq.setGlobal(false);
                dmq.setClustered(false);
                agentQueues.put(queueName, dmq);
            } else {
                AgentAdministrativelyCreatedQueue aacq = (AgentAdministrativelyCreatedQueue)QueueFactory.getQueueFactory().createAgentQueue(0, queueName, qHolder.getMaxSize());
                aacq.setSaveThresholdInKiloBytes(qHolder.getSaveThreshold());
                aacq.setReadExclusiveMode(qHolder.isReadExclusive());
                aacq.setGlobal(qHolder.isGlobal());
                aacq.setClustered(qHolder.isClustered());
                if (this.checkDebugFlags(16384) || qHolder.isMessageGroupEnabled()) {
                    if (aacq.isClustered()) {
                        // empty if block
                    }
                    aacq.enableMessageGroup(qHolder.getMessageGroupIDPropertyName(), qHolder.getMessageGroupIdleTimeoutInSeconds(), qHolder.getMessageGroupMaxWaitTimeInSeconds(), qHolder.getMessageGroupMinReceivers());
                }
                agentQueues.put(queueName, aacq);
            }
            qHolder.clear();
        }
        queues.clear();
        enu = agentQueues.elements();
        boolean hasRoutingQ = false;
        boolean hasExpiredQ = false;
        IAgentQueue iaq = null;
        while (enu.hasMoreElements()) {
            iaq = (IAgentQueue)enu.nextElement();
            String qName = iaq.getQueueName();
            if (this.DEBUG) {
                this.debug("NAME: " + qName);
            }
            this.connectQueue(iaq);
            if (qName.equals("SonicMQ.deadMessage")) {
                hasExpiredQ = true;
                this.m_dmq = (AgentDeadMessageQueue)iaq;
                iaq.setFlowControl(false);
                continue;
            }
            if (!qName.equals("SonicMQ.routingQueue")) continue;
            hasRoutingQ = true;
            this.m_routingQ = (AgentRoutingQueue)iaq;
        }
        if (!hasRoutingQ) {
            this.createRoutingQ();
        }
        if (!hasExpiredQ) {
            this.createDeadMsgQ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startQueues(RecoveryMgr.RecoveredQueueSet rqset) throws EGeneralException, EDatabaseException, InterruptedException {
        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("RESTORING_QUEUES"), 3);
        if (!rqset.isLoadable()) {
            if (this.DEBUG) {
                this.debug("Loading queues from store...");
            }
            this.loadQueuesFromDB();
        } else {
            if (this.DEBUG) {
                this.debug("Loading queues from log...");
            }
            this.loadQueuesFromRecoverySet(rqset);
        }
        if (this.m_dmq != null) {
            this.m_dmq.start();
        }
        if (this.m_cleanupThread == null) {
            this.m_cleanupThread = new QueueCleanupThread(this);
            this.m_cleanupThread.setDaemon(true);
        }
        Object object = this.m_queueStartMutex;
        synchronized (object) {
            Enumeration enu = this.getAgentQueues();
            IAgentQueue iaq = null;
            while (enu.hasMoreElements()) {
                iaq = (IAgentQueue)enu.nextElement();
                if (iaq == this.m_dmq) continue;
                iaq.start();
            }
            this.m_queuesStarted = true;
        }
        this.m_started = true;
    }

    private boolean checkAndProcessRecommittedAcks(long tracking) {
        return this.m_txnmgr.isAckRecomitted(tracking);
    }

    private boolean checkAndProcessInDoubt(long tracking, String queueName) {
        if (this.m_qMsgStateMgr.isMsgInDoubt(tracking)) {
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
            tracker.setLocalQueueName(queueName);
            tracker.setMsgSavedInDatabase(true);
            return true;
        }
        return false;
    }

    private boolean checkAndProcessInTransaction(long tracking, String queueName) {
        if (this.m_txnmgr.isMsgInPreparedXATxn(tracking, queueName)) {
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
            if (tracker != null) {
                tracker.setLocalQueueName(queueName);
                tracker.setMsgSavedInDatabase(true);
            }
            return true;
        }
        return false;
    }

    private SavableQElement createQueueElement(String queueName, long tracking, int prio, long size, long tte, boolean redelivered, boolean saved, Object payload) {
        SavableQElement element = null;
        element = queueName.equals("SonicMQ.deadMessage") ? new DMQElement(payload, tracking, prio, size, tte) : new SavableQElement(payload, tracking, prio, size, tte);
        element.setReenqueueCount(redelivered ? (byte)1 : 0);
        if (saved) {
            element.setSaved();
            element.setInDB();
        }
        return element;
    }

    public void loadQueuesFromRecoverySet(RecoveryMgr.RecoveredQueueSet rqset) throws EDatabaseException, InterruptedException {
        SavableQElement element;
        ArrayList<SavableQElement> loadable;
        IAgentQueue iaq;
        if (this.DEBUG) {
            this.debug("starting loadQueuesFromRecoverySet()");
        }
        Iterator queues = rqset.getRecoveredQueues();
        while (queues.hasNext()) {
            RecoveryMgr.RecoveredQueue rq = (RecoveryMgr.RecoveredQueue)queues.next();
            String queueName = rq.getQueueName();
            iaq = this.getAgentQueue(queueName);
            if (iaq == null) {
                this.processOrphanedQMsgs(rq);
                queues.remove();
                continue;
            }
            List msgs = rq.getRecoveredMsgs();
            loadable = new ArrayList<SavableQElement>(msgs.size());
            ListIterator msgsItr = msgs.listIterator();
            while (msgsItr.hasNext()) {
                RecoveryMgr.RecoveredQMsg rqm = (RecoveryMgr.RecoveredQMsg)msgsItr.next();
                if (this.checkAndProcessRecommittedAcks(rqm.getTracking())) {
                    if ((this.debugFlags & 0x1000) != 0) {
                        this.debug("loadQueuesFromRecoverySet: checkAndProcessRecommittedAcks() is true; skipping " + rqm.getTracking());
                    }
                    msgsItr.set(null);
                    continue;
                }
                if (this.checkAndProcessInDoubt(rqm.getTracking(), queueName)) {
                    msgsItr.set(null);
                    continue;
                }
                if (this.checkAndProcessInTransaction(rqm.getTracking(), queueName)) {
                    msgsItr.set(null);
                    continue;
                }
                element = this.createQueueElement(queueName, rqm.getTracking(), rqm.getPriority(), rqm.getEnqueuedSize(), rqm.getExpiration(), false, rqm.getMessage() == null, rqm.getMessage());
                loadable.add(element);
                msgsItr.set(null);
            }
            rq.clear();
            Vector vec = (Vector)this.m_msgsSentBeforeStart.get(queueName);
            if (vec != null) {
                for (IDbQMsgData msgdat : vec) {
                    int indx = this.locateIndex(loadable, msgdat.getMessageId());
                    if (indx < 0) {
                        SavableQElement element2 = this.createQueueElement(queueName, msgdat.getMessageId(), msgdat.getPriority(), msgdat.getMessageSize(), msgdat.getExpiration(), false, true, msgdat.getMessage());
                        loadable.add(-indx - 1, element2);
                        if ((this.debugFlags & 0x1000) == 0) continue;
                        this.debug("loadQueuesFromRecoverySet: added msg from m_msgsSentBeforeStart (1); trk= " + msgdat.getMessageId());
                        continue;
                    }
                    if ((this.debugFlags & 0x1000) == 0) continue;
                    this.debug("loadQueuesFromRecoverySet: skipping msg from m_msgsSentBeforeStart; trk= " + msgdat.getMessageId());
                }
                this.m_msgsSentBeforeStart.remove(queueName);
            } else if ((this.debugFlags & 0x1000) != 0) {
                this.debug("loadQueuesFromRecoverySet: no msgs in m_msgsSentBeforeStart for queue " + queueName);
            }
            Object[] obj = new Object[]{queueName};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_QUEUE"), obj), 3);
            if (this.DEBUG) {
                this.debug("Restoring " + loadable.size() + " msgs to " + queueName);
            }
            iaq.restore(loadable);
            loadable = null;
            queues.remove();
        }
        for (String qname : this.m_msgsSentBeforeStart.keySet()) {
            iaq = this.getAgentQueue(qname);
            Vector vec = (Vector)this.m_msgsSentBeforeStart.get(qname);
            if (iaq == null) {
                this.processOrphanedQMsgs(qname, vec);
                continue;
            }
            loadable = new ArrayList();
            for (IDbQMsgData msgdat : vec) {
                element = this.createQueueElement(qname, msgdat.getMessageId(), msgdat.getPriority(), msgdat.getMessageSize(), msgdat.getExpiration(), false, true, msgdat.getMessage());
                loadable.add(element);
                if ((this.debugFlags & 0x1000) == 0) continue;
                this.debug("loadQueuesFromRecoverySet: added msg from m_msgsSentBeforeStart (2); trk= " + msgdat.getMessageId());
            }
            Object[] obj = new Object[]{qname};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_QUEUE"), obj), 3);
            if (this.DEBUG) {
                this.debug("Restoring " + loadable.size() + " msgs to " + qname);
            }
            iaq.restore(loadable);
            loadable = null;
        }
        this.m_msgsSentBeforeStart.clear();
    }

    private int locateIndex(ArrayList a, long id) {
        int low = 0;
        int high = a.size() - 1;
        int mid = 0;
        while (low <= high) {
            mid = (low + high) / 2;
            SavableQElement sq = (SavableQElement)a.get(mid);
            if (sq.m_tracking < id) {
                low = mid + 1;
                continue;
            }
            if (sq.m_tracking > (long)mid) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadQueuesFromDB() throws EDatabaseException, InterruptedException {
        if (this.DEBUG) {
            this.debug("starting loadQueuesFromDB()");
        }
        IDbDataEnum dbQueues = this.m_agentReg.getBrokerDatabase().getIPtpDBQ().getQueuesDbDataEnum();
        while (dbQueues.hasMoreElements()) {
            IDbQueueData qData = (IDbQueueData)dbQueues.nextElement();
            String qName = qData.getQueueName();
            Object object = this.m_queues_lock;
            synchronized (object) {
                if (!this.m_queues.containsKey(qName)) {
                    this.processOrphanedQMsgs(qName, qData);
                    continue;
                }
            }
            Object[] obj = new Object[]{qName};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RESTORING_QUEUE"), obj), 3);
            Vector elementList = this.getQMsgs(qName, qData);
            IAgentQueue iaq = this.getAgentQueue(qName);
            if (iaq != null) {
                iaq.restore(elementList);
                continue;
            }
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("WARNING_NOQUEUE"), obj), 2);
        }
    }

    private void processOrphanedQMsgs(String qName, IDbQueueData qData) throws EDatabaseException, InterruptedException {
        if (this.DEBUG) {
            this.debug("starting processOrphanedQMsgs(), qName = " + qName);
        }
        IDbDataEnum dbQMsgs = this.m_agentReg.getBrokerDatabase().getIPtpDBQ().getQMsgsDbDataEnum(qData);
        while (dbQMsgs.hasMoreElements()) {
            IDbQMsgData msgData = (IDbQMsgData)dbQMsgs.nextElement();
            long msg_id = msgData.getMessageId();
            this.cancelMsg(msg_id, qName, true);
        }
    }

    private void processOrphanedQMsgs(RecoveryMgr.RecoveredQueue rq) throws EDatabaseException, InterruptedException {
        if (this.DEBUG) {
            this.debug("starting processOrphanedQMsgs(), qName = " + rq.getQueueName());
        }
        List qmsgList = rq.getRecoveredMsgs();
        for (RecoveryMgr.RecoveredQMsg rqm : qmsgList) {
            long msg_id = rqm.getTracking();
            this.cancelMsg(msg_id, rq.getQueueName(), true);
        }
    }

    private void processOrphanedQMsgs(String qname, Vector qmsgvec) throws EDatabaseException, InterruptedException {
        if (this.DEBUG) {
            this.debug("starting processOrphanedQMsgs(), qName = " + qname);
        }
        for (DbQMsgData qmsgdat : qmsgvec) {
            long msg_id = qmsgdat.getMessageId();
            this.cancelMsg(msg_id, qname, true);
        }
    }

    private Vector getQMsgs(String qName, IDbQueueData qData) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("starting getQMsgs(), qName = " + qName);
        }
        Vector<SavableQElement> elementList = new Vector<SavableQElement>();
        IDbDataEnum dbQMsgs = this.m_agentReg.getBrokerDatabase().getIPtpDBQ().getQMsgsDbDataEnum(qData);
        while (dbQMsgs.hasMoreElements()) {
            IDbQMsgData msgData = (IDbQMsgData)dbQMsgs.nextElement();
            int mgPrio = msgData.getPriority();
            long mgTrk = msgData.getMessageId();
            long mgEnqueuedSize = msgData.getMessageSize();
            boolean mgRedelivered = msgData.getRedelivery();
            long mgTTE = msgData.getExpiration();
            if (this.checkAndProcessInDoubt(mgTrk, qName) || this.checkAndProcessInTransaction(mgTrk, qName)) continue;
            SavableQElement element = this.createQueueElement(qName, mgTrk, mgPrio, mgEnqueuedSize, mgTTE, mgRedelivered, true, null);
            elementList.addElement(element);
        }
        return elementList;
    }

    void stopQueues() {
        if (this.m_cleanupThread != null) {
            if (this.m_cleanupThread.isAlive()) {
                this.m_cleanupThread.interrupt();
            } else if (Broker.exiting) {
                this.m_cleanupThread.start();
            }
        }
        this.m_started = false;
    }

    void startThreads() {
        this.m_dispatcher.startRoutingThread();
    }

    void shutdown() {
        if (this.m_dispatcher != null) {
            this.m_dispatcher.shutdown();
        }
    }

    public QueueCleanupThread getCleanupThread() {
        return this.m_cleanupThread;
    }

    QueueFactory getQueueFactory() {
        return this.m_qfactory;
    }

    AgentQueueDispatcher getDispatcher() {
        return this.m_dispatcher;
    }

    public RemoteBrokerHelper getRemoteBrokerHelper() {
        return this.m_rbHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAgentQueue getQueueFromClientId(long clientId) {
        IAgentQueue iaq = null;
        LongHashTable longHashTable = this.m_clientReg;
        synchronized (longHashTable) {
            iaq = (IAgentQueue)this.m_clientReg.get(clientId);
        }
        return iaq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean openReceiver(long clientId, IAgentQueue iaq, String selector) throws ParseException, TokenMgrError, EUnauthorizedClient {
        boolean ret;
        block24: {
            Object appid;
            if (this.DEBUG) {
                try {
                    String uid = this.m_agentReg.getClient(clientId).getUid();
                    appid = this.m_agentReg.getClient(clientId).getAppid();
                    String msg = "Opening receiver (" + uid + "," + (String)appid + ") to " + iaq.getQueueName();
                    if (selector != null) {
                        msg = msg + ", selector = " + selector;
                    }
                    this.debug(msg);
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
            }
            ret = false;
            appid = iaq;
            synchronized (appid) {
                ret = selector == null || "".equals(selector) ? iaq.openReceiver(clientId) : iaq.openReceiver(clientId, selector);
            }
            if (!ret) {
                return ret;
            }
            Label lab = new Label();
            lab.setRouteLimit(1);
            lab.setPersistent(false);
            lab.setNonStop(false);
            IClientContext cc = null;
            try {
                cc = this.m_agentReg.getClient(clientId);
                boolean nondelayable = false;
                switch (cc.getAckMode()) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: {
                        nondelayable = true;
                    }
                }
                if (cc.isXOnce()) {
                    nondelayable = true;
                }
                if (nondelayable) {
                    iaq.incrementNonDelayableReceiverCount();
                }
            }
            catch (EClientNotRegistered e) {
                ret = false;
            }
            if (ret && cc.getClientSessionVer() >= 24) {
                try {
                    SubscribeEvt evt = new SubscribeEvt(null, clientId, new Subject("$QSYS.client." + this.m_agentReg.getClient(clientId).getUid() + "." + this.m_agentReg.getClient(clientId).getAppid() + ".*"), lab);
                    this.m_agentReg.subscribe(evt);
                    String subject = "$Q." + iaq.getQueueName();
                    if (subject.equals("$Q.SonicMQ.deadMessage")) {
                        subject = "$Q.#";
                    }
                    evt = new SubscribeEvt(null, clientId, new Subject(subject), lab);
                    this.m_agentReg.subscribe(evt);
                }
                catch (EUnauthorizedClient ucex) {
                    throw ucex;
                }
                catch (Exception ex) {
                    ret = false;
                }
            }
            if (ret) {
                try {
                    String userID = this.m_agentReg.getClient(clientId).getUid();
                    String appID = this.m_agentReg.getClient(clientId).getAppid();
                    if (appID == null) {
                        appID = "";
                    }
                    String connectID = SessionConfig.getConnectIDFromQueueReceiverAppid(appID);
                    String clientID = "";
                    BrokerManagementNotificationsHelper.sendBrokerStartReceiveNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, iaq.getQueueName());
                }
                catch (Exception e) {
                    if (!this.DEBUG) break block24;
                    this.logException(ERROR_MESSAGES[6], null, e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeReceiver(long clientId) {
        block14: {
            IAgentQueue iaq = null;
            LongHashTable longHashTable = this.m_clientReg;
            synchronized (longHashTable) {
                iaq = (IAgentQueue)this.m_clientReg.get(clientId);
                if (iaq == null) {
                    return;
                }
                iaq.closeReceiver(clientId);
            }
            try {
                IClientContext cc = this.m_agentReg.getClient(clientId);
                cc.stopDelivery();
                boolean nondelayable = false;
                switch (cc.getAckMode()) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: {
                        nondelayable = true;
                    }
                }
                if (cc.isXOnce()) {
                    nondelayable = true;
                }
                if (nondelayable) {
                    iaq.decrementNonDelayableReceiverCount();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                String userID = this.m_agentReg.getClient(clientId).getUid();
                String appID = this.m_agentReg.getClient(clientId).getAppid();
                if (appID == null) {
                    appID = "";
                }
                String connectID = SessionConfig.getConnectIDFromQueueReceiverAppid(appID);
                String clientID = "";
                BrokerManagementNotificationsHelper.sendBrokerEndReceiveNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, iaq.getQueueName());
            }
            catch (Exception e) {
                if (!this.DEBUG) break block14;
                this.logException(ERROR_MESSAGES[0], null, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectClient(long clientId, IAgentQueue iaq) {
        if (this.DEBUG) {
            try {
                String uid = this.m_agentReg.getClient(clientId).getUid();
                String appid = this.m_agentReg.getClient(clientId).getAppid();
                this.debug("Connecting receiver (" + uid + "," + appid + ") to " + iaq.getQueueName());
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
        LongHashTable longHashTable = this.m_clientReg;
        synchronized (longHashTable) {
            this.m_clientReg.put(clientId, iaq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearGetRequests(long clientId) {
        IAgentQueue iaq = null;
        LongHashTable longHashTable = this.m_clientReg;
        synchronized (longHashTable) {
            iaq = (IAgentQueue)this.m_clientReg.get(clientId);
        }
        if (iaq != null) {
            iaq.clearLocalRequests(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startDelivery(long clientId) {
        IAgentQueue iaq = null;
        LongHashTable longHashTable = this.m_clientReg;
        synchronized (longHashTable) {
            iaq = (IAgentQueue)this.m_clientReg.get(clientId);
        }
        if (iaq != null) {
            iaq.startDelivery(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectClient(long clientId) {
        IAgentQueue iaq = null;
        LongHashTable longHashTable = this.m_clientReg;
        synchronized (longHashTable) {
            iaq = (IAgentQueue)this.m_clientReg.get(clientId);
            if (iaq == null) {
                return;
            }
            this.m_clientReg.remove(clientId);
            if (iaq.getMessageGroupHandle() != null) {
                iaq.getMessageGroupHandle().onDisconnectClient(clientId);
            }
        }
        if (this.DEBUG) {
            try {
                String uid = this.m_agentReg.getClient(clientId).getUid();
                String appid = this.m_agentReg.getClient(clientId).getAppid();
                this.debug("Disconnecting receiver (" + uid + "," + appid + ") from " + iaq.getQueueName());
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectBrowserClient(long clientId) {
        IAgentQueue iaq = null;
        LongHashTable longHashTable = this.m_clientBrowserReg;
        synchronized (longHashTable) {
            iaq = (IAgentQueue)this.m_clientBrowserReg.get(clientId);
            if (iaq == null) {
                return;
            }
            iaq.closeBrowser(clientId);
            this.unregisterQueueBrowser(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectQueue(IAgentQueue iaq) {
        long svSz;
        long maxCacheSz;
        Object aq;
        if (this.DEBUG) {
            aq = null;
            Object object = this.m_queues_lock;
            synchronized (object) {
                aq = this.m_queues.get(iaq.getQueueName());
            }
            if (aq != null) {
                this.debug("connectQueue: queue named " + iaq.getQueueName() + " is already connected...");
            } else {
                this.debug("connectQueue: no queue named " + iaq.getQueueName() + " currently connected - connecting it now...");
            }
        }
        aq = this.m_queues_lock;
        synchronized (aq) {
            this.m_queues.put(iaq.getQueueName(), iaq);
        }
        if (iaq instanceof ISavableAgentQueue && Config.MAX_QMSG_SAVER_ASYNC_CACHE_SIZE == 0 && Long.MAX_VALUE - (maxCacheSz = this.m_agentReg.getQueueMsgSaver().getMaxAsyncCacheSize()) > (svSz = (long)(((ISavableAgentQueue)((Object)iaq)).getSaveThresholdInKiloBytes() * 1024))) {
            this.m_agentReg.getQueueMsgSaver().setMaxAsyncCacheSize(maxCacheSz + svSz);
        }
    }

    private void disconnectQueue(IAgentQueue iaq) {
        this.disconnectQueue(iaq.getQueueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectQueue(String queueName) {
        long svSz;
        long maxCacheSz;
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            iaq = this.m_queues.remove(queueName);
        }
        if (iaq instanceof ISavableAgentQueue && Config.MAX_QMSG_SAVER_ASYNC_CACHE_SIZE == 0 && (maxCacheSz = this.m_agentReg.getQueueMsgSaver().getMaxAsyncCacheSize()) - (svSz = (long)(((ISavableAgentQueue)((Object)iaq)).getSaveThresholdInKiloBytes() * 1024)) > 0L) {
            this.m_agentReg.getQueueMsgSaver().setMaxAsyncCacheSize(maxCacheSz - svSz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQueue(String queueName) {
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            iaq = this.m_queues.get(queueName);
        }
        if (iaq == null) {
            return;
        }
        iaq.start();
    }

    public void createQueueDynamic(String qname, int maxSize, int saveThreshold, boolean isReadExclusive, boolean isGlobal, boolean isClustered) {
        this.createQueueDynamic(qname, maxSize, saveThreshold, isReadExclusive, isGlobal, isClustered, false, null, -1, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueueDynamic(String qname, int maxSize, int saveThreshold, boolean isReadExclusive, boolean isGlobal, boolean isClustered, boolean isMessageGroupEnabled, String groupID, int groupIdleTimeoutInSeconds, int groupMaxWaitTimeInSeconds, int groupMinReceivers) {
        if (qname.equals("SonicMQ.routingQueue")) {
            return;
        }
        if (qname.equals("SonicMQ.deadMessage")) {
            return;
        }
        IAgentQueue obj = this.getAgentQueue(qname);
        if (obj != null) {
            return;
        }
        QueueFactory qf = QueueFactory.getQueueFactory();
        IAgentQueue iaq = qf.createAgentQueue(0, qname, maxSize);
        iaq.setReadExclusiveMode(isReadExclusive);
        iaq.setGlobal(isGlobal);
        iaq.setClustered(isClustered);
        ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(saveThreshold);
        if (isMessageGroupEnabled || this.checkDebugFlags(16384)) {
            if (iaq.isClustered()) {
                // empty if block
            }
            ((AgentAdministrativelyCreatedQueue)iaq).enableMessageGroup(groupID, groupIdleTimeoutInSeconds, groupMaxWaitTimeInSeconds, groupMinReceivers);
        }
        this.connectQueue(iaq);
        Object object = this.m_queueStartMutex;
        synchronized (object) {
            if (this.m_queuesStarted) {
                iaq.start();
                if (isGlobal) {
                    this.advertiseGlobal(qname);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("Queue started.");
        }
    }

    private void advertiseGlobal(String qname) {
        RouterManager rm = this.m_agentReg.getRouterManager();
        if (rm != null) {
            RouteForwarder rf = rm.getRouteForwarder();
            rf.onNewGlobal(qname);
        }
    }

    private void unadvertiseGlobal(String qname) {
        RouterManager rm = this.m_agentReg.getRouterManager();
        if (rm != null) {
            RouteForwarder rf = rm.getRouteForwarder();
            rf.onRemoveGlobal(Config.ROUTING_NODE_NAME, qname);
        }
    }

    public void removeAdministrativelyCreatedQueue(String qname) {
        RouterManager rm;
        if (qname.equals("SonicMQ.routingQueue")) {
            return;
        }
        if (qname.equals("SonicMQ.deadMessage")) {
            return;
        }
        IAgentQueue obj = this.getAgentQueue(qname);
        if (obj == null) {
            return;
        }
        IAgentQueue iaq = obj;
        this.disconnectQueue(qname);
        iaq.close();
        try {
            iaq.clear();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.m_agentReg.getFlowControlManager().onQueueDelete(iaq.getQueueAddress());
        if (iaq.isGlobal() && (rm = this.m_agentReg.getRouterManager()) != null) {
            RouteForwarder rf = rm.getRouteForwarder();
            rf.onRemoveGlobal(Config.ROUTING_NODE_NAME, qname);
        }
    }

    public void addTemporaryQueue(long clientID, String qname, boolean isRecovery) throws InterruptedException {
        this.addTemporaryQueue(clientID, qname, isRecovery, true, Integer.MAX_VALUE);
    }

    void addTemporaryQueue(long clientID, String qname, boolean isRecovery, boolean isGlobal, int maxsize) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("AQP.addTemporaryQueue: clientID = " + clientID + ", qname = " + qname);
        }
        AgentTemporaryQueue atq = (AgentTemporaryQueue)this.m_qfactory.createAgentQueue(1, qname, maxsize);
        atq.setGlobal(isGlobal);
        this.addTemporaryQueue(clientID, atq, isRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTemporaryQueue(long clientID, AgentTemporaryQueue atq, boolean isRecovery) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("AQP.addTemporaryQueue: clientID = " + clientID);
            this.debug("AQP.addTemporaryQueue: tempQueue = " + atq);
        }
        Vector<AgentTemporaryQueue> tqVec = null;
        LongHashTable longHashTable = this.m_tempQueues;
        synchronized (longHashTable) {
            if (!this.m_tempQueues.isEmpty()) {
                tqVec = (Vector<AgentTemporaryQueue>)this.m_tempQueues.get(clientID);
            }
        }
        if (this.DEBUG) {
            this.debug("AQP.addTemporaryQueue: tqVec = " + tqVec);
        }
        if (tqVec == null) {
            tqVec = new Vector<AgentTemporaryQueue>();
            longHashTable = this.m_tempQueues;
            synchronized (longHashTable) {
                this.m_tempQueues.put(clientID, tqVec);
            }
            if (this.DEBUG) {
                this.debug("AQP.addTemporaryQueue: a new vecor create for client " + clientID + " size of m_tempQueues: " + this.m_tempQueues.size());
            }
        }
        tqVec.addElement(atq);
        if (this.DEBUG) {
            this.debug("AQP.addTemporaryQueue: connect the queue ");
        }
        if (!isRecovery) {
            this.connectQueue(atq);
        }
        if (this.DEBUG) {
            this.debug("AQP.addTemporaryQueue: queue connected...");
        }
    }

    public void removeTemporaryQueue(long clientID, String qname) throws InterruptedException {
        AgentTemporaryQueue atq;
        if (this.DEBUG) {
            this.debug("AQP.removeTemporaryQueue: clientID = " + clientID + ", qname = " + qname);
        }
        if ((atq = (AgentTemporaryQueue)this.getAgentQueue(qname)) != null) {
            this.removeTemporaryQueue(clientID, atq);
        }
    }

    public void removeTemporaryQueue(long clientID, AgentTemporaryQueue atq) throws InterruptedException {
        this.removeTemporaryQueue(clientID, atq, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryQueue(long clientID, AgentTemporaryQueue atq, Envelope env) {
        if (this.DEBUG) {
            this.debug("AQP.removeTemporaryQueue: clientID = " + clientID);
            this.debug("AQP.removeTemporaryQueue: tempQueue = " + atq);
        }
        TempQueueDeletionEvt evt = null;
        boolean xonceRecovery = Config.XONCE_RECOVERY;
        if (xonceRecovery) {
            evt = new TempQueueDeletionEvt(clientID, atq.getQueueName(), env);
            this.m_logMgr.addEvent(evt, true);
        }
        Vector tqVec = null;
        LongHashTable longHashTable = this.m_tempQueues;
        synchronized (longHashTable) {
            if (this.m_tempQueues.isEmpty()) {
                return;
            }
            tqVec = (Vector)this.m_tempQueues.get(clientID);
        }
        if (this.DEBUG) {
            this.debug("AQP.removeTemporaryQueue: tqVec = " + tqVec);
        }
        if (tqVec == null) {
            return;
        }
        if (!tqVec.isEmpty()) {
            AgentTemporaryQueue tq = null;
            Enumeration enu = tqVec.elements();
            while (enu.hasMoreElements()) {
                tq = (AgentTemporaryQueue)enu.nextElement();
                if (tq != atq) continue;
                this.removeTemporaryQueue(clientID, tqVec, tq);
                break;
            }
        }
        if (this.DEBUG) {
            this.debug("AQP.removeTemporaryQueue: tqVec again = " + tqVec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemporaryQueues(long clientID) throws InterruptedException {
        if (this.m_tempQueues == null) {
            return;
        }
        Vector tqVec = null;
        LongHashTable longHashTable = this.m_tempQueues;
        synchronized (longHashTable) {
            if (this.m_tempQueues.isEmpty()) {
                return;
            }
            tqVec = (Vector)this.m_tempQueues.get(clientID);
        }
        if (tqVec == null) {
            return;
        }
        boolean xonceRecoverable = Config.XONCE_RECOVERY;
        TempQueueDeletionEvt evt = null;
        if (xonceRecoverable) {
            evt = new TempQueueDeletionEvt(clientID, null, null);
            this.m_logMgr.addEvent(evt, true);
        }
        try {
            Cloneable cloneable;
            if (this.DEBUG) {
                this.debug("AQP.removeTemporaryQueues: clientID = " + clientID);
            }
            if (!tqVec.isEmpty()) {
                cloneable = tqVec;
                synchronized (cloneable) {
                    IAgentQueue iaq2 = null;
                    Vector v = (Vector)tqVec.clone();
                    for (IAgentQueue iaq2 : v) {
                        this.removeTemporaryQueue(clientID, tqVec, iaq2);
                    }
                    tqVec.removeAllElements();
                }
            }
            if (tqVec.isEmpty()) {
                cloneable = this.m_tempQueues;
                synchronized (cloneable) {
                    this.m_tempQueues.remove(clientID);
                }
                if (this.DEBUG) {
                    this.debug("AQP.removeTemporaryQueues remove empty vector, clientID = " + clientID + " size of m_tempQueues: " + this.m_tempQueues.size());
                }
            }
            tqVec = null;
        }
        finally {
            if (xonceRecoverable) {
                this.m_logMgr.waitForFlush(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryQueue(long clientID, Vector tqVec, IAgentQueue tq) {
        String queueName = tq.getQueueName();
        if (this.DEBUG) {
            this.debug("removeTemporaryQueue: deleting " + queueName);
        }
        Vector vector = tqVec;
        synchronized (vector) {
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: disconnecting queue " + queueName);
            }
            this.disconnectQueue(tq);
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: disconnected queue " + queueName);
            }
            try {
                tq.clear();
                if (this.DEBUG) {
                    this.debug("removeTemporaryQueue: cleared queue " + queueName);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            tq.close();
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: closed queue " + queueName);
            }
            this.m_agentReg.getFlowControlManager().onQueueDelete(tq.getQueueAddress());
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: from fcm, removed queue " + queueName);
            }
            tqVec.removeElement(tq);
            if (this.m_tempQDeleteListener != null) {
                this.m_tempQDeleteListener.queueDeleted(tq.getQueueName());
            }
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: removed from tqVec, queue " + queueName);
            }
        }
        if (this.DEBUG) {
            this.debug("removeTemporaryQueue: remove any advertising of queue " + queueName);
        }
        if (tq.isGlobal()) {
            RouterManager rm = this.m_agentReg.getRouterManager();
            if (rm != null) {
                RouteForwarder rf = rm.getRouteForwarder();
                rf.onRemoveGlobal(Config.ROUTING_NODE_NAME, queueName);
            }
            if (this.DEBUG) {
                this.debug("removeTemporaryQueue: removed from rf, queue " + queueName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncTempQueues() throws ECannotFlushEvents {
        if (Config.XONCE_RECOVERY) {
            LongHashTable tempQueues = null;
            if (this.m_tempQueues != null) {
                LongHashTable longHashTable = this.m_tempQueues;
                synchronized (longHashTable) {
                    if (!this.m_tempQueues.isEmpty()) {
                        tempQueues = (LongHashTable)this.m_tempQueues.clone();
                    }
                }
            }
            SyncTempQueueEvt evt = null;
            if (tempQueues != null) {
                evt = new SyncTempQueueEvt();
                Enumeration<Long> keyEnum = tempQueues.keys();
                while (keyEnum.hasMoreElements()) {
                    Vector tqVec;
                    Long cid = keyEnum.nextElement();
                    Vector vector = tqVec = (Vector)tempQueues.get(cid);
                    synchronized (vector) {
                        Enumeration tqEnum = tqVec.elements();
                        while (tqEnum.hasMoreElements()) {
                            IAgentQueue q = (IAgentQueue)tqEnum.nextElement();
                            evt.addTempQueue(cid, q.getQueueName(), q.getQueueType(), q.isGlobal(), q.getMaxQueueSizeInKiloBytes());
                        }
                    }
                }
            }
            if (evt != null) {
                this.m_logMgr.tryAddEvent(evt, false);
            }
        }
    }

    void restore(long cid, IndexedList unacked) {
        if (this.DEBUG) {
            this.debug("restore: starting; cid= " + cid + ", unacked msg count = " + unacked.count());
        }
        IAgentQueue iaq = this.getQueueFromClientId(cid);
        IClientContext cc = null;
        try {
            cc = this.m_agentReg.getClient(cid);
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
        if (cc != null && (InterbrokerHook.isSet() && cc.isInterbroker() || cc.isRemoteBroker())) {
            if (this.DEBUG) {
                this.debug("restore: starting; cid= " + cid);
            }
            if ((iaq = this.getRoutingQueue()) == null) {
                return;
            }
            if (this.DEBUG) {
                this.debug("restore: starting; cid= " + cid + " queue= " + iaq.getQueueName());
            }
            if ((this.debugFlags & 0x100) != 0) {
                this.debug("restore: adding messages to in-doubt list for " + cc);
            }
            int count = 0;
            int totCount = 0;
            Enumeration enu = unacked.elements();
            while (enu.hasMoreElements()) {
                ++totCount;
                IMgram m = (IMgram)enu.nextElement();
                long tracking = m.getGuarenteedTrackingNum();
                String queueName = m.getBrokerHandle().getLocalQueueName();
                if (m.isJMSPersistent()) {
                    ++count;
                    if (InterbrokerHook.isSet() && cc.isInterbroker()) {
                        InterbrokerHook.setMsgInDoubt(cid, tracking);
                    } else {
                        this.m_agentReg.getRouterManager().setMsgInDoubt(cid, tracking);
                    }
                    if (this.DEBUG) {
                        this.debug("AQP.restore cid: " + cid + " restoring message to original queue: " + queueName + " totCount: " + totCount);
                    }
                    this.m_agentReg.getQueueMsgSaver().saveMsg(queueName, m);
                    continue;
                }
                this.m_agentReg.getQueueMsgSaver().deleteMsg(queueName, tracking, false);
            }
            if (this.DEBUG) {
                this.debug("restore: added " + count + " persistent messages to in-doubt list for " + cc);
                this.debug("restore: dropped " + (totCount - count) + " nonpersistent messages on disconnect for " + cc);
            }
            return;
        }
        if (cc != null && cc.isXOnce() && iaq == null) {
            String qName;
            long tracking;
            AgentQueueMsgTracker tracker;
            IMgram m = null;
            ListNode head = unacked.head();
            if (head != null) {
                m = (IMgram)unacked.head().obj;
            }
            if (m != null && (tracker = AgentQueueMsgTracker.getTracker(tracking = m.getGuarenteedTrackingNum())) != null && (qName = tracker.getLocalQueueName()) != null) {
                iaq = this.getAgentQueue(qName);
            }
        }
        if (this.DEBUG) {
            this.debug("restore: IAgentQueue iaq = " + iaq);
        }
        if (iaq == null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("restore: starting; cid= " + cid + " queue= " + iaq.getQueueName());
        }
        if ((this.debugFlags & 0x100) != 0) {
            try {
                String uid = this.m_agentReg.getClient(cid).getUid();
                String appid = this.m_agentReg.getClient(cid).getAppid();
                this.debug("Restoring queue messages from (" + uid + "," + appid + ")");
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
        if ((this.debugFlags & 0x100) != 0) {
            this.debug("Restoring to queue " + iaq.getQueueName());
        }
        iaq.restore(unacked, false, true);
    }

    IAgentQueue resolveQueue(IMgram m) {
        return this.resolveQueue(m.getSubject(), m.getRoutingHandle().getRouting(), m.isPubSub());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAgentQueue resolveQueue(ISubject subject, String node, boolean isPubSub) {
        IQueueInfo iaq = null;
        if (!isPubSub) {
            String fullSubjectName = subject.getSubjectString();
            if (this.DEBUG) {
                this.debug("resolveQueue: full subject name = " + fullSubjectName);
            }
            if (fullSubjectName != null) {
                fullSubjectName = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
            }
            Object object = this.m_queues_lock;
            synchronized (object) {
                iaq = this.m_queues.get(fullSubjectName);
            }
        }
        if (this.DEBUG) {
            this.debug("resolveQueue: mgram subject = " + subject.getJMSName());
        }
        boolean routeFlag = false;
        if (node != null) {
            routeFlag = true;
        }
        if (!routeFlag) {
            if (iaq != null) {
                return iaq;
            }
            return null;
        }
        if (iaq != null && iaq.isGlobal() && (node.equals(Config.ROUTING_NODE_NAME) || "".equals(node))) {
            return iaq;
        }
        return this.m_routingQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reserveQSpace(IMgram mgram, IClientContext publisher, FastVector ptpRecipients) {
        boolean failure = false;
        int numRecipients = ptpRecipients.m_count;
        IAgentQueue[] localQueues = new IAgentQueue[numRecipients];
        boolean forUnblockedRemoteDestination = false;
        IRemoteBroker irb = null;
        RecipientWrap rw = null;
        String nodeName = null;
        IClientContext cc = null;
        int numProcessed = 0;
        int numBlocked = 0;
        int numUnblocked = 0;
        boolean[] reservedSpace = new boolean[numRecipients];
        Vector<IRemoteBroker> blockedIRBs = null;
        mgram.setEnqueuedSize(mgram.getEnqueuedSize());
        Object object = this.m_routingQ.getDequeueLock();
        synchronized (object) {
            for (int ii = 0; ii < numRecipients; ++ii) {
                rw = (RecipientWrap)ptpRecipients.m_data[ii];
                cc = rw.getClient();
                IAgentQueue iaq = cc.getLocalQueue();
                nodeName = cc.getTargetNodeName();
                localQueues[ii] = iaq;
                forUnblockedRemoteDestination = false;
                if (iaq == this.m_routingQ && (irb = this.m_rbHelper.selectRemoteBroker(nodeName, null, mgram)) != null && this.m_rbHelper.checkOkToSend(irb)) {
                    forUnblockedRemoteDestination = true;
                }
                reservedSpace[ii] = false;
                if (forUnblockedRemoteDestination) {
                    ++numUnblocked;
                    continue;
                }
                if (iaq == this.m_routingQ) {
                    ++numBlocked;
                    if (irb == null) continue;
                    if (blockedIRBs == null) {
                        blockedIRBs = new Vector<IRemoteBroker>();
                    }
                    blockedIRBs.addElement(irb);
                    continue;
                }
                if (!this.reserveQSpace(mgram, publisher, publisher != null ? publisher.getFlowController() : null, iaq, null)) {
                    failure = true;
                    numProcessed = ii;
                    break;
                }
                reservedSpace[ii] = true;
            }
            if (!failure && numBlocked > 0) {
                String[] blockedRoutes = null;
                if (blockedIRBs != null) {
                    blockedRoutes = new String[blockedIRBs.size()];
                    for (int ii = 0; ii < blockedIRBs.size(); ++ii) {
                        blockedRoutes[ii] = ((IRemoteBroker)blockedIRBs.elementAt(ii)).getPendingQueueName();
                    }
                }
                if (!this.reserveQSpace(mgram, publisher, publisher != null ? publisher.getFlowController() : null, this.m_routingQ, null, numBlocked, blockedRoutes)) {
                    failure = true;
                }
            }
        }
        if (!failure) {
            for (int ii = 0; ii < numUnblocked; ++ii) {
                this.m_routingQ.forceReserve(mgram);
            }
        } else {
            for (int ii = 0; ii < numProcessed; ++ii) {
                if (!reservedSpace[ii]) continue;
                localQueues[ii].unreserve(mgram.getEnqueuedSize());
            }
        }
        return !failure;
    }

    public void newMgram(IMgram m, IClientContext publisher) throws InterruptedException {
        this.newMgram(m, publisher, publisher != null ? publisher.getFlowController() : null, !m.hasTxn(), false);
    }

    public void newMgram(IMgram m, IClientContext publisher, IFlowController flowController) throws InterruptedException {
        this.newMgram(m, publisher, flowController, true, false);
    }

    void newMgram(IMgram m, IClientContext publisher, boolean reserveSpace, boolean deliverOnly) throws InterruptedException {
        this.newMgram(m, publisher, publisher != null ? publisher.getFlowController() : null, reserveSpace, deliverOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void newMgram(IMgram m, IClientContext publisher, IFlowController flowController, boolean reserveSpace, boolean deliverOnly) throws InterruptedException {
        IAgentQueue iaq = null;
        if (!m.isPubSub()) {
            String fullSubjectName = m.getSubject().getSubjectString();
            if (this.DEBUG) {
                this.debug("newMgram: full subject name = " + fullSubjectName);
            }
            if (fullSubjectName != null) {
                fullSubjectName = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
                if (m.getType() == 13 && fullSubjectName.startsWith("SonicMQ.routingQueue")) {
                    fullSubjectName = "SonicMQ.routingQueue";
                }
            }
            Object object = this.m_queues_lock;
            synchronized (object) {
                iaq = this.m_queues.get(fullSubjectName);
            }
        }
        if (this.DEBUG) {
            this.debug("newMgram: mgram subject = " + m.getSubject().getJMSName());
        }
        if (m.getType() == 13) {
            this.handleGetMgram(m, publisher, iaq);
            return;
        }
        boolean routeFlag = false;
        String node = m.getRoutingHandle().getRouting();
        if (node != null) {
            routeFlag = true;
        }
        if (!routeFlag) {
            if (iaq != null) {
                this.handlePutMgram(m, publisher, flowController, iaq, reserveSpace, false, deliverOnly);
            } else {
                if (publisher != null) {
                    publisher.sendErrorAck(m, (short)-15, false);
                }
                if (this.DEBUG) {
                    this.debug("Destination queue not found, mgram put on dead message queue:");
                }
            }
        } else if (iaq != null && iaq.isGlobal() && (node.equals(Config.ROUTING_NODE_NAME) || "".equals(node))) {
            this.handlePutMgram(m, publisher, flowController, iaq, reserveSpace, false, deliverOnly);
        } else {
            boolean valid;
            if (node.equals(Config.ROUTING_NODE_NAME) && this.isForGlobalTemporaryDestination(m) && !(valid = this.validateGlobalTemporaryDestination(node, m, publisher))) {
                return;
            }
            this.handlePutMgram(m, publisher, flowController, this.m_routingQ, reserveSpace, true, deliverOnly);
        }
    }

    private boolean isForGlobalTemporaryDestination(IMgram m) {
        String node = m.getRoutingHandle().getRouting();
        return node != null && m.getSubject().isQueue() && m.getSubject().isTemporary();
    }

    private boolean validateGlobalTemporaryDestination(String node, IMgram m, IClientContext publisher) {
        boolean routeDefined;
        boolean valid = true;
        RouterManager rm = AgentRegistrar.getAgentRegistrar().getRouterManager();
        RouteForwarder rf = rm.getRouteForwarder();
        int[] dest = null;
        if (!m.isPubSub()) {
            dest = m.getSubject().getMatchVector();
        }
        if ("".equals(node)) {
            node = Config.ROUTING_NODE_NAME;
        }
        if (!(routeDefined = rf.lookupGlobalDestination(node, dest))) {
            valid = false;
            if (publisher != null) {
                boolean isRemoteBroker = publisher.isRemoteBroker();
                boolean isInterbroker = publisher.isInterbroker();
                if (!isRemoteBroker && !isInterbroker) {
                    publisher.sendErrorAck(m, (short)-15, false);
                }
                if (InterbrokerHook.isSet() && publisher.isInterbroker() || publisher.isRemoteBroker()) {
                    publisher.sendErrorAck(m, (short)-15, true);
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoveredMgram(IMgram m) throws InterruptedException {
        String fullSubjectName = m.getSubject().getSubjectString();
        String subject = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            iaq = this.m_queues.get(subject);
        }
        if (iaq != null) {
            iaq.forceReserve(m);
            m.setEnqueuedSize(m.getEnqueuedSize());
            this.handlePutMgram(m, null, null, iaq, false, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveredTemporaryMgram(IMgram m) throws InterruptedException {
        String fullSubjectName = m.getSubject().getSubjectString();
        String subject = fullSubjectName.substring(fullSubjectName.indexOf(".") + 1);
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            iaq = this.m_queues.get(subject);
        }
        if (iaq != null) {
            this.recoveredMgram(m);
        } else {
            this.cancelMsg(m.getGuarenteedTrackingNum(), subject, false);
        }
    }

    public void cancelMsg(long msgId, String queueName, boolean delete) throws InterruptedException {
        AgentQueueMsgTracker tracker;
        if (this.m_qMsgStateMgr.isMsgInDoubt(msgId)) {
            this.m_qMsgStateMgr.removeInDoubtMsg(msgId);
        }
        if ((tracker = AgentQueueMsgTracker.getTracker(msgId)) != null) {
            tracker.canceled(false);
        } else if (delete) {
            this.m_agentReg.getQueueMsgSaver().deleteMsg(queueName, msgId, false);
        }
    }

    private void handleGetMgram(IMgram m, IClientContext publisher, IAgentQueue iaq) {
        if (iaq == null) {
            if (publisher != null) {
                publisher.sendErrorAck(m, (short)-15, false);
            }
            if (this.DEBUG) {
                this.debug("Destination queue not found, dropping mgram:");
                m.dump();
            }
            return;
        }
        int count = 1;
        try {
            byte[] body = m.getRawBody();
            short getType = ArrayUtil.readShort(body, 0);
            count = ArrayUtil.readInt(body, 2);
            iaq.get(publisher.getId(), getType, count, publisher.isInterbroker() || publisher.isRemoteBroker());
            return;
        }
        catch (Exception e) {
            if (this.DEBUG) {
                this.debug("Error reading count from GET message");
            }
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
    }

    private boolean reserveQSpace(IMgram m, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, IMgram nackMgram) {
        return this.reserveQSpace(m, publisher, flowController, iaq, nackMgram, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserveQSpace(IMgram m, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, IMgram nackMgram, int numReserves, String[] blockedRoutes) {
        boolean forceReserve = false;
        m.setEnqueuedSize(m.getEnqueuedSize());
        int totalSize = numReserves * m.getEnqueuedSize();
        if (nackMgram == null) {
            nackMgram = m;
        }
        if (flowController == null && publisher != null) {
            flowController = publisher.getFlowController();
        }
        if (!(forceReserve = m.getBrokerHandle().isTransactionalPublish() ? true : (m.isPubSub() && !m.isGuarenteed() ? true : (m.isDiscardable() ? true : m.getBrokerHandle().isBatchedPublish())))) {
            long maxSz = iaq.getMaxQueueSizeInBytes();
            if ((long)totalSize > maxSz) {
                if (this.DEBUG) {
                    this.debug("Message " + m.getGuarenteedTrackingNum() + " larger than queue, rejecting");
                }
                if (publisher != null && (nackMgram.isGuarenteed() || nackMgram.isRejectable())) {
                    if (InterbrokerHook.isSet() && publisher.isInterbroker() || publisher.isRemoteBroker()) {
                        publisher.sendErrorAck(nackMgram, (short)-16, true);
                    } else {
                        publisher.sendErrorAck(nackMgram, (short)-16, false);
                    }
                }
                return false;
            }
            Object object = iaq.getDequeueLock();
            synchronized (object) {
                if (this.DEBUG) {
                    this.debug("Checking flow control for " + m.getGuarenteedTrackingNum() + " on " + iaq);
                }
                boolean reserveFailed = false;
                if (flowController != null && !flowController.checkGlobalBlocked(iaq.getQueueAddress(), nackMgram)) {
                    reserveFailed = true;
                }
                if (!reserveFailed && !iaq.reserve(totalSize)) {
                    reserveFailed = true;
                }
                if (reserveFailed) {
                    if (flowController != null) {
                        flowController.nack(nackMgram, totalSize, iaq, blockedRoutes);
                    }
                    return false;
                }
            }
        }
        Object object = iaq.getDequeueLock();
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("Checking space for transactional publish " + m.getGuarenteedTrackingNum() + " on " + iaq);
            }
            boolean blocked = AgentRegistrar.getAgentRegistrar().getFlowControlManager().isDestinationGloballyBlocked(iaq.getQueueAddress());
            boolean overflow = false;
            for (int ii = 0; ii < numReserves; ++ii) {
                if (!iaq.forceReserve(m)) continue;
                overflow = true;
            }
            if (overflow || blocked) {
                if (this.DEBUG) {
                    this.debug("ForceReserved space (w. overflow) for tx publish " + m.getGuarenteedTrackingNum());
                }
                if (flowController != null) {
                    flowController.block(m, totalSize, iaq, blockedRoutes);
                } else if (this.DEBUG) {
                    this.debug("Sender not found, message accepted");
                }
            } else if (this.DEBUG) {
                this.debug("ForceReserved space (w/o overflow) for tx publish " + m.getGuarenteedTrackingNum());
            }
        }
        m.setEnqueuedSize(m.getEnqueuedSize());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUnblockedAndReserveSync(IMgram m, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, boolean forRemoteDestination, IMgram nackMgram) {
        if (iaq == this.m_routingQ) {
            Object object = iaq.getDequeueLock();
            synchronized (object) {
                return this.checkUnblockedAndReserve(m, publisher, flowController, iaq, forRemoteDestination, nackMgram);
            }
        }
        return this.checkUnblockedAndReserve(m, publisher, flowController, iaq, forRemoteDestination, nackMgram);
    }

    private boolean checkUnblockedAndReserve(IMgram m, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, boolean forRemoteDestination, IMgram nackMgram) {
        IRemoteBroker irb = null;
        String node = null;
        int[] dest = null;
        boolean forUnblockedRemoteDestination = false;
        if (nackMgram == null) {
            nackMgram = m;
        }
        if (forRemoteDestination) {
            if (!nackMgram.isPubSub()) {
                dest = nackMgram.getSubject().getMatchVector();
            }
            if ("".equals(node = nackMgram.getRoutingHandle().getRouting())) {
                node = Config.ROUTING_NODE_NAME;
            }
            if ((irb = this.m_rbHelper.selectRemoteBroker(node, dest, nackMgram)) != null && this.m_rbHelper.checkOkToSend(irb)) {
                forUnblockedRemoteDestination = true;
            }
        }
        boolean forceReserve = false;
        if (forRemoteDestination && forUnblockedRemoteDestination) {
            forceReserve = true;
        } else if (m.isDiscardable()) {
            forceReserve = true;
        }
        if (forceReserve) {
            iaq.forceReserve(m);
            m.setEnqueuedSize(m.getEnqueuedSize());
        } else {
            String[] blockedRoutes = null;
            if (irb != null) {
                blockedRoutes = new String[]{irb.getPendingQueueName()};
            }
            if (!this.reserveQSpace(m, publisher, flowController, iaq, nackMgram, 1, blockedRoutes)) {
                return false;
            }
        }
        return true;
    }

    private void handlePutMgram(IMgram m, IClientContext publisher, IAgentQueue iaq, boolean reserve, boolean forRemoteDestination, boolean deliverOnly) throws InterruptedException {
        this.handlePutMgram(m, publisher, publisher != null ? publisher.getFlowController() : null, iaq, reserve, forRemoteDestination, deliverOnly);
    }

    private void handlePutMgram(IMgram mgram, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, boolean reserve, boolean forRemoteDestination, boolean deliverOnly) throws InterruptedException {
        if (!forRemoteDestination && iaq.getMessageGroupHandle() != null && !iaq.getMessageGroupHandle().onNewMgram(mgram, publisher)) {
            return;
        }
        if (mgram.getType() != 27 || mgram.hasTxn()) {
            this.handlePutMgramInternal(mgram, publisher, flowController, iaq, reserve, forRemoteDestination, deliverOnly);
        } else {
            int size = mgram.getBatchHandle().getBatchSize();
            IMgram[] subMgrams = new IMgram[size];
            InterceptorManager.doActionalP2PReceiveJointPoint(mgram, publisher);
            this.splitBatch(mgram, publisher, iaq, deliverOnly, mgram.getBatchHandle(), subMgrams);
            for (int ii = 0; ii < subMgrams.length; ++ii) {
                this.handlePutMgramInternal(subMgrams[ii], publisher, flowController, iaq, reserve, forRemoteDestination, true);
            }
        }
    }

    private void splitBatch(IMgram batchMgram, IClientContext publisher, IAgentQueue iaq, boolean deliverOnly, IBatchHandle batchHandle, IMgram[] subMgrams) throws InterruptedException {
        int batchSize = batchHandle.getBatchSize();
        boolean isTempQ = false;
        if (iaq.getQueueType() == 1) {
            isTempQ = true;
        }
        long subLogSeqNo = -1L;
        boolean persistent = false;
        boolean discardable = batchMgram.isDiscardable();
        boolean needGuarAck = false;
        AgentQueueMsgTracker batchTracker = null;
        batchHandle.syncBatch();
        if (batchMgram.isJMSPersistent() && (!isTempQ || Config.XONCE_RECOVERY)) {
            persistent = true;
            if (batchMgram.getBrokerHandle().isTransactionalPublish() && batchMgram.getBrokerHandle().isTxnPublishFromLog()) {
                long batchTracking = batchMgram.getGuarenteedTrackingNum();
                batchTracker = AgentQueueMsgTracker.getTracker(batchTracking);
                if (batchTracker == null) {
                    throw new EAssertFailure("Transacted message from log; can't find tracker " + batchTracking);
                }
                batchTracker.setSplitBatch(true);
                BatchSplitEvt evt = new BatchSplitEvt(batchTracking, false);
                evt.setReplicateOnly(batchMgram.isNonPersistentReplicated());
                this.m_logMgr.addEvent(evt, false);
            } else {
                if (deliverOnly) {
                    throw new EAssertFailure("Previously logged non-transacted batch");
                }
                if (publisher != null) {
                    needGuarAck = publisher.isInterbroker() && InterbrokerHook.isSet() || publisher.isRemoteBroker() || publisher.needsGuarAck() && !batchMgram.getBrokerHandle().isTransactionalPublish();
                }
                QueueMsgEvt evt = new QueueMsgEvt(iaq.getQueueName(), publisher, batchMgram, needGuarAck, isTempQ);
                evt.setSplitBatch(true);
                this.m_logMgr.addEvent(evt, true);
                evt.createTracker();
                batchTracker = evt.getTracker();
            }
            subLogSeqNo = batchTracker.getTracking() + 1L;
        } else {
            if (publisher != null && batchMgram.isGuarenteed() && !batchMgram.getBrokerHandle().isTransactionalPublish()) {
                publisher.sendQAck(batchMgram.getGuarenteedTrackingNum(), batchMgram);
            }
            if (!discardable) {
                subLogSeqNo = this.m_logMgr.allocMultipleSeqNos(batchSize);
            }
        }
        IMgram subMgram = null;
        QueueMsgEvt subEvt = null;
        int ii = 0;
        Iterator iter = batchHandle.getBatchIterator();
        while (iter.hasNext()) {
            subMgram = (IMgram)iter.next();
            subMgram.getBrokerHandle().setBatchedPublish(true);
            if (persistent && subMgram.isJMSPersistent()) {
                subEvt = new QueueMsgEvt(iaq.getQueueName(), publisher, subMgram, false, isTempQ);
                subEvt.setSeqNo(subLogSeqNo);
                subEvt.createTracker();
                subMgram.setGuarenteed(subEvt.getTracker().getTracking());
            } else if (!discardable && !subMgram.isDiscardable()) {
                subMgram.setGuarenteed(subLogSeqNo & 0xFFFFFFFFFFFFL);
            }
            ++subLogSeqNo;
            subMgrams[ii] = subMgram;
            ++ii;
        }
        if (batchTracker != null) {
            batchTracker.endSplitting();
            batchTracker.canceled(false);
        }
    }

    private void handlePutMgramInternal(IMgram m, IClientContext publisher, IFlowController flowController, IAgentQueue iaq, boolean reserve, boolean forRemoteDestination, boolean deliverOnly) throws InterruptedException {
        if (m.getType() == 11) {
            this.ackAndMove(publisher, m, iaq, forRemoteDestination);
            return;
        }
        QueueMsgEvt evt = null;
        if (!deliverOnly) {
            evt = (QueueMsgEvt)m.getBrokerHandle().getLogEvent();
        }
        long tracking = -1L;
        boolean needGuarAck = false;
        boolean needTracking = true;
        boolean transacted = false;
        int tid = -1;
        if (m.hasTxn()) {
            transacted = true;
            tid = m.getTxnId();
            m.removeTxn();
        }
        if (transacted && (this.debugFlags & 0x800) != 0) {
            this.debug("handlePutMgram starting: message is transacted; tid= " + tid + " queue= " + iaq.getQueueName());
        }
        boolean isTempQ = false;
        if (iaq.getQueueType() == 1) {
            isTempQ = true;
        }
        if (m.isDiscardable()) {
            needTracking = false;
        }
        if (reserve && !this.checkUnblockedAndReserveSync(m, publisher, flowController, iaq, iaq == this.m_routingQ, null)) {
            return;
        }
        InterceptorManager.doActionalP2PReceiveJointPoint(m, publisher);
        if (!(!deliverOnly || isTempQ && Config.XONCE_RECOVERY)) {
            if (!this.m_started) {
                if (m.isJMSPersistent() && !isTempQ) {
                    if (this.DEBUG) {
                        this.debug("Saving persistent recovered GSA message; tracking= " + m.getGuarenteedTrackingNum());
                    }
                    this.handleMessageSentBeforeStart(m, iaq, true);
                }
                iaq.unreserve(m.getEnqueuedSize());
                return;
            }
        } else if (!deliverOnly && m.isJMSPersistent() && (isTempQ && Config.XONCE_RECOVERY || !isTempQ)) {
            if (evt == null) {
                boolean flush;
                IMgram logmg = m;
                if (transacted) {
                    try {
                        logmg = (IMgram)m.protectedClone();
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                }
                if (publisher != null) {
                    needGuarAck = publisher.isInterbroker() && InterbrokerHook.isSet() || publisher.isRemoteBroker() || publisher.needsGuarAck() && !transacted && !m.getBrokerHandle().isTransactionalPublish();
                }
                long senderTrackingNum = m.isGuarenteed() ? m.getGuarenteedTrackingNum() : 0L;
                evt = new QueueMsgEvt(iaq.getQueueName(), publisher, logmg, needGuarAck, isTempQ);
                boolean bl = flush = !m.getBrokerHandle().isTransactionalPublish() && !transacted && !m.getBrokerHandle().isBatchedPublish();
                if (Config.LOG_FLUSH_DELAY > 0 && flush) {
                    evt.setCanBeDelayed(iaq.canLogFlushBeDelayed());
                }
                if (transacted) {
                    evt.setTransacted(tid);
                    try {
                        this.m_txnmgr.addingMsgToLog(tid);
                    }
                    catch (ETxnSequenceError ex) {
                        if ((this.debugFlags & 0x800) != 0) {
                            this.logException(ERROR_MESSAGES[1], new Object[]{"txnSequenceError", tid}, ex);
                        }
                        return;
                    }
                    catch (ETxnNotFound ex) {
                        if ((this.debugFlags & 0x800) != 0) {
                            this.logException(ERROR_MESSAGES[1], new Object[]{"txnNotFound", tid}, ex);
                        }
                        return;
                    }
                }
                this.m_logMgr.addEvent(evt, flush);
                evt.createTracker();
                if (transacted) {
                    TxMsgQueue txMsg = new TxMsgQueue(publisher, tid, logmg);
                    AgentQueueMsgTracker trk = evt.getTracker();
                    txMsg.addDeliveryInfo(trk);
                    txMsg.setOrigTracking(evt.getOrigTracking());
                    try {
                        this.m_txnmgr.newMsg(txMsg);
                    }
                    catch (ETxnSequenceError ex) {
                    }
                    catch (ETxnNotFound ex) {
                        // empty catch block
                    }
                    if (!(publisher == null || !m.isGuarenteed() || transacted && publisher.isXOnce())) {
                        publisher.sendQAck(senderTrackingNum, m);
                    }
                    if ((this.debugFlags & 0x800) > 0) {
                        this.debug("handlePutMgram: logged persistent transacted message and gave to TM  tid= " + tid + "trk= " + trk.getTracking() + " queue= " + evt.getLocalQueueName());
                    }
                    return;
                }
                if (!this.m_started) {
                    if (this.DEBUG) {
                        this.debug("Saving persistent message from recovered transaction; tracking= " + logmg.getGuarenteedTrackingNum());
                    }
                    if (!isTempQ) {
                        this.handleMessageSentBeforeStart(logmg, iaq, logmg.isJMSPersistent());
                        iaq.unreserve(m.getEnqueuedSize());
                        return;
                    }
                }
            } else {
                if (transacted) {
                    throw new EAssertFailure("Persistent transacted message; evt != null ");
                }
                evt.createTracker();
            }
        } else if (!deliverOnly) {
            if (!this.m_started) {
                iaq.unreserve(m.getEnqueuedSize());
                return;
            }
            if (this.DEBUG) {
                this.debug("New nonpersistent qmsg; Sender: " + (publisher != null ? publisher.getId() : 0L) + " ourTracking= " + tracking);
            }
            long senderTrackingNum = 0L;
            if (publisher != null && m.isGuarenteed() && !m.getBrokerHandle().isTransactionalPublish()) {
                senderTrackingNum = m.getGuarenteedTrackingNum();
                if (!transacted) {
                    publisher.sendQAck(senderTrackingNum, m);
                }
            }
            if (needTracking) {
                tracking = this.m_logMgr.allocSeqNo() & 0xFFFFFFFFFFFFL;
                m.setGuarenteed(tracking);
            }
            if (transacted) {
                if (this.DEBUG) {
                    this.debug("handlePutMgram: giving nonpersistent transacted message to TM, trk= " + tracking + "tid= " + tid);
                }
                TxMsgQueue txm = new TxMsgQueue(publisher, tid, m);
                txm.setOrigTracking(senderTrackingNum);
                try {
                    this.m_txnmgr.newMsg(txm);
                }
                catch (ETxnSequenceError ex) {
                    return;
                }
                catch (ETxnNotFound ex) {
                    return;
                }
                if (publisher != null && m.isGuarenteed() && !publisher.isXOnce()) {
                    publisher.sendQAck(senderTrackingNum, m);
                }
                return;
            }
        }
        if (transacted) {
            throw new EAssertFailure("AQP: can't deliver uncommitted message ");
        }
        if (m.getBrokerHandle().isTransactionalPublish() && this.DEBUG) {
            this.debug("Enqueuing transacted message to queue " + iaq.getQueueName() + " committed tid= " + m.getBrokerHandle().getTxnPublishTid() + " tracking= " + m.getGuarenteedTrackingNum());
        }
        long senderCID = publisher != null ? publisher.getId() : -1L;
        if (!forRemoteDestination) {
            iaq.put(m, senderCID);
        } else {
            this.handleRemotePut(m, iaq, senderCID);
        }
    }

    private final void handleMessageSentBeforeStart(IMgram m, IAgentQueue iaq, boolean persistent) {
        this.m_agentReg.getQueueMsgSaver().saveMsg(iaq.getQueueName(), m);
        m.getBrokerHandle().setLocalQueueName(iaq.getQueueName());
        long exp = m.isTTE() ? m.getTTE() : 0L;
        DbQMsgData msgDat = new DbQMsgData(m.getGuarenteedTrackingNum(), m.getEnqueuedSize(), exp, m.getPriority(), persistent, m, m.isSuccessor(), iaq.getQueueName());
        Vector<DbQMsgData> vec = (Vector<DbQMsgData>)this.m_msgsSentBeforeStart.get(iaq.getQueueName());
        if (vec == null) {
            vec = new Vector<DbQMsgData>();
            this.m_msgsSentBeforeStart.put(iaq.getQueueName(), vec);
        }
        vec.add(msgDat);
        if ((this.debugFlags & 0x1000) != 0) {
            this.debug("added msg to m_msgsSentBeforeStart;; trk= " + msgDat.getMessageId() + " queue= " + iaq.getQueueName());
        }
    }

    private void handleRemotePut(IMgram m, IAgentQueue iaq, long senderCID) throws InterruptedException {
        m.getBrokerHandle().setLocalQueueName(iaq.getQueueName());
        if (iaq == this.m_routingQ && !this.m_routingQ.isRoutingQueueEmpty()) {
            if (!m.isDiscardable()) {
                this.m_routingQ.put(m, senderCID);
            } else {
                iaq.unreserve(m.getEnqueuedSize());
            }
        } else {
            this.m_rbHelper.route(m);
            iaq.unreserve(m.getEnqueuedSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getQueues(String prefix) {
        ArrayList<IQueueData> queuesData = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            queuesData = new ArrayList<IQueueData>(this.m_queues.size());
            boolean useFilter = prefix != null && prefix.length() > 0;
            for (IQueueInfo iQueueInfo : this.m_queues.values()) {
                String queueName = iQueueInfo.getQueueName();
                if (useFilter && !queueName.startsWith(prefix)) continue;
                int typeMask = 0;
                if (iQueueInfo.getQueueType() == 1 || iQueueInfo.getQueueType() == 5) {
                    typeMask |= 2;
                }
                if (queueName.startsWith("SonicMQ.")) {
                    typeMask |= 1;
                }
                if (iQueueInfo.isClustered()) {
                    typeMask |= 4;
                }
                if (iQueueInfo.isGlobal()) {
                    typeMask |= 8;
                }
                if (iQueueInfo.isReadExclusive()) {
                    typeMask |= 0x20;
                }
                IQueueData queueData = RuntimeDataFactory.createQueueData(queueName, typeMask, iQueueInfo.getTotalEnqueued(), iQueueInfo.getTotalSize());
                queuesData.add(queueData);
            }
        }
        return queuesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRoutingStatistics(String prefix) {
        IRemoteBroker rb;
        String nodeName;
        ArrayList httpRemoteBrokers;
        Collection pendingQueues = this.getRoutingQueue().getPendingQueueData();
        Enumeration rbEnum = this.m_agentReg.getRouterManager().getAllRemoteBrokers();
        Iterator httpDirectIt = null;
        if (this.m_rbHelper != null && (httpRemoteBrokers = this.m_rbHelper.getHttpRemoteBrokers()) != null) {
            ArrayList arrayList = httpRemoteBrokers;
            synchronized (arrayList) {
                httpDirectIt = ((ArrayList)httpRemoteBrokers.clone()).iterator();
            }
        }
        INeighbor[] neighbors = null;
        if (InterbrokerHook.isSet()) {
            neighbors = Interbroker.getInterbroker().getAllNeighbors();
        }
        HashMap<String, RoutingStatistic> resultMap = new HashMap<String, RoutingStatistic>();
        boolean useFilter = prefix != null && prefix.length() > 0;
        for (IQueueInfo qd : pendingQueues) {
            int size;
            nodeName = qd.getQueueName();
            if (useFilter && !nodeName.startsWith(prefix) || (size = qd.getTotalEnqueued()) <= 0) continue;
            RoutingStatistic stat = (RoutingStatistic)resultMap.get(nodeName);
            if (stat == null) {
                stat = RuntimeDataFactory.createRoutingStat(nodeName);
                resultMap.put(nodeName, stat);
            }
            stat.addMessageCount(size);
            if (!this.DEBUG) continue;
            this.debug("PMQ Name: " + nodeName + " Size: " + qd.getTotalEnqueued());
        }
        if (httpDirectIt != null) {
            while (httpDirectIt.hasNext()) {
                rb = (IRemoteBroker)httpDirectIt.next();
                nodeName = rb.getPendingQueueName();
                if (!rb.isHttp()) continue;
                this.addRemoteBrokerStat(rb, resultMap, nodeName, useFilter, prefix);
            }
        }
        while (rbEnum.hasMoreElements()) {
            rb = (IRemoteBroker)rbEnum.nextElement();
            nodeName = rb.getPendingQueueName();
            if (rb.isNeighbor()) continue;
            this.addRemoteBrokerStat(rb, resultMap, nodeName, useFilter, prefix);
        }
        if (neighbors != null) {
            for (int neighborCount = 0; neighborCount < neighbors.length; ++neighborCount) {
                IRemoteBroker rb2 = neighbors[neighborCount].getAsRemoteBroker();
                String nodeName2 = rb2.getPendingQueueName();
                this.addRemoteBrokerStat(rb2, resultMap, nodeName2, useFilter, prefix);
            }
        }
        ArrayList result = new ArrayList();
        result.addAll(resultMap.values());
        return result;
    }

    private void addRemoteBrokerStat(IRemoteBroker rb, HashMap resultMap, String nodeName, boolean useFilter, String prefix) {
        if (useFilter && !nodeName.startsWith(prefix)) {
            return;
        }
        int size = rb.getInDoubtQMsgsCount();
        if (this.DEBUG) {
            this.debug("Indoubt Q Size: " + size);
        }
        size += rb.getPendingQMsgsCount();
        if (this.DEBUG) {
            this.debug("Indoubt Q Size + PendingQMsgs: " + size);
        }
        if (size > 0) {
            RoutingStatistic stat = (RoutingStatistic)resultMap.get(nodeName);
            if (stat == null) {
                stat = RuntimeDataFactory.createRoutingStat(nodeName);
                resultMap.put(nodeName, stat);
            }
            stat.addMessageCount(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQueueMessages(ArrayList<String> queueNames) throws InterruptedException {
        Iterator<String> iterator = queueNames.iterator();
        IAgentQueue queue = null;
        while (iterator.hasNext()) {
            String queueName = iterator.next();
            String pendingQueueName = null;
            Object object = this.m_queues_lock;
            synchronized (object) {
                if (queueName.startsWith("SonicMQ.routingQueue")) {
                    queue = this.m_queues.get("SonicMQ.routingQueue");
                    int index = queueName.indexOf("$");
                    if (index != -1) {
                        pendingQueueName = queueName.substring(++index);
                    }
                } else {
                    queue = this.m_queues.get(queueName);
                }
            }
            if (queue == null) {
                throw new IllegalArgumentException("Deleting of queue messages aborted due to unknown queue: " + queueName);
            }
            if (pendingQueueName != null) {
                ((AgentRoutingQueue)queue).clearPendingQueue(pendingQueueName);
                continue;
            }
            queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getAgentQueues() {
        Object object = this.m_queues_lock;
        synchronized (object) {
            return ((Hashtable)this.getQueues()).elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAgentQueue getAgentQueue(String queueName) {
        Object object = this.m_queues_lock;
        synchronized (object) {
            return this.m_queues.get(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getGlobalQueues() {
        Vector<IAgentQueue> vec = new Vector<IAgentQueue>();
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            Enumeration<IAgentQueue> enu = this.m_queues.elements();
            while (enu.hasMoreElements()) {
                iaq = enu.nextElement();
                if (!iaq.isGlobal()) continue;
                vec.addElement(iaq);
            }
        }
        return vec.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IAgentQueue> getQueues() {
        Object object = this.m_queues_lock;
        synchronized (object) {
            return (Map)this.m_queues.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getClusteredQueues() {
        Vector<IAgentQueue> vec = new Vector<IAgentQueue>();
        IAgentQueue iaq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            Enumeration<IAgentQueue> enu = this.m_queues.elements();
            while (enu.hasMoreElements()) {
                iaq = enu.nextElement();
                if (!iaq.isClustered()) continue;
                vec.addElement(iaq);
            }
        }
        return vec.elements();
    }

    public AgentRoutingQueue getRoutingQueue() {
        return this.m_routingQ;
    }

    AgentDeadMessageQueue getDeadMessageQueue() {
        return this.m_dmq;
    }

    void forcedSave() {
        Enumeration enu = this.getAgentQueues();
        IAgentQueue iaq = null;
        while (enu.hasMoreElements()) {
            iaq = (IAgentQueue)enu.nextElement();
            if (iaq.getQueueType() == 1) continue;
            iaq.forcedSave();
        }
    }

    private void createDeadMsgQ() throws EDatabaseException {
        this.m_dmq = (AgentDeadMessageQueue)this.m_qfactory.createAgentQueue(3, "SonicMQ.deadMessage", DFLT_DEAD_MSG_QUEUE_SIZE);
        this.m_dmq.setSaveThresholdInKiloBytes(1536);
        this.m_dmq.setFlowControl(false);
        this.connectQueue(this.m_dmq);
    }

    private void createRoutingQ() throws EDatabaseException {
        this.m_routingQ = (AgentRoutingQueue)this.m_qfactory.createAgentQueue(4, "SonicMQ.routingQueue", Config.MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE);
        this.m_routingQ.setSaveThresholdInKiloBytes(1536);
        this.connectQueue(this.m_routingQ);
    }

    public AgentTemporaryQueue createTempQueue(long clientID, QueueAttributes attributes) throws InterruptedException {
        return this.createTempQueue(clientID, attributes, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentTemporaryQueue createTempQueue(long clientID, QueueAttributes attributes, Envelope env, Session session) throws InterruptedException {
        String queueName = attributes.getName();
        AgentTemporaryQueue atq = null;
        Object object = this.m_queues_lock;
        synchronized (object) {
            atq = (AgentTemporaryQueue)this.m_queues.get(queueName);
        }
        if (this.DEBUG) {
            this.debug("Set Queue NAME: " + queueName + ", ADDR:" + "$Q." + queueName);
        }
        boolean readOnly = attributes.getReadOnly();
        boolean readExclusive = attributes.getReadExclusive();
        boolean writeOnly = attributes.getWriteOnly();
        boolean writeExclusive = attributes.getWriteExclusive();
        int maxQSize = attributes.getMaxQSize();
        boolean global = attributes.getGlobal();
        if (atq == null) {
            if (this.DEBUG) {
                this.debug("Queue does not exist, creating...");
            }
            atq = (AgentTemporaryQueue)this.m_qfactory.createAgentQueue(1, queueName, maxQSize);
            atq.setReadExclusiveMode(readExclusive);
            atq.setReadOnlyMode(readOnly);
            atq.setWriteExclusiveMode(writeExclusive);
            atq.setWriteOnlyMode(writeOnly);
            atq.setGlobal(global);
            this.addTemporaryQueue(clientID, atq, false);
            atq.start();
            if (global) {
                this.advertiseGlobal(queueName);
            }
            TempQueueCreationEvt evt = null;
            if (Config.XONCE_RECOVERY) {
                evt = new TempQueueCreationEvt(clientID, atq.getQueueType(), atq.getQueueName(), atq.isGlobal(), atq.getMaxQueueSizeInKiloBytes(), env);
                this.m_logMgr.addEvent(evt, true);
            }
            if (this.DEBUG) {
                this.debug("Queue started.");
            }
        } else {
            atq.setReadExclusiveMode(attributes.getReadExclusive());
            atq.setReadOnlyMode(attributes.getReadOnly());
            atq.setWriteExclusiveMode(attributes.getWriteExclusive());
            atq.setWriteOnlyMode(attributes.getWriteOnly());
            atq.setMaxQueueSizeInKiloBytes(attributes.getMaxQSize());
            global = attributes.getGlobal();
            if (this.DEBUG) {
                this.debug("Setting GLOBAL_QUEUE = " + global);
            }
            if (!queueName.equals("SonicMQ.deadMessage") && !queueName.equals("SonicMQ.routingQueue")) {
                boolean wasGlobal = atq.isGlobal();
                atq.setGlobal(global);
                if (wasGlobal != global) {
                    if (global) {
                        this.advertiseGlobal(queueName);
                    } else {
                        this.unadvertiseGlobal(queueName);
                    }
                }
            }
            this.sendSuccessReply(env, session);
        }
        return atq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueBrowser(long clientId, IAgentQueue iaq) {
        LongHashTable longHashTable = this.m_clientBrowserReg;
        synchronized (longHashTable) {
            this.m_clientBrowserReg.put(clientId, iaq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterQueueBrowser(long clientId) {
        LongHashTable longHashTable = this.m_clientBrowserReg;
        synchronized (longHashTable) {
            this.m_clientBrowserReg.remove(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createQueueReceiver(long clientId, String queueName, String selector) throws ParseException, EUnauthorizedClient, EExclusiveQueueOpen {
        String errmsg = null;
        if (queueName != null && !"".equals(queueName) && !queueName.startsWith("SonicMQ.routingQueue")) {
            IAgentQueue iaq = null;
            Object object = this.m_queues_lock;
            synchronized (object) {
                iaq = this.m_queues.get(queueName);
            }
            if (iaq != null) {
                this.connectClient(clientId, iaq);
                if (!this.openReceiver(clientId, iaq, selector)) {
                    if (this.DEBUG) {
                        this.debug(iaq.getQueueName() + " already open");
                    }
                    throw new EExclusiveQueueOpen("Exclusive queue already open");
                }
            } else {
                errmsg = prAccessor.getString("Q_NOT_FOUND") + queueName;
            }
        } else {
            errmsg = "Null or invalid queue name " + queueName;
        }
        return errmsg;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ackAndMove(IClientContext forwarder, IMgram ackAndMoveMgram, IAgentQueue newQ, boolean forRemoteDestination) throws InterruptedException {
        IMgram mgram;
        IClientContext receiverContext;
        boolean origPersistent;
        long oldTracking;
        boolean isTempQueue;
        String newQueueName;
        block22: {
            IXOnceHandle xoh;
            block21: {
                newQueueName = newQ.getQueueName();
                isTempQueue = newQ.getQueueType() == 1;
                Hashtable props = ackAndMoveMgram.getSidebandData().getProperties();
                oldTracking = (Long)props.get("tracking");
                long receiverClientID = (Long)props.get("receiverClientID");
                origPersistent = (Boolean)props.get("origPersistent");
                boolean retriedAfterRecovery = false;
                Object obj = null;
                Object v = props.get("retriedAfterRecovery");
                obj = v;
                if (v != null) {
                    retriedAfterRecovery = obj;
                }
                if (this.DEBUG) {
                    this.debug("ackAndMove: Moving message with tracking " + oldTracking + " to queue " + newQueueName + "retry=" + retriedAfterRecovery);
                }
                if ((receiverContext = forwarder.redirectAckForward(receiverClientID)) == null) {
                    throw new EAssertFailure(this + ": acknowledge of msg " + oldTracking + " while unregistered");
                }
                mgram = null;
                if (!retriedAfterRecovery) break block21;
                xoh = receiverContext.getXOnceHandle();
                if (xoh != null) {
                    mgram = xoh.removeInDoubtQMsg(oldTracking);
                }
                if (mgram != null) {
                    if (this.DEBUG) {
                        this.debug("AAF retry: removed msg " + oldTracking + " from the in-doubt q msg list of " + receiverContext);
                    }
                    break block22;
                } else {
                    if (this.DEBUG) {
                        this.debug("AAF retry: msg " + oldTracking + " not found in the in-doubt q msg list of " + receiverContext);
                    }
                    forwarder.sendThrough(MgramFactory.getMgramFactory().buildAck(ackAndMoveMgram.getGuarenteedTrackingNum(), (short)0, forwarder.getChannel()));
                    return;
                }
            }
            mgram = receiverContext.getPendingQMessage(oldTracking);
            if (mgram == null && (xoh = receiverContext.getXOnceHandle()) != null) {
                mgram = xoh.removeInDoubtQMsg(oldTracking);
            }
        }
        if (mgram == null) {
            throw new EAssertFailure(this + ": Acknowledged message not found.");
        }
        boolean success = false;
        success = this.checkUnblockedAndReserveSync(mgram, forwarder, forwarder != null ? forwarder.getFlowController() : null, newQ, newQ == this.m_routingQ, ackAndMoveMgram);
        if (!success) {
            return;
        }
        IMgram ack = MgramFactory.getMgramFactory().buildAck(0L, (short)0, false, 0L, false, 0, 0);
        ack.getBrokerHandle().setAckNoReply(true);
        if (ackAndMoveMgram.isJMSPersistent() && origPersistent) {
            receiverContext.removeQMsgPendingAck(oldTracking);
        } else if (!ackAndMoveMgram.isJMSPersistent() && !origPersistent) {
            mgram = receiverContext.acknowledgeQueue(oldTracking, false, ack);
        } else if (!ackAndMoveMgram.isJMSPersistent() && origPersistent) {
            ack.setGuarenteed(1L);
            mgram = receiverContext.acknowledgeQueue(oldTracking, false, ack);
        } else if (ackAndMoveMgram.isJMSPersistent() && !origPersistent) {
            mgram = receiverContext.acknowledgeQueue(oldTracking, false, ack);
        }
        if (this.DEBUG) {
            this.debug("ackAndMove: Message id is " + this.getMessageID(mgram));
        }
        mgram.getBrokerHandle().acknowledgeAndForward(this.m_mp, ackAndMoveMgram);
        if (ackAndMoveMgram.isJMSPersistent() && origPersistent) {
            this.m_qMsgStateMgr.moveMsg(mgram, true, newQueueName, true, isTempQueue);
        }
        mgram.getBrokerHandle().setFromDB(false);
        if (ackAndMoveMgram.isJMSPersistent() && !origPersistent) {
            mgram.getBrokerHandle().acknowledgeAndForward(ackAndMoveMgram);
            this.handlePutMgram(mgram, forwarder, newQ, false, forRemoteDestination, false);
            return;
        }
        forwarder.sendThrough(MgramFactory.getMgramFactory().buildAck(ackAndMoveMgram.getGuarenteedTrackingNum(), (short)0, forwarder.getChannel()));
        this.handlePutMgram(mgram, forwarder, newQ, false, forRemoteDestination, true);
    }

    @Override
    public void processUndelivered(IMgram mgram, int reason, boolean delete) throws InterruptedException {
        this.processUndelivered(mgram, reason, delete, null);
    }

    public void processUndelivered(IMgram mgram, int reason, boolean delete, Hashtable dmqprops) throws InterruptedException {
        boolean preserve = this.getBooleanProperty(mgram, "JMS_SonicMQ_preserveUndelivered");
        boolean notify = this.getBooleanProperty(mgram, "JMS_SonicMQ_notifyUndelivered");
        if (mgram.isDiscardable()) {
            preserve = false;
            notify = false;
        }
        if (mgram.isPubSub()) {
            if (reason == 1 && mgram.forRemoteNode(Config.ROUTING_NODE_NAME)) {
                preserve = false;
                notify = false;
            } else if (reason == -1) {
                preserve = false;
                notify = false;
            } else if (SessionConfig.isSystemSubject(mgram.getSubject())) {
                preserve = false;
            }
        }
        if (this.DEBUG) {
            this.debug("processUndelivered: " + this.getMessageID(mgram) + " " + this.formatReason(reason) + " Notify = " + notify + " Preserve = " + preserve);
        }
        DestinationInfo undelDestInfo = null;
        if (this.checkDebugFlags(64) && mgram.isPubSub()) {
            this.debug("***AQP: calling preserveUndelivered for pubsubMsg " + mgram.getGuarenteedTrackingNum() + mgram.getSubject() + " m.isQueueMessage= " + mgram.isQueueMessage());
        }
        if (preserve) {
            undelDestInfo = this.preserveUndelivered(mgram, reason, delete, dmqprops);
        } else if (delete && mgram.isGuarenteed()) {
            if (mgram.isJMSPersistent()) {
                AgentQueueMsgTracker msgTracker;
                boolean pubsub = false;
                if (this.checkDebugFlags(64) && mgram.isPubSub()) {
                    this.debug("***AQP: processUndelivered for pubsubMsg " + mgram.getGuarenteedTrackingNum() + mgram.getSubject() + " looking for QueueTracker; m.isQueueMessage= " + mgram.isQueueMessage());
                    pubsub = true;
                }
                if ((msgTracker = AgentQueueMsgTracker.getTracker(mgram.getGuarenteedTrackingNum())) != null) {
                    msgTracker.acknowledged(null, false);
                    if (this.checkDebugFlags(64) && pubsub) {
                        this.debug("***AQP: processUndelivered for pubsubMsg " + mgram.getGuarenteedTrackingNum() + mgram.getSubject() + " found QueueTracker");
                    }
                } else if (this.checkDebugFlags(64) && pubsub) {
                    try {
                        AgentGuarMsgTracker.getTracker(mgram.getGuarenteedTrackingNum());
                        this.debug("***AQP: processUndelivered for pubsubMsg " + mgram.getGuarenteedTrackingNum() + mgram.getSubject() + " got GuarTracker");
                    }
                    catch (ETrackingNumNotFound ex) {}
                }
            } else {
                this.m_agentReg.getQueueMsgSaver().deleteMsg(mgram.getBrokerHandle().getLocalQueueName(), mgram.getGuarenteedTrackingNum(), false);
            }
        }
        if (notify) {
            String destination = mgram.getSubject().getSubjectString();
            String routing = mgram.getRoutingHandle().getRouting();
            if (routing != null) {
                String qprefix = "$Q.";
                destination = destination.startsWith(qprefix) ? qprefix + routing + "::" + destination.substring(qprefix.length()) : routing + "::" + destination;
            }
            boolean preservedInQueue = false;
            String undelDestName = " ";
            if (preserve) {
                if (undelDestInfo != null) {
                    preservedInQueue = undelDestInfo.isQueue();
                    undelDestName = undelDestInfo.getRouting() != null ? undelDestInfo.getRouting() + "::" + undelDestInfo.getSubject() : undelDestInfo.getSubject();
                } else {
                    preservedInQueue = true;
                    undelDestName = "SonicMQ.deadMessage";
                }
            }
            BrokerManagementNotificationsHelper.sendMessageUndeliveredNotification(Config.BROKER_NAME, this.getMessageID(mgram), destination, reason, preserve, preservedInQueue, undelDestName);
        }
        this.m_agentReg.getGSManager().processUndeliveredInterceptor(mgram, reason);
    }

    private DestinationInfo preserveUndelivered(IMgram mgram, int reason, boolean delete, Hashtable dmqprops) throws InterruptedException {
        IMgram newM;
        int reasonAddedToDMQ = 0;
        try {
            mgram = (IMgram)mgram.protectedClone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        ISidebandData sd = mgram.getSidebandData();
        Hashtable props = sd.getProperties();
        AMPScratchPad scratch = null;
        boolean undelDestIsQueue = true;
        boolean undelDestIsRemoteTopic = false;
        boolean useLocalDMQ = true;
        IAgentQueue undelQueue = null;
        boolean previouslyUndelivered = false;
        String undelDest = null;
        if (props.get("JMS_SonicMQ_destinationUndelivered") instanceof String) {
            undelDest = (String)props.get("JMS_SonicMQ_destinationUndelivered");
        }
        DestinationInfo undelDestInfo = null;
        if (undelDest != null) {
            if (!mgram.hasUndeliveredDestination()) {
                useLocalDMQ = true;
                reasonAddedToDMQ = 26;
            } else {
                useLocalDMQ = false;
            }
        }
        if (!useLocalDMQ) {
            undelDestInfo = new DestinationInfo(undelDest, Config.ROUTING_NODE_NAME);
            if (undelDestInfo.isQueue()) {
                if (undelDestInfo.getSubject().equals("SonicMQ.routingQueue")) {
                    useLocalDMQ = true;
                    reasonAddedToDMQ = 25;
                } else if (undelDestInfo.getSubject().equals("SonicMQ.deadMessage")) {
                    if (undelDestInfo.getRouting() != null && !undelDestInfo.getRouting().equals(Config.ROUTING_NODE_NAME)) {
                        useLocalDMQ = true;
                        reasonAddedToDMQ = 25;
                    } else {
                        useLocalDMQ = true;
                        undelDest = null;
                        undelDestInfo = null;
                    }
                }
            }
            if (!useLocalDMQ && this.checkPreviouslyUndelivered(undelDestInfo, mgram, props, sd)) {
                previouslyUndelivered = true;
                useLocalDMQ = true;
                reasonAddedToDMQ = reason;
            }
            if (!useLocalDMQ) {
                undelDestIsQueue = undelDestInfo.isQueue();
                if (undelDestInfo.getRouting() != null) {
                    RoutingConfiguration rc;
                    RoutingConnectionInfo rci;
                    undelDestIsRemoteTopic = undelDestInfo.isRemoteTopic();
                    if (undelDestInfo.getRouting().length() > 0 && !undelDestInfo.getRouting().equals(Config.ROUTING_NODE_NAME) && (rci = (rc = this.m_agentReg.getRoutingConfig()).getRoutingConnection(undelDestInfo.getRouting())) != null && rci.getRouteType() != RoutingConnectionInfo.ROUTE_TYPE_SONIC) {
                        useLocalDMQ = true;
                        reasonAddedToDMQ = 25;
                    }
                }
            }
        }
        if (!previouslyUndelivered) {
            props.put("JMS_SonicMQ_undeliveredReasonCode", new Integer(reason));
            props.put("JMS_SonicMQ_undeliveredTimestamp", new Long(new Date().getTime()));
            if (dmqprops != null) {
                Enumeration enu = dmqprops.keys();
                while (enu.hasMoreElements()) {
                    Object value;
                    String key = (String)enu.nextElement();
                    if (key == null || !key.startsWith("JMS_SonicMQ_") || (value = dmqprops.get(key)) == null) continue;
                    props.put(key, value);
                }
            }
            sd.setProperties(props);
        }
        IMgram origNewM = newM = mgram;
        byte origType = mgram.getType();
        if (!(newM.isJMSPersistent() || delete || newM.isGuarenteed())) {
            long tracking = this.m_logMgr.allocSeqNo() & 0xFFFFFFFFFFFFL;
            newM.setGuarenteed(tracking);
        }
        if (undelDestInfo != null && !useLocalDMQ) {
            try {
                newM = (IMgram)origNewM.protectedClone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            newM.setSubject(new Subject(undelDestInfo.getFullSubject()), 5);
            newM.removeTTE();
            ISidebandData newSd = newM.getSidebandData();
            newSd.setTimestamp(System.currentTimeMillis());
            if (undelDestIsQueue) {
                if (this.checkDebugFlags(64) && origType == 2) {
                    this.debug("*** origType = NORMAL_TYPE; newType = QUEUE_NORMAL_TYPE");
                }
                newM.setType((byte)12);
            } else {
                newM.setType((byte)2);
            }
            newM.getBrokerHandle().setLocalQueueName(null);
            newM.getRoutingHandle().setRouting(undelDestInfo.getRouting());
            if (undelDestIsQueue || undelDestIsRemoteTopic) {
                undelQueue = this.resolveQueue(undelDestInfo.getISubject(), undelDestInfo.getRouting(), !undelDestIsQueue);
                if (undelQueue == null) {
                    useLocalDMQ = true;
                    reasonAddedToDMQ = 22;
                } else if (!this.checkUnblockedAndReserveSync(newM, null, null, undelQueue, undelQueue == this.m_routingQ, null)) {
                    reasonAddedToDMQ = (long)newM.getEnqueuedSize() > undelQueue.getMaxQueueSizeInBytes() ? 9 : 23;
                    useLocalDMQ = true;
                }
            } else {
                undelQueue = null;
                scratch = new AMPScratchPad();
                scratch.m_dmqOverride = true;
            }
            if (!useLocalDMQ) {
                if (!undelDestIsQueue && !undelDestIsRemoteTopic) {
                    this.m_agentReg.getMsgProc().lookUpSubscribers(newM, scratch, null);
                    if (scratch.m_ptpClients.m_count > 0 && !this.reserveQSpace(newM, null, scratch.m_ptpClients)) {
                        useLocalDMQ = true;
                    }
                    if (this.m_agentReg.getMsgProc().checkTopicFlowControlForUndelivered(newM, scratch.m_guarClients) || this.m_agentReg.getMsgProc().checkTopicFlowControlForUndelivered(newM, scratch.m_relClients)) {
                        useLocalDMQ = true;
                        if (scratch.m_ptpClients.m_count > 0) {
                            this.m_routingQ.unreserve(scratch.m_ptpClients.m_count * newM.getEnqueuedSize());
                        }
                    }
                    if (useLocalDMQ) {
                        reasonAddedToDMQ = 24;
                        scratch.undoPubDispatch();
                    }
                }
            } else {
                newM = origNewM;
            }
        }
        if (undelDestInfo == null || useLocalDMQ) {
            undelDestIsQueue = true;
            undelDestIsRemoteTopic = false;
            undelQueue = this.m_dmq;
        }
        ISidebandData newSd = newM.getSidebandData();
        Hashtable newProps = newSd.getProperties();
        boolean setProperties = false;
        if (undelDest != null && useLocalDMQ) {
            setProperties = true;
            newProps.put("JMS_SonicMQ_undeliveredReasonAddedToDMQ", new Integer(reasonAddedToDMQ));
        }
        if (!previouslyUndelivered) {
            String routingNode;
            setProperties = true;
            newProps.put("JMS_SonicMQ_undeliveredBrokerName", Config.BROKER_NAME);
            newProps.put("JMS_SonicMQ_undeliveredNodeName", Config.ROUTING_NODE_NAME);
            if (origNewM.isTTE()) {
                newProps.put("JMS_SonicMQ_undeliveredOriginalJMSExpiration", new Long(origNewM.getTTE()));
            } else {
                newProps.put("JMS_SonicMQ_undeliveredOriginalJMSExpiration", new Long(0L));
            }
            newProps.put("JMS_SonicMQ_undeliveredOriginalJMSTimestamp", new Long(sd.getTimestamp()));
            String origDest = origNewM.getSubject().getJMSName();
            if (origDest == null) {
                origDest = "";
            }
            if ((routingNode = origNewM.getRouting()) != null) {
                origDest = routingNode + "::" + origDest;
            }
            if (origNewM.isPTP()) {
                origDest = "$Q." + origDest;
            }
            newProps.put("JMS_SonicMQ_undeliveredOriginalJMSDestination", origDest);
        }
        if (setProperties) {
            newSd.setProperties(newProps);
        }
        newM.getBrokerHandle().setFromDB(false);
        if (newM.getRoutingHandle().isGSAPublication()) {
            newM.getRoutingHandle().setGSAPublication(false);
        }
        if (undelDestIsQueue || undelDestIsRemoteTopic) {
            if (undelQueue == this.m_dmq && this.m_dmq == null) {
                BrokerComponent.getComponentContext().logMessage("Warning: Could not preserve message " + this.getMessageID(mgram) + ". Dead message queue does not exist.", 2);
            } else {
                if (this.checkDebugFlags(64) && origType == 2) {
                    this.debug("*** origType = NORMAL_TYPE; calling moveMsg");
                }
                this.m_qMsgStateMgr.moveMsg(newM, true, undelQueue.getQueueName(), delete, undelQueue.getQueueType() == 1);
                if (undelQueue == this.m_dmq) {
                    this.m_dmq.reserve(newM);
                }
                this.handlePutMgramInternal(newM, null, null, undelQueue, false, undelQueue == this.m_routingQ, true);
            }
        } else {
            if (this.checkDebugFlags(64) && origType == 2) {
                this.debug("*** origType = NORMAL_TYPE; calling deliverNonBatchedMgram ");
            }
            this.m_agentReg.getMsgProc().deliverNonBatchedMgram(newM, scratch, null);
        }
        return useLocalDMQ ? null : undelDestInfo;
    }

    private boolean checkPreviouslyUndelivered(DestinationInfo undelDestInfo, IMgram mgram, Hashtable props, ISidebandData sd) {
        String routing = mgram.getRoutingHandle().getRouting();
        String undelRouting = undelDestInfo.getRouting();
        if (mgram.isPubSub() && routing != null && mgram.getRoutingHandle().isGSAPublication()) {
            routing = null;
        }
        if (routing == null || routing.length() == 0) {
            routing = Config.ROUTING_NODE_NAME;
        }
        if (undelRouting == null || undelRouting.length() == 0) {
            undelRouting = Config.ROUTING_NODE_NAME;
        }
        if (routing.equals(undelRouting) && mgram.getSubject().getSubjectString().equals(undelDestInfo.getFullSubject())) {
            long origExpiration = 0L;
            long origTimestamp = 0L;
            String origDest = null;
            boolean origValuesFound = true;
            try {
                origExpiration = (Long)props.get("JMS_SonicMQ_undeliveredOriginalJMSExpiration");
                origTimestamp = (Long)props.get("JMS_SonicMQ_undeliveredOriginalJMSTimestamp");
                try {
                    origDest = (String)props.get("JMS_SonicMQ_undeliveredOriginalJMSDestination");
                }
                catch (ClassCastException e) {}
            }
            catch (NullPointerException e) {
                origValuesFound = false;
            }
            if (origValuesFound) {
                mgram.setTTE(origExpiration);
                sd.setTimestamp(origTimestamp);
                DestinationInfo origDestInfo = new DestinationInfo(origDest, Config.ROUTING_NODE_NAME);
                mgram.getRoutingHandle().setRouting(origDestInfo.getRouting());
                mgram.setSubject(new Subject(origDestInfo.getFullSubject()), 5);
                if (origDestInfo.isQueue()) {
                    mgram.setType((byte)12);
                } else {
                    mgram.setType((byte)2);
                }
                mgram.getBrokerHandle().setLocalQueueName(null);
            }
            return true;
        }
        return false;
    }

    public boolean getBooleanProperty(IMgram m, String p) {
        Hashtable props = m.getSidebandData().getProperties();
        if (props.containsKey(p)) {
            Object value = props.get(p);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            return false;
        }
        return false;
    }

    String getMessageID(IMgram m) {
        String sep = ":";
        ISidebandData sd = m.getSidebandData();
        StringBuffer id = new StringBuffer();
        id.append("ID:");
        id.append(Long.toHexString(sd.getBrokerID()));
        id.append(":");
        id.append(Long.toHexString(sd.getConnectionAndLocalID()));
        id.append(":");
        id.append(Long.toHexString(sd.getTimestamp()).toUpperCase());
        return id.toString();
    }

    String formatReason(int reason) {
        return "Reason = " + reason;
    }

    void writeExceptionDetails(Envelope envelope, Message reply, Exception e, int errcode) throws IOException {
        int clientSessionVer = 32;
        try {
            long clientID = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
            clientSessionVer = this.m_agentReg.getClient(clientID).getClientSessionVer();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String classname = e.getClass().getName();
        String errmsg = e.getMessage();
        if (errcode != -42) {
            errmsg = classname + (errmsg == null ? "" : ": " + errmsg);
        }
        if (clientSessionVer == 22) {
            reply.writeObject(new Exception(errmsg));
        } else {
            reply.writeUTF(errmsg);
            reply.writeInt(errcode);
        }
    }

    public ITempQueueDeleteListener getTempQueueDeleteListener() {
        return this.m_tempQDeleteListener;
    }

    public void setTempQueueDeleteListener(ITempQueueDeleteListener listener) {
        this.m_tempQDeleteListener = listener;
    }

    private final void sendSuccessReply(Envelope env, Session session) {
        block6: {
            if (null == env) {
                return;
            }
            try {
                Message reply = new Message();
                reply.writeBoolean(true);
                if (null != session) {
                    session.reply(reply, env);
                } else {
                    AgentAdminSession adminSession = AgentRegistrar.getAgentRegistrar().getAdminSession();
                    if (null != adminSession) {
                        adminSession.reply(reply, env, false);
                    }
                }
            }
            catch (IOException ioe) {
                if (!this.DEBUG) break block6;
                this.logException(ERROR_MESSAGES[2], new Object[]{"success"}, ioe);
            }
        }
    }

    private final void sendErrorReply(Session session, Envelope env, Exception e, int errorCode) {
        block2: {
            try {
                Message reply = new Message();
                reply.writeBoolean(false);
                this.writeExceptionDetails(env, reply, e, errorCode);
                session.reply(reply, env);
            }
            catch (IOException ioe) {
                if (!this.DEBUG) break block2;
                this.logException(ERROR_MESSAGES[2], new Object[]{ERROR}, ioe);
            }
        }
    }

    public void writeSyncQueueMessageGroups() throws ECannotFlushEvents {
        if (BrokerStateManager.getBrokerStateManager().getState() != 3) {
            return;
        }
        Map<String, IAgentQueue> queues = this.getQueues();
        for (IAgentQueue queue : queues.values()) {
            if (queue.getMessageGroupHandle() == null) continue;
            queue.getMessageGroupHandle().writeSyncGroupAssignments();
        }
    }

    private class AdminDelTempQueueHandler
    extends DebugObject
    implements IMessageHandler {
        AdminDelTempQueueHandler() {
            super("AgentQueueProcessor.AdminDelTempQueueHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            if (this.DEBUG) {
                this.debug("AgentQueueProcessor.AdminDelTempQueueHandler starting");
            }
            if (!env.isRequest()) {
                return;
            }
            String errmsg = null;
            long clientID = 0L;
            try {
                clientID = AddrUtil.getIdFromAdmin(env.getSubject());
                if (this.DEBUG) {
                    this.debug("ClientID: " + clientID);
                }
            }
            catch (EInvalidAdminAddress e) {
                errmsg = "Invalid admin address format: " + env.getSubject();
                if (this.DEBUG) {
                    AgentQueueProcessor.this.logException(errmsg, null, e);
                }
                return;
            }
            Message msg = env.getMessage();
            try {
                AgentTemporaryQueue atq = null;
                String queueName = msg.readUTF();
                if (this.DEBUG) {
                    this.debug("AQP.AdminDelTempQueueHandler: queueName = " + queueName);
                }
                Object object = AgentQueueProcessor.this.m_queues_lock;
                synchronized (object) {
                    atq = (AgentTemporaryQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                }
                if (this.DEBUG) {
                    this.debug("Delete Queue NAME: " + queueName + ", ADDR:" + "$Q." + queueName);
                }
                if (atq == null) {
                    EGeneralException re = new EGeneralException(0, prAccessor.getString("Q_NOT_FOUND") + queueName);
                    AgentQueueProcessor.this.sendErrorReply(session, env, re, 0);
                    return;
                }
                AgentQueueProcessor.this.removeTemporaryQueue(clientID, atq, env);
            }
            catch (IOException e) {
                AgentQueueProcessor.this.sendErrorReply(session, env, e, 1);
                return;
            }
        }
    }

    private class AdminCreateTempQueueHandler
    extends DebugObject
    implements IMessageHandler {
        AdminCreateTempQueueHandler() {
            super("AgentQueueProcessor.AdminCreateTempQueueHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            if (!env.isRequest()) {
                return;
            }
            String errmsg = null;
            long clientID = 0L;
            try {
                clientID = AddrUtil.getIdFromAdmin(env.getSubject());
                if (this.DEBUG) {
                    this.debug("ClientID: " + clientID);
                }
            }
            catch (EInvalidAdminAddress e) {
                errmsg = "Invalid admin address format: " + env.getSubject();
                if (this.DEBUG) {
                    AgentQueueProcessor.this.logException(errmsg, null, e);
                }
                return;
            }
            if (Config.MAX_TEMPORARY_QUEUES_PER_SESSION > 0) {
                int count = 0;
                LongHashTable longHashTable = AgentQueueProcessor.this.m_tempQueues;
                synchronized (longHashTable) {
                    Vector vec;
                    if (!AgentQueueProcessor.this.m_tempQueues.isEmpty() && (vec = (Vector)AgentQueueProcessor.this.m_tempQueues.get(clientID)) != null) {
                        count = vec.size();
                    }
                }
                if (count >= Config.MAX_TEMPORARY_QUEUES_PER_SESSION) {
                    EGeneralException re = new EGeneralException(0, prAccessor.getString("MAX_TEMP_QUEUES_ERR") + Config.MAX_TEMPORARY_QUEUES_PER_SESSION);
                    AgentQueueProcessor.this.sendErrorReply(session, env, re, -42);
                    return;
                }
            }
            Message msg = env.getMessage();
            try {
                boolean ret = true;
                try {
                    String queueName = msg.readUTF();
                    int numAttrs = msg.readInt();
                    if (this.DEBUG) {
                        this.debug("AQP.AdminCreateTempQueueHandler: queueName = " + queueName);
                    }
                    QueueAttributes attributes = new QueueAttributes(queueName);
                    String nm = null;
                    for (int i = 0; i < numAttrs; ++i) {
                        nm = msg.readUTF();
                        if (nm.equals("global")) {
                            attributes.setGlobal(msg.readBoolean());
                            continue;
                        }
                        if (nm.equals("readExclusive")) {
                            attributes.setReadExclusive(msg.readBoolean());
                            continue;
                        }
                        if (nm.equals("readOnly")) {
                            attributes.setReadOnly(msg.readBoolean());
                            continue;
                        }
                        if (nm.equals("writeExclusive")) {
                            attributes.setWriteExclusive(msg.readBoolean());
                            continue;
                        }
                        if (nm.equals("writeOnly")) {
                            attributes.setWriteOnly(msg.readBoolean());
                            continue;
                        }
                        if (nm.equals("retrieveThreshold")) {
                            msg.readInt();
                            continue;
                        }
                        if (nm.equals("saveThreshold")) {
                            msg.readInt();
                            continue;
                        }
                        if (!nm.equals("maxQueueSize")) continue;
                        attributes.setMaxQSize(msg.readInt());
                    }
                    AgentQueueProcessor.this.createTempQueue(clientID, attributes, env, session);
                }
                catch (IOException e) {
                    AgentQueueProcessor.this.sendErrorReply(session, env, e, 1);
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private class CloseBrowserHandler
    extends DebugObject
    implements IMessageHandler {
        CloseBrowserHandler() {
            super("AgentQueueProcessor.CloseBrowserHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block22: {
                Message reply;
                String errmsg;
                boolean success;
                block21: {
                    if (this.DEBUG) {
                        this.debug("received closeBrowser message");
                    }
                    success = false;
                    errmsg = null;
                    long clientId = 0L;
                    try {
                        clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                        if (this.DEBUG) {
                            this.debug("CID: " + clientId);
                        }
                    }
                    catch (EInvalidAdminAddress e) {
                        errmsg = "Invalid admin subject: " + env.getSubject();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                        return;
                    }
                    reply = new Message();
                    Message msg = env.getMessage();
                    try {
                        String queueName = msg.readUTF();
                        if (this.DEBUG) {
                            this.debug("Name: " + queueName);
                        }
                        if (queueName != null && !"".equals(queueName)) {
                            IAgentQueue iaq = null;
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                            }
                            if (iaq != null) {
                                iaq.closeBrowser(clientId);
                                AgentQueueProcessor.this.unregisterQueueBrowser(clientId);
                                success = true;
                                if (this.DEBUG) {
                                    this.debug("closed browser");
                                }
                            } else {
                                errmsg = "Queue not found" + queueName;
                            }
                            break block21;
                        }
                        errmsg = "Null or empty queue name";
                    }
                    catch (IOException e) {
                        errmsg = "Exception while reading request:" + e.getMessage();
                        if (!this.DEBUG) break block21;
                        AgentQueueProcessor.this.logException(errmsg, null, e);
                    }
                }
                try {
                    if (success) {
                        reply.writeBoolean(true);
                    } else {
                        reply.writeBoolean(false);
                        reply.writeUTF(errmsg);
                        if (this.DEBUG) {
                            this.debug("request failed: " + errmsg);
                        }
                    }
                    session.reply(reply, env);
                    if (this.DEBUG) {
                        this.debug("reply sent");
                    }
                }
                catch (IOException e) {
                    if (!this.DEBUG) break block22;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                }
            }
        }
    }

    private class CloseReceiverHandler
    extends DebugObject
    implements IMessageHandler {
        CloseReceiverHandler() {
            super("AgentQueueProcessor.CloseReceiverHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block22: {
                Message reply;
                String errmsg;
                boolean success;
                block21: {
                    if (this.DEBUG) {
                        this.debug("received CloseReceiver message");
                    }
                    success = false;
                    errmsg = null;
                    long clientId = 0L;
                    try {
                        clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                        if (this.DEBUG) {
                            this.debug("CID: " + clientId);
                        }
                    }
                    catch (EInvalidAdminAddress e) {
                        errmsg = "Invalid admin subject for closeReceiver request: " + env.getSubject();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                        BrokerComponent.getComponentContext().logMessage(errmsg, 2);
                    }
                    reply = new Message();
                    Message msg = env.getMessage();
                    try {
                        String queueName = msg.readUTF();
                        if (this.DEBUG) {
                            this.debug("Name: " + queueName);
                        }
                        if (queueName != null && !"".equals(queueName)) {
                            IAgentQueue iaq = null;
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                            }
                            if (iaq != null) {
                                AgentQueueProcessor.this.closeReceiver(clientId);
                                success = true;
                                if (this.DEBUG) {
                                    this.debug("Closed Receiver");
                                }
                            } else {
                                errmsg = "Queue not found" + queueName;
                            }
                            break block21;
                        }
                        errmsg = "Null or empty queue name";
                    }
                    catch (IOException e) {
                        errmsg = "Exception while reading request:" + e.getMessage();
                        if (!this.DEBUG) break block21;
                        AgentQueueProcessor.this.logException(errmsg, null, e);
                    }
                }
                try {
                    if (success) {
                        reply.writeBoolean(true);
                    } else {
                        reply.writeBoolean(false);
                        reply.writeUTF(errmsg);
                        if (this.DEBUG) {
                            this.debug("request failed: " + errmsg);
                        }
                    }
                    session.reply(reply, env);
                    if (this.DEBUG) {
                        this.debug("reply sent");
                    }
                }
                catch (IOException e) {
                    if (!this.DEBUG) break block22;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[4], null, e);
                }
            }
        }
    }

    private class OpenBrowserHandler
    extends DebugObject
    implements IMessageHandler {
        OpenBrowserHandler() {
            super("AgentQueueProcessor.OpenBrowserHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block33: {
                Message reply;
                int errcode;
                String errmsg;
                boolean success;
                block32: {
                    if (this.DEBUG) {
                        this.debug("processing an open browser request...");
                    }
                    success = false;
                    errmsg = null;
                    errcode = 0;
                    long clientId = 0L;
                    try {
                        clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                        if (this.DEBUG) {
                            this.debug("CID: " + clientId);
                        }
                    }
                    catch (EInvalidAdminAddress e) {
                        errmsg = "Invalid admin subject: " + env.getSubject();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                        return;
                    }
                    reply = new Message();
                    Message msg = env.getMessage();
                    try {
                        String queueName = msg.readUTF();
                        String selector = msg.readUTF();
                        if (this.DEBUG) {
                            this.debug("Queue Name: " + queueName + ", Selector: " + selector);
                        }
                        if (queueName != null && !"".equals(queueName)) {
                            IAgentQueue iaq = null;
                            String pendingQueueName = null;
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                if (queueName.startsWith("SonicMQ.routingQueue")) {
                                    int index = queueName.indexOf("$");
                                    if (index != -1) {
                                        iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get("SonicMQ.routingQueue");
                                        pendingQueueName = queueName.substring(++index);
                                    }
                                } else {
                                    iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                                }
                            }
                            if (iaq != null) {
                                if ("".equals(selector)) {
                                    selector = null;
                                }
                                if (pendingQueueName != null) {
                                    selector = QueueUtil.createRoutingQueueBrowserSelector(selector, pendingQueueName);
                                }
                                if (iaq.openBrowser(clientId, selector)) {
                                    AgentQueueProcessor.this.registerQueueBrowser(clientId, iaq);
                                    success = true;
                                } else {
                                    errmsg = "Unable to create queue browser for " + queueName;
                                }
                            } else {
                                errmsg = prAccessor.getString("Q_NOT_FOUND") + queueName;
                                errcode = 3005;
                            }
                            break block32;
                        }
                        errmsg = "Null or empty queue name";
                    }
                    catch (IOException e) {
                        errmsg = "Exception while reading request:" + e.getMessage();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                    }
                    catch (ParseException pe) {
                        errmsg = pe.getMessage();
                        errcode = 1;
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, pe);
                        }
                    }
                    catch (TokenMgrError tme) {
                        errmsg = tme.getMessage();
                        errcode = 1;
                        if (!this.DEBUG) break block32;
                        AgentQueueProcessor.this.logException(errmsg, null, tme);
                    }
                }
                try {
                    if (success) {
                        if (this.DEBUG) {
                            this.debug("request succeeded.");
                        }
                        reply.writeBoolean(true);
                    } else {
                        if (this.DEBUG) {
                            this.debug("request failed: " + errmsg);
                        }
                        reply.writeBoolean(false);
                        reply.writeUTF(errmsg);
                        reply.writeInt(errcode);
                    }
                    session.reply(reply, env);
                    if (this.DEBUG) {
                        this.debug("reply sent");
                    }
                }
                catch (IOException e) {
                    if (!this.DEBUG) break block33;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[4], null, e);
                }
            }
        }
    }

    private class OpenSenderHandler
    extends DebugObject
    implements IMessageHandler {
        OpenSenderHandler() {
            super("AgentQueueProcessor.OpenSenderHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block20: {
                Message reply;
                int errcode;
                String errmsg;
                boolean success;
                block19: {
                    if (this.DEBUG) {
                        this.debug("received message");
                    }
                    success = false;
                    errmsg = null;
                    errcode = 0;
                    reply = new Message();
                    Message msg = env.getMessage();
                    try {
                        String node;
                        String queueName = msg.readUTF();
                        String string = node = msg.readBoolean() ? msg.readUTF() : null;
                        if (this.DEBUG) {
                            this.debug("Name: " + queueName + " Routing Node: " + node);
                        }
                        if (queueName != null && !"".equals(queueName) && !queueName.startsWith("SonicMQ.routingQueue")) {
                            if (node == null) {
                                IAgentQueue iaq = null;
                                Object object = AgentQueueProcessor.this.m_queues_lock;
                                synchronized (object) {
                                    iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                                }
                                if (iaq != null) {
                                    success = true;
                                    if (this.DEBUG) {
                                        this.debug("Opened sender");
                                    }
                                } else {
                                    errmsg = prAccessor.getString("Q_NOT_FOUND") + queueName;
                                    errcode = 3005;
                                }
                                break block19;
                            }
                            success = true;
                            if (this.DEBUG) {
                                this.debug("Opened remote sender");
                            }
                            break block19;
                        }
                        errmsg = prAccessor.getString("NULL_Q_NAME");
                    }
                    catch (IOException e) {
                        errmsg = prAccessor.getString("EXCEPTION_READING_REQUEST") + e.getMessage();
                        if (!this.DEBUG) break block19;
                        AgentQueueProcessor.this.logException(errmsg, null, e);
                    }
                }
                try {
                    if (success) {
                        reply.writeBoolean(true);
                    } else {
                        reply.writeBoolean(false);
                        reply.writeUTF(errmsg);
                        reply.writeInt(errcode);
                        if (this.DEBUG) {
                            this.debug("request failed: " + errmsg);
                        }
                    }
                    session.reply(reply, env);
                    if (this.DEBUG) {
                        this.debug("reply sent");
                    }
                }
                catch (IOException e) {
                    if (!this.DEBUG) break block20;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[4], null, e);
                }
            }
        }
    }

    private class OpenReceiverHandler
    extends DebugObject
    implements IMessageHandler {
        OpenReceiverHandler() {
            super("AgentQueueProcessor.OpenReceiverHandler");
        }

        @Override
        public void handleMessage(Session session, Envelope env) {
            block25: {
                Message reply;
                int errcode;
                String errmsg;
                boolean success;
                block24: {
                    if (this.DEBUG) {
                        this.debug("received message");
                    }
                    success = false;
                    errmsg = null;
                    String queueName = null;
                    errcode = 0;
                    long clientId = 0L;
                    try {
                        clientId = AddrUtil.getIdFromAdmin(env.getSubject());
                        if (this.DEBUG) {
                            this.debug("CID: " + clientId);
                        }
                    }
                    catch (EInvalidAdminAddress e) {
                        errmsg = "Invalid admin subject: " + env.getSubject();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                        return;
                    }
                    reply = new Message();
                    Message msg = env.getMessage();
                    try {
                        queueName = msg.readUTF();
                        String selector = msg.readUTF();
                        if (this.DEBUG) {
                            this.debug("Name: " + queueName + ", Selector: " + selector);
                        }
                        if ((errmsg = AgentQueueProcessor.this.createQueueReceiver(clientId, queueName, selector)) == null) {
                            success = true;
                        }
                    }
                    catch (EExclusiveQueueOpen eqo) {
                        errmsg = eqo.getMessage();
                        errcode = 3;
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, eqo);
                        }
                    }
                    catch (EUnauthorizedClient ucex) {
                        errmsg = progress.message.client.prAccessor.getString("NOT_AUTH_RECV") + queueName;
                        errcode = 2;
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, ucex);
                        }
                    }
                    catch (IOException e) {
                        errmsg = "Exception while reading request:" + e.getMessage();
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, e);
                        }
                    }
                    catch (ParseException pe) {
                        errmsg = pe.getMessage();
                        errcode = 1;
                        if (this.DEBUG) {
                            AgentQueueProcessor.this.logException(errmsg, null, pe);
                        }
                    }
                    catch (TokenMgrError tme) {
                        errmsg = tme.getMessage();
                        errcode = 1;
                        if (!this.DEBUG) break block24;
                        AgentQueueProcessor.this.logException(errmsg, null, tme);
                    }
                }
                try {
                    if (success) {
                        reply.writeBoolean(true);
                    } else {
                        if (errmsg.indexOf(prAccessor.getString("Q_NOT_FOUND")) >= 0) {
                            errcode = 3005;
                        }
                        reply.writeBoolean(false);
                        reply.writeUTF(errmsg);
                        reply.writeInt(errcode);
                        if (this.DEBUG) {
                            this.debug("request failed: " + errmsg);
                        }
                    }
                    session.reply(reply, env);
                    if (this.DEBUG) {
                        this.debug("reply sent");
                    }
                }
                catch (IOException e) {
                    if (!this.DEBUG) break block25;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[4], null, e);
                }
            }
        }
    }

    private class AdminDefaultHandler
    extends DebugObject
    implements IMessageHandler {
        AdminDefaultHandler() {
            super("AgentQueueProcessor.AdminDefaultHandler");
        }

        @Override
        public void handleMessage(Session session, Envelope env) {
            if (this.DEBUG) {
                this.debug("Default handler received message: " + env.getMessage().getSubject());
            }
        }
    }

    private class AdminGetQueuesHandler
    extends DebugObject
    implements IMessageHandler {
        AdminGetQueuesHandler() {
            super("AgentQueueProcessor.AdminGetQueuesHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block17: {
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message reply = new Message();
                try {
                    String prefix = msg.readUTF();
                    reply.writeBoolean(true);
                    boolean useFilter = prefix.length() > 0;
                    Vector<IAgentQueue> matches = new Vector<IAgentQueue>();
                    IAgentQueue iaq = null;
                    Object object = AgentQueueProcessor.this.m_queues_lock;
                    synchronized (object) {
                        Enumeration test = AgentQueueProcessor.this.m_queues.elements();
                        while (test.hasMoreElements()) {
                            iaq = (IAgentQueue)test.nextElement();
                            if (!useFilter) continue;
                            if (iaq.getQueueName().startsWith(prefix)) {
                                matches.addElement(iaq);
                                continue;
                            }
                            matches.addElement(iaq);
                        }
                    }
                    int numQueues = matches.size();
                    Enumeration enu = matches.elements();
                    reply.writeInt(numQueues);
                    iaq = null;
                    while (enu.hasMoreElements()) {
                        iaq = (IAgentQueue)enu.nextElement();
                        try {
                            reply.writeUTF(iaq.getQueueName());
                            reply.writeBoolean(iaq.isGlobal());
                            reply.writeBoolean(iaq.isClustered());
                            reply.writeBoolean(iaq.isReadExclusive());
                            reply.writeBoolean(iaq.isReadOnly());
                            reply.writeBoolean(iaq.isWriteExclusive());
                            reply.writeBoolean(iaq.isWriteOnly());
                            reply.writeInt(0);
                            if (iaq instanceof ISavableAgentQueue) {
                                reply.writeInt(((ISavableAgentQueue)((Object)iaq)).getSaveThresholdInKiloBytes());
                            } else {
                                reply.writeInt(0);
                            }
                            reply.writeInt(iaq.getMaxQueueSizeInKiloBytes());
                            reply.writeInt(iaq.getTotalEnqueued());
                        }
                        catch (IOException ioe) {
                            if (!this.DEBUG) continue;
                            AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, ioe);
                        }
                    }
                    session.reply(reply, env);
                }
                catch (ESecurityPolicyViolation e) {
                    if (this.DEBUG) {
                        AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                    }
                }
                catch (EGeneralException e) {
                    if (this.DEBUG) {
                        AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                    }
                }
                catch (IOException ioe) {
                    reply.writeBoolean(false);
                    if (!this.DEBUG) break block17;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, ioe);
                }
            }
        }
    }

    private class AdminClearQueueHandler
    extends DebugObject
    implements IMessageHandler {
        AdminClearQueueHandler() {
            super("AgenQueueProcessor.AdminClearQueueHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block23: {
                if (this.DEBUG) {
                    this.debug("AdminClearQueueHandler received message");
                }
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message reply = new Message();
                try {
                    block22: {
                        IAgentQueue iaq = null;
                        try {
                            String queueName = msg.readUTF();
                            if (this.DEBUG) {
                                this.debug("Clear Queue NAME: " + queueName + ", ADDR:" + "$Q." + queueName);
                            }
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                            }
                            if (iaq == null) {
                                reply.writeBoolean(false);
                                EGeneralException re = new EGeneralException(0, "");
                                reply.writeObject(re);
                                session.reply(reply, env);
                                return;
                            }
                        }
                        catch (IOException e) {
                            if (this.DEBUG) {
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[3], null, e);
                            }
                            try {
                                reply.writeBoolean(false);
                                reply.writeObject(e);
                                session.reply(reply, env);
                                return;
                            }
                            catch (IOException ioe) {
                                if (this.DEBUG) {
                                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[2], new Object[]{AgentQueueProcessor.ERROR}, ioe);
                                }
                                return;
                            }
                        }
                        try {
                            iaq.clear();
                        }
                        catch (InterruptedException ex) {
                            try {
                                reply.writeBoolean(false);
                                reply.writeObject(ex);
                                session.reply(reply, env);
                                return;
                            }
                            catch (IOException ioe) {
                                if (!this.DEBUG) break block22;
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[2], new Object[]{AgentQueueProcessor.ERROR}, ioe);
                            }
                        }
                    }
                    reply.writeBoolean(true);
                    session.reply(reply, env);
                }
                catch (ESecurityPolicyViolation e) {
                    if (this.DEBUG) {
                        AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                    }
                }
                catch (EGeneralException e) {
                    if (!this.DEBUG) break block23;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                }
            }
            if (this.DEBUG) {
                this.debug("AdminClearQueueHandler: processed message");
            }
        }
    }

    private class AdminDeleteHandler
    extends DebugObject
    implements IMessageHandler {
        AdminDeleteHandler() {
            super("AgentQueueProcessor.AdminDeleteHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block25: {
                if (this.DEBUG) {
                    this.debug("AgentQueueProcessor.AdminDeleteHandler starting");
                }
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message reply = new Message();
                try {
                    block24: {
                        IAgentQueue iaq = null;
                        String queueName = null;
                        try {
                            queueName = msg.readUTF();
                            if (queueName.equals("SonicMQ.routingQueue")) {
                                return;
                            }
                            if (queueName.equals("SonicMQ.deadMessage")) {
                                return;
                            }
                            if (this.DEBUG) {
                                this.debug("Delete Queue NAME: " + queueName + ", ADDR:" + "$Q." + queueName);
                            }
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                            }
                            if (iaq == null) {
                                reply.writeBoolean(false);
                                EGeneralException re = new EGeneralException(0, "");
                                reply.writeObject(re);
                                session.reply(reply, env);
                                return;
                            }
                        }
                        catch (IOException e) {
                            if (this.DEBUG) {
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[3], null, e);
                            }
                            try {
                                reply.writeBoolean(false);
                                reply.writeObject(e);
                                session.reply(reply, env);
                                return;
                            }
                            catch (IOException ioe) {
                                if (this.DEBUG) {
                                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[2], new Object[]{AgentQueueProcessor.ERROR}, ioe);
                                }
                                return;
                            }
                        }
                        try {
                            RouterManager rm;
                            AgentQueueProcessor.this.disconnectQueue(queueName);
                            iaq.close();
                            iaq.clear();
                            AgentQueueProcessor.this.m_agentReg.getFlowControlManager().onQueueDelete(iaq.getQueueAddress());
                            if (iaq.isGlobal() && (rm = AgentQueueProcessor.this.m_agentReg.getRouterManager()) != null) {
                                RouteForwarder rf = rm.getRouteForwarder();
                                rf.onRemoveGlobal(Config.ROUTING_NODE_NAME, queueName);
                            }
                        }
                        catch (InterruptedException ex) {
                            try {
                                reply.writeBoolean(false);
                                reply.writeObject(ex);
                                session.reply(reply, env);
                                return;
                            }
                            catch (IOException ioe) {
                                if (!this.DEBUG) break block24;
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[2], new Object[]{AgentQueueProcessor.ERROR}, ioe);
                            }
                        }
                    }
                    reply.writeBoolean(true);
                    session.reply(reply, env);
                }
                catch (ESecurityPolicyViolation e) {
                    if (this.DEBUG) {
                        AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                    }
                }
                catch (EGeneralException e) {
                    if (!this.DEBUG) break block25;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                }
            }
        }
    }

    private class AdminCreateQueueHandler
    extends DebugObject
    implements IMessageHandler {
        AdminCreateQueueHandler() {
            super("AgentQueueProcessor.AdminCreateQueueHandler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Session session, Envelope env) {
            block53: {
                if (!env.isRequest()) {
                    return;
                }
                Message msg = env.getMessage();
                Message reply = new Message();
                try {
                    block52: {
                        IAgentQueue iaq = null;
                        try {
                            String queueName = msg.readUTF();
                            int numAttrs = msg.readInt();
                            if (this.DEBUG) {
                                this.debug("Set Queue NAME: " + queueName + ", ADDR:" + "$Q." + queueName);
                            }
                            Object object = AgentQueueProcessor.this.m_queues_lock;
                            synchronized (object) {
                                iaq = (IAgentQueue)AgentQueueProcessor.this.m_queues.get(queueName);
                            }
                            if (iaq == null) {
                                if (this.DEBUG) {
                                    this.debug("Queue does not exist, creating...");
                                }
                                boolean readOnly = false;
                                boolean readExclusive = false;
                                boolean writeOnly = false;
                                boolean writeExclusive = false;
                                int saveThreshold = 1536;
                                int maxQSize = Config.MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE;
                                boolean global = false;
                                boolean clustered = false;
                                String nm = null;
                                for (int i = 0; i < numAttrs; ++i) {
                                    nm = msg.readUTF();
                                    if (nm.equals("global")) {
                                        global = msg.readBoolean();
                                        continue;
                                    }
                                    if (nm.equals("readExclusive")) {
                                        readExclusive = msg.readBoolean();
                                        continue;
                                    }
                                    if (nm.equals("readOnly")) {
                                        readOnly = msg.readBoolean();
                                        continue;
                                    }
                                    if (nm.equals("writeExclusive")) {
                                        writeExclusive = msg.readBoolean();
                                        continue;
                                    }
                                    if (nm.equals("writeOnly")) {
                                        writeOnly = msg.readBoolean();
                                        continue;
                                    }
                                    if (nm.equals("retrieveThreshold")) {
                                        msg.readInt();
                                        continue;
                                    }
                                    if (nm.equals("saveThreshold")) {
                                        saveThreshold = msg.readInt();
                                        continue;
                                    }
                                    if (nm.equals("maxQueueSize")) {
                                        maxQSize = msg.readInt();
                                        continue;
                                    }
                                    if (!nm.equals("clustered")) continue;
                                    clustered = msg.readBoolean();
                                }
                                if (queueName.equals("SonicMQ.routingQueue")) {
                                    iaq = AgentQueueProcessor.this.m_qfactory.createAgentQueue(4, "SonicMQ.routingQueue", maxQSize);
                                    ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(saveThreshold);
                                    iaq.setGlobal(false);
                                } else if (queueName.equals("SonicMQ.deadMessage")) {
                                    iaq = AgentQueueProcessor.this.m_qfactory.createAgentQueue(3, "SonicMQ.deadMessage", maxQSize);
                                    ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(saveThreshold);
                                    iaq.setGlobal(global);
                                    iaq.setFlowControl(false);
                                } else {
                                    iaq = AgentQueueProcessor.this.m_qfactory.createAgentQueue(0, queueName, maxQSize);
                                    ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(saveThreshold);
                                    iaq.setGlobal(global);
                                    iaq.setClustered(clustered);
                                }
                                iaq.setReadExclusiveMode(readExclusive);
                                iaq.setReadOnlyMode(readOnly);
                                iaq.setWriteExclusiveMode(writeExclusive);
                                iaq.setWriteOnlyMode(writeOnly);
                                AgentQueueProcessor.this.connectQueue(iaq);
                                iaq.start();
                                if (global) {
                                    AgentQueueProcessor.this.advertiseGlobal(queueName);
                                }
                                if (this.DEBUG) {
                                    this.debug("Queue started.");
                                }
                            } else {
                                String nm = null;
                                boolean gval = false;
                                boolean clusteredval = false;
                                boolean bval = false;
                                int ival = 0;
                                boolean saveSet = false;
                                int saveValue = 0;
                                for (int i = 0; i < numAttrs; ++i) {
                                    nm = msg.readUTF();
                                    if (nm.equals("global")) {
                                        boolean wasGlobal;
                                        gval = msg.readBoolean();
                                        if (this.DEBUG) {
                                            this.debug("Setting GLOBAL_QUEUE = " + gval);
                                        }
                                        if (queueName.equals("SonicMQ.deadMessage") || queueName.equals("SonicMQ.routingQueue") || (wasGlobal = iaq.isGlobal()) == gval) continue;
                                        iaq.setGlobal(gval);
                                        if (gval) {
                                            AgentQueueProcessor.this.advertiseGlobal(queueName);
                                            continue;
                                        }
                                        AgentQueueProcessor.this.unadvertiseGlobal(queueName);
                                        continue;
                                    }
                                    if (nm.equals("clustered")) {
                                        boolean wasClustered;
                                        clusteredval = msg.readBoolean();
                                        this.debug("Setting CLUSTERED_QUEUE = " + clusteredval);
                                        if (queueName.equals("SonicMQ.deadMessage") || queueName.equals("SonicMQ.routingQueue") || (wasClustered = iaq.isClustered()) == clusteredval) continue;
                                        iaq.setClustered(clusteredval);
                                        continue;
                                    }
                                    if (nm.equals("readExclusive")) {
                                        bval = msg.readBoolean();
                                        if (this.DEBUG) {
                                            this.debug("Setting READ_EXCLUSIVE = " + bval);
                                        }
                                        iaq.setReadExclusiveMode(bval);
                                        continue;
                                    }
                                    if (nm.equals("readOnly")) {
                                        bval = msg.readBoolean();
                                        if (this.DEBUG) {
                                            this.debug("Setting READ_ONLY = " + bval);
                                        }
                                        iaq.setReadOnlyMode(bval);
                                        continue;
                                    }
                                    if (nm.equals("writeExclusive")) {
                                        bval = msg.readBoolean();
                                        if (this.DEBUG) {
                                            this.debug("Setting WRITE_EXCLUSIVE = " + bval);
                                        }
                                        iaq.setWriteExclusiveMode(bval);
                                        continue;
                                    }
                                    if (nm.equals("writeOnly")) {
                                        bval = msg.readBoolean();
                                        if (this.DEBUG) {
                                            this.debug("Setting WRITE_ONLY = " + bval);
                                        }
                                        iaq.setWriteOnlyMode(bval);
                                        continue;
                                    }
                                    if (nm.equals("retrieveThreshold")) {
                                        ival = msg.readInt();
                                        if (!this.DEBUG) continue;
                                        this.debug("Setting retrieve threshold = " + ival);
                                        continue;
                                    }
                                    if (nm.equals("saveThreshold")) {
                                        ival = msg.readInt();
                                        if (this.DEBUG) {
                                            this.debug("Setting save threshold = " + ival);
                                        }
                                        if (iaq.getQueueType() == 1) continue;
                                        saveSet = true;
                                        saveValue = ival;
                                        continue;
                                    }
                                    if (!nm.equals("maxQueueSize")) continue;
                                    ival = msg.readInt();
                                    if (this.DEBUG) {
                                        this.debug("Setting max queue size = " + ival);
                                    }
                                    iaq.setMaxQueueSizeInKiloBytes(ival);
                                    if (!this.DEBUG) continue;
                                    this.debug("Checking max queue size = " + iaq.getMaxQueueSizeInKiloBytes());
                                }
                                if (saveSet) {
                                    ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(saveValue);
                                    saveSet = false;
                                    if (this.DEBUG) {
                                        this.debug("Checking save threshold = " + ((ISavableAgentQueue)((Object)iaq)).getSaveThresholdInKiloBytes());
                                    }
                                }
                                if (this.DEBUG) {
                                    this.debug("updated attributes in Queue Registry");
                                }
                            }
                        }
                        catch (IOException e) {
                            if (this.DEBUG) {
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[3], null, e);
                            }
                            try {
                                reply.writeBoolean(false);
                                reply.writeObject(e);
                                session.reply(reply, env);
                                return;
                            }
                            catch (IOException ioe) {
                                if (!this.DEBUG) break block52;
                                AgentQueueProcessor.this.logException(ERROR_MESSAGES[2], new Object[]{AgentQueueProcessor.ERROR}, ioe);
                            }
                        }
                    }
                    reply.writeBoolean(true);
                    session.reply(reply, env);
                }
                catch (ESecurityPolicyViolation e) {
                    if (this.DEBUG) {
                        AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                    }
                }
                catch (EGeneralException e) {
                    if (!this.DEBUG) break block53;
                    AgentQueueProcessor.this.logException(ERROR_MESSAGES[5], new Object[]{this.getClass().getName()}, e);
                }
            }
        }
    }
}

