/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.GroupSubscription;
import progress.message.broker.IClientContext;
import progress.message.broker.IRoutingConfigListener;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.SubjectAclEntry;
import progress.message.broker.prAccessor;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.resources.prMessageFormat;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityEvent;
import progress.message.security.SecurityListener;
import progress.message.util.DebugState;
import progress.message.util.DraDestUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.QOP;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectLevel;
import progress.message.zclient.SubjectSpace;

public final class AgentSubjectSpace
extends SubjectSpace
implements SecurityListener,
IRoutingConfigListener {
    private final HashSet m_multiSubjectObjects = new HashSet();

    public AgentSubjectSpace() {
        super(Config.DEFAULT_BROKER_SUBJECT_CACHE, Config.MAX_BROKER_SUBJECT_CACHE);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("AgentSubjectSpace");
        }
    }

    public synchronized ISubjectMatchObject removeSubscription(ISubject subject, IClientContext client) {
        ISubjectMatchObject removed = null;
        if (subject.isMultiSubject()) {
            Iterator<ISubject> i = subject.getMultiSubjects();
            while (i.hasNext()) {
                ISubjectMatchObject result = this.removeSubscription(i.next(), client);
                if (result == null) continue;
                removed = result;
            }
            if (removed != null) {
                this.m_multiSubjectObjects.remove(removed);
            }
            return removed;
        }
        SubjectLevel level = (SubjectLevel)this.m_subjectTable.m_expressions.get(subject.getLookupName());
        if (level == null) {
            return null;
        }
        Vector objects = level.getLocalValues();
        if (objects == null) {
            return null;
        }
        for (int i = objects.size() - 1; i >= 0; --i) {
            Object o = objects.elementAt(i);
            if (!(o instanceof BrokerSubscription) || ((BrokerSubscription)o).getClient() != client) continue;
            removed = (ISubjectMatchObject)o;
            if (this.DEBUG) {
                this.debug("removing object " + objects.elementAt(i) + " from pattern " + subject);
            }
            objects.removeElementAt(i);
            break;
        }
        if (objects.isEmpty() && (level.getGlobalValues() == null || level.getGlobalValues().isEmpty())) {
            this.m_subjectTable.removeSubject(subject);
            this.resetCache();
        } else {
            this.incrementCacheVersion();
        }
        if (this.DEBUG) {
            this.debug("removed: " + removed + " pattern " + subject + " now has " + objects.size() + " matches");
        }
        return removed;
    }

    public void batchFlagsDirty() {
    }

    @Override
    public final void resetCache() {
        super.resetCache();
    }

    Enumeration getAllSubscriptions() {
        Enumeration allSubs = this.m_subjectTable.getLocalObjects();
        Vector<BrokerSubscription> brkrSubs = new Vector<BrokerSubscription>();
        while (allSubs.hasMoreElements()) {
            Object o = allSubs.nextElement();
            if (this.m_multiSubjectObjects.contains(o)) continue;
            if (o instanceof GroupSubscription) {
                GroupSubscription group = (GroupSubscription)o;
                group.appendAllSubscriptions(brkrSubs);
                continue;
            }
            brkrSubs.add((BrokerSubscription)o);
        }
        for (Object o : this.m_multiSubjectObjects) {
            if (o instanceof GroupSubscription) {
                GroupSubscription group = (GroupSubscription)o;
                group.appendAllSubscriptions(brkrSubs);
                continue;
            }
            brkrSubs.add((BrokerSubscription)o);
        }
        return brkrSubs.elements();
    }

    public synchronized void loadPolicies() {
        SecurityBean secbean = AgentRegistrar.getAgentRegistrar().getSecurityBean();
        Vector subjects = secbean.getSecureSubjects();
        int size = subjects.size();
        for (int i = 0; i < size; ++i) {
            String subject = (String)subjects.elementAt(i);
            Subject so = new Subject(subject);
            QOP q = secbean.getQOP(subject);
            if (q != null) {
                try {
                    this.put(so, (ISubjectMatchObject)q);
                }
                catch (EInvalidSubjectSyntax e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR036") + subject, 2);
                }
            }
            Vector acls = secbean.getAclEntries(subject);
            for (int j = 0; j < acls.size(); ++j) {
                SubjectAclEntry sae = (SubjectAclEntry)acls.elementAt(j);
                try {
                    this.put(so, (ISubjectMatchObject)sae);
                    continue;
                }
                catch (EInvalidSubjectSyntax e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR037") + subject, 2);
                }
            }
        }
    }

    @Override
    public synchronized void securityUpdate(SecurityEvent evt) {
        if (this.DEBUG) {
            this.debug("got security event: " + evt);
        }
        evt.updateSubjectSpace(this);
    }

    private synchronized void onNewRoutingNode(ISubject subject, ISubjectMatchObject object) {
        try {
            this.put(subject, object);
            Object[] parameters = new Object[]{((RoutingConnectionInfo)object).getRoutingNodeName(), subject};
            String info = prMessageFormat.format(prAccessor.getString("ADD_REVERSE_LOOKUP_ROUTING_NODE"), parameters);
            BrokerComponent.getComponentContext().logMessage(info, 3);
        }
        catch (EInvalidSubjectSyntax e) {
            RoutingConnectionInfo rn = (RoutingConnectionInfo)object;
            Object[] parameters = new Object[]{rn.getRoutingNodeName(), rn.getConnectionURLs()};
            String info = prMessageFormat.format(prAccessor.getString("INVALID_ROUTING_DESTINATION_FOR_REVERSE_LOOKUP"), parameters);
            BrokerComponent.getComponentContext().logMessage(info, 2);
        }
    }

    private synchronized void onRemoveRoutingNode(ISubject subject, ISubjectMatchObject object) {
        Object[] parameters = new Object[]{((RoutingConnectionInfo)object).getRoutingNodeName()};
        String info = prMessageFormat.format(prAccessor.getString("REMOVE_REVERSE_LOOKUP_ROUTING_NODE"), parameters);
        BrokerComponent.getComponentContext().logMessage(info, 3);
        this.removeSubjectObject(subject, object);
        this.resetCache();
    }

    @Override
    public String toString() {
        return "AgentSubjectSpace";
    }

    @Override
    protected final void onAddMultiSubjectObject(ISubjectMatchObject o) {
        this.m_multiSubjectObjects.add(o);
    }

    @Override
    protected void onRemoveMultiSubjectObject(ISubjectMatchObject o) {
        this.m_multiSubjectObjects.remove(o);
    }

    @Override
    public void IRoutingConfigChanged(RoutingConnectionInfo newRouting, RoutingConnectionInfo oldRouting) {
        String subject = null;
        if (oldRouting != null) {
            if (oldRouting.getRouteType() == RoutingConnectionInfo.ROUTE_TYPE_SONIC) {
                return;
            }
            subject = DraDestUtil.httpUrlToRoutingSubject(oldRouting.getConnectionURLs(), true);
            if (subject != null) {
                this.onRemoveRoutingNode(new Subject(subject), oldRouting);
            }
        }
        if (newRouting == null || newRouting.getRouteType() == RoutingConnectionInfo.ROUTE_TYPE_SONIC) {
            return;
        }
        subject = DraDestUtil.httpUrlToRoutingSubject(newRouting.getConnectionURLs(), true);
        if (subject == null) {
            Object[] parameters = new Object[]{newRouting.getRoutingNodeName(), newRouting.getConnectionURLs()};
            String info = prMessageFormat.format(prAccessor.getString("INVALID_ROUTING_DESTINATION_FOR_REVERSE_LOOKUP"), parameters);
            BrokerComponent.getComponentContext().logMessage(info, 2);
            return;
        }
        this.onNewRoutingNode(new Subject(subject), newRouting);
    }

    @Override
    public void setRoutingConfigIndex(int index) {
    }

    @Override
    public int getRoutingConfigIndex() {
        return -1;
    }
}

