/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.common.runtime.IAcceptorData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.ReplicationConnDef;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.SonicCipherSuite;
import java.io.IOException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EExpiredEvaluationLicenseKey;
import progress.message.broker.ELogFileException;
import progress.message.broker.EStartupFailure;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.HTTPDirectOutboundHolder;
import progress.message.broker.IClientContext;
import progress.message.broker.IStateController;
import progress.message.broker.MsgSaver;
import progress.message.broker.ProvisionMonitor;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.ServiceStartLocal;
import progress.message.broker.prAccessor;
import progress.message.client.ENetworkFailure;
import progress.message.crypto.DESString;
import progress.message.db.Db;
import progress.message.dd.NoDupDetectDb;
import progress.message.ft.ReplicationChannel;
import progress.message.net.ProgressInetAddress;
import progress.message.security.SecurityCache;
import progress.message.util.server.OStream;
import progress.message.zclient.Envelope;
import progress.message.zclient.Message;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;

public final class Broker
implements IStateController {
    private String m_defaultRoutingURL = null;
    private Properties m_dsProps = null;
    private AgentRegistrar reg;
    private BrokerLicenseMgr runtimeLM = null;
    private int m_severity = 0;
    private Set<Acceptor> m_activeAcceptors = Collections.synchronizedSet(new HashSet());
    private startupNotificationObject m_syncObject = new startupNotificationObject();
    private boolean DEBUG = false;
    private boolean m_acceptClients = false;
    public static volatile boolean exiting = false;
    public static volatile boolean s_inShutdown = false;
    public static volatile Broker s_broker;
    public static final String NEWLINE;
    private static boolean m_isMFComponent;
    private BrokerComponent m_component;

    public AcceptorHolder getFTPeerAcceptorHolder() {
        AcceptorHolder ah = (AcceptorHolder)this.m_dsProps.get("FTPEER_ACCEPTOR_HOLDER");
        return ah;
    }

    public Properties getConfigProperties() {
        return this.m_dsProps;
    }

    public void notifyClientsOfAcceptorsChange(String[] changedAcceptorNames) {
        if (changedAcceptorNames != null) {
            for (int i = 0; i < changedAcceptorNames.length; ++i) {
                this.notifyClientsOfAcceptorChange(changedAcceptorNames[i]);
            }
            return;
        }
        Enumeration acceptorNames = AcceptorHolder.getAcceptorHolder().getAcceptorNames();
        while (acceptorNames.hasMoreElements()) {
            String name = (String)acceptorNames.nextElement();
            this.notifyClientsOfAcceptorChange(name);
        }
    }

    private void notifyClientsOfAcceptorChange(String acceptorName) {
        Acceptor acc;
        Enumeration enu;
        if (!BrokerStateManager.getBrokerStateManager().isActive()) {
            return;
        }
        ArrayList<String> localUrlList = new ArrayList<String>();
        ArrayList<String> standbyUrlList = new ArrayList<String>();
        AcceptorHolder ah = AcceptorHolder.getAcceptorHolder();
        String localDefaultRouting = ah.getDefaultRoutingURL();
        if (acceptorName != null && (enu = ah.getAcceptors(acceptorName)) != null) {
            while (enu.hasMoreElements()) {
                acc = (Acceptor)enu.nextElement();
                String externalURL = acc.getExternalURL();
                if (externalURL == null || externalURL.trim().length() == 0) continue;
                localUrlList.add(externalURL);
            }
        }
        if (localUrlList.isEmpty()) {
            if (localDefaultRouting != null) {
                localUrlList.add(localDefaultRouting);
            } else if (acceptorName != null && (enu = ah.getAcceptors(acceptorName)) != null) {
                while (enu.hasMoreElements()) {
                    acc = (Acceptor)enu.nextElement();
                    localUrlList.add(acc.getURL());
                }
            }
        }
        if ((ah = this.getFTPeerAcceptorHolder()) != null) {
            Acceptor acc2;
            Enumeration enu2;
            String standbyDefaultRouting = ah.getDefaultRoutingURL();
            if (acceptorName != null && (enu2 = ah.getAcceptors(acceptorName)) != null) {
                while (enu2.hasMoreElements()) {
                    acc2 = (Acceptor)enu2.nextElement();
                    String externalURL = acc2.getExternalURL();
                    if (externalURL == null || externalURL.trim().length() == 0) continue;
                    standbyUrlList.add(externalURL);
                }
            }
            if (standbyUrlList.isEmpty()) {
                if (standbyDefaultRouting != null) {
                    standbyUrlList.add(standbyDefaultRouting);
                } else if (acceptorName != null && (enu2 = ah.getAcceptors(acceptorName)) != null) {
                    while (enu2.hasMoreElements()) {
                        acc2 = (Acceptor)enu2.nextElement();
                        standbyUrlList.add(acc2.getURL());
                    }
                }
            }
        }
        String[] localurls = new String[localUrlList.size()];
        localUrlList.toArray(localurls);
        String[] standbyurls = new String[standbyUrlList.size()];
        standbyUrlList.toArray(standbyurls);
        try {
            int i;
            Message request = new Message("$ISYS.acceptor." + acceptorName.trim());
            request.writeInt(localurls.length);
            for (i = 0; i < localurls.length; ++i) {
                request.writeUTF(localurls[i]);
            }
            request.writeInt(standbyurls.length);
            for (i = 0; i < standbyurls.length; ++i) {
                request.writeUTF(standbyurls[i]);
            }
            Envelope env = new Envelope(request);
            try {
                AgentRegistrar.getAgentRegistrar().getAdminSession().publishInternal(env, 0, false, true);
            }
            catch (ENetworkFailure enf) {
                if (!Broker.isInShutdown()) {
                    throw enf;
                }
            }
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
    }

    public String getAcceptorURLs(String acceptorName) {
        if (acceptorName == null || acceptorName.equals("")) {
            return null;
        }
        String urls = null;
        HashSet<Acceptor> acceptors = null;
        acceptors = new HashSet<Acceptor>(this.m_activeAcceptors);
        for (Acceptor acceptor : acceptors) {
            if (acceptor == null || !acceptor.getAcceptorName().equals(acceptorName)) continue;
            String url = acceptor.getExternalURL();
            if (url == null) {
                url = acceptor.getURL();
            }
            if (url == null) continue;
            if (urls == null) {
                urls = url;
                continue;
            }
            urls = urls + "," + url;
        }
        return urls;
    }

    public String getDefaultRoutingURL() {
        if (this.m_defaultRoutingURL == null) {
            AcceptorHolder ah = AcceptorHolder.getAcceptorHolder();
            if (ah != null) {
                return ah.getDefaultRoutingURL();
            }
            return null;
        }
        return this.m_defaultRoutingURL;
    }

    public Hashtable getQueuesHashtable() {
        Hashtable queues = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            queues = (Hashtable)this.m_dsProps.get("QUEUES_HASHTABLE");
        }
        return queues;
    }

    public Vector getRoutesVector() {
        Vector routes = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            routes = (Vector)this.m_dsProps.get("ROUTES_VECTOR");
        }
        return routes;
    }

    public Vector getGlobalSubscriptionsVector() {
        Vector subscriptions = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            subscriptions = (Vector)this.m_dsProps.get("GLOBAL_SUBSCRIPTIONS_VECTOR");
        }
        return subscriptions;
    }

    public String getClusterName() {
        if (m_isMFComponent && this.m_dsProps != null) {
            return (String)this.m_dsProps.get("CLUSTER_NAME");
        }
        return null;
    }

    public Hashtable getClusterPeerInfoTable() {
        Hashtable peerInfoTable = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            peerInfoTable = (Hashtable)this.m_dsProps.get("PEER_INFO_HASHTABLE");
        }
        return peerInfoTable;
    }

    public FTPairPeerInfoHolder getPeerInfoHolder(String peerBrokerName) {
        if (peerBrokerName == null) {
            return null;
        }
        Hashtable peerInfoTable = null;
        FTPairPeerInfoHolder holder = null;
        if (m_isMFComponent && this.m_dsProps != null && (peerInfoTable = (Hashtable)this.m_dsProps.get("PEER_INFO_HASHTABLE")) != null) {
            holder = (FTPairPeerInfoHolder)peerInfoTable.get(peerBrokerName);
        }
        return holder;
    }

    public HTTPDirectOutboundHolder getHTTPDirectOutboundHolder() {
        HTTPDirectOutboundHolder oh = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            oh = (HTTPDirectOutboundHolder)this.m_dsProps.get("HTTP_OUTBOUND_HOLDER");
        }
        return oh;
    }

    public SecurityCache getSecurityCache() {
        SecurityCache cache = null;
        if (m_isMFComponent && this.m_dsProps != null) {
            cache = (SecurityCache)this.m_dsProps.get("SECURITY_CACHE");
        }
        return cache;
    }

    public Broker(BrokerComponent component) {
        this.m_component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Properties properties) {
        block11: {
            this.startBroker(properties);
            try {
                while (!this.m_syncObject.isBrokerReady() && !this.m_syncObject.hasStartupFailed()) {
                    startupNotificationObject startupNotificationObject2 = this.m_syncObject;
                    synchronized (startupNotificationObject2) {
                        this.m_syncObject.wait();
                    }
                }
                if (this.m_syncObject.hasStartupFailed()) {
                    Throwable startupThrowable = this.m_syncObject.getStartupThrowable();
                    if (startupThrowable == null) {
                        throw new RuntimeException(prAccessor.getString("brokerStartFailure"));
                    }
                    String message = startupThrowable.getMessage();
                    if (message == null) {
                        message = startupThrowable.toString();
                    }
                    BrokerComponent.getComponentContext().registerErrorCondition(message, 1);
                    if (startupThrowable instanceof RuntimeException) {
                        throw (RuntimeException)startupThrowable;
                    }
                    throw new RuntimeException(startupThrowable.getMessage(), startupThrowable);
                }
            }
            catch (InterruptedException ie) {
                Broker.getBroker();
                if (exiting || Broker.getBroker().getState() == 4 || Broker.getBroker().getState() == 1) {
                    return;
                }
                if (!this.DEBUG) break block11;
                BrokerComponent.getComponentContext().logMessage((Throwable)ie, 7);
            }
        }
    }

    private void startBroker(Properties properties) {
        if (!Config.loadConfig(properties, false)) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR047"), 1);
            return;
        }
        AgentRegistrar.initAgentRegistrar();
        s_broker = this;
        exiting = false;
        s_inShutdown = false;
        this.reg = AgentRegistrar.getAgentRegistrar();
        this.reg.setProvisionMonitor((ProvisionMonitor)properties.get("PROVISION_MONITOR"));
        m_isMFComponent = true;
        this.m_dsProps = properties;
        this.DEBUG = Config.DEBUG;
        try {
            IPluggableCipherSuite cipherSuite;
            try {
                this.runtimeLM = (BrokerLicenseMgr)((Object)properties.get("LICENSE_MANAGER"));
                if (this.runtimeLM == null) {
                    this.runtimeLM = BrokerLicenseMgr.createLicenseMgr(Config.CONTROL_NUMBER);
                }
                this.runtimeLM.evalExpiredCheck();
                this.runtimeLM.checkExpiration();
            }
            catch (EExpiredEvaluationLicenseKey elke) {
                BrokerComponent.getBrokerComponent().abort(elke.getMessage(), 0);
                return;
            }
            catch (ELogFileException lfe) {
                BrokerComponent.getBrokerComponent().abort(lfe.getMessage(), 0);
                return;
            }
            catch (EStartupFailure esf) {
                BrokerComponent.getBrokerComponent().abort(esf.getMessage(), 0);
                return;
            }
            catch (Exception e) {
                this.setSeverity(1);
                if (Config.CONTROL_NUMBER == null) {
                    Config.CONTROL_NUMBER = "null";
                }
                String mf = prAccessor.getString("STR286");
                Object[] ob = new Object[]{Config.CONTROL_NUMBER};
                BrokerComponent.getBrokerComponent().abort(MessageFormat.format(mf, ob), 0);
                return;
            }
            if (!this.runtimeLM.isSecurityEnabled()) {
                if (Config.ENABLE_SECURITY) {
                    this.setSeverity(1);
                    BrokerComponent.getBrokerComponent().abort(Config.NO_SECURITY_MSG, 0);
                    return;
                }
            } else if (Config.ENABLE_SECURITY) {
                boolean securityEnabled = Config.getBooleanProperty("ENABLE_SECURITY", Config.ENABLE_SECURITY);
                boolean qopSecurityEnabled = Config.getBooleanProperty("ENABLE_QOPSECURITY", Config.ENABLE_QOPSECURITY);
                boolean accessMediationEnabled = Config.getBooleanProperty("ENABLE_ACCESS_MEDIATION", Config.ENABLE_ACCESS_MEDIATION);
                boolean setJMSXUserID = Config.getBooleanProperty("SET_JMSXUSERID", Config.SET_JMSXUSERID);
                if (securityEnabled) {
                    new Thread(){

                        @Override
                        public void run() {
                            ProgressSecureRandom.theSecureRandom(null);
                        }
                    }.start();
                } else {
                    ProgressSecureRandom.theSecureRandom();
                }
                Config.ENABLE_QOPSECURITY = securityEnabled && qopSecurityEnabled && this.runtimeLM.isQoPEnabled();
                Config.ENABLE_ACCESS_MEDIATION = securityEnabled && accessMediationEnabled;
                boolean bl = Config.SET_JMSXUSERID = securityEnabled && setJMSXUserID;
            }
            if (!this.runtimeLM.isInterbrokerAllowed() && Config.ENABLE_INTERBROKER) {
                this.setSeverity(1);
                BrokerComponent.getBrokerComponent().abort(Config.NO_INTERBROKER_MSG, 0);
                return;
            }
            String banner = this.getBanner();
            if (BrokerComponent.getComponentContext() == null) {
                OStream.println(banner);
            } else {
                BrokerComponent.getComponentContext().logMessage(banner, 4);
            }
            Hashtable replicationConnDefs = (Hashtable)properties.get("REPLCONNS_TABLE");
            if (replicationConnDefs != null) {
                Enumeration enu = replicationConnDefs.elements();
                while (enu.hasMoreElements()) {
                    ReplicationConnDef def = (ReplicationConnDef)enu.nextElement();
                    ReplicationChannel ch = ReplicationChannel.addChannel(def.getName(), def.getProtocol(), def.getPrimaryAddr(), def.getPrimaryPort(), def.getBackupAddr(), def.getBackupPort(), def.getDynamicHostName(), def.getWeight(), def.getProperties());
                    ConfigurationChangeBindHelper bindHelper = BrokerComponent.getBrokerComponent().getChangeBindHelper();
                    bindHelper.bindReplicationChannelChangeHandler(ch, def.getAttributeSet());
                }
            }
            if ((cipherSuite = AgentRegistrar.getCipherSuite()) == null) {
                cipherSuite = SonicCipherSuite.getInstance();
                AgentRegistrar.setCipherSuite(cipherSuite);
            }
            BrokerStateManager.resetBrokerStateManager();
            BrokerStateManager.getBrokerStateManager().registerStartupController(this);
            BrokerStateManager.getBrokerStateManager().setStateStartup(this);
        }
        catch (Throwable e) {
            this.setSeverity(1);
            this.m_syncObject.setStartupThrowable(e);
            if (this.getState() == 3) {
                this.setState((short)4);
            }
            try {
                BrokerComponent.getBrokerComponent().abort(prAccessor.getString("brokerStartFailure"), 0);
            }
            catch (EBrokerAborted eba) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptClients() {
        AcceptorHolder holder;
        AcceptorHolder acceptorHolder = holder = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            if (!this.m_acceptClients) {
                String msg;
                Acceptor primaryAcceptor;
                Map acceptorStartErrors;
                boolean primaryFailed;
                block34: {
                    block33: {
                        primaryFailed = false;
                        acceptorStartErrors = null;
                        primaryAcceptor = null;
                        try {
                            this.m_acceptClients = true;
                            Config.NUM_ACCEPTORS = holder.count();
                            acceptorStartErrors = this.startNonPrimaryAcceptors();
                            ServiceStartLocal.start(this.reg.getAdminConnection());
                            primaryAcceptor = holder.getPrimaryAcceptor();
                            try {
                                this.initAcceptor(primaryAcceptor);
                            }
                            catch (IOException ioexc) {
                                primaryFailed = true;
                            }
                            this.setState((short)3);
                            startupNotificationObject ioexc = this.m_syncObject;
                            synchronized (ioexc) {
                                this.m_syncObject.setMainAcceptorStarted();
                                this.m_syncObject.notifyAll();
                            }
                            if (this.getState() == 3) break block33;
                            this.setState((short)1);
                            this.setStartupFailed();
                            break block34;
                        }
                        catch (Throwable e) {
                            try {
                                this.setSeverity(1);
                                this.m_syncObject.setStartupThrowable(e);
                                if (this.getState() == 3) {
                                    this.setState((short)4);
                                }
                                try {
                                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("brokerStartFailure"), 0);
                                }
                                catch (EBrokerAborted eba) {
                                    String msg2;
                                    if (this.getState() != 3) {
                                        this.setState((short)1);
                                        this.setStartupFailed();
                                    } else {
                                        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("brokerStarted"), 3);
                                    }
                                    Integer severity = BrokerComponent.getLevelWarning();
                                    if (primaryFailed) {
                                        msg2 = prAccessor.getString("PrimaryAcceptorStartError");
                                        BrokerComponent.logMessage(msg2, severity);
                                        BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(primaryAcceptor.getName(), primaryAcceptor.getExternalURL(), true);
                                        BrokerComponent.getComponentContext().registerErrorCondition(msg2, severity.intValue());
                                    }
                                    if (acceptorStartErrors != null && !acceptorStartErrors.isEmpty()) {
                                        msg2 = prAccessor.getString("AcceptorStartError");
                                        BrokerComponent.logMessage(msg2, severity);
                                        for (Acceptor accept : acceptorStartErrors.keySet()) {
                                            BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(accept.getName(), accept.getExternalURL(), false);
                                        }
                                        if (!primaryFailed) {
                                            BrokerComponent.getComponentContext().registerErrorCondition("Not all acceptors started", severity.intValue());
                                        }
                                    }
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                String msg3;
                                if (this.getState() != 3) {
                                    this.setState((short)1);
                                    this.setStartupFailed();
                                } else {
                                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("brokerStarted"), 3);
                                }
                                Integer severity = BrokerComponent.getLevelWarning();
                                if (primaryFailed) {
                                    msg3 = prAccessor.getString("PrimaryAcceptorStartError");
                                    BrokerComponent.logMessage(msg3, severity);
                                    BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(primaryAcceptor.getName(), primaryAcceptor.getExternalURL(), true);
                                    BrokerComponent.getComponentContext().registerErrorCondition(msg3, severity.intValue());
                                }
                                if (acceptorStartErrors != null && !acceptorStartErrors.isEmpty()) {
                                    msg3 = prAccessor.getString("AcceptorStartError");
                                    BrokerComponent.logMessage(msg3, severity);
                                    for (Acceptor accept : acceptorStartErrors.keySet()) {
                                        BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(accept.getName(), accept.getExternalURL(), false);
                                    }
                                    if (!primaryFailed) {
                                        BrokerComponent.getComponentContext().registerErrorCondition("Not all acceptors started", severity.intValue());
                                    }
                                }
                            }
                        }
                    }
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("brokerStarted"), 3);
                }
                Integer severity = BrokerComponent.getLevelWarning();
                if (primaryFailed) {
                    msg = prAccessor.getString("PrimaryAcceptorStartError");
                    BrokerComponent.logMessage(msg, severity);
                    BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(primaryAcceptor.getName(), primaryAcceptor.getExternalURL(), true);
                    BrokerComponent.getComponentContext().registerErrorCondition(msg, severity.intValue());
                }
                if (acceptorStartErrors != null && !acceptorStartErrors.isEmpty()) {
                    msg = prAccessor.getString("AcceptorStartError");
                    BrokerComponent.logMessage(msg, severity);
                    for (Acceptor accept : acceptorStartErrors.keySet()) {
                        BrokerManagementNotificationsHelper.sendAcceptorFailureNotification(accept.getName(), accept.getExternalURL(), false);
                    }
                    if (!primaryFailed) {
                        BrokerComponent.getComponentContext().registerErrorCondition("Not all acceptors started", severity.intValue());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartupFailed() {
        startupNotificationObject startupNotificationObject2 = this.m_syncObject;
        synchronized (startupNotificationObject2) {
            this.m_syncObject.setStartupFailed();
            this.m_syncObject.notifyAll();
        }
    }

    public static boolean isInShutdown() {
        return s_inShutdown;
    }

    void waitForClientThreads(ArrayList contexts, long timeout) throws InterruptedException {
        Iterator iterator = contexts.iterator();
        HashMap<AgentConnection, AgentConnection> conns = new HashMap<AgentConnection, AgentConnection>();
        while (iterator.hasNext()) {
            IClientContext context = (IClientContext)iterator.next();
            AgentConnection connection = context.getConnection();
            if (connection == null || conns.containsKey(connection)) continue;
            conns.put(connection, connection);
            AgentListener listener = connection.getAgentListener();
            if (listener == null || !listener.isAlive()) continue;
            listener.join(timeout);
        }
        conns.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(int stopBehaviorMask) {
        while (this.getState() == 2) {
            try {
                Broker broker = this;
                synchronized (broker) {
                    this.wait(100L);
                }
            }
            catch (Exception e) {
            }
        }
        Broker e = this;
        synchronized (e) {
            if (s_inShutdown) {
                while (BrokerComponent.getBrokerComponent().getState() != 1) {
                    try {
                        Broker broker = this;
                        synchronized (broker) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException iex) {
                        if (!this.DEBUG) continue;
                        BrokerComponent.getComponentContext().logMessage((Throwable)iex, 7);
                    }
                }
                return;
            }
            s_inShutdown = true;
            this.notifyAll();
        }
        this.setState((short)4);
        HashSet<Acceptor> acceptors = null;
        acceptors = new HashSet<Acceptor>(this.m_activeAcceptors);
        for (Acceptor acceptor : acceptors) {
            if (acceptor == null) continue;
            acceptor.stopAcceptor();
        }
        try {
            QueueMsgSaver qms;
            MsgSaver ms;
            block62: {
                ArrayList contexts = this.reg.getClientContexts();
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR330"), 3);
                ServiceStartLocal.shutdown();
                this.serviceDestroy();
                if (Config.REPLICATED) {
                    this.reg.getReplicationManager().shutdown((stopBehaviorMask & 1) != 0);
                    this.reg.getAgentConnection().kill();
                    try {
                        AgentAdminConnection aac = this.reg.getAdminConnection();
                        if (aac != null) {
                            aac.disconnect(true);
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                this.waitForClientThreads(contexts, 5000L);
                if (NoDupDetectDb.isEnabled()) {
                    NoDupDetectDb.stopCleaner();
                }
                AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().shutdown();
                AgentRegistrar.getAgentRegistrar().getRemoteRestoreManager().shutdown();
                ms = this.reg.getMsgSaver();
                qms = this.reg.getQueueMsgSaver();
                if ((stopBehaviorMask & 1) == 0) {
                    long timeToWait;
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        try {
                                            if (BrokerStateManager.getBrokerStateManager().isActive()) {
                                                this.reg.forceSyncpoint(true);
                                            }
                                        }
                                        catch (InterruptedException e3) {
                                            if (!this.DEBUG) break block57;
                                            BrokerComponent.getComponentContext().logMessage((Throwable)e3, 7);
                                        }
                                    }
                                    try {
                                        if (ms != null && ms.isAlive()) {
                                            ms.flush();
                                        }
                                    }
                                    catch (InterruptedException e4) {
                                        if (!this.DEBUG) break block58;
                                        BrokerComponent.getComponentContext().logMessage((Throwable)e4, 7);
                                    }
                                }
                                try {
                                    if (qms != null && qms.isAlive()) {
                                        qms.flush();
                                    }
                                }
                                catch (InterruptedException e5) {
                                    if (!this.DEBUG) break block59;
                                    BrokerComponent.getComponentContext().logMessage((Throwable)e5, 7);
                                }
                            }
                            this.markAsExiting();
                            try {
                                int state = BrokerStateManager.getBrokerStateManager().getState();
                                if (state != 6 && state != 5) {
                                    AgentRegistrar.getAgentRegistrar().getDurableManager().logDurableStats(true);
                                }
                            }
                            catch (InterruptedException e6) {
                                // empty catch block
                            }
                            try {
                                BrokerStateManager.getBrokerStateManager().shutdown(true);
                            }
                            catch (InterruptedException e7) {
                                if (!this.DEBUG) break block60;
                                BrokerComponent.getComponentContext().logMessage((Throwable)e7, 7);
                            }
                        }
                        timeToWait = 15000L;
                        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("Waiting for the threads to shut down"), 3);
                        ms.exiting();
                        qms.exiting();
                        try {
                            ms.join(timeToWait);
                        }
                        catch (InterruptedException e8) {
                            if (!this.DEBUG) break block61;
                            BrokerComponent.getComponentContext().logMessage((Throwable)e8, 7);
                        }
                    }
                    try {
                        qms.join(timeToWait);
                    }
                    catch (InterruptedException e9) {
                        if (!this.DEBUG) break block62;
                        BrokerComponent.getComponentContext().logMessage((Throwable)e9, 7);
                    }
                }
            }
            this.markAsExiting();
            this.reg.getLogManager().shutdown();
            try {
                BrokerStateManager.getBrokerStateManager().shutdown(false);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (ms != null && ms.isAlive()) {
                ms.interrupt();
            }
            if (qms != null && qms.isAlive()) {
                qms.interrupt();
            }
            try {
                if (ms != null && ms.isAlive()) {
                    ms.join();
                }
            }
            catch (InterruptedException e10) {
                // empty catch block
            }
            try {
                if (qms != null && qms.isAlive()) {
                    qms.join();
                }
            }
            catch (InterruptedException e11) {
                // empty catch block
            }
            this.reg.killAllThreads();
            BrokerComponent.getComponentContext().logMessage("Broker shutdown tasks completed", 3);
        }
        catch (Throwable e12) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(e12, 2);
            }
        }
        finally {
            Broker.printEnd();
            this.beforeExit();
            this.reg.closeLogFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashSet<Acceptor> acceptors = null;
        Set<Acceptor> set = this.m_activeAcceptors;
        synchronized (set) {
            acceptors = new HashSet<Acceptor>(this.m_activeAcceptors);
            this.m_activeAcceptors.clear();
        }
        for (Acceptor acceptor : acceptors) {
            if (acceptor == null) continue;
            acceptor.destroyAcceptor();
            while (acceptor.getAcceptorState() != 1) {
                try {
                    Thread thread = Thread.currentThread();
                    synchronized (thread) {
                        this.wait(100L);
                    }
                }
                catch (Exception e) {
                }
            }
        }
        this.reg = null;
        this.setState((short)0);
    }

    public static Broker getBroker() {
        return s_broker;
    }

    public BrokerLicenseMgr getBrokerLicenseMgr() {
        return this.runtimeLM;
    }

    public boolean isMFComponent() {
        return m_isMFComponent;
    }

    static boolean isAgentRunning(int port) {
        boolean isRunning;
        try {
            Socket AgentSocket = new Socket(ProgressInetAddress.getLocalHostName(), port);
            AgentSocket.close();
            isRunning = true;
        }
        catch (IOException e) {
            isRunning = false;
        }
        return isRunning;
    }

    private String getBanner() {
        String banner = NEWLINE + NEWLINE + '\t' + this.runtimeLM.getProductName() + " [" + prAccessor.getString("STR294") + ' ' + this.runtimeLM.getSerial() + ']' + NEWLINE + '\t' + Config.RELEASE_BANNER + prAccessor.getString("STR274") + 32 + NEWLINE + '\t' + Config.COPYRIGHT1 + NEWLINE + '\t' + Config.COPYRIGHT2 + NEWLINE + NEWLINE;
        banner = banner + this.runtimeLM.getLicenseBanner();
        return banner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printEnd() {
        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("brokerStopped"), 3);
        s_broker.setState((short)1);
        Broker broker = s_broker;
        synchronized (broker) {
            s_broker.notifyAll();
        }
    }

    public void beforeExit() {
        Db.shutdown();
        this.markAsExiting();
    }

    public int getState() {
        return this.m_component.getState().shortValue();
    }

    private void setState(short state) {
        this.m_component.setState(state);
    }

    private void markAsExiting() {
        exiting = true;
        SessionConfig.BROKER_EXITING = true;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    private void setSeverity(int severity) {
        this.m_severity = severity;
    }

    protected void serviceStart() {
        this.reg.setAcceptConnection(true);
    }

    protected void serviceStop() {
        this.reg.setAcceptConnection(false);
    }

    protected void serviceDestroy() {
        this.reg.setAcceptConnection(false);
        this.reg.killAllConnections();
        this.reg.shutdown();
    }

    protected void serviceAbort() {
        throw new Error("Unsupported usage");
    }

    protected void serviceAbort(boolean immediate) {
        throw new Error("Unsupported usage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map startNonPrimaryAcceptors() throws IOException {
        AcceptorHolder holder = AcceptorHolder.getAcceptorHolder();
        HashMap<Acceptor, IOException> acceptorErrors = new HashMap<Acceptor, IOException>();
        AcceptorHolder acceptorHolder = holder;
        synchronized (acceptorHolder) {
            Acceptor primaryAcceptor = holder.getPrimaryAcceptor();
            Enumeration acceptorGroups = holder.getAcceptors();
            while (acceptorGroups.hasMoreElements()) {
                Hashtable table = (Hashtable)acceptorGroups.nextElement();
                Enumeration acceptors = table.elements();
                while (acceptors.hasMoreElements()) {
                    Acceptor acceptor = (Acceptor)acceptors.nextElement();
                    if (acceptor == primaryAcceptor) continue;
                    try {
                        this.initAcceptor(acceptor);
                    }
                    catch (IOException ioe) {
                        acceptorErrors.put(acceptor, ioe);
                    }
                }
            }
        }
        return acceptorErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceptor(Acceptor acceptor) throws IOException {
        AcceptorHolder holder;
        AcceptorHolder acceptorHolder = holder = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            if (!this.m_acceptClients) {
                return;
            }
            Integer sl = (Integer)this.m_dsProps.get("SOCKET_QUEUE_LENGTH");
            int socketQueueLength = 50;
            if (sl != null) {
                socketQueueLength = sl;
            }
            acceptor.setSocketHandler(this.reg);
            acceptor.setSocketQueueLength(socketQueueLength);
            if (!acceptor.isStartActive()) {
                BrokerComponent.getComponentContext().logMessage("Disabled acceptor \"" + acceptor.getAcceptorName() + "\" " + acceptor.getURL() + " is not started.", 2);
                acceptor.setAcceptorState(1);
                return;
            }
            acceptor.start();
            Acceptor acceptor2 = acceptor;
            synchronized (acceptor2) {
                while (acceptor.getAcceptorState() == 0) {
                    try {
                        acceptor.wait();
                    }
                    catch (Exception e) {}
                }
            }
            if (acceptor.getAcceptorState() == 1) {
                throw new IOException();
            }
            this.m_activeAcceptors.add(acceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAcceptors(String acceptorName) {
        AcceptorHolder acceptors;
        AcceptorHolder acceptorHolder = acceptors = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            Enumeration targetAcceptors = acceptors.getAcceptors(acceptorName);
            if (targetAcceptors != null) {
                while (targetAcceptors.hasMoreElements()) {
                    Acceptor acceptor = (Acceptor)targetAcceptors.nextElement();
                    if (!this.m_acceptClients) {
                        acceptor.setStartActive(true);
                        continue;
                    }
                    Acceptor acceptor2 = acceptor;
                    synchronized (acceptor2) {
                        if (acceptor.getAcceptorState() != 1) {
                            BrokerComponent.getComponentContext().logMessage("Unable to start acceptor \"" + acceptor.getAcceptorName() + "\" " + acceptor.getURL() + " - acceptor not in the off-line state.", 2);
                            continue;
                        }
                        acceptor.start();
                        while (acceptor.getAcceptorState() != 3) {
                            try {
                                acceptor.wait(100L);
                            }
                            catch (InterruptedException ie) {
                                BrokerComponent.getComponentContext().logMessage("Unable to start " + acceptor.getAcceptorName() + acceptor.getURL() + " - thread interrupted.", 2);
                            }
                        }
                        this.m_activeAcceptors.add(acceptor);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAcceptors(String acceptorName, boolean dropConnections) {
        AcceptorHolder acceptors;
        AcceptorHolder acceptorHolder = acceptors = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            Enumeration targetAcceptors = acceptors.getAcceptors(acceptorName);
            if (targetAcceptors != null) {
                while (targetAcceptors.hasMoreElements()) {
                    Acceptor acceptor = (Acceptor)targetAcceptors.nextElement();
                    List<AgentConnection> connectionsToDrop = null;
                    if (!this.m_acceptClients) {
                        acceptor.setStartActive(false);
                        continue;
                    }
                    Acceptor acceptor2 = acceptor;
                    synchronized (acceptor2) {
                        if (acceptor.getAcceptorState() != 3) {
                            BrokerComponent.getComponentContext().logMessage("Unable to stop acceptor \"" + acceptor.getAcceptorName() + "\" " + acceptor.getURL() + " - acceptor not in the on-line state.", 2);
                            continue;
                        }
                        connectionsToDrop = acceptor.stopAcceptor(dropConnections);
                        this.m_activeAcceptors.remove(acceptor);
                    }
                    if (connectionsToDrop == null || connectionsToDrop.isEmpty()) continue;
                    AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
                    for (AgentConnection conn : connectionsToDrop) {
                        IClientContext cc = null;
                        try {
                            cc = reg.getClient(conn.getClientId(0));
                        }
                        catch (EClientNotRegistered ec) {
                            // empty catch block
                        }
                        if (cc == null) continue;
                        reg.dropConnection(cc);
                    }
                }
            }
        }
    }

    public ArrayList getAcceptors(String acceptorNamePrefix) {
        if (!this.m_acceptClients) {
            return null;
        }
        ArrayList<IAcceptorData> acceptorList = new ArrayList<IAcceptorData>();
        AcceptorHolder allAcceptors = AcceptorHolder.getAcceptorHolder();
        boolean useFilter = acceptorNamePrefix != null && acceptorNamePrefix.trim().length() > 0;
        Enumeration acceptorNames = AcceptorHolder.getAcceptorHolder().getAcceptorNames();
        while (acceptorNames.hasMoreElements()) {
            Enumeration acceptors;
            String acceptorName = (String)acceptorNames.nextElement();
            if (useFilter && !acceptorName.startsWith(acceptorNamePrefix) || (acceptors = allAcceptors.getAcceptors(acceptorName)) == null) continue;
            while (acceptors.hasMoreElements()) {
                acceptorList.add(Broker.getAcceptorData((Acceptor)acceptors.nextElement()));
            }
        }
        return acceptorList;
    }

    private static IAcceptorData getAcceptorData(Acceptor acceptor) {
        return RuntimeDataFactory.createAcceptorData(acceptor.getAcceptorName(), acceptor.getProtocol(), acceptor.getURL(), acceptor.getExternalURL() == null ? "" : acceptor.getExternalURL(), acceptor.getPort(), acceptor.getAcceptorState(), acceptor.getConnections().size());
    }

    private String getSocketType(int acceptor_number) {
        String socket_type = null;
        try {
            if (this.DEBUG) {
                System.out.println("Broker.acceptor_number is: " + acceptor_number);
            }
            socket_type = Config.ACCEPTOR_PROTOCOLS[acceptor_number - 1];
            if (this.DEBUG) {
                System.out.println("Broker.socket_type is: " + socket_type);
            }
        }
        catch (NullPointerException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR050"), 1);
            String mf399 = prAccessor.getString("STR051");
            Object[] ob399 = new Object[]{Integer.toString(acceptor_number), Integer.toString(acceptor_number)};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf399, ob399), 3);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            socket_type = prAccessor.getString("STR052");
        }
        return socket_type;
    }

    private int getSocketPort(int acceptor_number) {
        int socket_port = 2506;
        try {
            if (this.DEBUG) {
                System.out.println("Broker.acceptor_number is: " + acceptor_number);
            }
            socket_port = Integer.parseInt(Config.ACCEPTOR_PORTS[acceptor_number - 1]);
            if (this.DEBUG) {
                System.out.println("Broker.socket_port is: " + socket_port);
            }
        }
        catch (NullPointerException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR053"), 1);
            String mf419 = prAccessor.getString("STR054");
            Object[] ob419 = new Object[]{Integer.toString(acceptor_number), Integer.toString(acceptor_number)};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf419, ob419), 3);
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return socket_port;
    }

    private void HTTPDirectConfigurationCheck() {
        if (Config.CLIENT_CONTEXT_FACTORY == null || Config.CLIENT_CONTEXT_FACTORY.length <= 0) {
            boolean bHttpDirectConfigured = false;
            if (Config.ROUTING_EXT_FACTORIES != null && Config.ROUTING_EXT_FACTORIES.length > 0) {
                bHttpDirectConfigured = true;
            } else if (Config.ACCEPTOR_HTTP_X_PROTOCOLS != null) {
                for (int i = 0; i < Config.NUM_ACCEPTORS; ++i) {
                    if (Config.ACCEPTOR_HTTP_X_PROTOCOLS[i] == null || Config.ACCEPTOR_HTTP_X_PROTOCOLS[i].length <= 0) continue;
                    bHttpDirectConfigured = true;
                    break;
                }
            }
            if (bHttpDirectConfigured) {
                BrokerComponent.getComponentContext().logMessage("", 3);
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("HTTP_DIRECT_CCFACTORY_NOT_SPECIFIED"), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChangeComplete(int status) {
        switch (status) {
            case 9: {
                startupNotificationObject startupNotificationObject2 = this.m_syncObject;
                synchronized (startupNotificationObject2) {
                    this.m_syncObject.setRecoveryComplete();
                    this.m_syncObject.notifyAll();
                    break;
                }
            }
            case 3: {
                this.acceptClients();
                break;
            }
            case 1: {
                this.acceptClients();
                if (Config.REPLICATED) break;
                try {
                    BrokerStateManager.getBrokerStateManager().shutdown(true);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                break;
            }
            case 4: {
                startupNotificationObject startupNotificationObject3 = this.m_syncObject;
                synchronized (startupNotificationObject3) {
                    this.m_syncObject.setWaitingState();
                    this.m_syncObject.notifyAll();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChangeFailed(Throwable t, int status) {
        switch (status) {
            case 7: 
            case 8: 
            case 9: {
                startupNotificationObject startupNotificationObject2 = this.m_syncObject;
                synchronized (startupNotificationObject2) {
                    this.m_syncObject.setStartupFailed();
                    this.m_syncObject.setStartupThrowable(t);
                    this.m_syncObject.notifyAll();
                    break;
                }
            }
        }
        try {
            BrokerComponent.getBrokerComponent().abort(t.getMessage(), t, 1);
        }
        catch (EBrokerAborted eba) {
            return;
        }
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        m_isMFComponent = true;
    }

    class startupNotificationObject {
        private boolean m_recoveryComplete = false;
        private boolean m_inWaitingState = false;
        private boolean m_mainAcceptorStarted = false;
        private boolean m_startupFailed = false;
        private Throwable m_startupThrowable = null;

        startupNotificationObject() {
        }

        synchronized boolean isBrokerReady() {
            return this.m_recoveryComplete && this.m_mainAcceptorStarted || this.m_inWaitingState;
        }

        synchronized boolean isRecoveryComplete() {
            return this.m_recoveryComplete;
        }

        synchronized boolean isMainAcceptorStarted() {
            return this.m_mainAcceptorStarted;
        }

        synchronized boolean hasStartupFailed() {
            return this.m_startupFailed;
        }

        synchronized Throwable getStartupThrowable() {
            return this.m_startupThrowable;
        }

        synchronized void setRecoveryComplete() {
            this.m_recoveryComplete = true;
        }

        synchronized void setMainAcceptorStarted() {
            this.m_mainAcceptorStarted = true;
        }

        synchronized void setWaitingState() {
            this.m_inWaitingState = true;
        }

        synchronized void setStartupFailed() {
            this.m_startupFailed = true;
        }

        synchronized void setStartupThrowable(Throwable t) {
            this.m_startupThrowable = t;
        }

        synchronized void setMainAcceptorStopped() {
            this.m_mainAcceptorStarted = false;
        }
    }

    private static final class StringEncrypter
    extends DESString {
        private static final byte[] s_data = new byte[]{21, 89, -63, 38, 64, -94, -40, 3, 5, 35, 69, 103, -119, -85, -51, -17};

        private StringEncrypter() {
        }

        @Override
        protected byte[] getSalt() {
            return s_data;
        }

        final String decrypt(String encoded_string) throws IOException {
            return this.DESDecrypt(encoded_string);
        }
    }
}

