/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.StringReader;
import java.util.Enumeration;
import progress.message.broker.BaseQueue;
import progress.message.broker.BrowserElement;
import progress.message.broker.IBrowsable;
import progress.message.broker.IQueueContext;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.SavableQElement;
import progress.message.broker.SelectorElement;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.TokenMgrError;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;

public abstract class BrowsableBaseQueue
extends BaseQueue
implements IBrowsable {
    protected LongHashTable<BrowserElement> m_browsers;
    protected LongHashTable<SelectorElement> m_selectors;
    protected BrowseResultsContainer m_theBrowseResultsContainer = new BrowseResultsContainer();

    public BrowsableBaseQueue(String qName, int numPriorities, int maxQueueSize, IQueueContext bqc) {
        super(qName, numPriorities, maxQueueSize, bqc);
    }

    @Override
    public synchronized boolean openBrowser(long clientID, String selectorString) throws ParseException, TokenMgrError {
        if (this.DEBUG) {
            this.debug(this + " : creating a browser for cid = " + clientID + ", selector = " + selectorString);
        }
        if (this.m_browsers == null) {
            this.m_browsers = new LongHashTable();
        }
        MessageSelector ms = null;
        if (selectorString != null && selectorString.trim().length() > 0) {
            StringReader sr = new StringReader(selectorString);
            Selector parser = new Selector(sr);
            ms = parser.MessageSelector();
            if (this.m_selectors == null) {
                this.m_selectors = new LongHashTable();
            }
            SelectorElement se = new SelectorElement(ms, this.m_numPriorities, this.m_queuePriorityToken, this.m_qName);
            this.m_selectors.put(clientID, se);
        }
        BrowserElement be = new BrowserElement(this.m_numPriorities - 1, ms);
        this.m_browsers.put(clientID, be);
        return true;
    }

    @Override
    public synchronized boolean closeBrowser(long clientID) {
        SelectorElement se;
        boolean fnd = false;
        if (this.m_browsers != null && !this.m_browsers.isEmpty()) {
            BrowserElement be = null;
            if (this.m_browsers.containsKey(clientID)) {
                be = this.m_browsers.remove(clientID);
                fnd = true;
                if (this.DEBUG) {
                    this.debug(this + " : browser for cid = " + clientID + " closed.");
                }
                be.recycle();
            }
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = this.m_selectors.remove(clientID)) != null) {
            se.recycle();
            se = null;
        }
        return fnd;
    }

    @Override
    public synchronized boolean isBrowserOpen(long clientID) {
        if (this.m_browsers == null || this.m_browsers.isEmpty()) {
            return false;
        }
        boolean b = this.m_browsers.containsKey(clientID);
        return b;
    }

    @Override
    public synchronized Object browse(long clientID) {
        Object result;
        block8: {
            if (this.m_totalEnqueuedCount == 0) {
                return null;
            }
            BrowserElement be = this.m_browsers.get(clientID);
            if (be == null) {
                SelectorElement se;
                MessageSelector ms = null;
                if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = this.m_selectors.get(clientID)) != null) {
                    ms = se.getMessageSelector();
                }
                if (this.DEBUG) {
                    this.debug(this + " : browser for cid = " + clientID + " not found...creating one w/ the existing selector = " + ms);
                }
                be = new BrowserElement(this.m_highestNonEmptyPriority, ms);
                this.m_browsers.put(clientID, be);
            }
            this.browseInternal(be);
            QElement elem = this.m_theBrowseResultsContainer.getElement();
            IMgram pyld = this.m_theBrowseResultsContainer.getPayload();
            this.m_theBrowseResultsContainer.reset();
            if (elem == null) {
                be = this.m_browsers.remove(clientID);
                if (be != null) {
                    be.recycle();
                }
                return null;
            }
            result = pyld;
            try {
                result = pyld.protectedClone();
            }
            catch (CloneNotSupportedException e) {
                if (!this.DEBUG) break block8;
                e.printStackTrace();
            }
        }
        return result;
    }

    private synchronized void browseInternal(BrowserElement be) {
        this.m_theBrowseResultsContainer.reset();
        QElement elem = be.getElement();
        if (elem == null) {
            if (be.getAtEnd()) {
                return;
            }
            elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1];
            elem = elem.getNext();
        }
        if (be.getBrowsed()) {
            elem = elem.getNext();
        }
        boolean match = false;
        MessageSelector ms = be.getMessageSelector();
        IMgram m = null;
        while (!match) {
            while (elem != null && elem instanceof QToken) {
                elem = elem.getNext();
            }
            if (elem == null) {
                be.setAtEnd();
                break;
            }
            m = this.retrieve(elem);
            try {
                match = ms != null ? ms.match(m) : true;
            }
            catch (EvalException ee) {
                // empty catch block
            }
            if (match) break;
            elem = elem.getNext();
        }
        if (elem != null) {
            be.update(elem, elem.getPriority(), true);
            this.m_theBrowseResultsContainer.set(elem, m);
        }
    }

    protected IMgram retrieve(QElement elem) {
        if (elem instanceof SavableQElement) {
            throw new EAssertFailure(this.getClass().getName() + " must override progress.message.broker.BrowsableBaseQueue#retrieve(progress.message.broker.QElement) to retrieve payload from the db.");
        }
        return (IMgram)elem.getPayload();
    }

    protected synchronized void updateBrowsersOnDequeue(QElement elem) {
        QElement substitute;
        if (elem == null) {
            return;
        }
        if (this.m_browsers == null || this.m_browsers.isEmpty()) {
            return;
        }
        int prio = elem.getPriority();
        boolean browsed = false;
        for (substitute = elem.getNext(); substitute != null && substitute instanceof QToken; substitute = substitute.getNext()) {
        }
        if (substitute == null) {
            for (substitute = elem.getPrevious(); substitute != null; substitute = substitute.getPrevious()) {
                if (substitute instanceof QToken) continue;
                browsed = true;
                break;
            }
        }
        Enumeration<BrowserElement> enumeration = this.m_browsers.elements();
        BrowserElement be = null;
        while (enumeration.hasMoreElements()) {
            be = enumeration.nextElement();
            if (be.getCurrentPriority() != prio || be.getElement() != elem) continue;
            if (substitute != null) {
                be.update(substitute, substitute.getPriority(), browsed);
                continue;
            }
            if (this.m_totalEnqueuedCount == 0 && !be.getAtEnd()) {
                be.update(null, this.m_numPriorities - 1, false);
                continue;
            }
            be.setAtEnd();
        }
    }

    private synchronized void updateBrowsersOnEnqueue(int prio) {
        if (this.m_browsers == null || this.m_browsers.isEmpty()) {
            return;
        }
        Enumeration<BrowserElement> enumeration = this.m_browsers.elements();
        BrowserElement be = null;
        while (enumeration.hasMoreElements()) {
            be = enumeration.nextElement();
        }
    }

    class BrowseResultsContainer {
        public QElement m_elem = null;
        public IMgram m_payload = null;

        public void reset() {
            this.m_elem = null;
            this.m_payload = null;
        }

        public void set(QElement elem, IMgram obj) {
            this.m_elem = elem;
            this.m_payload = obj;
        }

        public QElement getElement() {
            return this.m_elem;
        }

        public IMgram getPayload() {
            return this.m_payload;
        }
    }
}

