/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

class ClientLGSettingHandler
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    ClientLGSettingHandler(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ClientLGSettingHandler" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session context, Envelope env) {
        try {
            AgentConnection connection;
            Message msg = env.getMessage();
            boolean isInstrumented = msg.readBoolean();
            int downStreamNodeType = msg.readInt();
            String uid = null;
            String appid = null;
            IClientContext client = null;
            try {
                ISubject subject = msg.getSubject();
                uid = SessionConfig.getUidFromAdminSubject(subject);
                appid = SessionConfig.getAppidFromAdminSubject(subject);
                client = this.m_reg.getClient(AddrUtil.stringToClientId(uid, appid));
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
            if (client != null && (connection = client.getConnection()) != null) {
                connection.setLGSetting(isInstrumented, downStreamNodeType);
                if (this.DEBUG) {
                    this.debug("LG setting for connection (" + uid + "," + appid + ") : isInstrumented = " + isInstrumented + ", downStreamNodeType = " + downStreamNodeType);
                }
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

