/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrowsableBaseQueue;
import progress.message.broker.BrowserElement;
import progress.message.broker.Config;
import progress.message.broker.DMQElement;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.IReceivable;
import progress.message.broker.IRecycler;
import progress.message.broker.ISavable;
import progress.message.broker.ISavableQueueContext;
import progress.message.broker.ISelectable;
import progress.message.broker.LogManager;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.SavableQElement;
import progress.message.broker.SelectorElement;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.util.EDuplicateKey;
import progress.message.util.LongHashTable;
import progress.message.util.server.LongVector;

public final class DeadMessageQueue
extends BrowsableBaseQueue
implements IReceivable,
IRecycler,
ISavable,
ISelectable {
    LongVector m_receivers;
    LongHashTable m_browsers;
    LongHashTable m_selectors;
    long m_saveThreshold = 0x180000L;
    float m_notifyFactor;
    long m_notifySize;
    Vector m_recycledQElements;
    long m_maxRecycledQElementCount = 50L;
    BrowsableBaseQueue.BrowseResultsContainer m_theBrowseResultsContainer;
    LogManager m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
    static final float s_DFLT_DMQ_NOTIFY_FACTOR = 0.85f;
    static final long s_DFLT_SAVE_THRESHOLD = 0x180000L;
    static final long s_DFLT_MAX_QUEUE_SIZE = 0x1000000L;
    static final int s_DEAD_MESSAGE_QUEUE_ELEMENT_TYPE_CODE = 1;

    public DeadMessageQueue(String qName, int numPriorities, int maxQueueSize, ISavableQueueContext sqc, Hashtable env) {
        super(qName, numPriorities, maxQueueSize, sqc);
        this.m_notifyFactor = (double)Config.DMQ_NOTIFY_FACTOR >= 1.0 ? 0.99f : ((double)Config.DMQ_NOTIFY_FACTOR < 0.1 ? 0.1f : Config.DMQ_NOTIFY_FACTOR);
        this.m_notifySize = (long)(this.m_notifyFactor * (float)this.m_maxQueueSize);
        this.m_recycledQElements = new Vector();
        this.m_theBrowseResultsContainer = new BrowsableBaseQueue.BrowseResultsContainer();
    }

    public synchronized void enqueue(IMgram m) {
        if (m == null) {
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        DMQElement elem = (DMQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new DMQElement(m, tracking, prio, len, tte);
        }
        m.getBrokerHandle().setPtpEnqueueTime(0L);
        elem.setEnqueueTime(System.currentTimeMillis());
        Integer reasonCode = null;
        Object reasonCodeObj = m.getSidebandData().getProperties().get("JMS_SonicMQ_undeliveredReasonCode");
        if (reasonCodeObj == null || reasonCodeObj instanceof Integer) {
            reasonCode = (Integer)reasonCodeObj;
        } else {
            try {
                reasonCode = Integer.parseInt(reasonCodeObj.toString());
            }
            catch (Exception e) {
                reasonCode = -1;
            }
            long timestamp = m.getSidebandData().getTimestamp();
            BrokerComponent.getComponentContext().logMessage("Message with timestamp " + timestamp + " : unexpected JMS_SonicMQ_undeliveredReasonCode type in DMQ message - type: " + reasonCodeObj.getClass().getName() + ", value: " + reasonCodeObj.toString() + ", replacing with Integer(" + reasonCode + ")", 2);
        }
        if (reasonCode != null) {
            elem.setReasonCode(reasonCode);
        }
        m.getBrokerHandle().setLocalQueueName(this.m_qName);
        super.enqueue(elem, prio, len);
        this.updateSelectorsOnEnqueue(elem, prio);
        if (this.getCurrentEnqueuedSize() > this.m_saveThreshold) {
            this.save(elem);
        }
        this.notificationAndShutdownCheck();
        this.notifyAll();
    }

    public synchronized void reenqueue(IMgram m, boolean preserveRedelivery) {
        long tm;
        if (m == null) {
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        DMQElement elem = (DMQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new DMQElement(m, tracking, prio, len, tte);
        }
        Integer ig = (Integer)m.getSidebandData().getProperties().get("JMS_SonicMQ_undeliveredReasonCode");
        if (ig != null) {
            elem.setReasonCode(ig);
        }
        if ((tm = m.getBrokerHandle().getPtpEnqueueTime()) > 0L) {
            elem.setEnqueueTime(tm);
            m.getBrokerHandle().setPtpEnqueueTime(0L);
        } else {
            elem.setEnqueueTime(System.currentTimeMillis());
        }
        super.reenqueue(elem, prio, len, preserveRedelivery);
        this.updateSelectorsOnReenqueue(elem, prio);
        this.notificationAndShutdownCheck();
        this.notifyAll();
    }

    @Override
    public synchronized Object dequeue(int prio) {
        QElement elem = (QElement)super.dequeue(prio);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        IMgram payload = this.retrieve(elem);
        this.cancelPendingSave(elem, payload);
        this.updateSelectorsOnDequeue(elem);
        this.updateBrowsersOnDequeue(elem);
        byte reenqueues = elem.getReenqueueCount();
        this.recycle(elem, 1);
        if (payload != null) {
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            this.notifySpaceAvailable();
        }
        this.notifyAll();
        return payload;
    }

    @Override
    public synchronized Object dequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    public synchronized Object dequeueByTrackingNum(long tracking) {
        DMQElement elem = (DMQElement)super.dequeue(tracking);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        IMgram payload = this.retrieve(elem);
        this.cancelPendingSave(elem, payload);
        this.updateSelectorsOnDequeue(elem);
        this.updateBrowsersOnDequeue(elem);
        byte reenqueues = elem.getReenqueueCount();
        this.recycle(elem, 1);
        if (payload != null) {
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            this.notifySpaceAvailable();
        }
        this.notifyAll();
        return payload;
    }

    @Override
    public synchronized Object dequeue(long receiverID) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        if (this.m_selectors == null) {
            return this.dequeue();
        }
        SelectorElement se = (SelectorElement)this.m_selectors.get(receiverID);
        if (se == null) {
            return this.dequeue();
        }
        QElement elem = (QElement)this.select(se);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        IMgram payload = (IMgram)elem.getPayload();
        long tracking = elem.getTracking();
        super.dequeue(tracking);
        this.updateSelectorsOnDequeue(elem);
        this.updateBrowsersOnDequeue(elem);
        byte reenqueues = elem.getReenqueueCount();
        this.recycle(elem, 1);
        if (payload != null) {
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            this.notifySpaceAvailable();
        }
        this.notifyAll();
        return payload;
    }

    public synchronized Object dequeueWait() throws InterruptedException {
        while (this.m_totalEnqueuedCount == 0) {
            this.wait();
        }
        return this.dequeue();
    }

    public synchronized Object dequeueWait(long receiverID) throws InterruptedException {
        SelectorElement se = null;
        if (this.m_selectors != null) {
            se = (SelectorElement)this.m_selectors.get(receiverID);
        }
        Object payload = null;
        while (payload == null) {
            if (this.m_selectors == null || se == null) {
                while (this.m_totalEnqueuedCount == 0) {
                    this.wait();
                }
            } else {
                while (se.getAtEnd()) {
                    this.wait();
                }
            }
            payload = this.dequeue(receiverID);
        }
        return payload;
    }

    @Override
    public synchronized void clear() throws InterruptedException {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].m_next;
        int prio = this.m_highestNonEmptyPriority;
        QElement prev = null;
        QElement next = null;
        AgentQueueMsgTracker tracker = null;
        boolean lastOne = false;
        while (elem != null) {
            if (elem instanceof QToken) {
                --prio;
                elem = elem.getNext();
                continue;
            }
            lastOne = this.m_totalEnqueuedCount == 1;
            this.cancelPendingSave(elem, elem.getPayload());
            tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
            if (tracker != null) {
                tracker.canceled(lastOne);
            } else if (((SavableQElement)elem).isSaved()) {
                boolean deleted = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().deleteMsg(this.m_qName, elem.getTracking(), true);
                QueueMsgAckedEvt evt = new QueueMsgAckedEvt(elem.getTracking(), null, deleted);
                this.m_logMgr.addEvent(evt, lastOne);
                if (lastOne) {
                    this.m_logMgr.waitForFlush(evt);
                }
            }
            prev = elem.getPrevious();
            next = elem.getNext();
            prev.setNext(next);
            next.setPrevious(prev);
            this.recycle(elem, 1);
            elem = next;
            int n = prio;
            this.m_elementsEnqueuedCount[n] = this.m_elementsEnqueuedCount[n] - 1;
            --this.m_totalEnqueuedCount;
        }
        if (this.m_selectors != null) {
            Enumeration enumeration = this.m_selectors.elements();
            SelectorElement se = null;
            while (enumeration.hasMoreElements()) {
                se = (SelectorElement)enumeration.nextElement();
                if (se == null) continue;
                se.resetCursor();
            }
        }
        if (this.m_browsers != null) {
            Enumeration enumeration = this.m_browsers.elements();
            BrowserElement be = null;
            while (enumeration.hasMoreElements()) {
                be = (BrowserElement)enumeration.nextElement();
                if (be == null) continue;
                be.resetOnClear();
            }
        }
        ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().flush();
        this.m_totalEnqueuedCount = 0;
        this.setCurrentEnqueuedSize(0L);
        for (int i = 0; i < this.m_numPriorities; ++i) {
            this.m_elementsEnqueuedCount[i] = 0;
        }
        this.m_highestNonEmptyPriority = -1;
        this.notifySpaceAvailable();
        this.notifyAll();
    }

    @Override
    public synchronized void unreserve(int size) {
        super.unreserve(size);
        this.notifySpaceAvailable();
    }

    @Override
    synchronized void notifySpaceAvailable() {
        long min_notifysize;
        long available = this.getCurrentAvailableSize();
        long l = min_notifysize = (long)Config.FLOW_CONTROL_NOTIFY_SIZE <= this.m_maxQueueSize ? (long)Config.FLOW_CONTROL_NOTIFY_SIZE : (long)Config.FLOW_CONTROL_DEFAULT_NOTIFY_SIZE;
        if (available > 0L && available >= min_notifysize) {
            this.m_bqc.getFlowControlManager().onSpaceAvailable(this.getQueueAddress(), available);
        }
    }

    private void notificationAndShutdownCheck() {
        if (this.getCurrentEnqueuedSize() > this.m_notifySize) {
            int percentFull = this.m_maxQueueSize > 0L ? (int)(this.getCurrentEnqueuedSize() * 100L / this.m_maxQueueSize) : 100;
            BrokerManagementNotificationsHelper.sendStateDMQCapacityNotification(Config.BROKER_NAME, (short)percentFull);
        }
        if (this.getCurrentEnqueuedSize() > this.m_maxQueueSize) {
            if (BrokerComponent.getBrokerComponent().getState() == 1 || Broker.isInShutdown()) {
                return;
            }
            if (!Broker.isInShutdown()) {
                Object[] obj = new Object[]{new Integer((int)(this.m_maxQueueSize / 1024L)).toString()};
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(prAccessor.getString("DMQ_FULL_PRESHUTDOWN"), obj), 1);
                try {
                    BrokerComponent.getBrokerComponent().abort(prMessageFormat.format(prAccessor.getString("DMQ_FULL_POSTSHUTDOWN"), obj), 0);
                }
                catch (EBrokerAborted eBrokerAborted) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized void setMaxQueueSizeInBytes(long maxQueueSize) {
        super.setMaxQueueSizeInBytes(maxQueueSize);
        this.m_notifySize = (long)(this.m_notifyFactor * (float)this.m_maxQueueSize);
    }

    @Override
    public synchronized void setMaxQueueSizeInKiloBytes(int maxQueueSize) {
        super.setMaxQueueSizeInKiloBytes(maxQueueSize);
        this.m_notifySize = (long)(this.m_notifyFactor * (float)this.m_maxQueueSize);
    }

    @Override
    public synchronized void recycle(Object obj, int typeCode) {
        DMQElement elt;
        if (typeCode == 1 && !(elt = (DMQElement)obj).isSaved()) {
            elt.recycle();
            if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
                this.m_recycledQElements.add(elt);
            }
        }
    }

    @Override
    public synchronized Object reuse(int typeCode) {
        Object obj = null;
        if (typeCode == 1 && !this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    @Override
    public synchronized boolean openLocalJMSReceiver(long receiverID, String selectorString) throws ParseException, TokenMgrError {
        if (this.m_receivers == null) {
            this.m_receivers = new LongVector();
        }
        if (!this.m_receivers.contains(receiverID)) {
            this.m_receivers.addElement(receiverID);
        }
        if (selectorString == null) {
            return true;
        }
        MessageSelector ms = null;
        StringReader sr = new StringReader(selectorString);
        Selector parser = new Selector(sr);
        ms = parser.MessageSelector();
        if (ms == null) {
            return false;
        }
        if (this.m_selectors == null) {
            this.m_selectors = new LongHashTable();
        }
        SelectorElement se = new SelectorElement(ms, this.m_numPriorities, this.m_queuePriorityToken, this.m_qName);
        this.m_selectors.put(receiverID, se);
        return true;
    }

    @Override
    public synchronized void closeLocalJMSReceiver(long receiverID) {
        SelectorElement se;
        if (this.m_receivers != null && !this.m_receivers.isEmpty()) {
            this.m_receivers.removeElement(receiverID);
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = (SelectorElement)this.m_selectors.remove(receiverID)) != null) {
            se.recycle();
            Object var3_2 = null;
        }
    }

    @Override
    public synchronized boolean isLocalJMSReceiverOpen(long receiverID) {
        if (this.m_receivers == null || this.m_receivers.isEmpty()) {
            return false;
        }
        boolean b = this.m_receivers.contains(receiverID);
        return b;
    }

    @Override
    public synchronized int getLocalJMSReceiverCount() {
        if (this.m_receivers == null) {
            return 0;
        }
        return this.m_receivers.size();
    }

    @Override
    public synchronized void setSaveThresholdInBytes(int saveThreshold) {
        this.m_saveThreshold = Math.abs((long)saveThreshold);
    }

    @Override
    public synchronized void setSaveThresholdInKiloBytes(int svThreshold) {
        long saveThreshold = Math.abs((long)svThreshold);
        this.m_saveThreshold = saveThreshold > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : saveThreshold * 1024L;
    }

    @Override
    public synchronized long getSaveThresholdInBytes() {
        return this.m_saveThreshold;
    }

    @Override
    public synchronized int getSaveThresholdInKiloBytes() {
        int saveThreshold = (int)(this.m_saveThreshold / 1024L);
        return saveThreshold;
    }

    public void save(QElement input_elem) {
        long runningSz = 0L;
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.getNext();
                continue;
            }
            if (runningSz + elem.getPayloadSize() >= this.m_saveThreshold) break;
            runningSz += elem.getPayloadSize();
            elem = elem.getNext();
        }
        if (elem == null) {
            return;
        }
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.getNext();
                continue;
            }
            if (((DMQElement)elem).isInDB() || ((DMQElement)elem).isSaved()) {
                ((DMQElement)elem).unsetAsyncReq();
                elem = elem.getNext();
                continue;
            }
            IMgram mg = (IMgram)elem.getPayload();
            if (mg != null && mg.getBrokerHandle().isFromDB()) {
                ((DMQElement)elem).setSaved();
                ((DMQElement)elem).setInDB();
                ((DMQElement)elem).setPostProcess();
                elem.setPayload(null);
                ((DMQElement)elem).unsetAsyncReq();
                elem = elem.getNext();
                continue;
            }
            ((SavableQElement)elem).setPostProcess();
            ((SavableQElement)elem).setSaved();
            ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg(this.m_qName, (SavableQElement)elem);
            ((SavableQElement)elem).unsetAsyncReq();
            elem = elem.getNext();
        }
    }

    @Override
    public IMgram retrieve(QElement elem) {
        IMgram payload = (IMgram)elem.getPayload();
        if (payload == null) {
            payload = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, elem.getTracking());
        }
        payload.getBrokerHandle().setLocalQueueName(this.m_qName);
        return payload;
    }

    @Override
    public synchronized int restore(List elements) {
        if (elements == null) {
            return 0;
        }
        Iterator it = elements.iterator();
        DMQElement elem = null;
        int restoredCount = 0;
        IMgram m = null;
        long tracking = 0L;
        Integer ig = null;
        Object payload = null;
        while (it.hasNext()) {
            elem = (DMQElement)it.next();
            payload = elem.getPayload();
            tracking = elem.getTracking();
            if (tracking <= 0L) {
                elem.recycle();
                continue;
            }
            m = (IMgram)elem.getPayload();
            if (m == null && (m = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, tracking)) == null) {
                elem.recycle();
                continue;
            }
            ig = (Integer)m.getSidebandData().getProperties().get("JMS_SonicMQ_undeliveredReasonCode");
            if (ig != null) {
                elem.setReasonCode(ig);
            }
            if (this.getCurrentTotalSize() + elem.getPayloadSize() < this.getSaveThresholdInBytes()) {
                elem.setPayload(m);
                m.getBrokerHandle().setFromDB(true);
            }
            this.updateTotalSize(elem.getPayloadSize());
            this.incrementEnqueuedCounts(elem.getPriority());
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
            if (tracker == null) {
                try {
                    tracker = new AgentQueueMsgTracker(tracking, this.m_qName, (byte)elem.getPriority(), elem.getTTE(), elem.getPayloadSize());
                }
                catch (EDuplicateKey edk) {
                    tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
                }
            }
            tracker.setLocalQueueName(this.m_qName);
            tracker.saved();
            if (payload != null) {
                IMgram mgram = (IMgram)payload;
                tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
            }
            elem.setInDB();
            elem.setSaved();
            elem.setEnqueueTime(System.currentTimeMillis());
            this.link(elem, elem.getPriority());
            if (Config.PTP_REDELIVERED_ON_BROKER_RESTART) {
                elem.setReenqueueCount((byte)1);
                if (elem.getPayload() != null) {
                    ((IMgram)elem.getPayload()).setSuccessor(true);
                    ((IMgram)elem.getPayload()).setReenqueueCount((byte)1);
                }
            }
            if (++restoredCount != 1) continue;
            this.updateMinEnqueueTime();
        }
        return restoredCount;
    }

    @Override
    public void forcedSave() {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        int totalSize = 0;
        while (elem != null && (long)totalSize < this.m_saveThreshold) {
            if (elem instanceof QToken) {
                elem = elem.getNext();
                continue;
            }
            totalSize = (int)((long)totalSize + elem.getPayloadSize());
            if (((SavableQElement)elem).isSaved()) {
                elem = elem.getNext();
                continue;
            }
            IMgram m = (IMgram)elem.getPayload();
            if (m == null || m != null && !m.isJMSPersistent()) {
                elem = elem.getNext();
                continue;
            }
            ((SavableQElement)elem).unsetPostProcess();
            ((SavableQElement)elem).setSaved();
            ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg(this.m_qName, (SavableQElement)elem);
            elem = elem.getNext();
        }
    }

    private synchronized void cancelPendingSave(QElement elem, Object obj) {
        ((SavableQElement)elem).unsetPostProcess();
        if (((SavableQElement)elem).isSaved() && !((SavableQElement)elem).isInDB()) {
            boolean state = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().cancelSave(elem.getTracking());
            if (!state) {
                elem.setPayload(obj);
                IMgram payload = (IMgram)elem.getPayload();
                if (payload != null) {
                    payload.getBrokerHandle().setDBSaveRequested(true);
                }
            }
        } else if (elem.getPayload() == null) {
            elem.setPayload(obj);
        }
    }

    @Override
    public synchronized Object select(SelectorElement se) {
        if (se.getAtEnd()) {
            return null;
        }
        MessageSelector ms = se.getMessageSelector();
        boolean match = false;
        QElement elem = null;
        IMgram m = null;
        int prio = se.getSearchPriority();
        while (!match && prio >= 0) {
            elem = se.getCursorElement(prio);
            if (elem instanceof QToken) {
                se.setSearchPriority(--prio);
                continue;
            }
            m = this.retrieve(elem);
            try {
                match = ms.match(m);
            }
            catch (EvalException ee) {
                // empty catch block
            }
            if (match) continue;
            se.incrementCursor(prio);
            prio = se.getSearchPriority();
        }
        if (match) {
            this.cancelPendingSave(elem, m);
            return elem;
        }
        return null;
    }

    private synchronized void updateSelectorsOnEnqueue(QElement elem, int prio) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnEnqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnReenqueue(QElement elem, int prio) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnReenqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnDequeue(QElement elem) {
        if (elem == null) {
            return;
        }
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnDequeue(elem);
        }
    }
}

